/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.regex.Pattern;
import jp.sbi.celldesigner.plugin.PluginAntiSenseRNA;
import jp.sbi.celldesigner.plugin.PluginCompartment;
import jp.sbi.celldesigner.plugin.PluginGene;
import jp.sbi.celldesigner.plugin.PluginListOf;
import jp.sbi.celldesigner.plugin.PluginModel;
import jp.sbi.celldesigner.plugin.PluginProtein;
import jp.sbi.celldesigner.plugin.PluginRNA;
import jp.sbi.celldesigner.plugin.PluginReaction;
import jp.sbi.celldesigner.plugin.PluginSBase;
import jp.sbi.celldesigner.plugin.PluginSpecies;
import jp.sbi.celldesigner.plugin.PluginSpeciesAlias;
import plugin.ImportNotesDialog;
import plugin.ImportNotesPlugin;
import plugin.InvalidFileTypeException;

public class ReadAndImportNotes {
    private ImportNotesPlugin plugin;
    private int importCounter;
    private BufferedWriter bufferWriter;

    public ReadAndImportNotes(ImportNotesPlugin _plugin) {
        this.plugin = _plugin;
    }

    protected String readNotesFile(File selectedFile, String key, String selectedType) throws Exception {
        this.importCounter = 0;
        BufferedReader br = null;
        try {
            try {
                br = new BufferedReader(new FileReader(selectedFile));
                FileWriter fileWriter = new FileWriter(new File(String.valueOf(selectedFile.getPath()) + ".ImportNotes.log"));
                this.bufferWriter = new BufferedWriter(fileWriter);
                int idCol = -1;
                int nameCol = -1;
                int notesCol = -1;
                int classCol = -1;
                int typeCol = -1;
                int counter = 0;
                while (br.ready()) {
                    String line = br.readLine();
                    Pattern pattern = Pattern.compile("\".*\",|,");
                    String[] data = pattern.split(line);
                    if (counter == 0) {
                        int i = 0;
                        while (i < data.length) {
                            String element = data[i];
                            if (element.equals("id")) {
                                idCol = i;
                            }
                            if (element.equals("name")) {
                                nameCol = i;
                            }
                            if (element.equals("notes")) {
                                notesCol = i;
                            }
                            if (element.equals("class")) {
                                classCol = i;
                            }
                            if (element.equals("type")) {
                                typeCol = i;
                            }
                            ++i;
                        }
                        if (key.equals("ID") && (idCol == -1 || idCol == data.length)) {
                            throw new InvalidFileTypeException("ID column is not included.");
                        }
                        if (key.equals("Name") && (nameCol == -1 || nameCol == data.length)) {
                            throw new InvalidFileTypeException("Name column is not included.");
                        }
                        if (notesCol == -1) {
                            throw new InvalidFileTypeException("Notes column is not included.");
                        }
                        if (key.equals("Name") && selectedType.equals(ImportNotesDialog.fileType[0]) && (classCol == -1 || classCol == data.length)) {
                            throw new InvalidFileTypeException("Class column is not included.");
                        }
                        if (key.equals("Name") && selectedType.equals(ImportNotesDialog.fileType[1]) && (typeCol == -1 || typeCol == data.length)) {
                            throw new InvalidFileTypeException("Type column is not included.");
                        }
                        if (key.equals("Name") && selectedType.equals(ImportNotesDialog.fileType[5]) && (typeCol == -1 || typeCol == data.length)) {
                            throw new InvalidFileTypeException("Type column is not included.");
                        }
                    } else if (notesCol < data.length) {
                        String notes = data[notesCol];
                        if (notes.charAt(0) == '\"') {
                            String nextLine = null;
                            while ((nextLine = br.readLine()) != null) {
                                notes = String.valueOf(notes) + "\n" + nextLine;
                                int cnt = 0;
                                int p = 0;
                                while ((p = nextLine.indexOf(34, p)) != -1) {
                                    ++cnt;
                                    ++p;
                                }
                                if (cnt % 2 == 1) break;
                            }
                            notes = notes.replace("\"\"", "\"");
                            notes = notes.substring(1, notes.length() - 1);
                        }
                        if (notes != null && notes.length() != 0) {
                            String keyString = "";
                            String subkeyString = "";
                            keyString = key.equals("ID") ? data[idCol] : data[nameCol];
                            if (selectedType.equals(ImportNotesDialog.fileType[0])) {
                                subkeyString = data[classCol];
                                this.setSpeciesNotes(key, keyString, subkeyString, notes);
                            } else if (selectedType.equals(ImportNotesDialog.fileType[1])) {
                                subkeyString = data[typeCol];
                                this.setProteinNotes(key, keyString, subkeyString, notes);
                            } else if (selectedType.equals(ImportNotesDialog.fileType[2])) {
                                this.setGeneNotes(key, keyString, notes);
                            } else if (selectedType.equals(ImportNotesDialog.fileType[3])) {
                                this.setRNANotes(key, keyString, notes);
                            } else if (selectedType.equals(ImportNotesDialog.fileType[4])) {
                                this.setAsRNANotes(key, keyString, notes);
                            } else if (selectedType.equals(ImportNotesDialog.fileType[5])) {
                                subkeyString = data[typeCol];
                                this.setReactionNotes(key, keyString, subkeyString, notes);
                            } else if (selectedType.equals(ImportNotesDialog.fileType[6])) {
                                this.setCompartmentNotes(key, keyString, notes);
                            }
                        }
                    }
                    ++counter;
                }
                this.bufferWriter.flush();
                fileWriter.close();
                this.bufferWriter.close();
                fileWriter = null;
                this.bufferWriter = null;
            }
            catch (InvalidFileTypeException ife) {
                throw ife;
            }
            catch (IOException ie) {
                ie.printStackTrace();
                throw ie;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        }
        return this.importCounter <= 1 ? String.valueOf(this.importCounter) + "  " + selectedType + " Notes was imported." : String.valueOf(this.importCounter) + "  " + selectedType + " Notes were imported.";
    }

    private void setSpeciesNotes(String key, String keyString, String subkeyString, String notes) throws IOException {
        PluginModel model = this.plugin.getSelectedModel();
        if (model != null) {
            if (key.equals("ID")) {
                PluginSpecies species = model.getSpecies(keyString);
                if (species != null) {
                    species.setNotes(notes);
                    this.plugin.notifySBaseChanged((PluginSBase)species);
                    this.bufferWriter.write("ID=" + keyString + ", Notes=" + notes);
                    this.bufferWriter.newLine();
                    ++this.importCounter;
                }
            } else {
                PluginListOf list = model.getListOfAllSpeciesAlias();
                int i = 0;
                while (i < list.size()) {
                    PluginSpeciesAlias alias = (PluginSpeciesAlias)list.get(i);
                    if (!alias.getName().equals("") && alias.getName().equals(keyString) && alias.getType().equals(subkeyString)) {
                        alias.getSpecies().setNotes(notes);
                        this.plugin.notifySBaseChanged((PluginSBase)alias.getSpecies());
                        this.bufferWriter.write("Name=" + keyString + ", ID=" + alias.getSpecies().getId() + ", Class=" + alias.getType() + ", Notes=" + notes);
                        this.bufferWriter.newLine();
                        ++this.importCounter;
                    }
                    ++i;
                }
            }
        }
    }

    private void setProteinNotes(String key, String keyString, String subkeyString, String notes) throws IOException {
        PluginModel model = this.plugin.getSelectedModel();
        if (model != null) {
            if (key.equals("ID")) {
                PluginProtein protein = model.getProtein(keyString);
                if (protein != null) {
                    protein.setNotes(notes);
                    this.plugin.notifySBaseChanged((PluginSBase)protein);
                    this.bufferWriter.write("ID=" + keyString + ", Notes=" + notes);
                    this.bufferWriter.newLine();
                    ++this.importCounter;
                }
            } else {
                PluginListOf list = model.getListOfProteins();
                int i = 0;
                while (i < list.size()) {
                    PluginProtein protein = (PluginProtein)list.get(i);
                    if (!protein.getName().equals("") && protein.getName().equals(keyString) && protein.getType().equals(subkeyString)) {
                        protein.setNotes(notes);
                        this.plugin.notifySBaseChanged((PluginSBase)protein);
                        this.bufferWriter.write("Name=" + keyString + ", ID=" + protein.getExtensionId() + ", Type=" + protein.getType() + ", Notes=" + notes);
                        this.bufferWriter.newLine();
                        ++this.importCounter;
                    }
                    ++i;
                }
            }
        }
    }

    private void setGeneNotes(String key, String keyString, String notes) throws IOException {
        PluginModel model = this.plugin.getSelectedModel();
        if (model != null) {
            if (key.equals("ID")) {
                PluginGene gene = model.getGene(keyString);
                if (gene != null) {
                    gene.setNotes(notes);
                    this.plugin.notifySBaseChanged((PluginSBase)gene);
                    this.bufferWriter.write("ID=" + keyString + ", Notes=" + notes);
                    this.bufferWriter.newLine();
                    ++this.importCounter;
                }
            } else {
                PluginListOf list = model.getListOfGenes();
                int i = 0;
                while (i < list.size()) {
                    PluginGene gene = (PluginGene)list.get(i);
                    if (!gene.getName().equals("") && gene.getName().equals(keyString)) {
                        gene.setNotes(notes);
                        this.plugin.notifySBaseChanged((PluginSBase)gene);
                        this.bufferWriter.write("Name=" + keyString + ", ID=" + gene.getExtensionId() + ", Notes=" + notes);
                        this.bufferWriter.newLine();
                        ++this.importCounter;
                    }
                    ++i;
                }
            }
        }
    }

    private void setRNANotes(String key, String keyString, String notes) throws IOException {
        PluginModel model = this.plugin.getSelectedModel();
        if (model != null) {
            if (key.equals("ID")) {
                PluginRNA rna = model.getRNA(keyString);
                if (rna != null) {
                    rna.setNotes(notes);
                    this.plugin.notifySBaseChanged((PluginSBase)rna);
                    this.bufferWriter.write("ID=" + keyString + ", Notes=" + notes);
                    this.bufferWriter.newLine();
                    ++this.importCounter;
                }
            } else {
                PluginListOf list = model.getListOfRNAs();
                int i = 0;
                while (i < list.size()) {
                    PluginRNA rna = (PluginRNA)list.get(i);
                    if (!rna.getName().equals("") && rna.getName().equals(keyString)) {
                        rna.setNotes(notes);
                        this.plugin.notifySBaseChanged((PluginSBase)rna);
                        this.bufferWriter.write("Name=" + keyString + ", ID=" + rna.getExtensionId() + ", Notes=" + notes);
                        this.bufferWriter.newLine();
                        ++this.importCounter;
                    }
                    ++i;
                }
            }
        }
    }

    private void setAsRNANotes(String key, String keyString, String notes) throws IOException {
        PluginModel model = this.plugin.getSelectedModel();
        if (model != null) {
            if (key.equals("ID")) {
                PluginAntiSenseRNA asrna = model.getAntiSenseRNA(keyString);
                if (asrna != null) {
                    asrna.setNotes(notes);
                    this.plugin.notifySBaseChanged((PluginSBase)asrna);
                    this.bufferWriter.write("ID=" + keyString + ", Notes=" + notes);
                    this.bufferWriter.newLine();
                    ++this.importCounter;
                }
            } else {
                PluginListOf list = model.getListOfAntiSenseRNAs();
                int i = 0;
                while (i < list.size()) {
                    PluginAntiSenseRNA asrna = (PluginAntiSenseRNA)list.get(i);
                    if (!asrna.getName().equals("") && asrna.getName().equals(keyString)) {
                        asrna.setNotes(notes);
                        this.plugin.notifySBaseChanged((PluginSBase)asrna);
                        this.bufferWriter.write("Name=" + keyString + ", ID=" + asrna.getExtensionId() + ", Notes=" + notes);
                        this.bufferWriter.newLine();
                        ++this.importCounter;
                    }
                    ++i;
                }
            }
        }
    }

    private void setReactionNotes(String key, String keyString, String subkeyString, String notes) throws IOException {
        PluginModel model = this.plugin.getSelectedModel();
        if (model != null) {
            if (key.equals("ID")) {
                PluginReaction reaction = model.getReaction(keyString);
                if (reaction != null) {
                    reaction.setNotes(notes);
                    this.plugin.notifySBaseChanged((PluginSBase)reaction);
                    this.bufferWriter.write("ID=" + keyString + ", Notes=" + notes);
                    this.bufferWriter.newLine();
                    ++this.importCounter;
                }
            } else {
                PluginListOf list = model.getListOfReactions();
                int i = 0;
                while (i < list.size()) {
                    PluginReaction reaction = (PluginReaction)list.get(i);
                    if (!reaction.getName().equals("") && reaction.getName().equals(keyString) && reaction.getReactionType().equals(subkeyString)) {
                        reaction.setNotes(notes);
                        this.plugin.notifySBaseChanged((PluginSBase)reaction);
                        this.bufferWriter.write("Name=" + keyString + ", ID=" + reaction.getId() + ", Type=" + reaction.getReactionType() + ", Notes=" + notes);
                        this.bufferWriter.newLine();
                        ++this.importCounter;
                    }
                    ++i;
                }
            }
        }
    }

    private void setCompartmentNotes(String key, String keyString, String notes) throws IOException {
        PluginModel model = this.plugin.getSelectedModel();
        if (model != null) {
            if (key.equals("ID")) {
                PluginCompartment compartment = model.getCompartment(keyString);
                if (compartment != null) {
                    compartment.setNotes(notes);
                    this.plugin.notifySBaseChanged((PluginSBase)compartment);
                    this.bufferWriter.write("ID=" + keyString + ", Notes=" + notes);
                    this.bufferWriter.newLine();
                    ++this.importCounter;
                }
            } else {
                PluginListOf list = model.getListOfCompartments();
                int i = 0;
                while (i < list.size()) {
                    PluginCompartment compartment = (PluginCompartment)list.get(i);
                    if (compartment.getName().equals(keyString)) {
                        compartment.setNotes(notes);
                        this.plugin.notifySBaseChanged((PluginSBase)compartment);
                        this.bufferWriter.write("Name=" + keyString + ", ID=" + compartment.getId() + ", Notes=" + notes);
                        this.bufferWriter.newLine();
                        ++this.importCounter;
                    }
                    ++i;
                }
            }
        }
    }
}

