/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import plugin.ImportNotesPlugin;
import plugin.InvalidFileTypeException;
import plugin.ReadAndImportNotes;

public class ImportNotesDialog
extends JDialog {
    private static final long serialVersionUID = 7376098574441267953L;
    private ImportNotesPlugin plugin;
    private ReadAndImportNotes readAndImportNotes = null;
    private JFileChooser chooser = null;
    private JPanel jPanel = null;
    private JPanel keyPanel = null;
    private JPanel typePanel = null;
    private ButtonGroup buttonGroup = null;
    private JRadioButton speciesRadio = null;
    private JRadioButton proteinsRadio = null;
    private JRadioButton genesRadio = null;
    private JRadioButton rnasRadio = null;
    private JRadioButton asRnasRadio = null;
    private JRadioButton reactionsRadio = null;
    private JRadioButton compartmentsRadio = null;
    protected static final String[] fileType = new String[]{"Species", "Proteins", "Genes", "RNAs", "asRNAs", "Reactions", "Compartments"};
    private ButtonGroup keyButtonGroup = null;
    private JRadioButton idRadio = null;
    private JRadioButton nameRadio = null;
    protected static final String[] keyType = new String[]{"ID", "Name"};

    public ImportNotesDialog(ImportNotesPlugin _plugin) throws HeadlessException {
        this.plugin = _plugin;
        this.initialize();
    }

    private void initialize() {
        this.setSize(200, 330);
        this.setTitle("Import Notes 1.1");
        JPanel panel = new JPanel();
        this.setContentPane(panel);
        panel.add(this.getJPanel());
        panel.add(this.getButtonPanel());
        if (this.keyButtonGroup == null) {
            this.keyButtonGroup = new ButtonGroup();
            this.keyButtonGroup.add(this.idRadio);
            this.keyButtonGroup.add(this.nameRadio);
        }
        if (this.buttonGroup == null) {
            this.buttonGroup = new ButtonGroup();
            this.buttonGroup.add(this.speciesRadio);
            this.buttonGroup.add(this.proteinsRadio);
            this.buttonGroup.add(this.genesRadio);
            this.buttonGroup.add(this.rnasRadio);
            this.buttonGroup.add(this.asRnasRadio);
            this.buttonGroup.add(this.reactionsRadio);
            this.buttonGroup.add(this.compartmentsRadio);
        }
    }

    public void selectCsvFile() {
        String matchingKey = keyType[0];
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
        }
        this.chooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        this.chooser.setFileSelectionMode(0);
        int selected = this.chooser.showOpenDialog(this);
        if (selected == 0) {
            JRadioButton b;
            File selectedFile = this.chooser.getSelectedFile();
            if (this.readAndImportNotes == null) {
                this.readAndImportNotes = new ReadAndImportNotes(this.plugin);
            }
            Enumeration<AbstractButton> enumration = this.keyButtonGroup.getElements();
            while (enumration.hasMoreElements()) {
                b = (JRadioButton)enumration.nextElement();
                if (b.getModel() != this.keyButtonGroup.getSelection()) continue;
                matchingKey = b.getText();
            }
            enumration = this.buttonGroup.getElements();
            while (enumration.hasMoreElements()) {
                b = (JRadioButton)enumration.nextElement();
                if (b.getModel() != this.buttonGroup.getSelection()) continue;
                try {
                    String resultMessage = this.readAndImportNotes.readNotesFile(selectedFile, matchingKey, b.getText());
                    if (resultMessage.length() == 0) break;
                    JOptionPane.showMessageDialog(this, resultMessage, "Info", 1);
                }
                catch (InvalidFileTypeException ife) {
                    JOptionPane.showMessageDialog(this, ife.getMessage(), "Warning", 2);
                }
                catch (IOException ie) {
                    JOptionPane.showMessageDialog(this, ie.getMessage(), "Error", 0);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
                }
                break;
            }
        }
    }

    protected void closeActionPerformed() {
        this.setVisible(false);
        this.dispose();
    }

    private JPanel getButtonPanel() {
        this.jPanel = new JPanel();
        JButton importButton = new JButton("Import...");
        importButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImportNotesDialog.this.selectCsvFile();
            }
        });
        this.jPanel.add(importButton);
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImportNotesDialog.this.closeActionPerformed();
            }
        });
        this.jPanel.add(closeButton);
        return this.jPanel;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.anchor = 17;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 2;
            gridBagConstraints2.anchor = 17;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 3;
            gridBagConstraints3.anchor = 17;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 4;
            gridBagConstraints4.anchor = 17;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = 5;
            gridBagConstraints5.anchor = 17;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.gridy = 6;
            gridBagConstraints6.anchor = 17;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.gridy = 7;
            gridBagConstraints7.anchor = 17;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.gridy = 8;
            gridBagConstraints8.anchor = 17;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.gridy = 9;
            gridBagConstraints9.anchor = 17;
            this.typePanel = new JPanel();
            this.typePanel.setLayout(new GridBagLayout());
            this.typePanel.add((Component)this.getSpeciesRadio(), gridBagConstraints);
            this.typePanel.add((Component)this.getProteinsRadio(), gridBagConstraints1);
            this.typePanel.add((Component)this.getGenesRadio(), gridBagConstraints2);
            this.typePanel.add((Component)this.getRnasRadio(), gridBagConstraints3);
            this.typePanel.add((Component)this.getAsRnasRadio(), gridBagConstraints4);
            this.typePanel.add((Component)this.getReactionsRadio(), gridBagConstraints5);
            this.typePanel.add((Component)this.getCompartmentsRadio(), gridBagConstraints6);
            this.typePanel.setBorder(new TitledBorder("CSV file type"));
            this.keyPanel = new JPanel(new BorderLayout());
            this.keyPanel.add((Component)this.getIdRadio(), "Center");
            this.keyPanel.add((Component)this.getNameRadio(), "South");
            this.keyPanel.setBorder(new TitledBorder("matching key"));
            this.jPanel = new JPanel(new BorderLayout());
            this.jPanel.add((Component)this.keyPanel, "Center");
            this.jPanel.add((Component)this.typePanel, "South");
        }
        return this.jPanel;
    }

    private JRadioButton getSpeciesRadio() {
        if (this.speciesRadio == null) {
            this.speciesRadio = new JRadioButton();
            this.speciesRadio.setText(fileType[0]);
            this.speciesRadio.setSelected(true);
        }
        return this.speciesRadio;
    }

    private JRadioButton getProteinsRadio() {
        if (this.proteinsRadio == null) {
            this.proteinsRadio = new JRadioButton();
            this.proteinsRadio.setText(fileType[1]);
        }
        return this.proteinsRadio;
    }

    private JRadioButton getGenesRadio() {
        if (this.genesRadio == null) {
            this.genesRadio = new JRadioButton();
            this.genesRadio.setText(fileType[2]);
        }
        return this.genesRadio;
    }

    private JRadioButton getRnasRadio() {
        if (this.rnasRadio == null) {
            this.rnasRadio = new JRadioButton();
            this.rnasRadio.setText(fileType[3]);
        }
        return this.rnasRadio;
    }

    private JRadioButton getAsRnasRadio() {
        if (this.asRnasRadio == null) {
            this.asRnasRadio = new JRadioButton();
            this.asRnasRadio.setText(fileType[4]);
        }
        return this.asRnasRadio;
    }

    private JRadioButton getReactionsRadio() {
        if (this.reactionsRadio == null) {
            this.reactionsRadio = new JRadioButton();
            this.reactionsRadio.setText(fileType[5]);
        }
        return this.reactionsRadio;
    }

    private JRadioButton getCompartmentsRadio() {
        if (this.compartmentsRadio == null) {
            this.compartmentsRadio = new JRadioButton();
            this.compartmentsRadio.setText(fileType[6]);
        }
        return this.compartmentsRadio;
    }

    private JRadioButton getIdRadio() {
        if (this.idRadio == null) {
            this.idRadio = new JRadioButton();
            this.idRadio.setText(keyType[0]);
            this.idRadio.setSelected(true);
        }
        return this.idRadio;
    }

    private JRadioButton getNameRadio() {
        if (this.nameRadio == null) {
            this.nameRadio = new JRadioButton();
            this.nameRadio.setText(keyType[1]);
        }
        return this.nameRadio;
    }
}

