/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Pattern;
import jp.sbi.celldesigner.plugin.PluginAntiSenseRNA;
import jp.sbi.celldesigner.plugin.PluginCompartment;
import jp.sbi.celldesigner.plugin.PluginGene;
import jp.sbi.celldesigner.plugin.PluginModel;
import jp.sbi.celldesigner.plugin.PluginProtein;
import jp.sbi.celldesigner.plugin.PluginRNA;
import jp.sbi.celldesigner.plugin.PluginReaction;
import jp.sbi.celldesigner.plugin.PluginSBase;
import jp.sbi.celldesigner.plugin.PluginSpecies;
import plugin.ImportNotesDialog;
import plugin.ImportNotesPlugin;
import plugin.InvalidFileTypeException;

public class ReadAndImportNotes {
    private ImportNotesPlugin plugin;
    private int importCounter;

    public ReadAndImportNotes(ImportNotesPlugin _plugin) {
        this.plugin = _plugin;
    }

    protected String readNotesFile(File selectedFile, String selectedType) throws Exception {
        this.importCounter = 0;
        BufferedReader br = null;
        try {
            try {
                br = new BufferedReader(new FileReader(selectedFile));
                int idCol = -1;
                int notesCol = -1;
                int counter = 0;
                while (br.ready()) {
                    String line = br.readLine();
                    Pattern pattern = Pattern.compile("\".*\",|,");
                    String[] data = pattern.split(line);
                    if (counter == 0) {
                        int i = 0;
                        while (i < data.length) {
                            String element = data[i];
                            if (element.equals("id")) {
                                idCol = i;
                            }
                            if (element.equals("notes")) {
                                notesCol = i;
                            }
                            ++i;
                        }
                        if (idCol == -1 || idCol == data.length) {
                            throw new InvalidFileTypeException("ID column is not included.");
                        }
                        if (notesCol == -1) {
                            throw new InvalidFileTypeException("Notes column is not included.");
                        }
                    } else if (notesCol < data.length) {
                        String notes = data[notesCol];
                        if (notes.charAt(0) == '\"') {
                            String nextLine = null;
                            while ((nextLine = br.readLine()) != null) {
                                notes = String.valueOf(notes) + "\n" + nextLine;
                                int cnt = 0;
                                int p = 0;
                                while ((p = nextLine.indexOf(34, p)) != -1) {
                                    ++cnt;
                                    ++p;
                                }
                                if (cnt % 2 == 1) break;
                            }
                            notes = notes.replace("\"\"", "\"");
                            notes = notes.substring(1, notes.length() - 1);
                        }
                        if (notes != null && notes.length() != 0) {
                            String type = "";
                            if (selectedType.equals(ImportNotesDialog.fileType[0])) {
                                this.setSpeciesNotes(type, data[idCol], notes);
                            } else if (selectedType.equals(ImportNotesDialog.fileType[1])) {
                                this.setProteinNotes(type, data[idCol], notes);
                            } else if (selectedType.equals(ImportNotesDialog.fileType[2])) {
                                this.setGeneNotes(type, data[idCol], notes);
                            } else if (selectedType.equals(ImportNotesDialog.fileType[3])) {
                                this.setRNANotes(type, data[idCol], notes);
                            } else if (selectedType.equals(ImportNotesDialog.fileType[4])) {
                                this.setAsRNANotes(type, data[idCol], notes);
                            } else if (selectedType.equals(ImportNotesDialog.fileType[5])) {
                                this.setReactionNotes(type, data[idCol], notes);
                            } else if (selectedType.equals(ImportNotesDialog.fileType[6])) {
                                this.setCompartmentNotes(type, data[idCol], notes);
                            }
                        }
                    }
                    ++counter;
                }
            }
            catch (InvalidFileTypeException ife) {
                throw ife;
            }
            catch (IOException ie) {
                ie.printStackTrace();
                throw ie;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        }
        return this.importCounter <= 1 ? String.valueOf(this.importCounter) + "  " + selectedType + " Notes was imported." : String.valueOf(this.importCounter) + "  " + selectedType + " Notes were imported.";
    }

    private void setSpeciesNotes(String type, String id, String notes) {
        PluginSpecies species;
        PluginModel model = this.plugin.getSelectedModel();
        if (model != null && (species = model.getSpecies(id)) != null) {
            species.setNotes(notes);
            this.plugin.notifySBaseChanged((PluginSBase)species);
            ++this.importCounter;
        }
    }

    private void setProteinNotes(String type, String id, String notes) {
        PluginProtein protein;
        PluginModel model = this.plugin.getSelectedModel();
        if (model != null && (protein = model.getProtein(id)) != null) {
            protein.setNotes(notes);
            this.plugin.notifySBaseChanged((PluginSBase)protein);
            ++this.importCounter;
        }
    }

    private void setGeneNotes(String type, String id, String notes) {
        PluginGene gene;
        PluginModel model = this.plugin.getSelectedModel();
        if (model != null && (gene = model.getGene(id)) != null) {
            gene.setNotes(notes);
            this.plugin.notifySBaseChanged((PluginSBase)gene);
            ++this.importCounter;
        }
    }

    private void setRNANotes(String type, String id, String notes) {
        PluginRNA rna;
        PluginModel model = this.plugin.getSelectedModel();
        if (model != null && (rna = model.getRNA(id)) != null) {
            rna.setNotes(notes);
            this.plugin.notifySBaseChanged((PluginSBase)rna);
            ++this.importCounter;
        }
    }

    private void setAsRNANotes(String type, String id, String notes) {
        PluginAntiSenseRNA asrna;
        PluginModel model = this.plugin.getSelectedModel();
        if (model != null && (asrna = model.getAntiSenseRNA(id)) != null) {
            asrna.setNotes(notes);
            this.plugin.notifySBaseChanged((PluginSBase)asrna);
            ++this.importCounter;
        }
    }

    private void setReactionNotes(String type, String id, String notes) {
        PluginReaction reaction;
        PluginModel model = this.plugin.getSelectedModel();
        if (model != null && (reaction = model.getReaction(id)) != null) {
            reaction.setNotes(notes);
            this.plugin.notifySBaseChanged((PluginSBase)reaction);
            ++this.importCounter;
        }
    }

    private void setCompartmentNotes(String type, String id, String notes) {
        PluginCompartment compartment;
        PluginModel model = this.plugin.getSelectedModel();
        if (model != null && (compartment = model.getCompartment(id)) != null) {
            compartment.setNotes(notes);
            this.plugin.notifySBaseChanged((PluginSBase)compartment);
            ++this.importCounter;
        }
    }
}

