/**
 * 
 */
package org.celldesigner.plugin;

import java.awt.Color;
import java.awt.event.ActionEvent;

import javax.swing.JMenuItem;

import jp.sbi.celldesigner.plugin.*;

/**
 * @author Akira Funahashi <funa@celldesigner.org>
 *
 */
public class SamplePluginAction extends PluginAction {
	private SamplePlugin plugin;
	
	public SamplePluginAction(SamplePlugin plugin) {
		this.plugin = plugin;
	}
	
	public void myActionPerformed(ActionEvent e) {
		System.err.println("Version 0.1.0");
		if (((JMenuItem)e.getSource()).getText() == plugin.menuItem1.getText()) {
			PluginListOf plo = plugin.getSelectedSpeciesNode();
			PluginSpeciesAlias psa = (PluginSpeciesAlias)plo.get(0);
			System.out.println(psa.getName() + " " + psa.getAliasID() + " " + psa.getColor());
		} else if (((JMenuItem)e.getSource()).getText() == plugin.menuItem2.getText()) {
			PluginModel pm = plugin.getSelectedModel();
			PluginListOf plo = pm.getListOfAllSpeciesAlias();
			for (int i = 0; i < plo.getNumItems(); i++) {
				PluginSpeciesAlias psa = (PluginSpeciesAlias)plo.get(i);
				System.err.print(i + " : " + psa.getName());
				if (psa.getName().equals("MAPK")) {
					psa.setColor(Color.RED);
					plugin.notifySBaseChanged(psa);
					System.err.print(" : Color Changed!");
				} else if (psa.getName().equals("MKKK")) {
					psa.setFramePosition(psa.getX() + 100, psa.getY());
					plugin.notifySBaseChanged(psa);
					System.err.print(" : Moved!");
				} else if (psa.getName().equals("MKK")) {
					psa.setFrameSize(psa.getWidth() + 20, psa.getHeight() + 20);
					plugin.notifySBaseChanged(psa);
					System.err.print(" : Zoom!");
				}
				System.err.println("");
			}
		} else if (((JMenuItem)e.getSource()).getText() == plugin.menuItem3.getText()) {
			PluginModel pm = plugin.getSelectedModel();
			PluginListOf plo = pm.getListOfAllSpeciesAlias();
			for (int i = 0; i < plo.getNumItems(); i++) {
				PluginSpeciesAlias psa = (PluginSpeciesAlias)plo.get(i);
				System.err.print(i + " : " + psa.getName() + " : " + psa.getSpecies().getInitialAmount());
				if (psa.getSpecies().getInitialAmount() < 20.0 ||
					psa.getSpecies().getInitialConcentration() < 20.0) {
					psa.setColor(Color.WHITE);
					plugin.notifySBaseChanged(psa);
					System.err.print(" : Change Color!");
				}
				System.err.println("");
			}
		}
	}
}
