/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.39
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIGJAVA


#ifdef __cplusplus
/* SwigValueWrapper is described in swig.swg */
template<typename T> class SwigValueWrapper {
  struct SwigMovePointer {
    T *ptr;
    SwigMovePointer(T *p) : ptr(p) { }
    ~SwigMovePointer() { delete ptr; }
    SwigMovePointer& operator=(SwigMovePointer& rhs) { T* oldptr = ptr; ptr = 0; delete oldptr; ptr = rhs.ptr; rhs.ptr = 0; return *this; }
  } pointer;
  SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
  SwigValueWrapper(const SwigValueWrapper<T>& rhs);
public:
  SwigValueWrapper() : pointer(0) { }
  SwigValueWrapper& operator=(const T& t) { SwigMovePointer tmp(new T(t)); pointer = tmp; return *this; }
  operator T&() const { return *pointer.ptr; }
  T *operator&() { return pointer.ptr; }
};

template <typename T> T SwigValueInit() {
  return T();
}
#endif

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__)) 
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__)) 
# else
#   define SWIGUNUSED 
# endif
#endif

#ifndef SWIG_MSC_UNSUPPRESS_4505
# if defined(_MSC_VER)
#   pragma warning(disable : 4505) /* unreferenced local function has been removed */
# endif 
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#  ifndef GCC_HASCLASSVISIBILITY
#    define GCC_HASCLASSVISIBILITY
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif 
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif



/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTEL_COMPILER)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIGUNUSED SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" } };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else


#include "soslib.h"


#ifdef WIN32
char* convertUTF8ToANSI(const char* src_str); 
#endif

timeCourse_t* TimeCourseArray_getTimeCourse(timeCourseArray_t* tca, int i)
{
  if ( i >=0 && i < tca->num_val)
  {
    return tca->tc[i];
  }

  return NULL;
}

SBMLResults_t* s_odeSolver2(const char* filename, cvodeSettings_t* cset)
{
  SBMLResults_t* result = NULL;

#ifdef WIN32
  char* ansi_filename = convertUTF8ToANSI(filename);
  SBMLDocument_t* d = readSBML(ansi_filename ? ansi_filename : filename);
  delete [] ansi_filename;
#else
  SBMLDocument_t* d = readSBML(filename);
#endif
  Model_t* m = SBMLDocument_getModel(d); 

  if( m != NULL )
  {
    result = Model_odeSolver(m, cset); 
  }

  SBMLDocument_free(d);

  return result;
}

SBMLResultsArray_t* s_odeSolver3(const char* filename, cvodeSettings_t* cset, varySettings_t* vset)
{
  SBMLResultsArray_t* result = NULL;

#ifdef WIN32
  char* ansi_filename = convertUTF8ToANSI(filename);
  SBMLDocument_t* d = readSBML(ansi_filename ? ansi_filename : filename);
  delete [] ansi_filename;
#else
  SBMLDocument_t* d = readSBML(filename);
#endif
  Model_t* m = SBMLDocument_getModel(d); 

  if( m != NULL )
  {
    result = Model_odeSolverBatch(m, cset, vset); 
  }

  SBMLDocument_free(d);

  return result;
}

SBMLResultsArray_t* s_odeSolver4(const char* filename, cvodeSettings_t* cset, varySettings_t* vset)
{
  SBMLResultsArray_t* result = NULL;

#ifdef WIN32
  char* ansi_filename = convertUTF8ToANSI(filename);
  SBMLDocument_t* d = readSBML(ansi_filename ? ansi_filename : filename);
  delete [] ansi_filename;
#else
  SBMLDocument_t* d = readSBML(filename);
#endif
  Model_t* m = SBMLDocument_getModel(d); 

  if( m != NULL )
  {
    result = Model_odeSolverBatch(m, cset, vset); 
  }

  SBMLDocument_free(d);

  return result;
}


#ifdef WIN32
char* convertUTF8ToANSI(const char* src_str) 
{
	int      src_slen;
	int      length;
	int      c_length;
	wchar_t* wbuf;
	char*    abuf;

	src_slen = strlen(src_str);

	//
	// UTF8 -> Unicode
	//

//	printf("Start Convert : (%d) %s\n", src_slen, src_str);

	// Check src_str length
	length = MultiByteToWideChar(CP_UTF8,0,(LPCSTR)src_str,-1,NULL,0);
	if(length == 0){
		return NULL;
	}

    wbuf = new wchar_t[length+1];

//	printf("(UTF8->Unicode) Check Length\n");

	// Convert
	c_length = MultiByteToWideChar(CP_UTF8,0,(LPCSTR)src_str,-1,wbuf,length);
	wbuf[c_length] = 0;
	if(c_length == 0) {
        delete [] wbuf;
        return NULL;
	}

//	printf("(UTF8->Unicode) Convert : %d\n",c_length);

	//
	// Unicode -> ANSI
	//

	// Check wbuf length		
        // 
        // (2008-06-04: jouraku) 
        // Added WC_NO_BEST_FIT_CHARS option to WideCharToMultiByte function to translate any Unicode 
        // characters that do not translate directly to multibyte equivalents to the default character 
        // specified by lpDefaultChar. 
        // In other words, if translating from Unicode to multibyte and back to Unicode again does not 
        // yield the same Unicodes character,  the function uses the default character.
        // (cited from a document for WideCharToMultiByte function)
        // The purpose of this change is to avoid some malicious translation which can cause
        // security problems. 
        //
	length = WideCharToMultiByte(CP_ACP,WC_NO_BEST_FIT_CHARS, (LPCWSTR)wbuf,-1,NULL,0,NULL,NULL);

//	printf("(Unicode -> ANSI) Check Length : %d\n", length);

	if(length == 0){
       delete [] wbuf;
		return NULL;
	}

	abuf = new char[length+1];

	// Convert

        // (2008-06-04: jouraku) 
        // Added WC_NO_BEST_FIT_CHARS option to WideCharToMultiByte function to translate any Unicode 
        // characters that do not translate directly to multibyte equivalents to the default character 
        // specified by lpDefaultChar. 
        // In other words, if translating from Unicode to multibyte and back to Unicode again does not 
        // yield the same Unicodes character,  the function uses the default character.
        // (cited from a document for WideCharToMultiByte function)
        // The purpose of this change is to avoid some malicious translation which can cause
        // security problems. 
        //
	c_length = WideCharToMultiByte(CP_ACP, WC_NO_BEST_FIT_CHARS, (LPCWSTR)wbuf,-1,abuf,length,NULL,NULL);
	abuf[c_length] = 0;

	if(c_length == 0){
       delete [] wbuf;
       delete [] abuf;
		return NULL;
	}

//	printf("(Unicode -> ANSI) Convert : (%d) %s\n",c_length,abuf);

   delete [] wbuf;

	return abuf;

}
#endif



#ifdef __cplusplus
extern "C" {
#endif

SWIGEXPORT jlong JNICALL Java_org_sbml_soslib_soslibJNI_new_1varySettings(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  varySettings *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (varySettings *)new varySettings();
  *(varySettings **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_delete_1varySettings(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  varySettings *arg1 = (varySettings *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(varySettings **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_sbml_soslib_soslibJNI_VarySettings_1allocate(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jlong jresult = 0 ;
  int arg1 ;
  int arg2 ;
  varySettings_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  result = (varySettings_t *)VarySettings_allocate(arg1,arg2);
  *(varySettings_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_VarySettings_1addParameter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  jint jresult = 0 ;
  varySettings_t *arg1 = (varySettings_t *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(varySettings_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (int)VarySettings_addParameter(arg1,arg2,arg3);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_VarySettings_1addDesignPoint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdoubleArray jarg2) {
  jint jresult = 0 ;
  varySettings_t *arg1 = (varySettings_t *) 0 ;
  double *arg2 = (double *) 0 ;
  jint size2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(varySettings_t **)&jarg1; 
  {
    int i=0;
    jboolean isCopy;
    size2 = jenv->GetArrayLength(jarg2);
    arg2 = new double[size2];
    jdouble* jd_array = (jdouble*)jenv->GetDoubleArrayElements(jarg2, &isCopy);
    
    for(i=0; i < size2; i++)
    {
      arg2[i] = jd_array[i];
    }
    
    if (isCopy == JNI_TRUE)
    {
      jenv->ReleaseDoubleArrayElements(jarg2, jd_array, 0);
    }
  }
  result = (int)VarySettings_addDesignPoint(arg1,arg2);
  jresult = (jint)result; 
  {
    delete [] arg2;
  }
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_VarySettings_1setValueByID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3, jstring jarg4, jdouble jarg5) {
  jint jresult = 0 ;
  varySettings_t *arg1 = (varySettings_t *) 0 ;
  int arg2 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  double arg5 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(varySettings_t **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = (double)jarg5; 
  result = (int)VarySettings_setValueByID(arg1,arg2,arg3,arg4,arg5);
  jresult = (jint)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_sbml_soslib_soslibJNI_VarySettings_1getValueByID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3, jstring jarg4) {
  jdouble jresult = 0 ;
  varySettings_t *arg1 = (varySettings_t *) 0 ;
  int arg2 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(varySettings_t **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  result = (double)VarySettings_getValueByID(arg1,arg2,arg3,arg4);
  jresult = (jdouble)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_VarySettings_1setName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3, jstring jarg4) {
  jint jresult = 0 ;
  varySettings_t *arg1 = (varySettings_t *) 0 ;
  int arg2 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(varySettings_t **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  result = (int)VarySettings_setName(arg1,arg2,arg3,arg4);
  jresult = (jint)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_VarySettings_1setValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jdouble jarg4) {
  varySettings_t *arg1 = (varySettings_t *) 0 ;
  int arg2 ;
  int arg3 ;
  double arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(varySettings_t **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (double)jarg4; 
  VarySettings_setValue(arg1,arg2,arg3,arg4);
}


SWIGEXPORT jdouble JNICALL Java_org_sbml_soslib_soslibJNI_VarySettings_1getValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  jdouble jresult = 0 ;
  varySettings_t *arg1 = (varySettings_t *) 0 ;
  int arg2 ;
  int arg3 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(varySettings_t **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  result = (double)VarySettings_getValue(arg1,arg2,arg3);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_sbml_soslib_soslibJNI_VarySettings_1getName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jstring jresult = 0 ;
  varySettings_t *arg1 = (varySettings_t *) 0 ;
  int arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(varySettings_t **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (char *)VarySettings_getName(arg1,arg2);
  if(result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_sbml_soslib_soslibJNI_VarySettings_1getReactionName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jstring jresult = 0 ;
  varySettings_t *arg1 = (varySettings_t *) 0 ;
  int arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(varySettings_t **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (char *)VarySettings_getReactionName(arg1,arg2);
  if(result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_VarySettings_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  varySettings_t *arg1 = (varySettings_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(varySettings_t **)&jarg1; 
  VarySettings_dump(arg1);
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_VarySettings_1free(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  VarySettings_free();
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_timeCourse_1timepoints_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  timeCourse *arg1 = (timeCourse *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(timeCourse **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->timepoints = arg2;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_timeCourse_1timepoints_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  timeCourse *arg1 = (timeCourse *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(timeCourse **)&jarg1; 
  result = (int) ((arg1)->timepoints);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_timeCourse_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  timeCourse *arg1 = (timeCourse *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(timeCourse **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->name) delete [] arg1->name;
    if (arg2) {
      arg1->name = (char *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->name, (const char *)arg2);
    } else {
      arg1->name = 0;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_org_sbml_soslib_soslibJNI_timeCourse_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  timeCourse *arg1 = (timeCourse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(timeCourse **)&jarg1; 
  result = (char *) ((arg1)->name);
  if(result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sbml_soslib_soslibJNI_new_1timeCourse(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  timeCourse *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (timeCourse *)new timeCourse();
  *(timeCourse **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_delete_1timeCourse(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  timeCourse *arg1 = (timeCourse *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(timeCourse **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_timeCourseArray_1num_1val_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  timeCourseArray *arg1 = (timeCourseArray *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(timeCourseArray **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->num_val = arg2;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_timeCourseArray_1num_1val_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  timeCourseArray *arg1 = (timeCourseArray *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(timeCourseArray **)&jarg1; 
  result = (int) ((arg1)->num_val);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sbml_soslib_soslibJNI_new_1timeCourseArray(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  timeCourseArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (timeCourseArray *)new timeCourseArray();
  *(timeCourseArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_delete_1timeCourseArray(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  timeCourseArray *arg1 = (timeCourseArray *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(timeCourseArray **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI__1SBMLResults_1time_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  _SBMLResults *arg1 = (_SBMLResults *) 0 ;
  timeCourse_t *arg2 = (timeCourse_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(_SBMLResults **)&jarg1; 
  arg2 = *(timeCourse_t **)&jarg2; 
  if (arg1) (arg1)->time = arg2;
}


SWIGEXPORT jlong JNICALL Java_org_sbml_soslib_soslibJNI__1SBMLResults_1time_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  _SBMLResults *arg1 = (_SBMLResults *) 0 ;
  timeCourse_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(_SBMLResults **)&jarg1; 
  result = (timeCourse_t *) ((arg1)->time);
  *(timeCourse_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI__1SBMLResults_1species_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  _SBMLResults *arg1 = (_SBMLResults *) 0 ;
  timeCourseArray_t *arg2 = (timeCourseArray_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(_SBMLResults **)&jarg1; 
  arg2 = *(timeCourseArray_t **)&jarg2; 
  if (arg1) (arg1)->species = arg2;
}


SWIGEXPORT jlong JNICALL Java_org_sbml_soslib_soslibJNI__1SBMLResults_1species_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  _SBMLResults *arg1 = (_SBMLResults *) 0 ;
  timeCourseArray_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(_SBMLResults **)&jarg1; 
  result = (timeCourseArray_t *) ((arg1)->species);
  *(timeCourseArray_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI__1SBMLResults_1compartments_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  _SBMLResults *arg1 = (_SBMLResults *) 0 ;
  timeCourseArray_t *arg2 = (timeCourseArray_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(_SBMLResults **)&jarg1; 
  arg2 = *(timeCourseArray_t **)&jarg2; 
  if (arg1) (arg1)->compartments = arg2;
}


SWIGEXPORT jlong JNICALL Java_org_sbml_soslib_soslibJNI__1SBMLResults_1compartments_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  _SBMLResults *arg1 = (_SBMLResults *) 0 ;
  timeCourseArray_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(_SBMLResults **)&jarg1; 
  result = (timeCourseArray_t *) ((arg1)->compartments);
  *(timeCourseArray_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI__1SBMLResults_1parameters_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  _SBMLResults *arg1 = (_SBMLResults *) 0 ;
  timeCourseArray_t *arg2 = (timeCourseArray_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(_SBMLResults **)&jarg1; 
  arg2 = *(timeCourseArray_t **)&jarg2; 
  if (arg1) (arg1)->parameters = arg2;
}


SWIGEXPORT jlong JNICALL Java_org_sbml_soslib_soslibJNI__1SBMLResults_1parameters_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  _SBMLResults *arg1 = (_SBMLResults *) 0 ;
  timeCourseArray_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(_SBMLResults **)&jarg1; 
  result = (timeCourseArray_t *) ((arg1)->parameters);
  *(timeCourseArray_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI__1SBMLResults_1fluxes_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  _SBMLResults *arg1 = (_SBMLResults *) 0 ;
  timeCourseArray_t *arg2 = (timeCourseArray_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(_SBMLResults **)&jarg1; 
  arg2 = *(timeCourseArray_t **)&jarg2; 
  if (arg1) (arg1)->fluxes = arg2;
}


SWIGEXPORT jlong JNICALL Java_org_sbml_soslib_soslibJNI__1SBMLResults_1fluxes_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  _SBMLResults *arg1 = (_SBMLResults *) 0 ;
  timeCourseArray_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(_SBMLResults **)&jarg1; 
  result = (timeCourseArray_t *) ((arg1)->fluxes);
  *(timeCourseArray_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sbml_soslib_soslibJNI_new_1_1SBMLResults(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  _SBMLResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (_SBMLResults *)new _SBMLResults();
  *(_SBMLResults **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_delete_1_1SBMLResults(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  _SBMLResults *arg1 = (_SBMLResults *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(_SBMLResults **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_sbml_soslib_soslibJNI_new_1_1SBMLResultsArray(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  _SBMLResultsArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (_SBMLResultsArray *)new _SBMLResultsArray();
  *(_SBMLResultsArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_delete_1_1SBMLResultsArray(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  _SBMLResultsArray *arg1 = (_SBMLResultsArray *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(_SBMLResultsArray **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_sbml_soslib_soslibJNI_SBMLResults_1getTime(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SBMLResults_t *arg1 = (SBMLResults_t *) 0 ;
  timeCourse_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SBMLResults_t **)&jarg1; 
  result = (timeCourse_t *)SBMLResults_getTime(arg1);
  *(timeCourse_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sbml_soslib_soslibJNI_SBMLResults_1getTimeCourse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  SBMLResults_t *arg1 = (SBMLResults_t *) 0 ;
  char *arg2 = (char *) 0 ;
  timeCourse_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SBMLResults_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (timeCourse_t *)SBMLResults_getTimeCourse(arg1,(char const *)arg2);
  *(timeCourse_t **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SBMLResults_1getNout(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SBMLResults_t *arg1 = (SBMLResults_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SBMLResults_t **)&jarg1; 
  result = (int)SBMLResults_getNout(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SBMLResults_1getNumSens(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  SBMLResults_t *arg1 = (SBMLResults_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SBMLResults_t **)&jarg1; 
  result = (int)SBMLResults_getNumSens(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_sbml_soslib_soslibJNI_SBMLResults_1getSensParam(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jstring jresult = 0 ;
  SBMLResults_t *arg1 = (SBMLResults_t *) 0 ;
  int arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SBMLResults_t **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (char *)SBMLResults_getSensParam(arg1,arg2);
  if(result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_sbml_soslib_soslibJNI_TimeCourse_1getName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  timeCourse_t *arg1 = (timeCourse_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(timeCourse_t **)&jarg1; 
  result = (char *)TimeCourse_getName(arg1);
  if(result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_TimeCourse_1getNumValues(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  timeCourse_t *arg1 = (timeCourse_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(timeCourse_t **)&jarg1; 
  result = (int)TimeCourse_getNumValues(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_sbml_soslib_soslibJNI_TimeCourse_1getValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jdouble jresult = 0 ;
  timeCourse_t *arg1 = (timeCourse_t *) 0 ;
  int arg2 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(timeCourse_t **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (double)TimeCourse_getValue(arg1,arg2);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_sbml_soslib_soslibJNI_TimeCourse_1getSensitivity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  jdouble jresult = 0 ;
  timeCourse_t *arg1 = (timeCourse_t *) 0 ;
  int arg2 ;
  int arg3 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(timeCourse_t **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  result = (double)TimeCourse_getSensitivity(arg1,arg2,arg3);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_SBMLResults_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  SBMLResults_t *arg1 = (SBMLResults_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SBMLResults_t **)&jarg1; 
  SBMLResults_dump(arg1);
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_SBMLResults_1dumpSpecies(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  SBMLResults_t *arg1 = (SBMLResults_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SBMLResults_t **)&jarg1; 
  SBMLResults_dumpSpecies(arg1);
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_SBMLResults_1dumpCompartments(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  SBMLResults_t *arg1 = (SBMLResults_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SBMLResults_t **)&jarg1; 
  SBMLResults_dumpCompartments(arg1);
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_SBMLResults_1dumpParameters(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  SBMLResults_t *arg1 = (SBMLResults_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SBMLResults_t **)&jarg1; 
  SBMLResults_dumpParameters(arg1);
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_SBMLResults_1dumpFluxes(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  SBMLResults_t *arg1 = (SBMLResults_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SBMLResults_t **)&jarg1; 
  SBMLResults_dumpFluxes(arg1);
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_SBMLResults_1free(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  SBMLResults_t *arg1 = (SBMLResults_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SBMLResults_t **)&jarg1; 
  SBMLResults_free(arg1);
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_SBMLResultsArray_1free(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  SBMLResultsArray_t *arg1 = (SBMLResultsArray_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SBMLResultsArray_t **)&jarg1; 
  SBMLResultsArray_free(arg1);
}


SWIGEXPORT jlong JNICALL Java_org_sbml_soslib_soslibJNI_SBMLResultsArray_1getResults(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  SBMLResultsArray_t *arg1 = (SBMLResultsArray_t *) 0 ;
  int arg2 ;
  SBMLResults_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SBMLResultsArray_t **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (SBMLResults_t *)SBMLResultsArray_getResults(arg1,arg2);
  *(SBMLResults_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sbml_soslib_soslibJNI_new_1cvodeSettings(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  cvodeSettings *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (cvodeSettings *)new cvodeSettings();
  *(cvodeSettings **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_delete_1cvodeSettings(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  cvodeSettings *arg1 = (cvodeSettings *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(cvodeSettings **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1create(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  cvodeSettings_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (cvodeSettings_t *)CvodeSettings_create();
  *(cvodeSettings_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1createWithTime(JNIEnv *jenv, jclass jcls, jdouble jarg1, jint jarg2) {
  jlong jresult = 0 ;
  double arg1 ;
  int arg2 ;
  cvodeSettings_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (double)jarg1; 
  arg2 = (int)jarg2; 
  result = (cvodeSettings_t *)CvodeSettings_createWithTime(arg1,arg2);
  *(cvodeSettings_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1createWith(JNIEnv *jenv, jclass jcls, jdouble jarg1, jint jarg2, jdouble jarg3, jdouble jarg4, jint jarg5, jint jarg6, jint jarg7, jint jarg8, jint jarg9, jint jarg10, jint jarg11, jint jarg12, jint jarg13, jint jarg14) {
  jlong jresult = 0 ;
  double arg1 ;
  int arg2 ;
  double arg3 ;
  double arg4 ;
  int arg5 ;
  int arg6 ;
  int arg7 ;
  int arg8 ;
  int arg9 ;
  int arg10 ;
  int arg11 ;
  int arg12 ;
  int arg13 ;
  int arg14 ;
  cvodeSettings_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (double)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = (int)jarg5; 
  arg6 = (int)jarg6; 
  arg7 = (int)jarg7; 
  arg8 = (int)jarg8; 
  arg9 = (int)jarg9; 
  arg10 = (int)jarg10; 
  arg11 = (int)jarg11; 
  arg12 = (int)jarg12; 
  arg13 = (int)jarg13; 
  arg14 = (int)jarg14; 
  result = (cvodeSettings_t *)CvodeSettings_createWith(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13,arg14);
  *(cvodeSettings_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1setTime(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jint jarg3) {
  jint jresult = 0 ;
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  double arg2 ;
  int arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (int)jarg3; 
  result = (int)CvodeSettings_setTime(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1setTimeStep(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jdouble jarg3) {
  jint jresult = 0 ;
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  int arg2 ;
  double arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (double)jarg3; 
  result = (int)CvodeSettings_setTimeStep(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1setDiscreteObservation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  CvodeSettings_setDiscreteObservation(arg1);
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1unsetDiscreteObservation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  CvodeSettings_unsetDiscreteObservation(arg1);
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1setForwAdjTimeSeriesFromData(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3) {
  jint jresult = 0 ;
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (int)jarg3; 
  result = (int)CvodeSettings_setForwAdjTimeSeriesFromData(arg1,arg2,arg3);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1setSwitches(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jint jarg4, jint jarg5, jint jarg6, jint jarg7, jint jarg8) {
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  int arg6 ;
  int arg7 ;
  int arg8 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  arg6 = (int)jarg6; 
  arg7 = (int)jarg7; 
  arg8 = (int)jarg8; 
  CvodeSettings_setSwitches(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1setErrors(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jint jarg4) {
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  double arg2 ;
  double arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (int)jarg4; 
  CvodeSettings_setErrors(arg1,arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1setError(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  arg2 = (double)jarg2; 
  CvodeSettings_setError(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1setRError(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  arg2 = (double)jarg2; 
  CvodeSettings_setRError(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1setMxstep(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  arg2 = (int)jarg2; 
  CvodeSettings_setMxstep(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1setDetectNegState(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  arg2 = (int)jarg2; 
  CvodeSettings_setDetectNegState(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1setTStop(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  arg2 = (int)jarg2; 
  CvodeSettings_setTStop(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1setCompileFunctions(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  arg2 = (int)jarg2; 
  CvodeSettings_setCompileFunctions(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1setResetCvodeOnEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  arg2 = (int)jarg2; 
  CvodeSettings_setResetCvodeOnEvent(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1setDoAdj(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  CvodeSettings_setDoAdj(arg1);
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1unsetDoAdj(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  CvodeSettings_unsetDoAdj(arg1);
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1setAdjErrors(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3) {
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  double arg2 ;
  double arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  CvodeSettings_setAdjErrors(arg1,arg2,arg3);
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1setAdjError(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  arg2 = (double)jarg2; 
  CvodeSettings_setAdjError(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1setAdjRError(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  arg2 = (double)jarg2; 
  CvodeSettings_setAdjRError(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1setnSaveSteps(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  arg2 = (int)jarg2; 
  CvodeSettings_setnSaveSteps(arg1,arg2);
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1setAdjTime(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jint jarg3) {
  jint jresult = 0 ;
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  double arg2 ;
  int arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (int)jarg3; 
  result = (int)CvodeSettings_setAdjTime(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1setMethod(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  int arg2 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  CvodeSettings_setMethod(arg1,arg2,arg3);
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1setIterMethod(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  arg2 = (int)jarg2; 
  CvodeSettings_setIterMethod(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1setMaxOrder(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  arg2 = (int)jarg2; 
  CvodeSettings_setMaxOrder(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1setJacobian(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  arg2 = (int)jarg2; 
  CvodeSettings_setJacobian(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1setIndefinitely(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  arg2 = (int)jarg2; 
  CvodeSettings_setIndefinitely(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1setHaltOnEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  arg2 = (int)jarg2; 
  CvodeSettings_setHaltOnEvent(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1setHaltOnSteadyState(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  arg2 = (int)jarg2; 
  CvodeSettings_setHaltOnSteadyState(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1setSteadyStateThreshold(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  arg2 = (double)jarg2; 
  CvodeSettings_setSteadyStateThreshold(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1setStoreResults(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  arg2 = (int)jarg2; 
  CvodeSettings_setStoreResults(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1setSensitivity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  arg2 = (int)jarg2; 
  CvodeSettings_setSensitivity(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1unsetSensParams(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  CvodeSettings_unsetSensParams(arg1);
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1setSensMethod(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  arg2 = (int)jarg2; 
  CvodeSettings_setSensMethod(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  CvodeSettings_dump(arg1);
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1free(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  CvodeSettings_free(arg1);
}


SWIGEXPORT jlong JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1clone(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  cvodeSettings_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  result = (cvodeSettings_t *)CvodeSettings_clone(arg1);
  *(cvodeSettings_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1getEndTime(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  result = (double)CvodeSettings_getEndTime(arg1);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1getPrintsteps(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  result = (int)CvodeSettings_getPrintsteps(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1getTimeStep(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  result = (double)CvodeSettings_getTimeStep(arg1);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1getTime(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jdouble jresult = 0 ;
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  int arg2 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (double)CvodeSettings_getTime(arg1,arg2);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1getError(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  result = (double)CvodeSettings_getError(arg1);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1getRError(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  result = (double)CvodeSettings_getRError(arg1);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1getMxstep(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  result = (int)CvodeSettings_getMxstep(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1getMethod(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  result = (char *)CvodeSettings_getMethod(arg1);
  if(result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1getIterMethod(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  result = (char *)CvodeSettings_getIterMethod(arg1);
  if(result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1getMaxOrder(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  result = (int)CvodeSettings_getMaxOrder(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1getCompileFunctions(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  result = (int)CvodeSettings_getCompileFunctions(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1getResetCvodeOnEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  result = (int)CvodeSettings_getResetCvodeOnEvent(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1getJacobian(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  result = (int)CvodeSettings_getJacobian(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1getIndefinitely(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  result = (int)CvodeSettings_getIndefinitely(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1getHaltOnEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  result = (int)CvodeSettings_getHaltOnEvent(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1getHaltOnSteadyState(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  result = (int)CvodeSettings_getHaltOnSteadyState(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1getSteadyStateThreshold(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  result = (double)CvodeSettings_getSteadyStateThreshold(arg1);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1getStoreResults(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  result = (int)CvodeSettings_getStoreResults(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1getSensitivity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  result = (int)CvodeSettings_getSensitivity(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_sbml_soslib_soslibJNI_CvodeSettings_1getSensMethod(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  cvodeSettings_t *arg1 = (cvodeSettings_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(cvodeSettings_t **)&jarg1; 
  result = (char *)CvodeSettings_getSensMethod(arg1);
  if(result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1ODE_1COULD_1NOT_1BE_1CONSTRUCTED_1FOR_1SPECIES_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_ODE_COULD_NOT_BE_CONSTRUCTED_FOR_SPECIES;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1THE_1MODEL_1CONTAINS_1EVENTS_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_THE_MODEL_CONTAINS_EVENTS;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1THE_1MODEL_1CONTAINS_1ALGEBRAIC_1RULES_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_THE_MODEL_CONTAINS_ALGEBRAIC_RULES;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1ODE_1MODEL_1COULD_1NOT_1BE_1CONSTRUCTED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_ODE_MODEL_COULD_NOT_BE_CONSTRUCTED;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1NO_1KINETIC_1LAW_1FOUND_1FOR_1REACTION_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_NO_KINETIC_LAW_FOUND_FOR_REACTION;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1ENTRIES_1OF_1THE_1JACOBIAN_1MATRIX_1COULD_1NOT_1BE_1CONSTRUCTED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_ENTRIES_OF_THE_JACOBIAN_MATRIX_COULD_NOT_BE_CONSTRUCTED;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1MODEL_1NOT_1SIMPLIFIED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_MODEL_NOT_SIMPLIFIED;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1ENTRIES_1OF_1THE_1PARAMETRIC_1MATRIX_1COULD_1NOT_1BE_1CONSTRUCTED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_ENTRIES_OF_THE_PARAMETRIC_MATRIX_COULD_NOT_BE_CONSTRUCTED;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1REQUESTED_1PARAMETER_1NOT_1FOUND_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_REQUESTED_PARAMETER_NOT_FOUND;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1THE_1MODEL_1CONTAINS_1PIECEWISE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_THE_MODEL_CONTAINS_PIECEWISE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1MAKE_1SURE_1SCHEMA_1IS_1ON_1PATH_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_MAKE_SURE_SCHEMA_IS_ON_PATH;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1CANNOT_1PARSE_1MODEL_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_CANNOT_PARSE_MODEL;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1DOCUMENTLEVEL_1ONE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_DOCUMENTLEVEL_ONE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1NO_1GRAPHVIZ_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_NO_GRAPHVIZ;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1INTEGRATOR_1SETTINGS_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_INTEGRATOR_SETTINGS;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1VARY_1SETTINGS_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_VARY_SETTINGS;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1INTEGRATION_1NOT_1SUCCESSFUL_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_INTEGRATION_NOT_SUCCESSFUL;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1EVENT_1TRIGGER_1FIRED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_EVENT_TRIGGER_FIRED;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1CVODE_1MALLOC_1FAILED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_CVODE_MALLOC_FAILED;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1CVODE_1REINIT_1FAILED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_CVODE_REINIT_FAILED;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1AST_1UNKNOWN_1NODE_1TYPE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_AST_UNKNOWN_NODE_TYPE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1AST_1UNKNOWN_1FAILURE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_AST_UNKNOWN_FAILURE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1AST_1EVALUATION_1FAILED_1MISSING_1VALUE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_AST_EVALUATION_FAILED_MISSING_VALUE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1AST_1EVALUATION_1FAILED_1DELAY_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_AST_EVALUATION_FAILED_DELAY;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1AST_1EVALUATION_1FAILED_1LAMBDA_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_AST_EVALUATION_FAILED_LAMBDA;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1AST_1EVALUATION_1FAILED_1FUNCTION_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_AST_EVALUATION_FAILED_FUNCTION;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1AST_1EVALUATION_1FAILED_1FLOAT_1FACTORIAL_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_AST_EVALUATION_FAILED_FLOAT_FACTORIAL;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1AST_1EVALUATION_1FAILED_1PIECEWISE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_AST_EVALUATION_FAILED_PIECEWISE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1AST_1EVALUATION_1FAILED_1DISCRETE_1DATA_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_AST_EVALUATION_FAILED_DISCRETE_DATA;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1AST_1DIFFERENTIATION_1FAILED_1CONSTANT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_AST_DIFFERENTIATION_FAILED_CONSTANT;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1AST_1DIFFERENTIATION_1FAILED_1OPERATOR_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_AST_DIFFERENTIATION_FAILED_OPERATOR;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1AST_1DIFFERENTIATION_1FAILED_1LAMBDA_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_AST_DIFFERENTIATION_FAILED_LAMBDA;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1AST_1DIFFERENTIATION_1FAILED_1DELAY_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_AST_DIFFERENTIATION_FAILED_DELAY;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1AST_1DIFFERENTIATION_1FAILED_1FACTORIAL_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_AST_DIFFERENTIATION_FAILED_FACTORIAL;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1AST_1DIFFERENTIATION_1FAILED_1PIECEWISE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_AST_DIFFERENTIATION_FAILED_PIECEWISE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1AST_1DIFFERENTIATION_1FAILED_1LOGICAL_1OR_1RELATIONAL_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_AST_DIFFERENTIATION_FAILED_LOGICAL_OR_RELATIONAL;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1CVODE_1RESULTS_1FAILED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_CVODE_RESULTS_FAILED;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1SBML_1RESULTS_1FAILED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_SBML_RESULTS_FAILED;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1VECTOR_1V_1FAILED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_VECTOR_V_FAILED;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1OBJECTIVE_1FUNCTION_1FAILED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_OBJECTIVE_FUNCTION_FAILED;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1OBJECTIVE_1FUNCTION_1V_1VECTOR_1COULD_1NOT_1BE_1CONSTRUCTED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_OBJECTIVE_FUNCTION_V_VECTOR_COULD_NOT_BE_CONSTRUCTED;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1MESSAGE_1RERUN_1WITH_1OR_1WO_1JACOBIAN_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_MESSAGE_RERUN_WITH_OR_WO_JACOBIAN;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1MESSAGE_1STEADYSTATE_1FOUND_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_MESSAGE_STEADYSTATE_FOUND;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1UPDATE_1ADJDATA_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_UPDATE_ADJDATA;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1INITIALIZE_1ADJDATA_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_INITIALIZE_ADJDATA;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1MESSAGE_1INTERPOLATION_1OUT_1OF_1RANGE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_MESSAGE_INTERPOLATION_OUT_OF_RANGE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1NO_1MORE_1MEMORY_1AVAILABLE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_NO_MORE_MEMORY_AVAILABLE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1WIN32_1ERROR_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_WIN32_ERROR;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1WIN32_1FORMAT_1ERROR_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_WIN32_FORMAT_ERROR;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1COMPILATION_1FAILED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_COMPILATION_FAILED;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1CANNOT_1COMPILE_1JACOBIAN_1NOT_1COMPUTED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_CANNOT_COMPILE_JACOBIAN_NOT_COMPUTED;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1AST_1COMPILATION_1FAILED_1DATA_1AST_1NODE_1NOT_1SUPPORTED_1YET_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_AST_COMPILATION_FAILED_DATA_AST_NODE_NOT_SUPPORTED_YET;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1AST_1COMPILATION_1FAILED_1MISSING_1VALUE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_AST_COMPILATION_FAILED_MISSING_VALUE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1AST_1COMPILATION_1FAILED_1STRANGE_1NODE_1TYPE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_AST_COMPILATION_FAILED_STRANGE_NODE_TYPE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1CANNOT_1COMPILE_1SENSITIVITY_1NOT_1COMPUTED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_CANNOT_COMPILE_SENSITIVITY_NOT_COMPUTED;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1GCC_1FORK_1FAILED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_GCC_FORK_FAILED;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1DL_1LOAD_1FAILED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_DL_LOAD_FAILED;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1DL_1SYMBOL_1UNDEFINED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_DL_SYMBOL_UNDEFINED;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1OPEN_1FILE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_OPEN_FILE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1SYMBOL_1IS_1NOT_1IN_1MODEL_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_SYMBOL_IS_NOT_IN_MODEL;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1ATTEMPTING_1TO_1COPY_1VARIABLE_1STATE_1BETWEEN_1INSTANCES_1OF_1DIFFERENT_1MODELS_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_ATTEMPTING_TO_COPY_VARIABLE_STATE_BETWEEN_INSTANCES_OF_DIFFERENT_MODELS;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SOLVER_1ERROR_1ATTEMPTING_1TO_1SET_1IMPOSSIBLE_1INITIAL_1TIME_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorCode result;
  
  (void)jenv;
  (void)jcls;
  result = (errorCode)SOLVER_ERROR_ATTEMPTING_TO_SET_IMPOSSIBLE_INITIAL_TIME;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_FATAL_1ERROR_1TYPE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorType result;
  
  (void)jenv;
  (void)jcls;
  result = (errorType)FATAL_ERROR_TYPE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_ERROR_1ERROR_1TYPE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorType result;
  
  (void)jenv;
  (void)jcls;
  result = (errorType)ERROR_ERROR_TYPE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_WARNING_1ERROR_1TYPE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorType result;
  
  (void)jenv;
  (void)jcls;
  result = (errorType)WARNING_ERROR_TYPE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_NUMBER_1OF_1ERROR_1TYPES_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorType result;
  
  (void)jenv;
  (void)jcls;
  result = (errorType)NUMBER_OF_ERROR_TYPES;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_MESSAGE_1ERROR_1TYPE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  errorType result;
  
  (void)jenv;
  (void)jcls;
  result = (errorType)MESSAGE_ERROR_TYPE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SolverError_1getNum(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jint jresult = 0 ;
  errorType_t arg1 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (errorType_t)jarg1; 
  result = (int)SolverError_getNum(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_sbml_soslib_soslibJNI_SolverError_1getMessage(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jstring jresult = 0 ;
  errorType_t arg1 ;
  int arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (errorType_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (char *)SolverError_getMessage(arg1,arg2);
  if(result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SolverError_1getCode(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jint jresult = 0 ;
  errorType_t arg1 ;
  int arg2 ;
  errorCode_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (errorType_t)jarg1; 
  arg2 = (int)jarg2; 
  result = (errorCode_t)SolverError_getCode(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sbml_soslib_soslibJNI_SolverError_1getLastCode(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jint jresult = 0 ;
  errorType_t arg1 ;
  errorCode_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (errorType_t)jarg1; 
  result = (errorCode_t)SolverError_getLastCode(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_SolverError_1clear(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  SolverError_clear();
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_SolverError_1haltOnErrors(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  SolverError_haltOnErrors();
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_SolverError_1dump(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  SolverError_dump();
}


SWIGEXPORT jstring JNICALL Java_org_sbml_soslib_soslibJNI_SolverError_1dumpToString(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)SolverError_dumpToString();
  if(result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_SolverError_1freeDumpString(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  char *arg1 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return ;
  }
  SolverError_freeDumpString(arg1);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
}


SWIGEXPORT void JNICALL Java_org_sbml_soslib_soslibJNI_SolverError_1dumpAndClearErrors(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  SolverError_dumpAndClearErrors();
}


SWIGEXPORT jlong JNICALL Java_org_sbml_soslib_soslibJNI_TimeCourseArray_1getTimeCourse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  timeCourseArray_t *arg1 = (timeCourseArray_t *) 0 ;
  int arg2 ;
  timeCourse_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(timeCourseArray_t **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (timeCourse_t *)TimeCourseArray_getTimeCourse(arg1,arg2);
  *(timeCourse_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sbml_soslib_soslibJNI_s_1odeSolver2(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  cvodeSettings_t *arg2 = (cvodeSettings_t *) 0 ;
  SBMLResults_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = *(cvodeSettings_t **)&jarg2; 
  result = (SBMLResults_t *)s_odeSolver2((char const *)arg1,arg2);
  *(SBMLResults_t **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sbml_soslib_soslibJNI_s_1odeSolver3(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  cvodeSettings_t *arg2 = (cvodeSettings_t *) 0 ;
  varySettings_t *arg3 = (varySettings_t *) 0 ;
  SBMLResultsArray_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = *(cvodeSettings_t **)&jarg2; 
  arg3 = *(varySettings_t **)&jarg3; 
  result = (SBMLResultsArray_t *)s_odeSolver3((char const *)arg1,arg2,arg3);
  *(SBMLResultsArray_t **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sbml_soslib_soslibJNI_s_1odeSolver4(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  cvodeSettings_t *arg2 = (cvodeSettings_t *) 0 ;
  varySettings_t *arg3 = (varySettings_t *) 0 ;
  SBMLResultsArray_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = *(cvodeSettings_t **)&jarg2; 
  arg3 = *(varySettings_t **)&jarg3; 
  result = (SBMLResultsArray_t *)s_odeSolver4((char const *)arg1,arg2,arg3);
  *(SBMLResultsArray_t **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


#ifdef __cplusplus
}
#endif

