#include <stdlib.h>
#ifdef WIN32
#include <windows.h>
#include <winnls.h>
#endif

#include "jp_co_mki_celldesigner_simulation_Simulator.h"

#include <sbmlsolver/odeSolver.h>
#include <sbmlsolver/sbml.h>
#include <sbmlsolver/options.h>
#include <sbmlsolver/integratorSettings.h>

/*
#include <printModel.h>
*/


extern int odeSolver (int argc, char *argv[]);
extern SBMLResults_t * Model_odeSolver(SBMLDocument_t *d, cvodeSettings_t *set);
extern SBMLResults_t ** Model_odeSolverBatch(SBMLDocument_t *d,cvodeSettings_t *settings, VarySettings vary);
//void printConcentrationTimeCourse(CvodeData data);

#ifdef WIN32
char* convert_multibyte_str(const char* src_str);
#endif

/*
 * Class:     jp_co_mki_celldesigner_simulation_Simulator
 * Method:    s_odeSolver2
 * Signature: ([Ljava/lang/String;)Ljp/co/mki/celldesigner/simulation/SBMLResults;
 */
JNIEXPORT jobject JNICALL Java_jp_co_mki_celldesigner_simulation_Simulator_s_1odeSolver2
  (JNIEnv *env, jclass clazz, jobjectArray args) {
#ifdef WIN32
	char *model_path;
#endif
    char **parameters;
    int i;
    char model[256];
    double time = 0.0;
    double printstep = 1.0;
    SBMLDocument_t *d;
    SBMLReader_t *sr;
    SBMLResults_t *sbml_results;
    cvodeSettings_t *set;

	jclass cTimeCourse ;
	jmethodID cid ;
	jobject oTimeCourse_Species;
	jmethodID mid;
	jobjectArray namesArray;
	jobject oTimeCourse_Compartments;
	jobject oTimeCourse_Parameters;
	jobject oTimeCourse_Fluxes;
    jclass cSBMLResults;
    jobject oSBMLResults;
	jdoubleArray timeArray;
	jdoubleArray valueArray;

	double rerror = 0.0;

    int argc = (int)(*env)->GetArrayLength(env, args);

/*printf("-->native new Simulator_s_1odeSolver2\n");*/

    parameters = malloc(sizeof(char *) * argc);

    for(i = 0; i < argc; i++) {
        parameters[i] = (char *)(*env)->GetStringUTFChars(env, (*env)->GetObjectArrayElement(env, args, i), 0);
    }

    /** initializing options, that are set via commandline
        arguments in the stand-alone version of the odeSolver.
        Please see file options.h for possible options.
        Option handling will be reorganized soon!!
      */
    initializeOptions();

#ifdef WIN32
	model_path = convert_multibyte_str(parameters[1]);
//    sscanf(model_path, "%s", model);
	strcpy(model,model_path);
//	printf("before: %s\n",parameters[1]);
// 	printf("after : %s\n",model_path);
#else
	strcpy(model,parameters[1]);
//    sscanf(parameters[1], "%s", model);
#endif		
    sscanf(parameters[2], "%lf", &time);
    sscanf(parameters[3], "%lf", &printstep);
    sscanf(parameters[4], "%lf", &rerror);

    /* parsing the SBML model with libSBML */
    sr = SBMLReader_create();
    d = SBMLReader_readSBML(sr, model);
    SBMLReader_free(sr);

    /* Setting SBML ODE Solver integration parameters with default values */
    set = CvodeSettings_createDefaults();

    /* resetting the values we need */
    set->Time = time;
    set->PrintStep = printstep;  
    set->Error = 1e-18;
    set->RError = 1e-14;
    set->Mxstep = 10000;

    //override by specified value.
    set->Time = time;
    set->PrintStep = printstep;
    set->RError = rerror;
    set->Mxstep = 100000;

/*printf("call Model_odeSolver\n");*/
	sbml_results = Model_odeSolver(d, set);
    CvodeSettings_free(set);
    SBMLDocument_free(d);
  
/*printf("***1\n"); */

    /** Find & Construct TimeCourse class. */
    cTimeCourse = (*env)->FindClass(env, "jp/co/mki/celldesigner/simulation/TimeCourse");
    cid = (*env)->GetMethodID(env, cTimeCourse, "<init>", "(II)V");
/*printf("***2\n"); */

    /** Set TimeCourse as species */
    oTimeCourse_Species = (*env)->NewObject(env, cTimeCourse, cid, sbml_results->species->timepoints, sbml_results->species->num_val);
    mid = (*env)->GetMethodID(env, cTimeCourse, "setNames", "([Ljava/lang/String;)V");
    namesArray = (*env)->NewObjectArray(env, (jsize)(sbml_results->species->num_val), (*env)->FindClass(env, "java/lang/String"), NULL);
    for(i = 0; i < sbml_results->species->num_val; ++i) {
        (*env)->SetObjectArrayElement(env, namesArray, i, (*env)->NewStringUTF(env, sbml_results->species->names[i]));
    }
    (*env)->CallVoidMethod(env, oTimeCourse_Species, mid, namesArray);
    mid = (*env)->GetMethodID(env, cTimeCourse, "setValue", "(I[D)V");
    for(i = 0; i < sbml_results->species->timepoints; ++i) {
/*printf("sbml_results->species i = %d\n", i);*/
        valueArray = (*env)->NewDoubleArray(env, (jsize)(sbml_results->species->num_val));
        (*env)->SetDoubleArrayRegion(env, valueArray, 0, sbml_results->species->num_val, sbml_results->species->values[i]);
        (*env)->CallVoidMethod(env, oTimeCourse_Species, mid, i, valueArray);
    }
//printf("***3\n");     

    /** Set TimeCourse as compartments */
    oTimeCourse_Compartments = (*env)->NewObject(env, cTimeCourse, cid, sbml_results->compartments->timepoints, sbml_results->compartments->num_val);
    mid = (*env)->GetMethodID(env, cTimeCourse, "setNames", "([Ljava/lang/String;)V");
    namesArray = (*env)->NewObjectArray(env, (jsize)(sbml_results->compartments->num_val), (*env)->FindClass(env, "java/lang/String"), NULL);
    for(i = 0; i < sbml_results->compartments->num_val; ++i) {
        (*env)->SetObjectArrayElement(env, namesArray, i, (*env)->NewStringUTF(env, sbml_results->compartments->names[i]));
    }
    (*env)->CallVoidMethod(env, oTimeCourse_Compartments, mid, namesArray);
    mid = (*env)->GetMethodID(env, cTimeCourse, "setValue", "(I[D)V");
    for(i = 0; i < sbml_results->compartments->timepoints; ++i) {
//printf("sbml_results->compartments = %d\n", i);
        jdoubleArray valueArray = (*env)->NewDoubleArray(env, (jsize)(sbml_results->compartments->num_val));
        (*env)->SetDoubleArrayRegion(env, valueArray, 0, sbml_results->compartments->num_val, sbml_results->compartments->values[i]);
        (*env)->CallVoidMethod(env, oTimeCourse_Compartments, mid, i, valueArray);
    }
//printf("***4\n"); 

    /** Set TimeCourse as parameters */
    oTimeCourse_Parameters = (*env)->NewObject(env, cTimeCourse, cid, sbml_results->parameters->timepoints, sbml_results->parameters->num_val);
    mid = (*env)->GetMethodID(env, cTimeCourse, "setNames", "([Ljava/lang/String;)V");
    namesArray = (*env)->NewObjectArray(env, (jsize)(sbml_results->parameters->num_val), (*env)->FindClass(env, "java/lang/String"), NULL);
    for(i = 0; i < sbml_results->parameters->num_val; ++i) {
        (*env)->SetObjectArrayElement(env, namesArray, i, (*env)->NewStringUTF(env, sbml_results->parameters->names[i]));
    }
    (*env)->CallVoidMethod(env, oTimeCourse_Parameters, mid, namesArray);
    mid = (*env)->GetMethodID(env, cTimeCourse, "setValue", "(I[D)V");
    for(i = 0; i < sbml_results->parameters->timepoints; ++i) {
//printf("sbml_results->parameters = %d\n", i);
        jdoubleArray valueArray = (*env)->NewDoubleArray(env, (jsize)(sbml_results->parameters->num_val));
        (*env)->SetDoubleArrayRegion(env, valueArray, 0, sbml_results->parameters->num_val, sbml_results->parameters->values[i]);
        (*env)->CallVoidMethod(env, oTimeCourse_Parameters, mid, i, valueArray);
    }
//printf("***5\n"); 

    /** Set TimeCourse as fluxes */
    oTimeCourse_Fluxes = (*env)->NewObject(env, cTimeCourse, cid, sbml_results->fluxes->timepoints, sbml_results->fluxes->num_val);
    mid = (*env)->GetMethodID(env, cTimeCourse, "setNames", "([Ljava/lang/String;)V");
    namesArray = (*env)->NewObjectArray(env, (jsize)(sbml_results->fluxes->num_val), (*env)->FindClass(env, "java/lang/String"), NULL);
    for(i = 0; i < sbml_results->fluxes->num_val; ++i) {
        (*env)->SetObjectArrayElement(env, namesArray, i, (*env)->NewStringUTF(env, sbml_results->fluxes->names[i]));
    }
    (*env)->CallVoidMethod(env, oTimeCourse_Fluxes, mid, namesArray);
    mid = (*env)->GetMethodID(env, cTimeCourse, "setValue", "(I[D)V");
    for(i = 0; i < sbml_results->fluxes->timepoints; ++i) {
//printf("sbml_results->fluxes = %d\n", i);
        jdoubleArray valueArray = (*env)->NewDoubleArray(env, (jsize)(sbml_results->fluxes->num_val));
        (*env)->SetDoubleArrayRegion(env, valueArray, 0, sbml_results->fluxes->num_val, sbml_results->fluxes->values[i]);
        (*env)->CallVoidMethod(env, oTimeCourse_Fluxes, mid, i, valueArray);
    }
//printf("***6\n"); 

    /** Find & Construct class for result. */
    cSBMLResults = (*env)->FindClass(env, "jp/co/mki/celldesigner/simulation/SBMLResults");
    cid = (*env)->GetMethodID(env, cSBMLResults, "<init>", "()V");
    oSBMLResults = (*env)->NewObject(env, cSBMLResults, cid);
    mid = (*env)->GetMethodID(env, cSBMLResults, "setTimepoints", "(I)V");
    (*env)->CallVoidMethod(env, oSBMLResults, mid, sbml_results->species->timepoints);
    mid = (*env)->GetMethodID(env, cSBMLResults, "setTime", "([D)V");
    timeArray = (*env)->NewDoubleArray(env, (jsize)(sbml_results->species->timepoints));
    (*env)->SetDoubleArrayRegion(env, timeArray, 0, sbml_results->species->timepoints, sbml_results->time);
    (*env)->CallVoidMethod(env, oSBMLResults, mid, timeArray);
//printf("***7\n"); 

    /** Set TimeCourse */
    /** set value. */
    mid = (*env)->GetMethodID(env, cSBMLResults, "setSpecies", "(Ljp/co/mki/celldesigner/simulation/TimeCourse;)V");
    (*env)->CallVoidMethod(env, oSBMLResults, mid, oTimeCourse_Species);
    mid = (*env)->GetMethodID(env, cSBMLResults, "setCompartments", "(Ljp/co/mki/celldesigner/simulation/TimeCourse;)V");
    (*env)->CallVoidMethod(env, oSBMLResults, mid, oTimeCourse_Compartments);
    mid = (*env)->GetMethodID(env, cSBMLResults, "setParameters", "(Ljp/co/mki/celldesigner/simulation/TimeCourse;)V");
    (*env)->CallVoidMethod(env, oSBMLResults, mid, oTimeCourse_Parameters);
    mid = (*env)->GetMethodID(env, cSBMLResults, "setFluxes", "(Ljp/co/mki/celldesigner/simulation/TimeCourse;)V");
    (*env)->CallVoidMethod(env, oSBMLResults, mid, oTimeCourse_Fluxes);
//printf("***8\n"); 

    free(parameters);
#ifdef WIN32
	free(model_path);
#endif	
    return oSBMLResults;
}

/*
 * Class:     jp_co_mki_celldesigner_simulation_Simulator
 * Method:    s_odeSolver3
 * Signature: ([Ljava/lang/String;)[Ljava/lang/Object;
 */
JNIEXPORT jobject JNICALL Java_jp_co_mki_celldesigner_simulation_Simulator_s_1odeSolver3
  (JNIEnv *env, jclass clazz, jobjectArray args) {
#ifdef WIN32
	char *model_path;
#endif
    char **parameters;
    int i = 0;
    int k = 0;
    cvodeSettings_t *set;

    char model[256];
    double time      = 0.0;
    double printstep = 1.0;
    double rerror    = 0.0;
    
    char rid[256];
    char id[256];
    double start = 0.0;
    double end   = 0.0;
    int steps    = 0;
    
    SBMLReader_t *sr;
    SBMLDocument_t *d;
    SBMLResults_t **results;
	VarySettings vset;
	jclass cSBMLResults;
	jobjectArray  jobData;
	int n ;
	SBMLResults_t **sbml_results;
	jclass cTimeCourse ;
	jmethodID cid;
	jobject oTimeCourse_Species;
	jmethodID mid ;
	jobjectArray namesArray;
	jobject oTimeCourse_Compartments;
	jobject oTimeCourse_Parameters ;
	jobject oTimeCourse_Fluxes;
	jobject oSBMLResults;
	jdoubleArray timeArray;

    int argc = (int)(*env)->GetArrayLength(env, args);
//printf("-->native new Simulator_s_1odeSolver3 parameterScan1\n");

    parameters = malloc(sizeof(char *) * argc);

    for(i = 0; i < argc; i++) {
        parameters[i] = (char *)(*env)->GetStringUTFChars(env, (*env)->GetObjectArrayElement(env, args, i), 0);
    }

    /** initializing options, that are set via commandline
        arguments in the stand-alone version of the odeSolver.
        Please see file options.h for possible options.
        Option handling will be reorganized soon!!
      */
    initializeOptions();

#ifdef WIN32
	model_path = convert_multibyte_str(parameters[1]);
	strcpy(model,model_path);
//    sscanf(model_path, "%s", model);
//	printf("before: %s\n",parameters[1]);
//	printf("after: %s\n",model_path);
#else
	strcpy(model,parameters[1]);
//    sscanf(parameters[1], "%s", model);
#endif
    sscanf(parameters[2], "%lf", &time);
    sscanf(parameters[3], "%lf", &printstep);
    sscanf(parameters[4], "%lf", &rerror);
    
    sscanf(parameters[5], "%s",  rid);
    sscanf(parameters[6], "%s",  id);
    sscanf(parameters[7], "%lf", &start);
    sscanf(parameters[8], "%lf", &end);
    sscanf(parameters[9], "%d", &steps);
        
    /* parsing the SBML model with libSBML */
    sr = SBMLReader_create();
    d = SBMLReader_readSBML(sr, model);
    SBMLReader_free(sr);        
        
//    d = parseModel(model);
    
    /* Setting SBML ODE Solver integration parameters with default values */
    set = CvodeSettings_createDefaults();
    /* resetting the values we need */
    set->Time = time;
    set->PrintStep = printstep;  
    set->Error = 1e-18;
    set->RError = 1e-14;
    set->Mxstep = 10000;
  
    //override by specified value.
    set->Time = time;
    set->PrintStep = printstep;
    set->RError = rerror;
    set->Mxstep = 100000;
    
    vset.id     = id;
    vset.rid    = rid;
    vset.start  = start;
    vset.end    = end;
    vset.steps  = steps;
    
    results = Model_odeSolverBatch(d, set,vset);
//printf("vset.id  = %s\n"  , vset.id);    	 
//printf("vset.rid = %s\n" , vset.rid);    	 
   
    /** Find & Construct TimeCourse class. */
    cSBMLResults = (*env)->FindClass(env, "jp/co/mki/celldesigner/simulation/SBMLResults");
    n = steps + 1;
    jobData = (*env)->NewObjectArray(env , n , cSBMLResults , NULL);
            
    for(k = 0; k < n ; k++) {
//printf("+++ k = %d\n", k);        
        sbml_results = results++;

	    cTimeCourse = (*env)->FindClass(env, "jp/co/mki/celldesigner/simulation/TimeCourse");
	    cid = (*env)->GetMethodID(env, cTimeCourse, "<init>", "(II)V");

	    /** Set TimeCourse as species */
	    oTimeCourse_Species = (*env)->NewObject(env, cTimeCourse, cid, (*sbml_results)->species->timepoints, (*sbml_results)->species->num_val);
	    mid = (*env)->GetMethodID(env, cTimeCourse, "setNames", "([Ljava/lang/String;)V");
	    namesArray = (*env)->NewObjectArray(env, (jsize)((*sbml_results)->species->num_val), (*env)->FindClass(env, "java/lang/String"), NULL);
	    for(i = 0; i < (*sbml_results)->species->num_val; ++i) {
	        (*env)->SetObjectArrayElement(env, namesArray, i, (*env)->NewStringUTF(env, (*sbml_results)->species->names[i]));
	    }
	    (*env)->CallVoidMethod(env, oTimeCourse_Species, mid, namesArray);
	    mid = (*env)->GetMethodID(env, cTimeCourse, "setValue", "(I[D)V");
	    for(i = 0; i < (*sbml_results)->species->timepoints; ++i) {
	        jdoubleArray valueArray = (*env)->NewDoubleArray(env, (jsize)((*sbml_results)->species->num_val));
	        (*env)->SetDoubleArrayRegion(env, valueArray, 0, (*sbml_results)->species->num_val, (*sbml_results)->species->values[i]);
	        (*env)->CallVoidMethod(env, oTimeCourse_Species, mid, i, valueArray);
	    }
	
	    /** Set TimeCourse as compartments */
	    oTimeCourse_Compartments = (*env)->NewObject(env, cTimeCourse, cid, (*sbml_results)->compartments->timepoints, (*sbml_results)->compartments->num_val);
	    mid = (*env)->GetMethodID(env, cTimeCourse, "setNames", "([Ljava/lang/String;)V");
	    namesArray = (*env)->NewObjectArray(env, (jsize)((*sbml_results)->compartments->num_val), (*env)->FindClass(env, "java/lang/String"), NULL);
	    for(i = 0; i < (*sbml_results)->compartments->num_val; ++i) {
	        (*env)->SetObjectArrayElement(env, namesArray, i, (*env)->NewStringUTF(env, (*sbml_results)->compartments->names[i]));
	    }
	    (*env)->CallVoidMethod(env, oTimeCourse_Compartments, mid, namesArray);
	    mid = (*env)->GetMethodID(env, cTimeCourse, "setValue", "(I[D)V");
	    for(i = 0; i < (*sbml_results)->compartments->timepoints; ++i) {
	        jdoubleArray valueArray = (*env)->NewDoubleArray(env, (jsize)((*sbml_results)->compartments->num_val));
	        (*env)->SetDoubleArrayRegion(env, valueArray, 0, (*sbml_results)->compartments->num_val, (*sbml_results)->compartments->values[i]);
	        (*env)->CallVoidMethod(env, oTimeCourse_Compartments, mid, i, valueArray);
	    }
	
	    /** Set TimeCourse as parameters */
	    oTimeCourse_Parameters = (*env)->NewObject(env, cTimeCourse, cid, (*sbml_results)->parameters->timepoints, (*sbml_results)->parameters->num_val);
	    mid = (*env)->GetMethodID(env, cTimeCourse, "setNames", "([Ljava/lang/String;)V");
	    namesArray = (*env)->NewObjectArray(env, (jsize)((*sbml_results)->parameters->num_val), (*env)->FindClass(env, "java/lang/String"), NULL);
	    for(i = 0; i < (*sbml_results)->parameters->num_val; ++i) {
	        (*env)->SetObjectArrayElement(env, namesArray, i, (*env)->NewStringUTF(env, (*sbml_results)->parameters->names[i]));
	    }
	    (*env)->CallVoidMethod(env, oTimeCourse_Parameters, mid, namesArray);
	    mid = (*env)->GetMethodID(env, cTimeCourse, "setValue", "(I[D)V");
	    for(i = 0; i < (*sbml_results)->parameters->timepoints; ++i) {
	        jdoubleArray valueArray = (*env)->NewDoubleArray(env, (jsize)((*sbml_results)->parameters->num_val));
	        (*env)->SetDoubleArrayRegion(env, valueArray, 0, (*sbml_results)->parameters->num_val, (*sbml_results)->parameters->values[i]);
	        (*env)->CallVoidMethod(env, oTimeCourse_Parameters, mid, i, valueArray);
	    }
	
	    /** Set TimeCourse as fluxes */
	    oTimeCourse_Fluxes = (*env)->NewObject(env, cTimeCourse, cid, (*sbml_results)->fluxes->timepoints, (*sbml_results)->fluxes->num_val);
	    mid = (*env)->GetMethodID(env, cTimeCourse, "setNames", "([Ljava/lang/String;)V");
	    namesArray = (*env)->NewObjectArray(env, (jsize)((*sbml_results)->fluxes->num_val), (*env)->FindClass(env, "java/lang/String"), NULL);
	    for(i = 0; i < (*sbml_results)->fluxes->num_val; ++i) {
	        (*env)->SetObjectArrayElement(env, namesArray, i, (*env)->NewStringUTF(env, (*sbml_results)->fluxes->names[i]));
	    }
	    (*env)->CallVoidMethod(env, oTimeCourse_Fluxes, mid, namesArray);
	    mid = (*env)->GetMethodID(env, cTimeCourse, "setValue", "(I[D)V");
	    for(i = 0; i < (*sbml_results)->fluxes->timepoints; ++i) {
	        jdoubleArray valueArray = (*env)->NewDoubleArray(env, (jsize)((*sbml_results)->fluxes->num_val));
	        (*env)->SetDoubleArrayRegion(env, valueArray, 0, (*sbml_results)->fluxes->num_val, (*sbml_results)->fluxes->values[i]);
	        (*env)->CallVoidMethod(env, oTimeCourse_Fluxes, mid, i, valueArray);
	    }
	
	    /** Find & Construct class for result. */
	    cSBMLResults = (*env)->FindClass(env, "jp/co/mki/celldesigner/simulation/SBMLResults");
	    cid = (*env)->GetMethodID(env, cSBMLResults, "<init>", "()V");
	    oSBMLResults = (*env)->NewObject(env, cSBMLResults, cid);
	    mid = (*env)->GetMethodID(env, cSBMLResults, "setTimepoints", "(I)V");
	    (*env)->CallVoidMethod(env, oSBMLResults, mid, (*sbml_results)->species->timepoints);
	    mid = (*env)->GetMethodID(env, cSBMLResults, "setTime", "([D)V");
	    timeArray = (*env)->NewDoubleArray(env, (jsize)((*sbml_results)->species->timepoints));
	    (*env)->SetDoubleArrayRegion(env, timeArray, 0, (*sbml_results)->species->timepoints, (*sbml_results)->time);
	    (*env)->CallVoidMethod(env, oSBMLResults, mid, timeArray);
	
	    /** Set TimeCourse */
	    /** set value. */
	    mid = (*env)->GetMethodID(env, cSBMLResults, "setSpecies", "(Ljp/co/mki/celldesigner/simulation/TimeCourse;)V");
	    (*env)->CallVoidMethod(env, oSBMLResults, mid, oTimeCourse_Species);
	    mid = (*env)->GetMethodID(env, cSBMLResults, "setCompartments", "(Ljp/co/mki/celldesigner/simulation/TimeCourse;)V");
	    (*env)->CallVoidMethod(env, oSBMLResults, mid, oTimeCourse_Compartments);
	    mid = (*env)->GetMethodID(env, cSBMLResults, "setParameters", "(Ljp/co/mki/celldesigner/simulation/TimeCourse;)V");
	    (*env)->CallVoidMethod(env, oSBMLResults, mid, oTimeCourse_Parameters);
	    mid = (*env)->GetMethodID(env, cSBMLResults, "setFluxes", "(Ljp/co/mki/celldesigner/simulation/TimeCourse;)V");
	    (*env)->CallVoidMethod(env, oSBMLResults, mid, oTimeCourse_Fluxes);

        (*env)->SetObjectArrayElement(env, jobData, k, oSBMLResults);

    }


    free(parameters);
#ifdef WIN32
	free(model_path);
#endif
    return jobData;
}

/*
 * Class:     jp_co_mki_celldesigner_simulation_Simulator
 * Method:    s_odeSolver4
 * Signature: ([Ljava/lang/String;)[Ljava/lang/Object;
 */
JNIEXPORT jobject JNICALL Java_jp_co_mki_celldesigner_simulation_Simulator_s_1odeSolver4
  (JNIEnv *env, jclass clazz, jobjectArray args) {
#ifdef WIN32
    char* model_path;
#endif
    char **parameters;
    int i  = 0;
    int k  = 0;
    int k2 = 0;

    char model[256];
    double time      = 0.0;
    double printstep = 1.0;
    double rerror    = 0.0;
    
    char rid[256];
    char id[256];
    double start = 0.0;
    double end   = 0.0;
    int steps    = 0;
    
    char rid2[256];
    char id2[256];
    double start2 = 0.0;
    double end2   = 0.0;
    int steps2    = 0;
    
    cvodeSettings_t *set;
        
    SBMLDocument_t *d;
    SBMLReader_t *sr;
    SBMLResults_t ***results;
    VarySettings vset;
	VarySettings vset2;
	jclass cSBMLResults;
    jclass  cArray;
    int n;
    jobjectArray  jobData;
    int n2;
	jobjectArray  jobData2;
	SBMLResults_t sbml_results;        
    jclass cTimeCourse;
    jmethodID cid;
	jobject oTimeCourse_Species;
	jmethodID mid;
	jobjectArray namesArray;
    jobject oTimeCourse_Compartments;
	jobject oTimeCourse_Parameters;
	jobject oTimeCourse_Fluxes;
	jobject oSBMLResults;
	jdoubleArray timeArray;

    int argc = (int)(*env)->GetArrayLength(env, args);

//printf("-->native new Simulator_s_1odeSolver4 parameterScan2\n");

	parameters = malloc(sizeof(char *) * argc);

    for(i = 0; i < argc; i++) {
        parameters[i] = (char *)(*env)->GetStringUTFChars(env, (*env)->GetObjectArrayElement(env, args, i), 0);
    }

    /** initializing options, that are set via commandline
        arguments in the stand-alone version of the odeSolver.
        Please see file options.h for possible options.
        Option handling will be reorganized soon!!
      */
    initializeOptions();
//    Opt.PrintMessage = 1;
#ifdef WIN32
	model_path = convert_multibyte_str(parameters[1]);
	strcpy(model,model_path);
//    sscanf(model_path, "%s", model);
//	printf("before: %s\n",parameters[1]);
//	printf("after: %s\n",model_path);
#else
	strcpy(model,parameters[1]);
//    sscanf(parameters[1], "%s", model);
#endif
    sscanf(parameters[2], "%lf", &time);
    sscanf(parameters[3], "%lf", &printstep);
    sscanf(parameters[4], "%lf", &rerror);
    
    sscanf(parameters[5], "%s",  rid);
    sscanf(parameters[6], "%s",  id);
    sscanf(parameters[7], "%lf", &start);
    sscanf(parameters[8], "%lf", &end);
    sscanf(parameters[9], "%d", &steps);
    
    sscanf(parameters[10], "%s",  rid2);
    sscanf(parameters[11], "%s",  id2);
    sscanf(parameters[12], "%lf", &start2);
    sscanf(parameters[13], "%lf", &end2);
    sscanf(parameters[14], "%d", &steps2);
  
    /* parsing the SBML model with libSBML */
    sr = SBMLReader_create();
    d = SBMLReader_readSBML(sr, model);
    SBMLReader_free(sr);       
//    d = parseModel(model);
  
    /* Setting SBML ODE Solver integration parameters with default values */
    set = CvodeSettings_createDefaults();
    /* resetting the values we need */
    set->Time = time;
    set->PrintStep = printstep;  
    set->Error = 1e-18;
    set->RError = 1e-14;
    set->Mxstep = 10000;
  
    //override by specified value.
    set->Time = time;
    set->PrintStep = printstep;
    set->RError = rerror;
    set->Mxstep = 100000;
                
    vset.id     = id;
    vset.rid    = rid;
    vset.start  = start;
    vset.end    = end;
    vset.steps  = steps;
    
    vset2.id     = id2;
    vset2.rid    = rid2;
    vset2.start  = start2;
    vset2.end    = end2;
    vset2.steps  = steps2;
    
    results = Model_odeSolverBatch2(d, set,vset,vset2);
//printf("vset.id = %s\n" , vset.id);    	 
//printf("vset.rid = %s\n" , vset.rid);    	
//printf("vset2.id = %s\n" , vset2.id);    	
//printf("vset2.rid = %s\n\n" , vset2.rid);    	
   
    /** Find & Construct TimeCourse class. */
    cSBMLResults = (*env)->FindClass(env, "jp/co/mki/celldesigner/simulation/SBMLResults");
    cArray      = (*env)->FindClass(env , "java/lang/Object");
    n = steps + 1;
    jobData = (*env)->NewObjectArray(env , n , cArray , NULL);

    n2 = steps2 + 1;

            
    for(k = 0; k < n ; k++) {
//printf("+++ k = %d\n", k);

        jobData2 = (*env)->NewObjectArray(env , n2 , cSBMLResults , NULL);
        
        for(k2 = 0 ; k2 < n2 ; k2++){
//printf("+++++ k2 = %d\n", k2);
            sbml_results = *results[k][k2];
            
		    cTimeCourse = (*env)->FindClass(env, "jp/co/mki/celldesigner/simulation/TimeCourse");
		    cid = (*env)->GetMethodID(env, cTimeCourse, "<init>", "(II)V");
	
		    /** Set TimeCourse as species */
		    oTimeCourse_Species = (*env)->NewObject(env, cTimeCourse, cid, sbml_results.species->timepoints, sbml_results.species->num_val);
		    mid = (*env)->GetMethodID(env, cTimeCourse, "setNames", "([Ljava/lang/String;)V");
		    namesArray = (*env)->NewObjectArray(env, (jsize)(sbml_results.species->num_val), (*env)->FindClass(env, "java/lang/String"), NULL);
		    for(i = 0; i < sbml_results.species->num_val; ++i) {
		        (*env)->SetObjectArrayElement(env, namesArray, i, (*env)->NewStringUTF(env, sbml_results.species->names[i]));
		    }
		    (*env)->CallVoidMethod(env, oTimeCourse_Species, mid, namesArray);
		    mid = (*env)->GetMethodID(env, cTimeCourse, "setValue", "(I[D)V");
		    for(i = 0; i < sbml_results.species->timepoints; ++i) {
		        jdoubleArray valueArray = (*env)->NewDoubleArray(env, (jsize)(sbml_results.species->num_val));
		        (*env)->SetDoubleArrayRegion(env, valueArray, 0, sbml_results.species->num_val, sbml_results.species->values[i]);
		        (*env)->CallVoidMethod(env, oTimeCourse_Species, mid, i, valueArray);
		    }
		
		    /** Set TimeCourse as compartments */
		    oTimeCourse_Compartments = (*env)->NewObject(env, cTimeCourse, cid, sbml_results.compartments->timepoints, sbml_results.compartments->num_val);
		    mid = (*env)->GetMethodID(env, cTimeCourse, "setNames", "([Ljava/lang/String;)V");
		    namesArray = (*env)->NewObjectArray(env, (jsize)(sbml_results.compartments->num_val), (*env)->FindClass(env, "java/lang/String"), NULL);
		    for(i = 0; i < sbml_results.compartments->num_val; ++i) {
		        (*env)->SetObjectArrayElement(env, namesArray, i, (*env)->NewStringUTF(env, sbml_results.compartments->names[i]));
		    }
		    (*env)->CallVoidMethod(env, oTimeCourse_Compartments, mid, namesArray);
		    mid = (*env)->GetMethodID(env, cTimeCourse, "setValue", "(I[D)V");
		    for(i = 0; i < sbml_results.compartments->timepoints; ++i) {
		        jdoubleArray valueArray = (*env)->NewDoubleArray(env, (jsize)(sbml_results.compartments->num_val));
		        (*env)->SetDoubleArrayRegion(env, valueArray, 0, sbml_results.compartments->num_val, sbml_results.compartments->values[i]);
		        (*env)->CallVoidMethod(env, oTimeCourse_Compartments, mid, i, valueArray);
		    }
		
		    /** Set TimeCourse as parameters */
		    oTimeCourse_Parameters = (*env)->NewObject(env, cTimeCourse, cid, sbml_results.parameters->timepoints, sbml_results.parameters->num_val);
		    mid = (*env)->GetMethodID(env, cTimeCourse, "setNames", "([Ljava/lang/String;)V");
		    namesArray = (*env)->NewObjectArray(env, (jsize)(sbml_results.parameters->num_val), (*env)->FindClass(env, "java/lang/String"), NULL);
		    for(i = 0; i < sbml_results.parameters->num_val; ++i) {
		        (*env)->SetObjectArrayElement(env, namesArray, i, (*env)->NewStringUTF(env, sbml_results.parameters->names[i]));
		    }
		    (*env)->CallVoidMethod(env, oTimeCourse_Parameters, mid, namesArray);
		    mid = (*env)->GetMethodID(env, cTimeCourse, "setValue", "(I[D)V");
		    for(i = 0; i < sbml_results.parameters->timepoints; ++i) {
		        jdoubleArray valueArray = (*env)->NewDoubleArray(env, (jsize)(sbml_results.parameters->num_val));
		        (*env)->SetDoubleArrayRegion(env, valueArray, 0, sbml_results.parameters->num_val, sbml_results.parameters->values[i]);
		        (*env)->CallVoidMethod(env, oTimeCourse_Parameters, mid, i, valueArray);
		    }
		
		    /** Set TimeCourse as fluxes */
		    oTimeCourse_Fluxes = (*env)->NewObject(env, cTimeCourse, cid, sbml_results.fluxes->timepoints, sbml_results.fluxes->num_val);
		    mid = (*env)->GetMethodID(env, cTimeCourse, "setNames", "([Ljava/lang/String;)V");
		    namesArray = (*env)->NewObjectArray(env, (jsize)(sbml_results.fluxes->num_val), (*env)->FindClass(env, "java/lang/String"), NULL);
		    for(i = 0; i < sbml_results.fluxes->num_val; ++i) {
		        (*env)->SetObjectArrayElement(env, namesArray, i, (*env)->NewStringUTF(env, sbml_results.fluxes->names[i]));
		    }
		    (*env)->CallVoidMethod(env, oTimeCourse_Fluxes, mid, namesArray);
		    mid = (*env)->GetMethodID(env, cTimeCourse, "setValue", "(I[D)V");
		    for(i = 0; i < sbml_results.fluxes->timepoints; ++i) {
		        jdoubleArray valueArray = (*env)->NewDoubleArray(env, (jsize)(sbml_results.fluxes->num_val));
		        (*env)->SetDoubleArrayRegion(env, valueArray, 0, sbml_results.fluxes->num_val, sbml_results.fluxes->values[i]);
		        (*env)->CallVoidMethod(env, oTimeCourse_Fluxes, mid, i, valueArray);
		    }
		
		    /** Find & Construct class for result. */
		    cSBMLResults = (*env)->FindClass(env, "jp/co/mki/celldesigner/simulation/SBMLResults");
		    cid = (*env)->GetMethodID(env, cSBMLResults, "<init>", "()V");
		    oSBMLResults = (*env)->NewObject(env, cSBMLResults, cid);
		    mid = (*env)->GetMethodID(env, cSBMLResults, "setTimepoints", "(I)V");
		    (*env)->CallVoidMethod(env, oSBMLResults, mid, sbml_results.species->timepoints);
		    mid = (*env)->GetMethodID(env, cSBMLResults, "setTime", "([D)V");
		    timeArray = (*env)->NewDoubleArray(env, (jsize)(sbml_results.species->timepoints));
		    (*env)->SetDoubleArrayRegion(env, timeArray, 0, sbml_results.species->timepoints, sbml_results.time);
		    (*env)->CallVoidMethod(env, oSBMLResults, mid, timeArray);
		
		    /** Set TimeCourse */
		    /** set value. */
		    mid = (*env)->GetMethodID(env, cSBMLResults, "setSpecies", "(Ljp/co/mki/celldesigner/simulation/TimeCourse;)V");
		    (*env)->CallVoidMethod(env, oSBMLResults, mid, oTimeCourse_Species);
		    mid = (*env)->GetMethodID(env, cSBMLResults, "setCompartments", "(Ljp/co/mki/celldesigner/simulation/TimeCourse;)V");
		    (*env)->CallVoidMethod(env, oSBMLResults, mid, oTimeCourse_Compartments);
		    mid = (*env)->GetMethodID(env, cSBMLResults, "setParameters", "(Ljp/co/mki/celldesigner/simulation/TimeCourse;)V");
		    (*env)->CallVoidMethod(env, oSBMLResults, mid, oTimeCourse_Parameters);
		    mid = (*env)->GetMethodID(env, cSBMLResults, "setFluxes", "(Ljp/co/mki/celldesigner/simulation/TimeCourse;)V");
		    (*env)->CallVoidMethod(env, oSBMLResults, mid, oTimeCourse_Fluxes);

	        (*env)->SetObjectArrayElement(env, jobData2, k2, oSBMLResults);
        }
 
		 (*env)->SetObjectArrayElement(env, jobData, k, jobData2);
    }



    free(parameters);
#ifdef WIN32
	free(model_path);
#endif
    return jobData;
    
}

#ifdef WIN32
char* convert_multibyte_str(const char* src_str) 
{
	const int max = 256;
	const char* err_str = "too_long";

	int src_slen;
	int length;
	int c_length;
	wchar_t* wbuf;
	char* abuf;

	src_slen = strlen(src_str);

	//
	// UTF8 -> Unicode
	//

//	printf("Start Convert : (%d) %s\n", src_slen, src_str);

	// Check src_str length
	length = MultiByteToWideChar(CP_UTF8,0,(LPCSTR)src_str,-1,NULL,0);
	if(length == 0){
		abuf = (char*)malloc(src_slen+1);
		strcpy(abuf,src_str);
		return abuf;
	}
	wbuf = (wchar_t*)malloc(sizeof(wchar_t)*(length+1));

//	printf("(UTF8->Unicode) Check Length\n");

	// Convert
	c_length = MultiByteToWideChar(CP_UTF8,0,(LPCSTR)src_str,-1,wbuf,length);
	wbuf[c_length] = 0;
	if(c_length == 0) {
		free(wbuf);
		abuf = (char*)malloc(src_slen+1);
		strcpy(abuf,src_str);
		return abuf;
	}

//	printf("(UTF8->Unicode) Convert : %d\n",c_length);

	//
	// Unicode -> ANSI
	//

	// Check wbuf length		
	length = WideCharToMultiByte(CP_ACP,0,(LPCWSTR)wbuf,-1,NULL,0,NULL,NULL);

//	printf("(Unicode -> ANSI) Check Length : %d\n", length);

	if(length == 0){
		free(wbuf);
		abuf = (char*)malloc(src_slen+1);
		strcpy(abuf,src_str);
		return abuf;
	}
	abuf = (char*)malloc(length + 1);

	// Convert

	c_length = WideCharToMultiByte(CP_ACP,0,(LPCWSTR)wbuf,-1,abuf,length,NULL,NULL);
	abuf[c_length] = 0;

	if(c_length == 0){
		free(wbuf);		
		free(abuf);
		abuf = (char*)malloc(src_slen+1);
		strcpy(abuf,src_str);
		return abuf;
	}

//	printf("(Unicode -> ANSI) Convert : (%d) %s\n",c_length,abuf);

	free(wbuf);

	if(strlen(abuf)+1 > max){
		free(abuf);
		abuf = (char*)malloc(strlen(err_str)+1);
		strcpy(abuf,err_str);
	}

	return abuf;

}
#endif
