/*
 * $Id: Variable.java 1169 2012-03-15 14:24:02Z andreas-draeger $
 * $URL: https://jsbml.svn.sourceforge.net/svnroot/jsbml/trunk/core/src/org/sbml/jsbml/Variable.java $
 * ----------------------------------------------------------------------------
 * This file is part of JSBML. Please visit <http://sbml.org/Software/JSBML>
 * for the latest version of JSBML and more information about SBML.
 *
 * Copyright (C) 2009-2012 jointly by the following organizations:
 * 1. The University of Tuebingen, Germany
 * 2. EMBL European Bioinformatics Institute (EBML-EBI), Hinxton, UK
 * 3. The California Institute of Technology, Pasadena, CA, USA
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation. A copy of the license agreement is provided
 * in the file named "LICENSE.txt" included with this software distribution
 * and also available online as <http://sbml.org/Software/JSBML/License>.
 * ----------------------------------------------------------------------------
 */

package org.sbml.jsbml;

/**
 * A variable of the system is a {@link Quantity} whose value may change during
 * a simulation. To decide whether it has to stay constant, this interface
 * provides the necessary methods.
 * 
 * @author Andreas Dr&auml;ger
 * @author Nicolas Rodriguez
 * @date 2010-04-20
 * @since 0.8
 * @version $Rev: 1169 $
 */
public interface Variable extends Quantity, UniqueNamedSBase {

	/**
	 * 
	 * @return the constant boolean of this variable.
	 */
	public boolean getConstant();

	/**
	 * 
	 * @return the constant value if it is set, false otherwise.
	 */
	public boolean isConstant();

	/**
	 * 
	 * @return true if the constant boolean of this Variable is not null.
	 */
	public boolean isSetConstant();

	/**
	 * Sets the constant boolean of this Variable.
	 * 
	 * @param constant
	 * @throws PropertyNotAvailableException
	 *             for inappropriate Level/Version combinations depending on the
	 *             implementing class.
	 */
	public void setConstant(boolean constant);

	/**
	 * With this method the constant property of this variable will be set to an
	 * undefined state.
	 */
	public void unsetConstant();

}
