<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:iso="http://purl.oclc.org/dsdl/schematron" xmlns:sch="http://www.ascc.net/xml/schematron" xmlns:sed="http://sed-ml.org/" xmlns:math="http://www.w3.org/1998/Math/MathML" version="1.0">
<!--Implementers: please note that overriding process-prolog or process-root is 
    the preferred method for meta-stylesheets to use where possible. -->
<xsl:param name="archiveDirParameter"/>
<xsl:param name="archiveNameParameter"/>
<xsl:param name="fileNameParameter"/>
<xsl:param name="fileDirParameter"/>

<!--PHASES-->


<!--PROLOG-->
<xsl:output xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" method="xml" omit-xml-declaration="no" standalone="yes" indent="yes"/>

<!--KEYS-->
<xsl:key name="modelid" match="sed:model[@id]" use="@id"/>
<xsl:key name="simid" match="sed:uniformTimeCourse[@id]" use="@id"/>
<xsl:key name="dgid" match="sed:dataGenerator[@id]" use="@id"/>
<xsl:key name="taskid" match="sed:task[@id]" use="@id"/>
<xsl:key name="allIds" match="sed:*[@id]" use="@id"/>

<!--DEFAULT RULES-->


<!--MODE: SCHEMATRON-SELECT-FULL-PATH-->
<!--This mode can be used to generate an ugly though full XPath for locators-->
<xsl:template match="*" mode="schematron-select-full-path">
<xsl:apply-templates select="." mode="schematron-get-full-path"/>
</xsl:template>

<!--MODE: SCHEMATRON-FULL-PATH-->
<!--This mode can be used to generate an ugly though full XPath for locators-->
<xsl:template match="*" mode="schematron-get-full-path">
<xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
<xsl:text>/</xsl:text>
<xsl:choose>
<xsl:when test="namespace-uri()=''">
<xsl:value-of select="name()"/>
<xsl:variable name="p_1" select="1+    count(preceding-sibling::*[name()=name(current())])"/>
<xsl:if test="$p_1&gt;1 or following-sibling::*[name()=name(current())]">[<xsl:value-of select="$p_1"/>]</xsl:if>
</xsl:when>
<xsl:otherwise>
<xsl:text>*[local-name()='</xsl:text>
<xsl:value-of select="local-name()"/>
<xsl:text>' and namespace-uri()='</xsl:text>
<xsl:value-of select="namespace-uri()"/>
<xsl:text>']</xsl:text>
<xsl:variable name="p_2" select="1+   count(preceding-sibling::*[local-name()=local-name(current())])"/>
<xsl:if test="$p_2&gt;1 or following-sibling::*[local-name()=local-name(current())]">[<xsl:value-of select="$p_2"/>]</xsl:if>
</xsl:otherwise>
</xsl:choose>
</xsl:template>
<xsl:template match="@*" mode="schematron-get-full-path">
<xsl:text>/</xsl:text>
<xsl:choose>
<xsl:when test="namespace-uri()=''">@<xsl:value-of select="name()"/>
</xsl:when>
<xsl:otherwise>
<xsl:text>@*[local-name()='</xsl:text>
<xsl:value-of select="local-name()"/>
<xsl:text>' and namespace-uri()='</xsl:text>
<xsl:value-of select="namespace-uri()"/>
<xsl:text>']</xsl:text>
</xsl:otherwise>
</xsl:choose>
</xsl:template>

<!--MODE: SCHEMATRON-FULL-PATH-2-->
<!--This mode can be used to generate prefixed XPath for humans-->
<xsl:template match="node() | @*" mode="schematron-get-full-path-2">
<xsl:for-each select="ancestor-or-self::*">
<xsl:text>/</xsl:text>
<xsl:value-of select="name(.)"/>
<xsl:if test="preceding-sibling::*[name(.)=name(current())]">
<xsl:text>[</xsl:text>
<xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
<xsl:text>]</xsl:text>
</xsl:if>
</xsl:for-each>
<xsl:if test="not(self::*)">
<xsl:text/>/@<xsl:value-of select="name(.)"/>
</xsl:if>
</xsl:template>

<!--MODE: GENERATE-ID-FROM-PATH -->
<xsl:template match="/" mode="generate-id-from-path"/>
<xsl:template match="text()" mode="generate-id-from-path">
<xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
<xsl:value-of select="concat('.text-', 1+count(preceding-sibling::text()), '-')"/>
</xsl:template>
<xsl:template match="comment()" mode="generate-id-from-path">
<xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
<xsl:value-of select="concat('.comment-', 1+count(preceding-sibling::comment()), '-')"/>
</xsl:template>
<xsl:template match="processing-instruction()" mode="generate-id-from-path">
<xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
<xsl:value-of select="concat('.processing-instruction-', 1+count(preceding-sibling::processing-instruction()), '-')"/>
</xsl:template>
<xsl:template match="@*" mode="generate-id-from-path">
<xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
<xsl:value-of select="concat('.@', name())"/>
</xsl:template>
<xsl:template match="*" mode="generate-id-from-path" priority="-0.5">
<xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
<xsl:text>.</xsl:text>
<xsl:value-of select="concat('.',name(),'-',1+count(preceding-sibling::*[name()=name(current())]),'-')"/>
</xsl:template>
<!--MODE: SCHEMATRON-FULL-PATH-3-->
<!--This mode can be used to generate prefixed XPath for humans 
	(Top-level element has index)-->
<xsl:template match="node() | @*" mode="schematron-get-full-path-3">
<xsl:for-each select="ancestor-or-self::*">
<xsl:text>/</xsl:text>
<xsl:value-of select="name(.)"/>
<xsl:if test="parent::*">
<xsl:text>[</xsl:text>
<xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
<xsl:text>]</xsl:text>
</xsl:if>
</xsl:for-each>
<xsl:if test="not(self::*)">
<xsl:text/>/@<xsl:value-of select="name(.)"/>
</xsl:if>
</xsl:template>

<!--MODE: GENERATE-ID-2 -->
<xsl:template match="/" mode="generate-id-2">U</xsl:template>
<xsl:template match="*" mode="generate-id-2" priority="2">
<xsl:text>U</xsl:text>
<xsl:number level="multiple" count="*"/>
</xsl:template>
<xsl:template match="node()" mode="generate-id-2">
<xsl:text>U.</xsl:text>
<xsl:number level="multiple" count="*"/>
<xsl:text>n</xsl:text>
<xsl:number count="node()"/>
</xsl:template>
<xsl:template match="@*" mode="generate-id-2">
<xsl:text>U.</xsl:text>
<xsl:number level="multiple" count="*"/>
<xsl:text>_</xsl:text>
<xsl:value-of select="string-length(local-name(.))"/>
<xsl:text>_</xsl:text>
<xsl:value-of select="translate(name(),':','.')"/>
</xsl:template>
<!--Strip characters-->
<xsl:template match="text()" priority="-1"/>

<!--SCHEMA METADATA-->
<xsl:template match="/">
<svrl:schematron-output xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" title="SED-ML Schematron schema" schemaVersion="ISO19757-3">
<xsl:comment>
<xsl:value-of select="$archiveDirParameter"/>   
		 <xsl:value-of select="$archiveNameParameter"/>  
		 <xsl:value-of select="$fileNameParameter"/>  
		 <xsl:value-of select="$fileDirParameter"/>
</xsl:comment>
<svrl:text>
   This schema is not a full replacement for the SED-ML XML schema, but instead provides                            
  validation that is not possible in XML schema. This includes:    
                                                                     
  1. Non-unique values for 'id' attributes across a document.                                                     
  2. Validation of cross-references between elements.                                                             
  3. Validation of the relations between attributes of the UniformTimeCourse element that configure a simulation. 
  4. Validation that variables referred to in a MathML expression are defined as variables or parameters.         
                                                                                                                  

</svrl:text>
<svrl:ns-prefix-in-attribute-values uri="http://sed-ml.org/" prefix="sed"/>
<svrl:ns-prefix-in-attribute-values uri="http://www.w3.org/1998/Math/MathML" prefix="math"/>
<svrl:active-pattern>
<xsl:attribute name="id">UniformTimeCourse</xsl:attribute>
<xsl:attribute name="name">Checking numeric values of uniform time courses</xsl:attribute>
<xsl:apply-templates/>
</svrl:active-pattern>
<xsl:apply-templates select="/" mode="M4"/>
<svrl:active-pattern>
<xsl:attribute name="id">targetOrSymbol</xsl:attribute>
<xsl:attribute name="name"> Checking a variable has a target or a symbol, but not both.</xsl:attribute>
<xsl:apply-templates/>
</svrl:active-pattern>
<xsl:apply-templates select="/" mode="M10"/>
<svrl:active-pattern>
<xsl:attribute name="id">duplicates</xsl:attribute>
<xsl:attribute name="name">Checking no duplicate IDs </xsl:attribute>
<xsl:apply-templates/>
</svrl:active-pattern>
<xsl:apply-templates select="/" mode="M11"/>
<svrl:active-pattern>
<xsl:attribute name="id">xreferences</xsl:attribute>
<xsl:attribute name="name">Checking cross references </xsl:attribute>
<xsl:apply-templates/>
</svrl:active-pattern>
<xsl:apply-templates select="/" mode="M12"/>
</svrl:schematron-output>
</xsl:template>

<!--SCHEMATRON PATTERNS-->
<svrl:text xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl">SED-ML Schematron schema</svrl:text>

<!--PATTERN UniformTimeCourseChecking numeric values of uniform time courses-->
<svrl:text xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Checking numeric values of uniform time courses</svrl:text>

	<!--RULE -->
<xsl:template match="sed:uniformTimeCourse" priority="1000" mode="M4">
<svrl:fired-rule xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="sed:uniformTimeCourse"/>

		<!--ASSERT -->
<xsl:choose>
<xsl:when test="@initialTime &gt;= 0 "/>
<xsl:otherwise>
<svrl:failed-assert xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@initialTime &gt;= 0">
<xsl:attribute name="location">
<xsl:apply-templates select="." mode="schematron-get-full-path"/>
</xsl:attribute>
<svrl:text>Initial time  must be &gt;= than 0.
        </svrl:text>
</svrl:failed-assert>
</xsl:otherwise>
</xsl:choose>

		<!--ASSERT -->
<xsl:choose>
<xsl:when test="@outputStartTime &gt;= @initialTime"/>
<xsl:otherwise>
<svrl:failed-assert xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@outputStartTime &gt;= @initialTime">
<xsl:attribute name="location">
<xsl:apply-templates select="." mode="schematron-get-full-path"/>
</xsl:attribute>
<svrl:text>Output start time must be &gt;= than initialTime.
        </svrl:text>
</svrl:failed-assert>
</xsl:otherwise>
</xsl:choose>

		<!--ASSERT -->
<xsl:choose>
<xsl:when test="@outputEndTime &gt;= @outputStartTime"/>
<xsl:otherwise>
<svrl:failed-assert xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@outputEndTime &gt;= @outputStartTime">
<xsl:attribute name="location">
<xsl:apply-templates select="." mode="schematron-get-full-path"/>
</xsl:attribute>
<svrl:text>Output end time must be &gt;= than output start time.
        </svrl:text>
</svrl:failed-assert>
</xsl:otherwise>
</xsl:choose>

		<!--ASSERT -->
<xsl:choose>
<xsl:when test="@numberOfPoints &gt;= 0"/>
<xsl:otherwise>
<svrl:failed-assert xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@numberOfPoints &gt;= 0">
<xsl:attribute name="location">
<xsl:apply-templates select="." mode="schematron-get-full-path"/>
</xsl:attribute>
<svrl:text>There must be more than zero points output.
        </svrl:text>
</svrl:failed-assert>
</xsl:otherwise>
</xsl:choose>
<xsl:apply-templates select="@*|*" mode="M4"/>
</xsl:template>
<xsl:template match="text()" priority="-1" mode="M4"/>
<xsl:template match="@*|node()" priority="-2" mode="M4">
<xsl:apply-templates select="@*|*" mode="M4"/>
</xsl:template>

<!--PATTERN targetOrSymbol Checking a variable has a target or a symbol, but not both.-->
<svrl:text xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl"> Checking a variable has a target or a symbol, but not both.</svrl:text>

	<!--RULE -->
<xsl:template match="sed:variable[@target]" priority="1001" mode="M10">
<svrl:fired-rule xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="sed:variable[@target]"/>

		<!--ASSERT -->
<xsl:choose>
<xsl:when test="not(@symbol)"/>
<xsl:otherwise>
<svrl:failed-assert xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@symbol)">
<xsl:attribute name="location">
<xsl:apply-templates select="." mode="schematron-get-full-path"/>
</xsl:attribute>
<svrl:text> Variable cannot have target and symbol defined.</svrl:text> <svrl:diagnostic-reference diagnostic="notTargetAndSymbol">

    The <xsl:text/>
<xsl:value-of select="name(.)"/>
<xsl:text/> with id  '<xsl:text/>
<xsl:value-of select="@id"/>
<xsl:text/>' must have either a target XPath expression, identifying a model variable,
     or a symbol, representing an implicit variable, but not both. 
   </svrl:diagnostic-reference>
</svrl:failed-assert>
</xsl:otherwise>
</xsl:choose>
<xsl:apply-templates select="@*|*" mode="M10"/>
</xsl:template>

	<!--RULE -->
<xsl:template match="sed:variable" priority="1000" mode="M10">
<svrl:fired-rule xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="sed:variable"/>

		<!--ASSERT -->
<xsl:choose>
<xsl:when test="@target | @symbol"/>
<xsl:otherwise>
<svrl:failed-assert xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@target | @symbol">
<xsl:attribute name="location">
<xsl:apply-templates select="." mode="schematron-get-full-path"/>
</xsl:attribute>
<svrl:text> Variable must have either a target or a symbol attribute.</svrl:text> <svrl:diagnostic-reference diagnostic="targetOrSymbol">

    The <xsl:text/>
<xsl:value-of select="name(.)"/>
<xsl:text/> with id  '<xsl:text/>
<xsl:value-of select="@id"/>
<xsl:text/>' must have either a target XPath expression, identifying a model variable,
     or a symbol, representing an implicit variable. 
   </svrl:diagnostic-reference>
</svrl:failed-assert>
</xsl:otherwise>
</xsl:choose>
<xsl:apply-templates select="@*|*" mode="M10"/>
</xsl:template>
<xsl:template match="text()" priority="-1" mode="M10"/>
<xsl:template match="@*|node()" priority="-2" mode="M10">
<xsl:apply-templates select="@*|*" mode="M10"/>
</xsl:template>

<!--PATTERN duplicatesChecking no duplicate IDs -->
<svrl:text xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Checking no duplicate IDs </svrl:text>

	<!--RULE -->
<xsl:template match="sed:*[@id and not(ancestor::sed:newXML)]" priority="1000" mode="M11">
<svrl:fired-rule xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="sed:*[@id and not(ancestor::sed:newXML)]"/>

		<!--ASSERT -->
<xsl:choose>
<xsl:when test="count(key('allIds', @id)) = 1"/>
<xsl:otherwise>
<svrl:failed-assert xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(key('allIds', @id)) = 1">
<xsl:attribute name="location">
<xsl:apply-templates select="." mode="schematron-get-full-path"/>
</xsl:attribute>
<svrl:text>
           Duplicated id in element "<xsl:text/>
<xsl:value-of select="name(.)"/>
<xsl:text/>" - "<xsl:text/>
<xsl:value-of select="@id"/>
<xsl:text/>".
           </svrl:text> <svrl:diagnostic-reference diagnostic="failedUniqueIds">

     The Id  '<xsl:text/>
<xsl:value-of select="@id"/>
<xsl:text/>' for the element <xsl:text/>
<xsl:value-of select="name(.)"/>
<xsl:text/> is not unique in this document. To be valid SED-ML,
      all Id attribute values should be unique.
   </svrl:diagnostic-reference>
</svrl:failed-assert>
</xsl:otherwise>
</xsl:choose>
<xsl:apply-templates select="@*|*" mode="M11"/>
</xsl:template>
<xsl:template match="text()" priority="-1" mode="M11"/>
<xsl:template match="@*|node()" priority="-2" mode="M11">
<xsl:apply-templates select="@*|*" mode="M11"/>
</xsl:template>

<!--PATTERN xreferencesChecking cross references -->
<svrl:text xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Checking cross references </svrl:text>

	<!--RULE -->
<xsl:template match="sed:task" priority="1005" mode="M12">
<svrl:fired-rule xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="sed:task"/>

		<!--ASSERT -->
<xsl:choose>
<xsl:when test="count(key('modelid', @modelReference)) = 1"/>
<xsl:otherwise>
<svrl:failed-assert xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(key('modelid', @modelReference)) = 1">
<xsl:attribute name="location">
<xsl:apply-templates select="." mode="schematron-get-full-path"/>
</xsl:attribute>
<svrl:text>Model reference '<xsl:text/>
<xsl:value-of select="@modelReference"/>
<xsl:text/>' did not refer to the id of a model element. </svrl:text>
</svrl:failed-assert>
</xsl:otherwise>
</xsl:choose>

		<!--REPORT -->
<xsl:if test="count(key('modelid', @modelReference)) = 1">
<svrl:successful-report xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(key('modelid', @modelReference)) = 1">
<xsl:attribute name="location">
<xsl:apply-templates select="." mode="schematron-get-full-path"/>
</xsl:attribute>
<svrl:text>
          Model reference '<xsl:text/>
<xsl:value-of select="@modelReference"/>
<xsl:text/>' matched to a model in task '<xsl:text/>
<xsl:value-of select="@id"/>
<xsl:text/>'.
   	</svrl:text>
</svrl:successful-report>
</xsl:if>

		<!--ASSERT -->
<xsl:choose>
<xsl:when test="count(key('simid', @simulationReference)) = 1"/>
<xsl:otherwise>
<svrl:failed-assert xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(key('simid', @simulationReference)) = 1">
<xsl:attribute name="location">
<xsl:apply-templates select="." mode="schematron-get-full-path"/>
</xsl:attribute>
<svrl:text>Simulation reference '<xsl:text/>
<xsl:value-of select="@simulationReference"/>
<xsl:text/>' did not refer to the id of a simulation element.</svrl:text>
</svrl:failed-assert>
</xsl:otherwise>
</xsl:choose>

		<!--REPORT -->
<xsl:if test="count(key('simid', @simulationReference)) = 1">
<svrl:successful-report xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(key('simid', @simulationReference)) = 1">
<xsl:attribute name="location">
<xsl:apply-templates select="." mode="schematron-get-full-path"/>
</xsl:attribute>
<svrl:text>
          Simulation reference '<xsl:text/>
<xsl:value-of select="@simulationReference"/>
<xsl:text/>' matched to a simulation in task '<xsl:text/>
<xsl:value-of select="@id"/>
<xsl:text/>'.
   	</svrl:text>
</svrl:successful-report>
</xsl:if>
<xsl:apply-templates select="@*|*" mode="M12"/>
</xsl:template>

	<!--RULE -->
<xsl:template match="sed:variable" priority="1004" mode="M12">
<svrl:fired-rule xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="sed:variable"/>

		<!--ASSERT -->
<xsl:choose>
<xsl:when test="count(key('taskid', @taskReference)) = 1"/>
<xsl:otherwise>
<svrl:failed-assert xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(key('taskid', @taskReference)) = 1">
<xsl:attribute name="location">
<xsl:apply-templates select="." mode="schematron-get-full-path"/>
</xsl:attribute>
<svrl:text>  Variable  '<xsl:text/>
<xsl:value-of select="@id"/>
<xsl:text/>' referred to unknown task '<xsl:text/>
<xsl:value-of select="@taskReference"/>
<xsl:text/>'. </svrl:text>
</svrl:failed-assert>
</xsl:otherwise>
</xsl:choose>
<xsl:apply-templates select="@*|*" mode="M12"/>
</xsl:template>

	<!--RULE -->
<xsl:template match="math:ci | math:csymbol" priority="1003" mode="M12">
<svrl:fired-rule xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="math:ci | math:csymbol"/>

		<!--ASSERT -->
<xsl:choose>
<xsl:when test=" (count (ancestor::sed:dataGenerator/sed:listOfVariables/sed:variable[@id = current()/text()]) ) +       (count (ancestor::sed:dataGenerator/sed:listOfParameters/sed:parameter[@id = current()/text()]) )            = 1"/>
<xsl:otherwise>
<svrl:failed-assert xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="(count (ancestor::sed:dataGenerator/sed:listOfVariables/sed:variable[@id = current()/text()]) ) + (count (ancestor::sed:dataGenerator/sed:listOfParameters/sed:parameter[@id = current()/text()]) ) = 1">
<xsl:attribute name="location">
<xsl:apply-templates select="." mode="schematron-get-full-path"/>
</xsl:attribute>
<svrl:text>  Variable  '<xsl:text/>
<xsl:value-of select="text()"/>
<xsl:text/>' not found in
    	 .
    	 for <xsl:text/>
<xsl:value-of select="text()"/>
<xsl:text/>
</svrl:text>
</svrl:failed-assert>
</xsl:otherwise>
</xsl:choose>
<xsl:apply-templates select="@*|*" mode="M12"/>
</xsl:template>

	<!--RULE -->
<xsl:template match="sed:dataSet" priority="1002" mode="M12">
<svrl:fired-rule xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="sed:dataSet"/>

		<!--ASSERT -->
<xsl:choose>
<xsl:when test="count(key('dgid', @dataReference)) = 1"/>
<xsl:otherwise>
<svrl:failed-assert xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(key('dgid', @dataReference)) = 1">
<xsl:attribute name="location">
<xsl:apply-templates select="." mode="schematron-get-full-path"/>
</xsl:attribute>
<svrl:text>  Data reference '<xsl:text/>
<xsl:value-of select="@dataReference"/>
<xsl:text/>' did not refer to the id of a DataGenerator element.</svrl:text>
</svrl:failed-assert>
</xsl:otherwise>
</xsl:choose>
<xsl:apply-templates select="@*|*" mode="M12"/>
</xsl:template>

	<!--RULE -->
<xsl:template match="sed:curve" priority="1001" mode="M12">
<svrl:fired-rule xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="sed:curve"/>

		<!--ASSERT -->
<xsl:choose>
<xsl:when test="count(key('dgid', @xDataReference)) = 1"/>
<xsl:otherwise>
<svrl:failed-assert xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(key('dgid', @xDataReference)) = 1">
<xsl:attribute name="location">
<xsl:apply-templates select="." mode="schematron-get-full-path"/>
</xsl:attribute>
<svrl:text> X Data reference '<xsl:text/>
<xsl:value-of select="@xDataReference"/>
<xsl:text/>' did not refer to the id of a DataGenerator element.</svrl:text>
</svrl:failed-assert>
</xsl:otherwise>
</xsl:choose>

		<!--ASSERT -->
<xsl:choose>
<xsl:when test="count(key('dgid', @yDataReference)) = 1"/>
<xsl:otherwise>
<svrl:failed-assert xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(key('dgid', @yDataReference)) = 1">
<xsl:attribute name="location">
<xsl:apply-templates select="." mode="schematron-get-full-path"/>
</xsl:attribute>
<svrl:text> Y Data reference '<xsl:text/>
<xsl:value-of select="@yDataReference"/>
<xsl:text/>' did not refer to the id of a DataGenerator element.</svrl:text>
</svrl:failed-assert>
</xsl:otherwise>
</xsl:choose>
<xsl:apply-templates select="@*|*" mode="M12"/>
</xsl:template>

	<!--RULE -->
<xsl:template match="sed:surface" priority="1000" mode="M12">
<svrl:fired-rule xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="sed:surface"/>

		<!--ASSERT -->
<xsl:choose>
<xsl:when test="count(key('dgid', @xDataReference)) = 1"/>
<xsl:otherwise>
<svrl:failed-assert xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(key('dgid', @xDataReference)) = 1">
<xsl:attribute name="location">
<xsl:apply-templates select="." mode="schematron-get-full-path"/>
</xsl:attribute>
<svrl:text> X Data reference '<xsl:text/>
<xsl:value-of select="@xDataReference"/>
<xsl:text/>' did not refer to the id of a DataGenerator element.
        </svrl:text>
</svrl:failed-assert>
</xsl:otherwise>
</xsl:choose>

		<!--ASSERT -->
<xsl:choose>
<xsl:when test="count(key('dgid', @yDataReference)) = 1"/>
<xsl:otherwise>
<svrl:failed-assert xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(key('dgid', @yDataReference)) = 1">
<xsl:attribute name="location">
<xsl:apply-templates select="." mode="schematron-get-full-path"/>
</xsl:attribute>
<svrl:text> Y Data reference '<xsl:text/>
<xsl:value-of select="@yDataReference"/>
<xsl:text/>' did not refer to the id of a DataGenerator element.
        </svrl:text>
</svrl:failed-assert>
</xsl:otherwise>
</xsl:choose>

		<!--ASSERT -->
<xsl:choose>
<xsl:when test="count(key('dgid', @yDataReference)) = 1"/>
<xsl:otherwise>
<svrl:failed-assert xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(key('dgid', @yDataReference)) = 1">
<xsl:attribute name="location">
<xsl:apply-templates select="." mode="schematron-get-full-path"/>
</xsl:attribute>
<svrl:text> Z Data reference '<xsl:text/>
<xsl:value-of select="@zDataReference"/>
<xsl:text/>' did not refer to the id of a DataGenerator element.
        </svrl:text>
</svrl:failed-assert>
</xsl:otherwise>
</xsl:choose>
<xsl:apply-templates select="@*|*" mode="M12"/>
</xsl:template>
<xsl:template match="text()" priority="-1" mode="M12"/>
<xsl:template match="@*|node()" priority="-2" mode="M12">
<xsl:apply-templates select="@*|*" mode="M12"/>
</xsl:template>
</xsl:stylesheet>
