package plugin.sample2.table;

import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;

import plugin.sample2.dialog.PluginSampleDialog;

import jp.sbi.celldesigner.plugin.PluginUnit;
import jp.sbi.celldesigner.plugin.PluginUnitDefinition;

public class UnitViewingTable extends JTable{

	private String tabName;
	
	/** COL_NAMES*/
	protected Object[] COL_NAMES;
	
	protected PluginUnitDefinition def;
	
	/**
	 * makeColName
	 * @return Object[]
	 */
	protected Object[] makeColNameForSPRef() {
		Object[] colName = new Object[5];
		colName[0] = "kind";
		colName[1] = "exponent";
		colName[2] = "scale";
		colName[3] = "multiplier";
		colName[4] = "offset";

		return colName;
	};
		
	/**
	 *  Constructor
	 *  @param  parent
	 *  @param  data    
	 */
	public UnitViewingTable(Object[][] data , String tabName , PluginUnitDefinition def) {
		this.tabName = tabName;
		this.def =def;
		COL_NAMES = makeColNameForSPRef();

		this.setModel(new UnitViewingTableModel(data , COL_NAMES , tabName ,this));
		
		this.TableInit();
	}

	/**
	 *  TableInit
	 */
	protected void TableInit() {
		setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
		setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		
		this.getTableHeader().setReorderingAllowed(false);
		this.getTableHeader().setResizingAllowed(true);
	}
}

/**
 * UnitViewingTableModel
 * @author MKI
 */
class UnitViewingTableModel extends AbstractTableModel{

	UnitViewingTable parent;
	
	/** data */
	private Object[][] data;

	/** COL_NAMES */
	protected Object[] COL_NAMES;

	private String tabName;
	
	/**
	 * Constructor
	 * @param parent
	 * @param data
	 * @param names
	 */
	public UnitViewingTableModel( Object[][] data, Object[] names , String tabName , UnitViewingTable parent) {
		super();
		this.parent = parent;
		this.COL_NAMES = names;
		this.data   = data;
		this.tabName = tabName;
		try {
		} catch(Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * delData
	 * @param jar
	 */
	public void delData(int selectedRow){
		Object[][] newData = new Object[data.length-1][4];
		int row = 0;
		for(int i = 0 ; i < data.length ; i++){
			if(i == selectedRow){
				continue;
			}
			for(int k = 0 ; k < data[i].length ; k++){
				newData[row][k] = data[i][k];
			}
			
			row++;
		}
		
		data = newData;			
		
		//�ύX�ʒm
        fireTableDataChanged();		
	}
	
	/**
	 * getColumnCount
	 * @return int
	 */
	public int getColumnCount() {
    	return COL_NAMES.length;
	}
        
    /**
     * getRowCount
     * @return int
     */
	public int getRowCount() {
		return data.length;
	}

    /**
     * getColumnName
     * @param  col
     * @return String
     */
	public String getColumnName(int col) {
		return (String)COL_NAMES[col];
	}

    /**
     * getValueAt
     * @param  row
     * @param  col
     * @return Object
     */
	public Object getValueAt(int row, int col) {
		return data[row][col];
	}

	/*
	 * JTable uses this method to determine the default renderer/
	 * editor for each cell.  If we didn't implement this method,
	 * then the last column would contain text ("true"/"false"),
	 * rather than a check box.
	 * @param c
	 */
	public Class getColumnClass(int c) {
//System.out.println("c = " + getValueAt(0, c).getClass());	
        if(getValueAt(0, c) != null){
        	return getValueAt(0, c).getClass();	
        }
		else if(c == 0){
			return new Boolean(false).getClass();
		}
		else{
			return new String().getClass();
		}
	}

	/*
	 * Don't need to implement this method unless your table's
	 * editable.
	 * @param row
	 * @param col
	 */
	public boolean isCellEditable(int row, int col) {
		return true;
	}

	/*
	 * Don't need to implement this method unless your table's
	 * data can change.
	 * @param value
	 * @param row
	 * @param col
	 */
	public void setValueAt(Object value, int row, int col) {
		if (data[0][col] instanceof Integer                        
				&& !(value instanceof Integer)) {                  
			//With JFC/Swing 1.1 and JDK 1.2, we need to create    
			//an Integer from the value; otherwise, the column     
			//switches to contain Strings.  Starting with v 1.3,   
			//the table automatically converts value to an Integer,
			//so you only need the code in the 'else' part of this 
			//'if' block.                                          
			//See TableEditDemo.java for a better solution!!!
			try {
				data[row][col] = new Integer(value.toString());
				fireTableCellUpdated(row, col);				
				
			} catch (NumberFormatException e) {
                e.printStackTrace();
			}
		} else {
			data[row][col] = value;
			fireTableCellUpdated(row, col);
				

			PluginUnit sp = parent.def.getUnit(parent.getSelectedRow());
			for(int j = 0 ; j < parent.getModel().getColumnCount() ; j++){
				String rowvalue = null;
				Boolean boo = null;
				try{
					rowvalue = (String)parent.getModel().getValueAt(
							parent.getSelectedRow(),j);
				}catch(Exception ex){
					boo = (Boolean) parent.getModel().getValueAt(
							parent.getSelectedRow(),j);
				}
//	System.out.println("rowvalue = " + rowvalue);								
					
				if(j == 0){
					sp.setKind(Integer.parseInt(rowvalue));
				}
				else if(j == 1){
					sp.setExponent(Integer.parseInt(rowvalue));
				}	
				else if(j == 2){
					sp.setScale(Integer.parseInt(rowvalue));
				}
				else if(j == 3){
					sp.setMultiplier(Double.parseDouble(rowvalue));
				}				
				else if(j == 4){
					sp.setOffset(Double.parseDouble(rowvalue));
				}				
			}
			
			PluginSampleDialog.plug.notifySBaseChanged(sp);	
		}
	}
	
}

