package plugin.sample2.table;

import java.awt.Color;

import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

import org.sbml.libsbml.libsbml;

import plugin.sample2.dialog.CommonSBaseViewingTab;
import plugin.sample2.dialog.PluginSampleDialog;


import jp.sbi.celldesigner.plugin.*;

/**
 * JarViewingTable
 * @author MKI
 */
public class SBaseViewingTable extends JTable{

	private String tabName;
	
	/** ATTRIBUTE*/
	public static final int ATTRIBUTE = 0;
	
	/** HREF*/
	public static final int HREF      = 1;

	/** MAIN*/
	public static final int MAIN      = 2;

	/** DOWNLOAD*/
	public static final int DOWNLOAD  = 3;

	
	/** COL_NAMES*/
	protected Object[] COL_NAMES;
	
	/**
	 * makeColName
	 * @return Object[]
	 */
	protected Object[] makeColNameForTest() {
		Object[] colName = new Object[4];
		colName[0] = "attribute";
		colName[1] = "href";
		colName[2] = "main";
		colName[3] = "download";

		return colName;
	};
	
	/**
	 * makeColName
	 * @return Object[]
	 */
	protected Object[] makeColNameForSpecies() {
		Object[] colName = new Object[15];
		int i = 0;
		colName[i++] = "class";
		colName[i++] = "extension id";
		colName[i++] = "positionToCompartment";
		colName[i++] = "id";
		colName[i++] = "name";
		colName[i++] = "compartment";
		colName[i++] = "quantity type";
		colName[i++] = "initialQuanity";
		colName[i++] = "substanceUnits";
		colName[i++] = "spatialSizeUnits";
		colName[i++] = "hasOnlySubstanceUnits";
		colName[i++] = "boundaryCondition";
		colName[i++] = "charge";
		colName[i++] = "constant";
//		colName[12] = "x";
//		colName[13] = "y";
//		colName[14] = "width";
//		colName[15] = "height";
		colName[i++] = "notes";
		
		return colName;
	};
	
	/**
	 * makeColName
	 * @return Object[]
	 */
	protected Object[] makeColSpeciesAlias() {
		Object[] colName = new Object[6];
		colName[0] = "species id";
		colName[1] = "alias id";
		colName[2] = "type";
		colName[3] = "name";
		colName[4] = "x";
		colName[5] = "y";

		return colName;
	};
	
	/**
	 * makeColName
	 * @return Object[]
	 */
	protected Object[] makeColNameForProteins() {
		Object[] colName = new Object[4];
		colName[0] = "type";
		colName[1] = "id";
		colName[2] = "name";
		colName[3] = "notes";
		
		return colName;
	}
	/**
	 * makeColName
	 * @return Object[]
	 */
	protected Object[] makeColNameForReactions() {
		Object[] colName = new Object[11];
		colName[0] = "type";
		colName[1] = "id";
		colName[2] = "name";
		colName[3] = "reversible";
		colName[4] = "fast";
		colName[5] = "reactants";
		colName[6] = "products";
		colName[7] = "modifiers";
		colName[8] = "math";
		colName[9] = "linewidth";
		colName[10] = "notes";
		
		return colName;
	};
	
	/**
	 * makeColName
	 * @return Object[]
	 */
	protected Object[] makeColNameForKineticLaw() {
		Object[] colName = new Object[3];
		colName[0] = "Formula";
		colName[1] = "SubstanceUnit";
		colName[2] = "TimeUnits";
		
		return colName;
	};
	
	/**
	 * makeColName
	 * @return Object[]
	 */
	protected Object[] makeColNameForCompartment() {
		Object[] colName = new Object[12];
		colName[0] = "id";
		colName[1] = "name";
		colName[2] = "spatialDimensions";
		colName[3] = "size";
		colName[4] = "units";
		colName[5] = "outside";
		colName[6] = "constant";
		colName[7] = "x";
		colName[8] = "y";
		colName[9] = "width";
		colName[10] = "height";
		colName[11] = "notes";
		
		return colName;
	};
	
	/**
	 * makeColName
	 * @return Object[]
	 */
	protected Object[] makeColNameForLocalParameter() {
		Object[] colName = new Object[5];
		colName[0] = "id";
		colName[1] = "name";
		colName[2] = "value";
		colName[3] = "units";
		colName[4] = "constant";
		
		return colName;
	};
	
	/**
	 * makeColName
	 * @return Object[]
	 */
	protected Object[] makeColNameForParameter() {
		Object[] colName = new Object[5];
		colName[0] = "id";
		colName[1] = "name";
		colName[2] = "value";
		colName[3] = "units";
		colName[4] = "constant";
		
		return colName;
	};
	
	/**
	 * makeColName
	 * @return Object[]
	 */
	protected Object[] makeColNameForFunction() {
		Object[] colName = new Object[4];
		colName[0] = "id";
		colName[1] = "name";
		colName[2] = "argument";
		colName[3] = "math";
		
		return colName;
	};
	
	/**
	 * makeColName
	 * @return Object[]
	 */
	protected Object[] makeColNameForUnitDef() {
		Object[] colName = new Object[3];
		colName[0] = "id";
		colName[1] = "name";
		colName[2] = "units";
		
		return colName;
	};
	
	/**
	 * makeColName
	 * @return Object[]
	 */
	protected Object[] makeColNameForUnit() {
		Object[] colName = new Object[5];
		colName[0] = "parent_id";
		colName[1] = "Exponent";
		colName[2] = "kind";
		colName[3] = "Scale";
		colName[4] = "Multiplier";
		
		return colName;
	};
	
	/**
	 * makeColName
	 * @return Object[]
	 */
	protected Object[] makeColNameForRule() {
		Object[] colName = new Object[3];
		colName[0] = "Object";
		colName[1] = "math";
		colName[2] = "variable";
		
		return colName;
	};
	
	/**
	 * makeColName
	 * @return Object[]
	 */
	protected Object[] makeColNameForEvents() {
		Object[] colName = new Object[5];
		colName[0] = "id";
		colName[1] = "name";
		colName[2] = "trigger";
		colName[3] = "delay";
		colName[4] = "timeUnits";
		
		return colName;
	};
	
	/**
	 *  Constructor
	 *  @param  parent
	 *  @param  data    
	 */
	public SBaseViewingTable(Object[][] data , String tabName) {
		this.tabName = tabName;
		if(tabName.equals(PluginSampleDialog.SPECIES)){
			COL_NAMES = makeColNameForSpecies();
		}
		else if(tabName.equals(PluginSampleDialog.SPECIES_ALIAS)){
			COL_NAMES = makeColSpeciesAlias();
		}		
		else if(tabName.equals(PluginSampleDialog.PROTEINS) ||
				tabName.equals(PluginSampleDialog.GENES) ||
				tabName.equals(PluginSampleDialog.RNAS) ||
				tabName.equals(PluginSampleDialog.AS_RNAS)){
			COL_NAMES = makeColNameForProteins();
		}
		else if(tabName.equals(PluginSampleDialog.REACTIONS)){
			COL_NAMES = makeColNameForReactions();
		}
		else if(tabName.equals(PluginSampleDialog.KINETICLAWS)){
			COL_NAMES = makeColNameForKineticLaw();
		}
		else if(tabName.equals(PluginSampleDialog.COMPARTMENTS)){
			COL_NAMES = makeColNameForCompartment();
		}
		else if(tabName.equals(PluginSampleDialog.LOCAL_PARAM)){
			COL_NAMES = makeColNameForParameter();
		}
		else if(tabName.equals(PluginSampleDialog.PARAMETERS)){
			COL_NAMES = makeColNameForParameter();
		}
		else if(tabName.equals(PluginSampleDialog.FUNCTIONS)){
			COL_NAMES = makeColNameForFunction();
		}
		else if(tabName.equals(PluginSampleDialog.UNIT_DEFINITIONS)){
			COL_NAMES = makeColNameForUnitDef();
		}
		else if(tabName.equals(PluginSampleDialog.UNITS)){
			COL_NAMES = makeColNameForUnit();
		}
		else if(tabName.equals(PluginSampleDialog.RULES)){
			COL_NAMES = makeColNameForRule();
		}
		else if(tabName.equals(PluginSampleDialog.EVENTS)){
			COL_NAMES = makeColNameForEvents();
		}
		else{
			COL_NAMES = makeColNameForTest();	
		}		
		
		this.setModel(new JarViewingTableModel(data , COL_NAMES , tabName));
		
		this.TableInit();
	}

	/**
	 *  TableInit
	 */
	protected void TableInit() {
		setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
		setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		
		this.setColumnWidth();
		this.getTableHeader().setReorderingAllowed(false);
		this.getTableHeader().setResizingAllowed(true);
	
//		setUpSportColumn(
//			getColumnModel().getColumn(ATTRIBUTE) ,new AttributeTypeComboBox());	
//		
//		setUpSportColumn(
//				getColumnModel().getColumn(DOWNLOAD) ,new DownloadTypeComboBox());
//		
//        addMouseListener( new MouseAdapter(){
//            public void mouseClicked( MouseEvent e ) {
//
//                //���_�u���N���b�N��
//                if( e.getClickCount() == 2 ) {
//                }
//                //���V���O���N���b�N��
//                else if(e.getClickCount() == 1){
////                	clickAction();
//                }
//            }
//        } );
	}
	
//	/**
//	 * clickAction
//	 */
//	private void clickAction(){
//		((CommonJarViewingTab)PluginSampleDialog.getJTabbedPane().getSelectedComponent()).setDeleteButtonEnable(true);
//	}

	/**
	 * JTextField��e�[�u���ɕ\��������ׂ̏���
	 * @param sportColumn
	 * @param combo
	 * @param columnIndex
	 */
	public void setUpSportColumn(TableColumn sportColumn, JComboBox combo) {
		//Set up the editor for the sport cells.
		sportColumn.setCellEditor(new DefaultCellEditor(combo));

		setUpSportColumn(sportColumn);
	}

	/**
	 * �����񓙈ȊO��Object��e�[�u���ɕ\��������ׂ̏���
	 * @param sportColumn
	 * @param columnIndex
	 */
	public void setUpSportColumn(TableColumn sportColumn) {
		//Set up tool tips for the sport cells.
		DefaultTableCellRenderer renderer =
				new DefaultTableCellRenderer();
		sportColumn.setCellRenderer(renderer);
	}

	/**
	 *  setColumnWidth
	 */
	private void setColumnWidth() {
//		getColumnModel().getColumn(ATTRIBUTE).setPreferredWidth(50);
//		getColumnModel().getColumn(HREF).setPreferredWidth(300);
//		getColumnModel().getColumn(MAIN).setPreferredWidth(40);
//		getColumnModel().getColumn(DOWNLOAD).setPreferredWidth(60);
	}

//	/**
//	 * addData
//	 * @param jar
//	 */
//	public void addData(Jar jar){
//		((JarViewingTableModel)getModel()).addData(jar);
//	}
	
	/**
	 * delData
	 */
	public void delData(){
		((JarViewingTableModel)getModel()).delData(getSelectedRow());
	}	
}

/**
 * JarViewingTableModel
 * @author MKI
 */
class JarViewingTableModel extends AbstractTableModel{

	/** data */
	private Object[][] data;

	/** COL_NAMES */
	protected Object[] COL_NAMES;

	private String tabName;
	
	/**
	 * Constructor
	 * @param parent
	 * @param data
	 * @param names
	 */
	public JarViewingTableModel( Object[][] data, Object[] names , String tabName) {
		super();
		this.COL_NAMES = names;
		this.data   = data;
		this.tabName = tabName;
		try {
		} catch(Exception e) {
			e.printStackTrace();
		}
	}

//	/**
//	 * addData
//	 * @param jar
//	 */
//	public void addData(Jar jar){
//		Object[][] newData = new Object[data.length+1][4];
//		for(int i = 0 ; i < data.length ; i++){
//			for(int k = 0 ; k < data[i].length ; k++){
//				newData[i][k] = data[i][k];
//			}
//		}
//		
//		newData[data.length][JarViewingTable.ATTRIBUTE] = jar.getAttribute();
//		newData[data.length][JarViewingTable.HREF] = jar.getHref();
//		newData[data.length][JarViewingTable.MAIN] = new Boolean(jar.isMain());
//		newData[data.length][JarViewingTable.DOWNLOAD] = jar.getDownload();
//		
//		data = newData;			
//		
//		//�ύX�ʒm
//        fireTableDataChanged();		
//	}
	
	/**
	 * delData
	 * @param jar
	 */
	public void delData(int selectedRow){
		Object[][] newData = new Object[data.length-1][4];
		int row = 0;
		for(int i = 0 ; i < data.length ; i++){
			if(i == selectedRow){
				continue;
			}
			for(int k = 0 ; k < data[i].length ; k++){
				newData[row][k] = data[i][k];
			}
			
			row++;
		}
		
		data = newData;			
		
		//�ύX�ʒm
        fireTableDataChanged();		
	}
	
	/**
	 * getColumnCount
	 * @return int
	 */
	public int getColumnCount() {
    	return COL_NAMES.length;
	}
        
    /**
     * getRowCount
     * @return int
     */
	public int getRowCount() {
		return data.length;
	}

    /**
     * getColumnName
     * @param  col
     * @return String
     */
	public String getColumnName(int col) {
		return (String)COL_NAMES[col];
	}

    /**
     * getValueAt
     * @param  row
     * @param  col
     * @return Object
     */
	public Object getValueAt(int row, int col) {
		return data[row][col];
	}

	/*
	 * JTable uses this method to determine the default renderer/
	 * editor for each cell.  If we didn't implement this method,
	 * then the last column would contain text ("true"/"false"),
	 * rather than a check box.
	 * @param c
	 */
	public Class getColumnClass(int c) {
//System.out.println("c = " + getValueAt(0, c).getClass());	
        if(getValueAt(0, c) != null){
        	return getValueAt(0, c).getClass();	
        }
		else if(c == 0){
			return new Boolean(false).getClass();
		}
		else{
			return new String().getClass();
		}
	}

	/*
	 * Don't need to implement this method unless your table's
	 * editable.
	 * @param row
	 * @param col
	 */
	public boolean isCellEditable(int row, int col) {
		if(tabName.equals(PluginSampleDialog.SPECIES)){
            if(col == 0 ||
            		col == 1 ||
            		col == 2 ||
            		col == 3){
            	return false;
            }
		}
		else if(tabName.equals(PluginSampleDialog.SPECIES_ALIAS)){
           	return false;
		}
		else if(tabName.equals(PluginSampleDialog.PROTEINS) ||
				tabName.equals(PluginSampleDialog.GENES) ||
				tabName.equals(PluginSampleDialog.RNAS) ||
				tabName.equals(PluginSampleDialog.AS_RNAS)){
            if(col == 1){
            	return false;
            }
		}
		else if(tabName.equals(PluginSampleDialog.REACTIONS)){
            if(col == 1 ||
            		col == 5 ||
            		col == 6 ||
            		col == 7 ||
            		col == 8){
            	return false;
            }
		}
		else if(tabName.equals(PluginSampleDialog.KINETICLAWS)){
			return false;
		}
		else if(tabName.equals(PluginSampleDialog.COMPARTMENTS)){
            if(col == 0){
            	return false;
            }
		}
		else if(tabName.equals(PluginSampleDialog.LOCAL_PARAM)){
            if(col == 0){
            	return false;
            }
		}
		else if(tabName.equals(PluginSampleDialog.PARAMETERS)){
            if(col == 0){
            	return false;
            }
		}
		else if(tabName.equals(PluginSampleDialog.FUNCTIONS)){
            if(col == 0){
            	return false;
            }
		}
		else if(tabName.equals(PluginSampleDialog.UNIT_DEFINITIONS)){
            if(col == 0 || col == 2){
            	return false;
            }
		}
		else if(tabName.equals(PluginSampleDialog.UNITS)){
            if(col == 0){
            	return false;
            }
		}
		else if(tabName.equals(PluginSampleDialog.RULES)){
		}
		else if(tabName.equals(PluginSampleDialog.EVENTS)){
            if(col == 0){
            	return false;
            }
		}

		return true;
	}

	/*
	 * Don't need to implement this method unless your table's
	 * data can change.
	 * @param value
	 * @param row
	 * @param col
	 */
	public void setValueAt(Object value, int row, int col) {
		if (data[0][col] instanceof Integer                        
				&& !(value instanceof Integer)) {                  
			//With JFC/Swing 1.1 and JDK 1.2, we need to create    
			//an Integer from the value; otherwise, the column     
			//switches to contain Strings.  Starting with v 1.3,   
			//the table automatically converts value to an Integer,
			//so you only need the code in the 'else' part of this 
			//'if' block.                                          
			//See TableEditDemo.java for a better solution!!!
			try {
				data[row][col] = new Integer(value.toString());
				fireTableCellUpdated(row, col);				
				
			} catch (NumberFormatException e) {
                e.printStackTrace();
			}
		} else {
			data[row][col] = value;
			fireTableCellUpdated(row, col);
			
			//���ݑI�Ⳃ�Ă���tab�ȊO��main�̑I����
			PluginModel model= PluginSampleDialog.model;
			JTabbedPane pane = PluginSampleDialog.tabPane;		
			//species
	
			if(CommonSBaseViewingTab.SPECIES == pane.getSelectedIndex()){
				CommonSBaseViewingTab tab = (CommonSBaseViewingTab)pane.getComponent(CommonSBaseViewingTab.SPECIES);
				
				PluginSpecies sp = model.getSpecies(tab.getViewTabel().getSelectedRow());
				for(int j = 0 ; j < tab.getViewTabel().getColumnCount() ; j++){
					String rowvalue = null;
					Boolean boo = null;
					try{
						rowvalue = (String) tab.getViewTabel().getModel().getValueAt(
								tab.getViewTabel().getSelectedRow(),j);
					}catch(Exception ex){
						boo = (Boolean) tab.getViewTabel().getModel().getValueAt(
								tab.getViewTabel().getSelectedRow(),j);
					}
//	System.out.println("rowvalue = " + rowvalue);								
						
					if(j == 0){
//						sp.set(rowvalue);
					}
					else if(j == 1){
//						sp.setPositionToCompartment(rowvalue);
					}	
					else if(j == 2){
//								sp.set(rowvalue);
					}				
					else if(j == 3){
//						sp.setName(rowvalue);
					}		
					else if(j == 5){
						sp.setCompartment(rowvalue);
					}
					else if(j == 6){
						// do nothing for quantity type
					}	
					else if(j == 7){
						if(sp.isSetInitialAmount()){
							sp.setInitialAmount(Double.parseDouble(rowvalue));	
						}
						else{
							sp.setInitialConcentration(Double.parseDouble(rowvalue));
						}
					}	
					else if(j == 8){
						sp.setSubstanceUnits(rowvalue);
					}	
					else if(j == 9){
						sp.setSpatialSizeUnits(rowvalue);
					}	
					else if(j == 10){
						sp.setHasOnlySubstanceUnits(boo.booleanValue());
					}
					else if(j == 11){
						sp.setBoundaryCondition(boo.booleanValue());
					}
					else if(j == 12){
						sp.setCharge(Integer.parseInt(rowvalue));
					}
					else if(j == 13){
						sp.setConstant(boo.booleanValue());
					}
//					else if(j == 12){
//						sp.setX(Double.parseDouble(rowvalue));
//					}
//					else if(j == 13){
//						sp.setY(Double.parseDouble(rowvalue));
//					}
//					else if(j == 14){
//						sp.setWidth(Double.parseDouble(rowvalue));
//					}
//					else if(j == 15){
//						sp.setHeight(Double.parseDouble(rowvalue));
//					}
					else if(j == 14){
						sp.setNotes(rowvalue);
					}
				}
				
				PluginSampleDialog.plug.notifySBaseChanged(sp);	
			}
			//Protein
			else if(CommonSBaseViewingTab.PROTEINS == pane.getSelectedIndex()){
				CommonSBaseViewingTab tab = (CommonSBaseViewingTab)pane.getComponent(CommonSBaseViewingTab.PROTEINS);
				PluginProtein pro = model.getProtein(
						(String) tab.getViewTabel().getValueAt(tab.getViewTabel().getSelectedRow(),1));
				
				for(int j = 0 ; j < tab.getViewTabel().getColumnCount() ; j++){
					String rowvalue = null;
					Boolean boo = null;
					try{
						rowvalue = (String) tab.getViewTabel().getModel().getValueAt(
								tab.getViewTabel().getSelectedRow(),j);
					}catch(Exception ex){
						boo = (Boolean) tab.getViewTabel().getModel().getValueAt(
								tab.getViewTabel().getSelectedRow(),j);
					}						
					
					if(j == 0){
						pro.setType(rowvalue);
					}
					else if(j == 1){
//						pro.setSubstanceUnits(rowvalue);
					}
					else if(j == 2){
						pro.setName(rowvalue);
					}
					else if(j == 3){
						pro.setNotes(rowvalue);
					}
				}
				PluginSampleDialog.plug.notifySBaseChanged(pro);	
			}
			//GENE
			else if(CommonSBaseViewingTab.GENES == pane.getSelectedIndex()){
				CommonSBaseViewingTab tab = (CommonSBaseViewingTab)pane.getComponent(CommonSBaseViewingTab.GENES);
				PluginGene pro = model.getGene(
						(String) tab.getViewTabel().getValueAt(tab.getViewTabel().getSelectedRow(),1));
				
				for(int j = 0 ; j < tab.getViewTabel().getColumnCount() ; j++){
					String rowvalue = null;
					Boolean boo = null;
					try{
						rowvalue = (String) tab.getViewTabel().getModel().getValueAt(
								tab.getViewTabel().getSelectedRow(),j);
					}catch(Exception ex){
						boo = (Boolean) tab.getViewTabel().getModel().getValueAt(
								tab.getViewTabel().getSelectedRow(),j);
					}						
					
					if(j == 0){
						pro.setType(rowvalue);
					}
					else if(j == 1){
//						pro.setSubstanceUnits(rowvalue);
					}
					else if(j == 2){
						pro.setName(rowvalue);
					}
					else if(j == 3){
						pro.setNotes(rowvalue);
					}
				}
				PluginSampleDialog.plug.notifySBaseChanged(pro);	
			}
			//RNA
			else if(CommonSBaseViewingTab.RNAS == pane.getSelectedIndex()){
				CommonSBaseViewingTab tab = (CommonSBaseViewingTab)pane.getComponent(CommonSBaseViewingTab.RNAS);
				PluginRNA pro = model.getRNA(
						(String) tab.getViewTabel().getValueAt(tab.getViewTabel().getSelectedRow(),1));
				
				for(int j = 0 ; j < tab.getViewTabel().getColumnCount() ; j++){
					String rowvalue = null;
					Boolean boo = null;
					try{
						rowvalue = (String) tab.getViewTabel().getModel().getValueAt(
								tab.getViewTabel().getSelectedRow(),j);
					}catch(Exception ex){
						boo = (Boolean) tab.getViewTabel().getModel().getValueAt(
								tab.getViewTabel().getSelectedRow(),j);
					}						
					
					if(j == 0){
						pro.setType(rowvalue);
					}
					else if(j == 1){
//						pro.setSubstanceUnits(rowvalue);
					}
					else if(j == 2){
						pro.setName(rowvalue);
					}
					else if(j == 3){
						pro.setNotes(rowvalue);
					}
				}
				PluginSampleDialog.plug.notifySBaseChanged(pro);	
			}
			//asRNA
			else if(CommonSBaseViewingTab.ASRNAS == pane.getSelectedIndex()){
				CommonSBaseViewingTab tab = (CommonSBaseViewingTab)pane.getComponent(CommonSBaseViewingTab.ASRNAS);
				PluginAntiSenseRNA pro = model.getAntiSenseRNA(
						(String) tab.getViewTabel().getValueAt(tab.getViewTabel().getSelectedRow(),1));
				
				for(int j = 0 ; j < tab.getViewTabel().getColumnCount() ; j++){
					String rowvalue = null;
					Boolean boo = null;
					try{
						rowvalue = (String) tab.getViewTabel().getModel().getValueAt(
								tab.getViewTabel().getSelectedRow(),j);
					}catch(Exception ex){
						boo = (Boolean) tab.getViewTabel().getModel().getValueAt(
								tab.getViewTabel().getSelectedRow(),j);
					}						
					
					if(j == 0){
						pro.setType(rowvalue);
					}
					else if(j == 1){
//						pro.setSubstanceUnits(rowvalue);
					}
					else if(j == 2){
						pro.setName(rowvalue);
					}
					else if(j == 3){
						pro.setNotes(rowvalue);
					}
				}
				PluginSampleDialog.plug.notifySBaseChanged(pro);	
			}
			//reaction
			else if(CommonSBaseViewingTab.REACTIONS == pane.getSelectedIndex()){

				CommonSBaseViewingTab tab = (CommonSBaseViewingTab)pane.getComponent(CommonSBaseViewingTab.REACTIONS);
				PluginReaction sp = model.getReaction(tab.getViewTabel().getSelectedRow());
				for(int j = 0 ; j < tab.getViewTabel().getColumnCount() ; j++){
					String rowvalue = null;
					Boolean boo = null;
					try{
						rowvalue = (String) tab.getViewTabel().getModel().getValueAt(
								tab.getViewTabel().getSelectedRow(),j);
					}catch(Exception ex){
						boo = (Boolean) tab.getViewTabel().getModel().getValueAt(
								tab.getViewTabel().getSelectedRow(),j);
					}
						
					if(j == 0){
						sp.setReactionType(rowvalue);
					}
					else if(j == 1){
//							sp.set(rowvalue);
					}	
					else if(j == 2){
							sp.setName(rowvalue);
					}				
					else if(j == 3){
						sp.setReversible(boo.booleanValue());
					}		
					else if(j == 4){
						sp.setFast(boo.booleanValue());
					}	
					else if(j == 5){
//							sp(Double.parseDouble(rowvalue));
					}	
					else if(j == 6){
//							sp.setSubstanceUnits(rowvalue);
					}	
					else if(j == 7){
//							sp.setHasOnlySubstanceUnits(bo	o.booleanValue());
					}
					else if(j == 8){
						if(sp.getKineticLaw() != null){
							sp.getKineticLaw().setFormula(rowvalue);	
						}							
					}
					else if(j == 9){
						sp.setLineWidth(Double.parseDouble(rowvalue));
					}
					else if(j == 10){
						sp.setNotes(rowvalue);
					}
				}
				
				PluginSampleDialog.plug.notifySBaseChanged(sp);	
			}
			//KineticLaw
			else if(CommonSBaseViewingTab.KINETICLAWS == pane.getSelectedIndex()){
				CommonSBaseViewingTab tab = (CommonSBaseViewingTab)pane.getComponent(CommonSBaseViewingTab.KINETICLAWS);
				PluginReaction re = model.getReaction(tab.getViewTabel().getSelectedRow());
				PluginKineticLaw sp = re.getKineticLaw();
				for(int j = 0 ; j < tab.getViewTabel().getColumnCount() ; j++){
					String rowvalue = null;
					Boolean boo = null;
					try{
						rowvalue = (String) tab.getViewTabel().getModel().getValueAt(
								tab.getViewTabel().getSelectedRow(),j);
					}catch(Exception ex){
						boo = (Boolean) tab.getViewTabel().getModel().getValueAt(
								tab.getViewTabel().getSelectedRow(),j);
					}						
					
					if(j == 0){
						sp.setFormula(rowvalue);
					}
					else if(j == 1){
						sp.setSubstanceUnits(rowvalue);
					}
					else if(j == 2){
						sp.setTimeUnits(rowvalue);
					}
				}
				PluginSampleDialog.plug.notifySBaseChanged(sp);	
			}
			//Comaprtment
			else if(CommonSBaseViewingTab.COMPARTMENTS == pane.getSelectedIndex()){				
				CommonSBaseViewingTab tab = (CommonSBaseViewingTab)pane.getComponent(CommonSBaseViewingTab.COMPARTMENTS);
				PluginCompartment sp = model.getCompartment(tab.getViewTabel().getSelectedRow());
				for(int j = 0 ; j < tab.getViewTabel().getColumnCount() ; j++){
					String rowvalue = null;
					Boolean boo = null;
					try{
						rowvalue = (String) tab.getViewTabel().getModel().getValueAt(
								tab.getViewTabel().getSelectedRow(),j);
					}catch(Exception ex){
						boo = (Boolean) tab.getViewTabel().getModel().getValueAt(
								tab.getViewTabel().getSelectedRow(),j);
					}
						
					if(j == 0){
//						spsetReactionType(rowvalue);
					}
					else if(j == 1){
						sp.setName(rowvalue);
					}	
					else if(j == 2){
						sp.setSpatialDimensions(Long.parseLong(rowvalue));
					}				
					else if(j == 3){
						sp.setSize(Double.parseDouble(rowvalue));
					}		
					else if(j == 4){
						sp.setUnits(rowvalue);
					}	
					else if(j == 5){
						sp.setOutside(rowvalue);
					}	
					else if(j == 6){
						sp.setConstant(boo.booleanValue());
					}	
					else if(j == 7){
						sp.setX(Double.parseDouble(rowvalue));
					}
					else if(j == 8){
						sp.setY(Double.parseDouble(rowvalue));
					}
					else if(j == 9){
						sp.setWidth(Double.parseDouble(rowvalue));
					}
					else if(j == 10){
						sp.setHeight(Double.parseDouble(rowvalue));
					}
					else if(j == 11){
						sp.setNotes(rowvalue);
					}
				}
				
				sp.setLineColor(Color.BLACK);
System.out.println("sp.setLineColor(Color.BLACK);");				
				PluginSampleDialog.plug.notifySBaseChanged(sp);	
			}
			//local parameter
//			else if(8 == pane.getSelectedIndex()){				
//				CommonSBaseViewingTab tab = (CommonSBaseViewingTab)pane.getComponent(8);
//				PluginReaction re = model.getReaction(0);
//				PluginParameter sp = re.getKineticLaw().getParameter(tab.getViewTabel().getSelectedRow());
//				for(int j = 0 ; j < tab.getViewTabel().getColumnCount() ; j++){
//					String rowvalue = null;
//					Boolean boo = null;
//					try{
//						rowvalue = (String) tab.getViewTabel().getModel().getValueAt(
//								tab.getViewTabel().getSelectedRow(),j);
//					}catch(Exception ex){
//						boo = (Boolean) tab.getViewTabel().getModel().getValueAt(
//								tab.getViewTabel().getSelectedRow(),j);
//					}
//					
//					if(j == 0){
////						sp.setispsetReactionType(rowvalue);
//					}
//					else if(j == 1){
//						if(rowvalue != null){
//							sp.setName(rowvalue);	
//						}						
//					}	
//					else if(j == 2){
//						sp.setValue(Double.parseDouble(rowvalue));
//					}				
//					else if(j == 3){
//						sp.setUnits(rowvalue);
//					}		
//					else if(j == 4){
//						sp.setConstant(boo.booleanValue());
//					}	
//				}
////System.out.println("parent Reaction = " + sp.getParentReaction());				
//				
//				PluginSampleDialog.plug.notifySBaseChanged(sp);	
//			}
			//global parameter
			else if(CommonSBaseViewingTab.G_PARAMETERS == pane.getSelectedIndex()){								
				CommonSBaseViewingTab tab = (CommonSBaseViewingTab)pane.getComponent(CommonSBaseViewingTab.G_PARAMETERS);
				PluginParameter sp = model.getParameter(tab.getViewTabel().getSelectedRow());
				for(int j = 0 ; j < tab.getViewTabel().getColumnCount() ; j++){
					String rowvalue = null;
					Boolean boo = null;
					try{
						rowvalue = (String) tab.getViewTabel().getModel().getValueAt(
								tab.getViewTabel().getSelectedRow(),j);
					}catch(Exception ex){
						boo = (Boolean) tab.getViewTabel().getModel().getValueAt(
								tab.getViewTabel().getSelectedRow(),j);
					}
					
					if(j == 0){
//						sp.setispsetReactionType(rowvalue);
					}
					else if(j == 1){
						sp.setName(rowvalue);
					}	
					else if(j == 2){
						sp.setValue(Double.parseDouble(rowvalue));
					}				
					else if(j == 3){
						sp.setUnits(rowvalue);
					}		
					else if(j == 4){
						sp.setConstant(boo.booleanValue());
					}	
				}
//System.out.println("parent Reaction = " + sp.getParentReaction());				
				
				PluginSampleDialog.plug.notifySBaseChanged(sp);	
			}
			//FunctionDefinition
			else if(CommonSBaseViewingTab.FUNCTIONS == pane.getSelectedIndex()){								
				CommonSBaseViewingTab tab = (CommonSBaseViewingTab)pane.getComponent(CommonSBaseViewingTab.FUNCTIONS);
				PluginFunctionDefinition sp = model.getFunctionDefinition(tab.getViewTabel().getSelectedRow());
				for(int j = 0 ; j < tab.getViewTabel().getColumnCount() ; j++){
					String rowvalue = null;
					Boolean boo = null;
					try{
						rowvalue = (String) tab.getViewTabel().getModel().getValueAt(
								tab.getViewTabel().getSelectedRow(),j);
					}catch(Exception ex){
						boo = (Boolean) tab.getViewTabel().getModel().getValueAt(
								tab.getViewTabel().getSelectedRow(),j);
					}
					
//					colName[0] = "id";
//					colName[1] = "name";
//					colName[2] = "argument";
//					colName[3] = "math";
					
					if(j == 0){
//						sp.setsetispsetReactionType(rowvalue);
					}
					else if(j == 1){
						sp.setName(rowvalue);
					}	
					else if(j == 2){
//						sp.setsetValue(Double.parseDouble(rowvalue));
					}				
					else if(j == 3){
						sp.setMath(libsbml.parseFormula(rowvalue));
					}		
				}
//System.out.println("parent Reaction = " + sp.getParentReaction());				
				
				PluginSampleDialog.plug.notifySBaseChanged(sp);	
			}
			//UnitDefinition
			else if(CommonSBaseViewingTab.UNITDEFINITIONS == pane.getSelectedIndex()){								
				CommonSBaseViewingTab tab = (CommonSBaseViewingTab)pane.getComponent(CommonSBaseViewingTab.UNITDEFINITIONS);
				PluginUnitDefinition sp = model.getUnitDefinition(tab.getViewTabel().getSelectedRow());
				for(int j = 0 ; j < tab.getViewTabel().getColumnCount() ; j++){
					String rowvalue = null;
					Boolean boo = null;
					try{
						rowvalue = (String) tab.getViewTabel().getModel().getValueAt(
								tab.getViewTabel().getSelectedRow(),j);
					}catch(Exception ex){
						boo = (Boolean) tab.getViewTabel().getModel().getValueAt(
								tab.getViewTabel().getSelectedRow(),j);
					}
					
//					colName[0] = "id";
//					colName[1] = "name";
//					colName[2] = "units";
					
					if(j == 0){
//						sp.set.setsetispsetReactionType(rowvalue);
					}
					else if(j == 1){
						sp.setName(rowvalue);
					}	
					else if(j == 2){
//						sp.setListOfUnits(Double.parseDouble(rowvalue));
					}									
				}
//System.out.println("parent Reaction = " + sp.getParentReaction());				
				
				PluginSampleDialog.plug.notifySBaseChanged(sp);	
			}
//			//Unit
//			else if(11 == pane.getSelectedIndex()){								
//				CommonSBaseViewingTab tab = (CommonSBaseViewingTab)pane.getComponent(12);
//				PluginUnitDefinition def = model.getUnitDefinition(0);
//				PluginUnit sp = def.getUnit(tab.getViewTabel().getSelectedRow());
//				for(int j = 0 ; j < tab.getViewTabel().getColumnCount() ; j++){
//					String rowvalue = null;
//					Boolean boo = null;
//					try{
//						rowvalue = (String) tab.getViewTabel().getModel().getValueAt(
//								tab.getViewTabel().getSelectedRow(),j);
//					}catch(Exception ex){
//						boo = (Boolean) tab.getViewTabel().getModel().getValueAt(
//								tab.getViewTabel().getSelectedRow(),j);
//					}					
//					
//					if(j == 0){
////						sp.set.setsetispsetReactionType(rowvalue);
//					}
//					else if(j == 1){
//						sp.setExponent(Integer.parseInt(rowvalue));
//					}	
//					else if(j == 2){
//						sp.setKind(Integer.parseInt(rowvalue));
//					}
//					else if(j == 3){
//						sp.setScale(Integer.parseInt(rowvalue));
//					}
//					else if(j == 4){
//						sp.setMultiplier(Integer.parseInt(rowvalue));
//					}
//				}
////System.out.println("parent Reaction = " + sp.getParentReaction());				
//				
//				PluginSampleDialog.plug.notifySBaseChanged(sp);	
//			}
			//Rule
			else if(CommonSBaseViewingTab.RULES == pane.getSelectedIndex()){								
				CommonSBaseViewingTab tab = (CommonSBaseViewingTab)pane.getComponent(CommonSBaseViewingTab.RULES);
				PluginRule rule = model.getRule(tab.getViewTabel().getSelectedRow());
				for(int j = 0 ; j < tab.getViewTabel().getColumnCount() ; j++){
					String rowvalue = null;
					Boolean boo = null;
					try{
						rowvalue = (String) tab.getViewTabel().getModel().getValueAt(
								tab.getViewTabel().getSelectedRow(),j);
					}catch(Exception ex){
//						boo = (Boolean) tab.getViewTabel().getModel().getValueAt(
//								tab.getViewTabel().getSelectedRow(),j);
					}					
										
					if(j == 1){
						rule.setFormula(rowvalue);
					}
					else if(j == 2){
						if(rule instanceof PluginAssignmentRule){
							PluginAssignmentRule r = (PluginAssignmentRule)rule;							
							r.setVariable(rowvalue);
						}
						else if(rule instanceof PluginRateRule){
							PluginRateRule r = (PluginRateRule)rule;
							r.setVariable(rowvalue);
						}
					}
				}
//System.out.println("parent Reaction = " + sp.getParentReaction());				
				
				PluginSampleDialog.plug.notifySBaseChanged(rule);	
			}
			//Event
			else if(CommonSBaseViewingTab.EVENTS == pane.getSelectedIndex()){								
				CommonSBaseViewingTab tab = (CommonSBaseViewingTab)pane.getComponent(CommonSBaseViewingTab.EVENTS);
				PluginEvent sp = model.getEvent(tab.getViewTabel().getSelectedRow());
				for(int j = 0 ; j < tab.getViewTabel().getColumnCount() ; j++){
					String rowvalue = null;
					Boolean boo = null;
					try{
						rowvalue = (String) tab.getViewTabel().getModel().getValueAt(
								tab.getViewTabel().getSelectedRow(),j);
					}catch(Exception ex){
						boo = (Boolean) tab.getViewTabel().getModel().getValueAt(
								tab.getViewTabel().getSelectedRow(),j);
					}					
					
					if(j == 0){
//						sp.set(rowvalue);
					}
					else if(j == 1){
						sp.setName(rowvalue);
					}
					else if(j == 2){
						if(rowvalue != null && 
								!rowvalue.equals("")){
							sp.setTrigger(libsbml.parseFormula(rowvalue));	
						}
					}
					else if(j == 3){
						if(rowvalue != null && 
								!rowvalue.equals("")){
							sp.setDelay(libsbml.parseFormula(rowvalue));
						}
					}
					else if(j == 4){
						sp.setTimeUnits(rowvalue);
					}
				}
//System.out.println("parent Reaction = " + sp.getParentReaction());				
				
				PluginSampleDialog.plug.notifySBaseChanged(sp);	
			}
		}
	}
	
}
