package plugin.sample2.table;

import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;

import plugin.sample2.dialog.PluginSampleDialog;
import plugin.sample2.dialog.editdialog.PluginReactionDialog;

import jp.sbi.celldesigner.plugin.PluginListOf;
import jp.sbi.celldesigner.plugin.PluginModifierSpeciesReference;
import jp.sbi.celldesigner.plugin.PluginReaction;
import jp.sbi.celldesigner.plugin.PluginSpeciesAlias;
import jp.sbi.celldesigner.plugin.PluginSpeciesReference;

public class ReferenceViewingTable extends JTable{

	protected PluginReaction reaction;
	
	private String tabName;
	
	/** COL_NAMES*/
	protected Object[] COL_NAMES;
	
	/**
	 * makeColName
	 * @return Object[]
	 */
	protected Object[] makeColNameForSPRef() {
		Object[] colName = new Object[4];
		colName[0] = "species";
		colName[1] = "alias ID";
		colName[2] = "stoichiometry";
		colName[3] = "math";

		return colName;
	};
	
	/**
	 * makeColName
	 * @return Object[]
	 */
	protected Object[] makeColNameForMDRef() {
		Object[] colName = new Object[2];
		colName[0] = "species";
		colName[1] = "alias ID";


		return colName;
	};
	
	/**
	 *  Constructor
	 *  @param  parent
	 *  @param  data    
	 */
	public ReferenceViewingTable(Object[][] data , String tabName , PluginReaction reaction) {
		this.tabName = tabName;
		this.reaction = reaction;
		if(tabName.equals("listOfReactants") ||
				tabName.equals("listOfProducts")){
			COL_NAMES = makeColNameForSPRef();
		}
		else if(tabName.equals("listOfModifiers")){
			COL_NAMES = makeColNameForMDRef();
		}
		
		this.setModel(new RefViewingTableModel(data , COL_NAMES , tabName , this));
		
		this.TableInit();
	}

	/**
	 *  TableInit
	 */
	protected void TableInit() {
		setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
		setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		
		this.getTableHeader().setReorderingAllowed(false);
		this.getTableHeader().setResizingAllowed(true);
	}
}

/**
 * RefViewingTableModel
 * @author MKI
 */
class RefViewingTableModel extends AbstractTableModel{

	ReferenceViewingTable parent ;
	
	/** data */
	private Object[][] data;

	/** COL_NAMES */
	protected Object[] COL_NAMES;

	private String tabName;
	
	/**
	 * Constructor
	 * @param parent
	 * @param data
	 * @param names
	 */
	public RefViewingTableModel( Object[][] data, Object[] names , String tabName , ReferenceViewingTable parent) {
		super();
		this.parent = parent;
		this.COL_NAMES = names;
		this.data   = data;
		this.tabName = tabName;
		try {
		} catch(Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * delData
	 * @param jar
	 */
	public void delData(int selectedRow){
		Object[][] newData = new Object[data.length-1][4];
		int row = 0;
		for(int i = 0 ; i < data.length ; i++){
			if(i == selectedRow){
				continue;
			}
			for(int k = 0 ; k < data[i].length ; k++){
				newData[row][k] = data[i][k];
			}
			
			row++;
		}
		
		data = newData;			
		
		//�ύX�ʒm
        fireTableDataChanged();		
	}
	
	/**
	 * getColumnCount
	 * @return int
	 */
	public int getColumnCount() {
    	return COL_NAMES.length;
	}
        
    /**
     * getRowCount
     * @return int
     */
	public int getRowCount() {
		return data.length;
	}

    /**
     * getColumnName
     * @param  col
     * @return String
     */
	public String getColumnName(int col) {
		return (String)COL_NAMES[col];
	}

    /**
     * getValueAt
     * @param  row
     * @param  col
     * @return Object
     */
	public Object getValueAt(int row, int col) {
		return data[row][col];
	}

	/*
	 * JTable uses this method to determine the default renderer/
	 * editor for each cell.  If we didn't implement this method,
	 * then the last column would contain text ("true"/"false"),
	 * rather than a check box.
	 * @param c
	 */
	public Class getColumnClass(int c) {
//System.out.println("c = " + getValueAt(0, c).getClass());	
        if(getValueAt(0, c) != null){
        	return getValueAt(0, c).getClass();	
        }
		else if(c == 0){
			return new Boolean(false).getClass();
		}
		else{
			return new String().getClass();
		}
	}

	/*
	 * Don't need to implement this method unless your table's
	 * editable.
	 * @param row
	 * @param col
	 */
	public boolean isCellEditable(int row, int col) {
		if(col == 0){
			return false;
		}
		return true;
	}

	/*
	 * Don't need to implement this method unless your table's
	 * data can change.
	 * @param value
	 * @param row
	 * @param col
	 */
	public void setValueAt(Object value, int row, int col) {
		if (data[0][col] instanceof Integer                        
				&& !(value instanceof Integer)) {                  
			//With JFC/Swing 1.1 and JDK 1.2, we need to create    
			//an Integer from the value; otherwise, the column     
			//switches to contain Strings.  Starting with v 1.3,   
			//the table automatically converts value to an Integer,
			//so you only need the code in the 'else' part of this 
			//'if' block.                                          
			//See TableEditDemo.java for a better solution!!!
			try {
				data[row][col] = new Integer(value.toString());
				fireTableCellUpdated(row, col);				
				
			} catch (NumberFormatException e) {
                e.printStackTrace();
			}
		} else {
			data[row][col] = value;
			fireTableCellUpdated(row, col);
				
			//reactants	
			if(0 == PluginReactionDialog.jTabbedPane.getSelectedIndex()){
				
				PluginSpeciesReference sp = parent.reaction.getReactant(parent.getSelectedRow());
				for(int j = 0 ; j < parent.getModel().getColumnCount() ; j++){
					String rowvalue = null;
					Boolean boo = null;
					try{
						rowvalue = (String)parent.getModel().getValueAt(
								parent.getSelectedRow(),j);
					}catch(Exception ex){
						boo = (Boolean) parent.getModel().getValueAt(
								parent.getSelectedRow(),j);
					}
//	System.out.println("rowvalue = " + rowvalue);								
					
					//species
					if(j == 0){
//						sp.setSpecies(rowvalue);
					}
					//alias id
					else if(j == 1){
						PluginListOf listOfAlias = PluginSampleDialog.model.getListOfAllSpeciesAlias();
						boolean exist = false;
						for(int k = 0 ; k < listOfAlias.size() ; k++){
							PluginSpeciesAlias alias = (PluginSpeciesAlias) listOfAlias.get(k);
							if(rowvalue.equals(alias.getAliasID())){
								sp.setAlias(alias);
								data[row][0] = sp.getSpecies();
								fireTableCellUpdated(row, col);

								exist = true;
								break;
							}
						}
						if(!exist){
System.out.println("<Illegal ID>");
							data[row][col] = sp.getAlias().getAliasID();
							fireTableCellUpdated(row, col);
						}
					}
					else if(j == 2){
						sp.setStoichiometry(Double.parseDouble(rowvalue));
					}	
					else if(j == 3){
						if(rowvalue != null &&
								!rowvalue.equals("")){
							sp.setStoichiometryMath(rowvalue);	
						}						
					}				
				}
				
				PluginSampleDialog.plug.notifySBaseChanged(sp);	
			}
			else if(1 == PluginReactionDialog.jTabbedPane.getSelectedIndex()){
				
				PluginSpeciesReference sp = parent.reaction.getProduct(parent.getSelectedRow());
				for(int j = 0 ; j < parent.getModel().getColumnCount() ; j++){
					String rowvalue = null;
					Boolean boo = null;
					try{
						rowvalue = (String)parent.getModel().getValueAt(
								parent.getSelectedRow(),j);
					}catch(Exception ex){
						boo = (Boolean) parent.getModel().getValueAt(
								parent.getSelectedRow(),j);
					}
//	System.out.println("rowvalue = " + rowvalue);								
						
					//species
					if(j == 0){
//						sp.setSpecies(rowvalue);
					}
					//alias id
					else if(j == 1){
						PluginListOf listOfAlias = PluginSampleDialog.model.getListOfAllSpeciesAlias();
						boolean exist = false;
						for(int k = 0 ; k < listOfAlias.size() ; k++){
							PluginSpeciesAlias alias = (PluginSpeciesAlias) listOfAlias.get(k);
							if(rowvalue.equals(alias.getAliasID())){
								sp.setAlias(alias);
								data[row][0] = sp.getSpecies();
								fireTableCellUpdated(row, col);
								exist = true;
								break;
							}
						}
						if(!exist){
System.out.println("<Illegal ID>");
							data[row][col] = sp.getAlias().getAliasID();
							fireTableCellUpdated(row, col);
						}
					}
					else if(j == 2){
						sp.setStoichiometry(Double.parseDouble(rowvalue));
					}	
					else if(j == 3){
						if(rowvalue != null &&
								!rowvalue.equals("")){
							sp.setStoichiometryMath(rowvalue);	
						}	
					}				
				}
				
				PluginSampleDialog.plug.notifySBaseChanged(sp);	
			}
			else if(2 == PluginReactionDialog.jTabbedPane.getSelectedIndex()){
				
				PluginModifierSpeciesReference sp = parent.reaction.getModifier(parent.getSelectedRow());
				for(int j = 0 ; j < parent.getModel().getColumnCount() ; j++){
					String rowvalue = null;
					Boolean boo = null;
					try{
						rowvalue = (String)parent.getModel().getValueAt(
								parent.getSelectedRow(),j);
					}catch(Exception ex){
						boo = (Boolean) parent.getModel().getValueAt(
								parent.getSelectedRow(),j);
					}
//	System.out.println("rowvalue = " + rowvalue);								
						
					if(j == 0){
//						sp.setSpecies(rowvalue);
					}	
					else if(j == 1){
						PluginListOf listOfAlias = PluginSampleDialog.model.getListOfAllSpeciesAlias();
						boolean exist = false;
						for(int k = 0 ; k < listOfAlias.size() ; k++){
							PluginSpeciesAlias alias = (PluginSpeciesAlias) listOfAlias.get(k);
							if(rowvalue.equals(alias.getAliasID())){
								sp.setAlias(alias);
								data[row][0] = sp.getSpecies();
								fireTableCellUpdated(row, col);

								exist = true;
								break;
							}
						}
						if(!exist){
System.out.println("<Illegal ID>");
							data[row][col] = sp.getAlias().getAliasID();
							fireTableCellUpdated(row, col);
						}
					}		
				}
				
				PluginSampleDialog.plug.notifySBaseChanged(sp);	
			}
		}
	}
	
}

