package plugin.sample2.table;

import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;

import plugin.sample2.dialog.PluginSampleDialog;
import plugin.sample2.dialog.editdialog.PluginProteinDialog;

import jp.sbi.celldesigner.plugin.PluginModificationResidue;

public class ProteinViewingTable extends JTable{

	protected PluginProteinDialog law;
	
	/** COL_NAMES*/
	protected Object[] COL_NAMES;
	
	/**
	 * makeColName
	 * @return Object[]
	 */
	protected Object[] makeColNameForParameter() {
		Object[] colName = new Object[4];
		colName[0] = "id";
		colName[1] = "name";
		colName[2] = "side";
		colName[3] = "angle";

		return colName;
	};
	
	/**
	 *  Constructor
	 *  @param  parent
	 *  @param  data    
	 */
	public ProteinViewingTable(Object[][] data , PluginProteinDialog law) {
		this.law = law;
		COL_NAMES = makeColNameForParameter();
		
		this.setModel(new ProteinViewingTableModel(data , COL_NAMES ,this));
		
		this.TableInit();
	}

	/**
	 *  TableInit
	 */
	protected void TableInit() {
		setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
		setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		
		this.getTableHeader().setReorderingAllowed(false);
		this.getTableHeader().setResizingAllowed(true);
	}
}

/**
 * ProteinViewingTableModel
 * @author MKI
 */
class ProteinViewingTableModel extends AbstractTableModel{

	/** data */
	private Object[][] data;

	/** COL_NAMES */
	protected Object[] COL_NAMES;

	ProteinViewingTable parent;
	
	/**
	 * Constructor
	 * @param parent
	 * @param data
	 * @param names
	 */
	public ProteinViewingTableModel( Object[][] data, Object[] names , ProteinViewingTable parent) {
		super();
		this.COL_NAMES = names;
		this.data   = data;
		this.parent = parent;
		try {
		} catch(Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * delData
	 * @param jar
	 */
	public void delData(int selectedRow){
		Object[][] newData = new Object[data.length-1][4];
		int row = 0;
		for(int i = 0 ; i < data.length ; i++){
			if(i == selectedRow){
				continue;
			}
			for(int k = 0 ; k < data[i].length ; k++){
				newData[row][k] = data[i][k];
			}
			
			row++;
		}
		
		data = newData;			
		
		//�ύX�ʒm
        fireTableDataChanged();		
	}
	
	/**
	 * getColumnCount
	 * @return int
	 */
	public int getColumnCount() {
    	return COL_NAMES.length;
	}
        
    /**
     * getRowCount
     * @return int
     */
	public int getRowCount() {
		return data.length;
	}

    /**
     * getColumnName
     * @param  col
     * @return String
     */
	public String getColumnName(int col) {
		return (String)COL_NAMES[col];
	}

    /**
     * getValueAt
     * @param  row
     * @param  col
     * @return Object
     */
	public Object getValueAt(int row, int col) {
		return data[row][col];
	}

	/*
	 * JTable uses this method to determine the default renderer/
	 * editor for each cell.  If we didn't implement this method,
	 * then the last column would contain text ("true"/"false"),
	 * rather than a check box.
	 * @param c
	 */
	public Class getColumnClass(int c) {
//System.out.println("c = " + getValueAt(0, c).getClass());	
        if(getValueAt(0, c) != null){
        	return getValueAt(0, c).getClass();	
        }
		else if(c == 0){
			return new Boolean(false).getClass();
		}
		else{
			return new String().getClass();
		}
	}

	/*
	 * Don't need to implement this method unless your table's
	 * editable.
	 * @param row
	 * @param col
	 */
	public boolean isCellEditable(int row, int col) {
		if(col == 0){
			return false;
		}
		return true;
	}

	/*
	 * Don't need to implement this method unless your table's
	 * data can change.
	 * @param value
	 * @param row
	 * @param col
	 */
	public void setValueAt(Object value, int row, int col) {
		if (data[0][col] instanceof Integer                        
				&& !(value instanceof Integer)) {                  
			//With JFC/Swing 1.1 and JDK 1.2, we need to create    
			//an Integer from the value; otherwise, the column     
			//switches to contain Strings.  Starting with v 1.3,   
			//the table automatically converts value to an Integer,
			//so you only need the code in the 'else' part of this 
			//'if' block.                                          
			//See TableEditDemo.java for a better solution!!!
			try {
				data[row][col] = new Integer(value.toString());
				fireTableCellUpdated(row, col);				
				
			} catch (NumberFormatException e) {
                e.printStackTrace();
			}
		} else {
			data[row][col] = value;
			fireTableCellUpdated(row, col);
			
			//���ݑI�Ⳃ�Ă���tab�ȊO��main�̑I����
			//reactants	
			PluginModificationResidue sp = parent.law.protein.getPluginModificationResidue(parent.getSelectedRow());
				
			for(int j = 0 ; j < parent.getModel().getColumnCount() ; j++){
				String rowvalue = null;
				Boolean boo = null;
				try{
					rowvalue = (String) parent.getModel().getValueAt(
							parent.getSelectedRow(),j);
				}catch(Exception ex){
					boo = (Boolean) parent.getModel().getValueAt(
							parent.getSelectedRow(),j);
				}
//	System.out.println("rowvalue = " + rowvalue);								
					
				if(j == 0){
//						sp.set(rowvalue);
				}
				else if(j == 1){
					sp.setName(rowvalue);
				}	
				else if(j == 2){
			    	sp.setSide(rowvalue);
				}				
				else if(j == 3){
					sp.setAngle(Double.parseDouble(rowvalue));
				}		
			}
			
			PluginSampleDialog.plug.notifySBaseChanged(sp);	
		}
	}
	
}

