package plugin.sample2.dialog.editdialog;

import java.awt.BorderLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

import plugin.sample2.dialog.PluginSampleDialog;
import plugin.sample2.table.UnitViewingTable;

import jp.sbi.celldesigner.plugin.PluginUnit;
import jp.sbi.celldesigner.plugin.PluginUnitDefinition;

public class PluginUnitDialog extends PluginSBaseDialog{

	
	
	public PluginUnitDialog(PluginUnitDefinition sbase){
		super();
		editingSBase = sbase;
		init();
		this.setResizable(true);
		this.setSize(500,500);
		this.setVisible(true);
	}
	
	private JButton buttonAdd;
	private JButton buttonRemove;
	JScrollPane jTabbedPane;
	
	protected JPanel createDialogPanel() {
		
		
		mainPanel = new JPanel();
		
		buttonAdd = new JButton("ADD");
		buttonAdd.setBounds(new Rectangle(280, 82, 80, 20));
		buttonAdd.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				PluginUnitDefinition re = (PluginUnitDefinition)editingSBase;
				PluginUnit ref = new PluginUnit(re);
				re.addUnit(ref);
System.out.println("add UNIT");
				updatePanel();
				jTabbedPane.updateUI();
				
				PluginSampleDialog.plug.notifySBaseAdded(ref);	
			}			
		});
		mainPanel.add(buttonAdd, null);
		
		buttonRemove = new JButton("REMOVE");
		buttonRemove.setBounds(new Rectangle(360, 82, 80, 20));		
		buttonRemove.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				PluginUnitDefinition re = (PluginUnitDefinition)editingSBase;
				JTable table = (JTable) jTabbedPane.getViewport().getComponent(0);
							
				PluginUnit ref = re.getUnit(table.getSelectedRow());
				re.removeUnit(table.getSelectedRow());
					
				updatePanel();
				jTabbedPane.updateUI();
				
				PluginSampleDialog.plug.notifySBaseDeleted(ref);	
			}			
		});
		mainPanel.add(buttonRemove, null);
		
		//中央にテーブルを置くだけ
		return mainPanel;
	}
	
	private void init(){
		jTabbedPane = new JScrollPane();
		
		jTabbedPane.getViewport().add(new UnitViewingTable(formatForTableData(),"",(PluginUnitDefinition) editingSBase));
		
		mainPanel.add(jTabbedPane,BorderLayout.CENTER);
		
	}
	
    private void updatePanel(){
    	mainPanel.remove(jTabbedPane);
    	
    	init();    	
    	mainPanel.updateUI();
    }

	/**
	 * listOfJars��e�[�u���Z�b�g�p�Ƀt�H�[�}�b�g����
	 * @return Object[][]
	 */
	protected Object[][] formatForTableData() {
		ArrayList newData = new ArrayList();
        
		PluginUnitDefinition def = (PluginUnitDefinition)editingSBase;
		
		for( int i = 0;  i < def.getNumUnits(); i++) {
			ArrayList rowData = new ArrayList();
			
			PluginUnit species = (PluginUnit) def.getUnit(i);
				
			rowData.add(String.valueOf(species.getKind()));
			rowData.add(String.valueOf(species.getExponent()));
			rowData.add(String.valueOf(species.getScale()));
			rowData.add(String.valueOf(species.getMultiplier()));
			rowData.add(String.valueOf(species.getOffset()));
				
			newData.add(rowData);
		}

		// It changes from Vector. 
		Object[][] arrayData = new Object[newData.size()][1];
		for(int i = 0; i < newData.size() ; i++) {
			ArrayList data = (ArrayList)newData.get(i);
			arrayData[i] = data.toArray();
		}

		return arrayData;
	}
	
	protected void updateObject() {
		// TODO 自動生成されたメソッド・スタブ
		
	}

}
