package plugin.sample2.dialog.editdialog;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import jp.sbi.celldesigner.plugin.PluginUnitDefinition;


public class PluginUnitDefinitionDialog extends PluginSBaseDialog{

	//ユーザ入力用のGUIコンポーネント
	/**@serial*/ private JTextField idTextField;
	/**@serial*/ private JTextField nameTextField;
	/**@serial*/ private JButton unitListDlgButton;
	
	/**<pre>
	 * オーナーなしのダイアログを生成する。
	 * </pre>
	 */
	//---------------------------------------------------------
	public PluginUnitDefinitionDialog(PluginUnitDefinition unit , boolean mode) {
		super();
		super.editingSBase = unit;
		addmode = mode;
		setDialogFromObject(unit);
//		initListDialogs();
//		if ( useKeyListenerToTextFields ) {
//		    addListenerToTextFields();
//		}
//		initIsFirstShowing();
		this.setVisible(true);
	}
	
	//---------------------------------------------------------
	/**<pre>
	 * SBaseDialogの実装で、
	 * 各サブクラスで任意のパネルを実装する。
	 * 作成したパネルはgetContentPane().add()しないこと。
	 * </pre>
	 * @return GUIの構築が終わったパネル
	 */
	//---------------------------------------------------------
	protected JPanel createDialogPanel(){

	    //final JRootPane rootPane = getRootPane();

		mainPanel = new JPanel();
		mainPanel.setLayout(null);

		//idフィールド
		JLabel idLabel = new JLabel("id");
		idLabel.setBounds(new Rectangle(10, 10, 60, 20));
		mainPanel.add(idLabel, null);

		idTextField = new JTextField();
		idTextField.setBounds(new Rectangle(55, 10, 200, 20));
		idTextField.setEditable(true);
		mainPanel.add(idTextField, null);

		//nameフィールド
		JLabel nameLabel = new JLabel("name");
		nameLabel.setBounds(new Rectangle(10, 34, 60, 20));
		mainPanel.add(nameLabel, null);

		nameTextField = new JTextField();
		nameTextField.setBounds(new Rectangle(55, 34, 200, 20));
		nameTextField.setEditable(true);
		mainPanel.add(nameTextField, null);

		//listOfUnitsフィールド
		JLabel listOfUnitsLabel = new JLabel("listOfUnits");
		listOfUnitsLabel.setBounds(new Rectangle(10, 70, 160, 20));
		mainPanel.add(listOfUnitsLabel, null);

		unitListDlgButton = new JButton("Show list..");
		unitListDlgButton.setBounds(new Rectangle(155, 70, 100, 20));
		unitListDlgButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				listDlgButton_actionPerformed();
			}
		});
		mainPanel.add(unitListDlgButton, null);

		//OKボタン、Cancelボタン
		LABEL_WIDTH = 40;
		TEXT_WIDTH = 200;
		setLayoutConstants();
		BUTTON_POSITION_Y = 10 + 4 * BASELINE_SKIP;
		setDefaultButtonsLayout();
		addDefaultButtonsToPanel();

		return mainPanel;
	}

	private void listDlgButton_actionPerformed(){
		PluginUnitDialog unitDialog = new PluginUnitDialog((PluginUnitDefinition) editingSBase);
	}
	
	//---------------------------------------------------------
	/**<pre>
	 * SBaseDialogの実装で、
	 * 引数であたえられたオブジェクトの情報をダイアログ内にセットする。
	 * 引数はダイアログにあわせてダウンキャストして使用する。
	 * </pre>
	 * @param sbase 対象のsbase
	 */
	//---------------------------------------------------------
	protected void setDialogFromObject(PluginUnitDefinition unitDefinition){

		//idフィールド
		String id = unitDefinition.getId();
		idTextField.setText(id);
		idTextField.setCaretPosition(id.length());

		//nameフィールド
		String name = unitDefinition.getName();
		nameTextField.setText(name);
		nameTextField.setCaretPosition(name.length());

		//このモデルダイアログではidとnameしか編集対象としない。
		//残りの<listOf*>については個別のリストダイアログにまかせる。
	}
	
	protected void updateObject() {
		// TODO 自動生成されたメソッド・スタブ
		PluginUnitDefinition unitDefinition = (PluginUnitDefinition)editingSBase;
		
		unitDefinition.setName(nameTextField.getText());
	}

}
