package plugin.sample2.dialog.editdialog;

import java.awt.Rectangle;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import org.sbml.libsbml.libsbml;

import jp.sbi.celldesigner.plugin.PluginModifierSpeciesReference;
import jp.sbi.celldesigner.plugin.PluginSBase;
import jp.sbi.celldesigner.plugin.PluginSpeciesReference;
import jp.sbi.sbml.util.MathEditPanel;

public class PluginSpeciesReferenceDialog extends PluginSBaseDialog{

	/**@serial*/	private JTextField speciesTextField;
	/**@serial*/	private JTextField aliasTextField;
	/**@serial*/	private JTextField stoichiometryTextField;
//	/**@serial*/	private JTextField denominatorTextField;

    private JTextField mathTextField;
    private MathEditPanel mathPanel;
    
//add MKI
    private String type;
	
    /**
     * 
     * @param ref
     */
    public PluginSpeciesReferenceDialog(PluginSpeciesReference ref){
    	super();
    	super.editingSBase = ref;
    	setDialogFromObject(ref);
    	this.setVisible(true);
    }
    
    /**
     * 
     * @param ref
     */
    public PluginSpeciesReferenceDialog(PluginModifierSpeciesReference ref){
    	super();
    	super.editingSBase = ref;
    	setDialogFromObject(ref);
    	this.setVisible(true);
    }
    
	////////////////////////////////////////////////////////////////////////////////////
	//SBaseDialogダイアログの実装

	//---------------------------------------------------------
	/**<pre>
	 * SBaseDialogの実装。
	 * 各サブクラスで任意のパネルを実装する。
	 * 作成したパネルはgetContentPane().add()しないこと。
	 * </pre>
	 * @return GUIの構築が終わったパネル
	 */	
	//---------------------------------------------------------
	protected JPanel createDialogPanel(){

	    //rootPane = getRootPane();
        //Layout
        LABEL_WIDTH = 90;
        TEXT_WIDTH = 300;
        setLayoutConstants();

        //mainPanel
		mainPanel = new JPanel();
		mainPanel.setLayout(null);

		//species
        int yline = VERTICAL_MARGIN;
		JLabel speciesLabel = new JLabel("species ID");
		speciesLabel.setBounds(new Rectangle(HORIZONTAL_MARGIN, yline, LABEL_WIDTH, LINE_HEIGHT));
		mainPanel.add(speciesLabel, null);
		
		speciesTextField = new JTextField();
		speciesTextField.setBounds(new Rectangle(TEXT_POSITION_X, yline, TEXT_WIDTH, LINE_HEIGHT));
		speciesTextField.setEditable(true);
		mainPanel.add(speciesTextField, null);

        
		//alias
        yline += BASELINE_SKIP;
		JLabel aliasLabel = new JLabel("speciesAlias ID");
		aliasLabel.setBounds(new Rectangle(HORIZONTAL_MARGIN, yline, LABEL_WIDTH, LINE_HEIGHT));
		mainPanel.add(aliasLabel, null);
		
		aliasTextField = new JTextField();
		aliasTextField.setBounds(new Rectangle(TEXT_POSITION_X, yline, TEXT_WIDTH, LINE_HEIGHT));
		aliasTextField.setEditable(true);
		mainPanel.add(aliasTextField, null);

        yline += BASELINE_SKIP;
		//stoichiometry (double: Level 2)
		JLabel stoichiometryLabel = new JLabel("stoichiometry");
		stoichiometryLabel.setBounds(new Rectangle(HORIZONTAL_MARGIN, yline, LABEL_WIDTH, LINE_HEIGHT));
		mainPanel.add(stoichiometryLabel, null);
		
		stoichiometryTextField = new JTextField();
		stoichiometryTextField.setBounds(new Rectangle(TEXT_POSITION_X, yline, TEXT_WIDTH, LINE_HEIGHT));
		stoichiometryTextField.setEditable(true);
		mainPanel.add(stoichiometryTextField, null);

        yline += BASELINE_SKIP;
        //stoichiometry math
        JLabel stoichiometryMathLabel = new JLabel("stoichiometryMath");
        stoichiometryMathLabel.setBounds(new Rectangle(HORIZONTAL_MARGIN, yline, LABEL_WIDTH, LINE_HEIGHT));
        mainPanel.add(stoichiometryMathLabel, null);
        
        mathPanel = new MathEditPanel();
        int mpheight = mathPanel.createUI(TEXT_WIDTH, LINE_HEIGHT, BASELINE_SKIP);
        mathPanel.setBounds(new Rectangle(TEXT_POSITION_X, yline, TEXT_WIDTH, mpheight));
        mathTextField = mathPanel.getTextField();
        mathTextField.setEditable(true);
        mainPanel.add(mathPanel, null);

        yline += mpheight + BASELINE_SKIP - LINE_HEIGHT;
		//OK button, Cancel button
		BUTTON_POSITION_Y = yline;
		setDefaultButtonsLayout();
        
		addDefaultButtonsToPanel();

		return mainPanel;
	}

	//---------------------------------------------------------
	/**<pre>
	 * SBaseDialogの実装で、
	 * 引数であたえられたオブジェクトの情報をダイアログ内にセットする。
	 * 引数はダイアログにあわせてダウンキャストして使用する。
	 * </pre>
	 * @param sbase 対象のsbase
	 */	
	//---------------------------------------------------------
	protected void setDialogFromObject(PluginSBase sbase){
		
		if(sbase==null){
			return;
		}

		if(sbase instanceof PluginSpeciesReference){
			PluginSpeciesReference speciesReference = (PluginSpeciesReference)sbase;

			//species
//			String species = speciesReference.getId();
	        String species = speciesReference.getSpecies();
			speciesTextField.setText(species);

			aliasTextField.setText(speciesReference.getAlias().getAliasID());
			aliasTextField.setCaretPosition(speciesReference.getAlias().getAliasID().length());

	        // Use either stoichiometry or stoichiometryMath
	        //stoichiometry
//	System.out.println("+SpeciesReferenceDialog@253:speciesReference.getStoichiometryMathString()");        
//	        String mathString = speciesReference.getStoichiometryMathString();

	        String mathString = "";
	        if(speciesReference.getStoichiometryMath() != null){
	            mathString = libsbml.formulaToString(speciesReference.getStoichiometryMath().getMath());    
	        }        
	        if ( mathString.equals("") ){
	            double stoichiometry = speciesReference.getStoichiometry();
	            String s1 = Double.toString(stoichiometry);
	            stoichiometryTextField.setText(s1);
	            stoichiometryTextField.setCaretPosition(s1.length());
	            
	        } else {
	            stoichiometryTextField.setText("");
	        }

	        //stoichiometryMath
	        mathTextField.setText(mathString);
	        mathTextField.setCaretPosition(mathString.length());
		}
		else{
			PluginModifierSpeciesReference speciesReference = (PluginModifierSpeciesReference)sbase;

			//species
//			String species = speciesReference.getId();
	        String species = speciesReference.getSpecies();
			speciesTextField.setText(species);

			aliasTextField.setText(speciesReference.getAlias().getAliasID());
			aliasTextField.setCaretPosition(species.length());

			stoichiometryTextField.setEditable(false);
	        mathTextField.setEditable(false);

		}
	}
	
	/**
	 * 
	 *
	 */
	protected void updateObject(){
		PluginSpeciesReference ref = (PluginSpeciesReference)editingSBase;
		
//		ref.setSpecies(aliasTextField.getText());
		
		
        String mathString = "";
        if ( mathString.equals("") ){
            double stoichiometry = Double.parseDouble(stoichiometryTextField.getText());
            String s1 = Double.toString(stoichiometry);
            if(s1 != null && !s1.equals("")){
            	ref.setStoichiometry(Double.valueOf(s1).doubleValue());    	
            }
        }        
			
		ref.setStoichiometryMath(mathTextField.getText());	
	}
}
