package plugin.sample2.dialog.editdialog;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

import plugin.sample2.dialog.PluginSampleDialog;


//import jp.sbi.celldesigner.plugin.PluginAntiSenseRNA;
//import jp.sbi.celldesigner.plugin.PluginGene;
//import jp.sbi.celldesigner.plugin.PluginProtein;
//import jp.sbi.celldesigner.plugin.PluginRNA;
import jp.sbi.celldesigner.plugin.PluginAntiSenseRNA;
import jp.sbi.celldesigner.plugin.PluginGene;
import jp.sbi.celldesigner.plugin.PluginModification;
import jp.sbi.celldesigner.plugin.PluginProtein;
import jp.sbi.celldesigner.plugin.PluginRNA;
import jp.sbi.celldesigner.plugin.PluginSpeciesAlias;
import jp.sbi.celldesigner.plugin.util.PluginSpeciesSymbolType;

public class PluginSpeciesNodeDialog extends JDialog{

	PluginSpeciesAlias alias;
	
	JButton buttonOK;
	JButton buttonClose;
	
	JLabel labelSpeciesId;
	JLabel labelExtensionType;
	JLabel labelExtensionID;
	JLabel labelName;
	JLabel labelHomodimer;
	JLabel labelHypothetical;
	JLabel labelX;
	JLabel labelY;
	JLabel labelWidth;
	JLabel labelHeight;
	JLabel labelColor;
	JLabel labelLineWidth;
//	JLabel labelNotes;
	
	String[] typeData = {PluginSpeciesSymbolType.PROTEIN, 
			PluginSpeciesSymbolType.GENE, PluginSpeciesSymbolType.RNA, PluginSpeciesSymbolType.ANTISENSE_RNA, 
			PluginSpeciesSymbolType.ION, PluginSpeciesSymbolType.SIMPLE_MOLECULE , PluginSpeciesSymbolType.PHENOTYPE,
			PluginSpeciesSymbolType.UNKNOWN , PluginSpeciesSymbolType.COMPLEX , PluginSpeciesSymbolType.DEGRADED};
	
	private String[] getProteinData(){
//System.out.println("PluginSampleDialog.model.getListOfProteins().size() = " + PluginSampleDialog.model.getListOfProteins().size());		
		String[] data = new String[PluginSampleDialog.model.getListOfProteins().size()];
        for(int i = 0 ; i < PluginSampleDialog.model.getListOfProteins().size() ; i++){
        	PluginProtein p = (PluginProtein) PluginSampleDialog.model.getListOfProteins().get(i);
//System.out.println("p.getExtensionId() = " + p.getExtensionId());        	
        	data[i] = p.getExtensionId();
        }
        
        return data;
	}
	
	private String[] getGeneData(){
		String[] data = new String[PluginSampleDialog.model.getListOfGenes().size()];
        for(int i = 0 ; i < PluginSampleDialog.model.getListOfGenes().size() ; i++){
        	PluginGene p = (PluginGene) PluginSampleDialog.model.getListOfGenes().get(i);
        	data[i] = p.getExtensionId();
        }
        
        return data;
	}
	
	private String[] getRNAData(){
		String[] data = new String[PluginSampleDialog.model.getListOfRNAs().size()];
        for(int i = 0 ; i < PluginSampleDialog.model.getListOfRNAs().size() ; i++){
        	PluginRNA p = (PluginRNA) PluginSampleDialog.model.getListOfRNAs().get(i);
        	data[i] = p.getExtensionId();
        }
        
        return data;
	}
	
	private String[] getasRNAData(){
		String[] data = new String[PluginSampleDialog.model.getListOfAntiSenseRNAs().size()];
        for(int i = 0 ; i < PluginSampleDialog.model.getListOfAntiSenseRNAs().size() ; i++){
        	PluginAntiSenseRNA p = (PluginAntiSenseRNA) PluginSampleDialog.model.getListOfAntiSenseRNAs().get(i);
        	data[i] = p.getExtensionId();
        }
        
        return data;
	}
	
	JTextField textSpeciesId;
	JComboBox  comboExtensionType = new JComboBox(typeData);
	JComboBox  comboExtensionID = new JComboBox();
	JTextField textName;
	JTextField textHomodimer;
	JCheckBox  checkHypothetical;
	JTextField textX;
	JTextField textY;
	JTextField textWidth;
	JTextField textHeight;
	JTextField textColor;
	JTextField textLineWidth;
//	JTextField textNotes;
	
	
	
	public PluginSpeciesNodeDialog(PluginSpeciesAlias alias){
		this.alias = alias;
		init();
		setDataDialog();
	}
	
	private void init(){
		this.setSize(400,400);
		
		getContentPane().setLayout(new GridLayout(14,2,1,1));
				
		labelSpeciesId = new JLabel("   Species ID");
		getContentPane().add(labelSpeciesId);
		
		textSpeciesId = new JTextField();
		getContentPane().add(textSpeciesId);
		textSpeciesId.setEditable(false);
		
		labelExtensionType = new JLabel("   Species Type");
		getContentPane().add(labelExtensionType);
		
		getContentPane().add(comboExtensionType);
		comboExtensionType.addActionListener(new ActionListener(){

			public void actionPerformed(ActionEvent e) {
				if(comboExtensionType == null ||
						comboExtensionType.getSelectedItem() == null){
					return;
				}
				comboExtensionID.removeAllItems();
				if(((String)comboExtensionType.getSelectedItem()).equals(PluginSpeciesSymbolType.PROTEIN)){
					String[] item = getProteinData();
					for(int i = 0 ; i < item.length ; i++){
						comboExtensionID.addItem(item[i]);	
					}
					
					comboExtensionID.updateUI();
				}
				else if(((String)comboExtensionType.getSelectedItem()).equals(PluginSpeciesSymbolType.GENE)){
					String[] item = getGeneData();
					for(int i = 0 ; i < item.length ; i++){
						comboExtensionID.addItem(item[i]);	
					}			
					comboExtensionID.updateUI();
				}
				else if(((String)comboExtensionType.getSelectedItem()).equals(PluginSpeciesSymbolType.RNA)){
					String[] item = getRNAData();
					for(int i = 0 ; i < item.length ; i++){
						comboExtensionID.addItem(item[i]);	
					}			
					comboExtensionID.updateUI();
				}		
				else if(((String)comboExtensionType.getSelectedItem()).equals(PluginSpeciesSymbolType.ANTISENSE_RNA)){
					String[] item = getasRNAData();
					for(int i = 0 ; i < item.length ; i++){
						comboExtensionID.addItem(item[i]);	
					}			
					comboExtensionID.updateUI();
				}				
			}
			
		});
		
		labelName = new JLabel("   name");
		getContentPane().add(labelName);
		
		textName = new JTextField();
		getContentPane().add(textName);
		
		labelExtensionID = new JLabel("   extension ID");
		getContentPane().add(labelExtensionID);
				
		getContentPane().add(comboExtensionID);		
		comboExtensionID.addActionListener(new ActionListener(){

			public void actionPerformed(ActionEvent e) {
				if(((String)comboExtensionType.getSelectedItem()).equals(PluginSpeciesSymbolType.PROTEIN)){
					String id = (String)comboExtensionID.getSelectedItem();
					PluginProtein p = PluginSampleDialog.model.getProtein(id);
					if(p != null){
						textName.setText(p.getName());
						textName.setEditable(false);
					}
					else{
						System.out.println("<Illegal protein ID.> = " + id);
					}
				}
				else if(((String)comboExtensionType.getSelectedItem()).equals(PluginSpeciesSymbolType.GENE)){
					String id = (String)comboExtensionID.getSelectedItem();
					PluginGene p = PluginSampleDialog.model.getGene(id);
					if(p != null){
						textName.setText(p.getName());
						textName.setEditable(false);
					}
					else{
						System.out.println("<Illegal gene ID.> = " + id);
					}
				}
				else if(((String)comboExtensionType.getSelectedItem()).equals(PluginSpeciesSymbolType.RNA)){
					String id = (String)comboExtensionID.getSelectedItem();
					PluginRNA p = PluginSampleDialog.model.getRNA(id);
					if(p != null){
						textName.setText(p.getName());
						textName.setEditable(false);
					}
					else{
						System.out.println("<Illegal rna ID.> = " + id);
					}
				}		
				else if(((String)comboExtensionType.getSelectedItem()).equals(PluginSpeciesSymbolType.ANTISENSE_RNA)){
					String id = (String)comboExtensionID.getSelectedItem();
					PluginAntiSenseRNA p = PluginSampleDialog.model.getAntiSenseRNA(id);
					if(p != null){
						textName.setText(p.getName());
						textName.setEditable(false);
					}
					else{
						System.out.println("<Illegal asrna ID.> = " + id);
					}
				}				
				else{
					textName.setEditable(true);
				}
			}
			
		});
				
		labelHomodimer = new JLabel("   Homodimer");
		getContentPane().add(labelHomodimer);
		
		textHomodimer = new JTextField();
		getContentPane().add(textHomodimer);
		
		labelHypothetical = new JLabel("   Hypothetical");
		getContentPane().add(labelHypothetical);
		
		checkHypothetical = new JCheckBox();
		getContentPane().add(checkHypothetical);
		
		labelX = new JLabel("   x");
		getContentPane().add(labelX);
		
		textX = new JTextField();
		getContentPane().add(textX);
		
		labelY = new JLabel("   y");
		getContentPane().add(labelY);
		
		textY = new JTextField();
		getContentPane().add(textY);
		
		labelWidth = new JLabel("   width");
		getContentPane().add(labelWidth);
		
		textWidth = new JTextField();
		getContentPane().add(textWidth);

		labelHeight = new JLabel("   height");
		getContentPane().add(labelHeight);
		
		textHeight = new JTextField();
		getContentPane().add(textHeight);
		
		labelColor = new JLabel("   Color");
		getContentPane().add(labelColor);
		
		textColor = new JTextField();
		getContentPane().add(textColor);
		
		labelLineWidth = new JLabel("   LineWidth");
		getContentPane().add(labelLineWidth);
		
		textLineWidth = new JTextField();
		getContentPane().add(textLineWidth);
		
		buttonOK = new JButton("Update");
		buttonOK.addActionListener(new ActionListener(){

			public void actionPerformed(ActionEvent e) {
				setAliasData();
				PluginSampleDialog.plug.notifySBaseChanged(alias);				
			}
			
		});
		getContentPane().add(buttonOK);
		
		buttonClose = new JButton("Close");
		buttonClose.addActionListener(new ActionListener(){

			public void actionPerformed(ActionEvent e) {
				setVisible(false);				
				dispose();
			}
			
		});
		getContentPane().add(buttonClose);
		
		setVisible(true);
	}
	
	private void setDataDialog(){
		textSpeciesId.setText(alias.getSpecies().getId());
		textName.setText(alias.getName());
		comboExtensionType.setSelectedItem(alias.getType());
//		comboExtensionID.setSelectedItem(alias.getExtensionId());
		comboExtensionID.removeAllItems();
		
		if(comboExtensionType == null ||
				comboExtensionType.getSelectedItem() == null){
			
		}
		else{
			if(((String)comboExtensionType.getSelectedItem()).equals(PluginSpeciesSymbolType.PROTEIN)){
				String[] item = getProteinData();
				for(int i = 0 ; i < item.length ; i++){
					comboExtensionID.addItem(item[i]);	
				}
				
				comboExtensionID.setSelectedItem(alias.getExtensionId());
				comboExtensionID.updateUI();
			}
			else if(((String)comboExtensionType.getSelectedItem()).equals(PluginSpeciesSymbolType.GENE)){
				String[] item = getGeneData();
				for(int i = 0 ; i < item.length ; i++){
					comboExtensionID.addItem(item[i]);	
				}			
				comboExtensionID.setSelectedItem(alias.getExtensionId());
				comboExtensionID.updateUI();
			}
			else if(((String)comboExtensionType.getSelectedItem()).equals(PluginSpeciesSymbolType.RNA)){
				String[] item = getRNAData();
				for(int i = 0 ; i < item.length ; i++){
					comboExtensionID.addItem(item[i]);	
				}			
				comboExtensionID.setSelectedItem(alias.getExtensionId());
				comboExtensionID.updateUI();
			}		
			else if(((String)comboExtensionType.getSelectedItem()).equals(PluginSpeciesSymbolType.ANTISENSE_RNA)){
				String[] item = getasRNAData();
				for(int i = 0 ; i < item.length ; i++){
					comboExtensionID.addItem(item[i]);	
				}			
				comboExtensionID.setSelectedItem(alias.getExtensionId());
				comboExtensionID.updateUI();
			}
		}
		
		textHomodimer.setText(String.valueOf(alias.getHomodimer()));
		checkHypothetical.setSelected(alias.getHypothetical());
		textX.setText(String.valueOf(alias.getX()));
		textY.setText(String.valueOf(alias.getY()));
		textWidth.setText(String.valueOf(alias.getWidth()));
		textHeight.setText(String.valueOf(alias.getHeight()));
		textColor.setText(String.valueOf(alias.getColor()));
		textLineWidth.setText(String.valueOf(alias.getFrameLineWidth()));
	}
	
	private void setAliasData(){
		alias.setType((String)comboExtensionType.getSelectedItem());
System.out.println("(String)comboExtensionType.getSelectedItem() = " + alias.getType());		
//		alias.setExtensionId(textSpeciesId.getText());
		alias.setName(textName.getText());		
		alias.setHomodimer(Integer.parseInt(textHomodimer.getText()));
		alias.setHypothetical(checkHypothetical.isSelected());
		alias.setFramePosition(Double.parseDouble(textX.getText()) , Double.parseDouble(textY.getText()));
		alias.setFrameSize(Double.parseDouble(textWidth.getText()) , Double.parseDouble(textHeight.getText()));
		alias.setFrameLineWidth(Double.parseDouble(textLineWidth.getText()));
		
		if(alias.getType().equals(PluginSpeciesSymbolType.PROTEIN)){
			PluginProtein pro = PluginSampleDialog.model.getProtein((String)comboExtensionID.getSelectedItem());
			if(pro != null){
				alias.setProtein(pro);
//				alias.getSpecies().setExtensionSBase(pro);
			}			
		}
		else if(alias.getType().equals(PluginSpeciesSymbolType.GENE)){
			PluginGene ge = PluginSampleDialog.model.getGene((String)comboExtensionID.getSelectedItem());
			if(ge != null){
				alias.setGene(ge);
//				alias.getSpecies().setExtensionSBase(ge);
			}
		}
		else if(alias.getType().equals(PluginSpeciesSymbolType.RNA)){
			PluginRNA rna = PluginSampleDialog.model.getRNA((String)comboExtensionID.getSelectedItem());
			if(rna != null){
				alias.setRNA(rna);
//				alias.getSpecies().setExtensionSBase(rna);
			}
System.out.println("(String)comboExtensionID.getSelectedItem() = " + (String)comboExtensionID.getSelectedItem());			
		}
		else if(alias.getType().equals(PluginSpeciesSymbolType.ANTISENSE_RNA)){
			PluginAntiSenseRNA as = PluginSampleDialog.model.getAntiSenseRNA((String)comboExtensionID.getSelectedItem());
			if(as != null){
				alias.setAntiSenseRNA(as);
//				alias.getSpecies().setExtensionSBase(as);
			}
		}
		else{
			alias.setProtein(null);
			alias.setGene(null);
			alias.setRNA(null);
			alias.setAntiSenseRNA(null);
		}
		
//		PluginSpecies sp = PluginSampleDialog.model.getSpecies(alias.getSpeciesID());
//		if(sp != null){
//			sp.setForViewSpeciesType(alias.getType());
//		}
		alias.setColor(Color.BLUE);
		
		PluginModification m = new PluginModification();
		m.setResidue("rs100");
		m.setState(PluginModification.STATE_PHOSPHORYLATED);
		alias.getModifications().append(m);
		
		PluginSampleDialog.updateTable();
	}
}
