package plugin.sample2.dialog.editdialog;

import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;



import jp.sbi.celldesigner.plugin.PluginSBase;
import jp.sbi.celldesigner.plugin.PluginSpecies;
import jp.sbi.sbml.util.SpeciesDialog;

public class PluginSpeciesDialog extends PluginSBaseDialog{

	/**@serial*/	private JTextField idTextField;
	/**@serial*/	private JTextField nameTextField;
	/**@serial*/	private JTextField compartmentTextField;
    /**@serial*/   private JRadioButton amountRadioButton;
    /**@serial*/   private JRadioButton concentrationRadioButton;
	/**@serial*/	private JTextField initialQuantityTextField;
	/**@serial*/	private JTextField substanceUnitsTextField;
    /**@serial*/   private JTextField spatialSizeUnitsTextField;
    /**@serial*/    private JRadioButton hasOnlySubstanceUnitsRadio;
    /**@serial*/    private JRadioButton hasOnlySubstanceUnitsFalseRadio;
	/**@serial*/	private JRadioButton boundaryConditionRadio;
	/**@serial*/	private JRadioButton boundaryConditionFalseRadio;
	/**@serial*/	private JTextField chargeTextField;
	/**@serial*/	private JRadioButton constantRadio;
	/**@serial*/	private JRadioButton constantFalseRadio;
	
	/**
	 * 
	 * @param editSpecies
	 */
	public PluginSpeciesDialog(PluginSpecies editSpecies){
		super();
		super.editingSBase = editSpecies;
		
//		this.getContentPane().add(createDialogPanel());
		setDialogFromObject(editingSBase);
		this.setVisible(true);
	}
	
	//---------------------------------------------------------
	/**<pre>
	 * SBaseDialogの実装で、
	 * 各サブクラスで任意のパネルを実装する。
	 * 作成したパネルはgetContentPane().add()しないこと。
	 * </pre>
	 * @return GUIの構築が終わったパネル
	 */
	//---------------------------------------------------------
	protected JPanel createDialogPanel(){

		/* 各フィールドコンポーネントの作成と動作・リスナー設定 */
		//id
		JLabel idLabel = new JLabel("id");
		idTextField = new JTextField();
		idTextField.setEditable(true);

		//name
		JLabel nameLabel = new JLabel("name");
		nameTextField = new JTextField();
		nameTextField.setEditable(true);

		//compartment
		JLabel compartmentLabel = new JLabel("compartment");
		compartmentTextField = new JTextField();
		compartmentTextField.setEditable(true);

        //quantityType
        JLabel initialQuantityLabel = new JLabel("initial...");
        JPanel initialQuantityPanel = new JPanel(null);
        initialQuantityPanel.setOpaque(true);
        initialQuantityPanel.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.LOWERED));
        amountRadioButton = new JRadioButton("Amount");
        concentrationRadioButton = new JRadioButton("Concentration");
        ButtonGroup quantityTypeGroup = new ButtonGroup();
        quantityTypeGroup.add(amountRadioButton);
        quantityTypeGroup.add(concentrationRadioButton);
        
		//initialQuantity
		//JLabel initialQuantityLabel = new JLabel("initial...");
		initialQuantityTextField = new JTextField();
		initialQuantityTextField.setEditable(true);

		//substanceUnits
		JLabel substanceUnitsLabel = new JLabel("substanceUnits");
		substanceUnitsTextField = new JTextField();
		substanceUnitsTextField.setEditable(true);

        //spatialSizeUnits
        JLabel spatialSizeUnitsLabel = new JLabel("spatialSizeUnits");
        spatialSizeUnitsTextField = new JTextField();
        spatialSizeUnitsTextField.setEditable(true);
        
        //hasOnlySubstanceUnits
        JLabel hasOnlySubstanceUnitsLabel = new JLabel("hasOnlySubstanceUnits");
        hasOnlySubstanceUnitsRadio = new JRadioButton("true");
        hasOnlySubstanceUnitsFalseRadio = new JRadioButton("false");
        ButtonGroup onlySubstanceUnitsGroup = new ButtonGroup();
        onlySubstanceUnitsGroup.add(hasOnlySubstanceUnitsRadio);
        onlySubstanceUnitsGroup.add(hasOnlySubstanceUnitsFalseRadio);
        
		//boundaryCondition
		JLabel boundaryConditionLabel = new JLabel("boundaryCondition");
		boundaryConditionRadio = new JRadioButton("true");
		boundaryConditionFalseRadio = new JRadioButton("false");
		ButtonGroup boundaryConditionGroup = new ButtonGroup();
		boundaryConditionGroup.add(boundaryConditionRadio);
		boundaryConditionGroup.add(boundaryConditionFalseRadio);

		//charge
		JLabel chargeLabel = new JLabel("charge");
		chargeTextField = new JTextField();
		chargeTextField.setEditable(true);

		//constant
		JLabel constantLabel = new JLabel("constant");
		constantRadio = new JRadioButton("true");
		constantFalseRadio = new JRadioButton("false");
		ButtonGroup constantsGroup = new ButtonGroup();
		constantsGroup.add(constantRadio);
		constantsGroup.add(constantFalseRadio);


  		/* Layout */
		LABEL_WIDTH = 120;
		TEXT_WIDTH = 200;
		setLayoutConstants();
		final int x1 = HORIZONTAL_MARGIN;
		final int x2 = TEXT_POSITION_X;

		int yline = VERTICAL_MARGIN;
 		idLabel.setBounds    (x1, yline, LABEL_WIDTH, LINE_HEIGHT);
		idTextField.setBounds(x2, yline, TEXT_WIDTH,  LINE_HEIGHT);

		yline += BASELINE_SKIP;
		nameLabel.setBounds    (x1, yline, LABEL_WIDTH, LINE_HEIGHT);
		nameTextField.setBounds(x2, yline, TEXT_WIDTH,  LINE_HEIGHT);

		yline += BASELINE_SKIP;
		compartmentLabel.setBounds    (x1, yline, LABEL_WIDTH, LINE_HEIGHT);
		compartmentTextField.setBounds(x2, yline, TEXT_WIDTH,  LINE_HEIGHT);

        yline += BASELINE_SKIP;
        initialQuantityLabel.setBounds    (x1, yline, LABEL_WIDTH, LINE_HEIGHT);
        //local panel
        final int margin = 4;
        initialQuantityPanel.setBounds(x2, yline, TEXT_WIDTH, BASELINE_SKIP+LINE_HEIGHT+2*margin);
        //local coordinate
        amountRadioButton.setBounds(margin, margin, BUTTON_WIDTH, LINE_HEIGHT);
        concentrationRadioButton.setBounds(margin+BUTTON_WIDTH+BUTTON_MARGIN, margin, BUTTON_WIDTH+20, LINE_HEIGHT);
		initialQuantityTextField.setBounds(margin, margin+BASELINE_SKIP, TEXT_WIDTH-2*margin,  LINE_HEIGHT);

		yline += 2*BASELINE_SKIP+2*margin;
		substanceUnitsLabel.setBounds    (x1, yline, LABEL_WIDTH, LINE_HEIGHT);
		substanceUnitsTextField.setBounds(x2, yline, TEXT_WIDTH,  LINE_HEIGHT);

        yline += BASELINE_SKIP;
        spatialSizeUnitsLabel.setBounds    (x1, yline, LABEL_WIDTH, LINE_HEIGHT);
        spatialSizeUnitsTextField.setBounds(x2, yline, TEXT_WIDTH,  LINE_HEIGHT);

        yline += BASELINE_SKIP;
        hasOnlySubstanceUnitsLabel.setBounds     (x1, yline, LABEL_WIDTH,  LINE_HEIGHT);
        hasOnlySubstanceUnitsRadio.setBounds     (x2, yline, BUTTON_WIDTH, LINE_HEIGHT);
        hasOnlySubstanceUnitsFalseRadio.setBounds(x2+BUTTON_WIDTH+BUTTON_MARGIN, yline, BUTTON_WIDTH, LINE_HEIGHT);

		yline += BASELINE_SKIP;
		boundaryConditionLabel.setBounds     (x1, yline, LABEL_WIDTH,  LINE_HEIGHT);
		boundaryConditionRadio.setBounds     (x2, yline, BUTTON_WIDTH, LINE_HEIGHT);
		boundaryConditionFalseRadio.setBounds(x2+BUTTON_WIDTH+BUTTON_MARGIN, yline, BUTTON_WIDTH, LINE_HEIGHT);

		yline += BASELINE_SKIP;
		chargeLabel.setBounds    (x1, yline, LABEL_WIDTH, LINE_HEIGHT);
		chargeTextField.setBounds(x2, yline, TEXT_WIDTH,  LINE_HEIGHT);

		yline += BASELINE_SKIP;
		constantLabel.setBounds     (x1, yline, LABEL_WIDTH,  LINE_HEIGHT);
		constantRadio.setBounds     (x2, yline, BUTTON_WIDTH, LINE_HEIGHT);
		constantFalseRadio.setBounds(x2+BUTTON_WIDTH+BUTTON_MARGIN, yline, BUTTON_WIDTH, LINE_HEIGHT);

		yline += BASELINE_SKIP;
		BUTTON_POSITION_Y = yline;
		setDefaultButtonsLayout();

		/* Add to panel */
		mainPanel = new JPanel();
		mainPanel.setLayout(null);

		mainPanel.add(idLabel, null);
		mainPanel.add(idTextField, null);
		mainPanel.add(nameLabel, null);
		mainPanel.add(nameTextField, null);
		mainPanel.add(compartmentLabel, null);
		mainPanel.add(compartmentTextField, null);
        mainPanel.add(initialQuantityLabel, null);
        mainPanel.add(initialQuantityPanel, null);
        initialQuantityPanel.add(amountRadioButton, null);
        initialQuantityPanel.add(concentrationRadioButton, null);
        initialQuantityPanel.add(initialQuantityTextField, null);
		mainPanel.add(substanceUnitsLabel, null);
		mainPanel.add(substanceUnitsTextField, null);
        mainPanel.add(spatialSizeUnitsLabel, null);
        mainPanel.add(spatialSizeUnitsTextField, null);
        mainPanel.add(hasOnlySubstanceUnitsLabel, null);
        mainPanel.add(hasOnlySubstanceUnitsRadio, null);
        mainPanel.add(hasOnlySubstanceUnitsFalseRadio, null);
		mainPanel.add(boundaryConditionLabel, null);
		mainPanel.add(boundaryConditionRadio, null);
		mainPanel.add(boundaryConditionFalseRadio, null);
		mainPanel.add(chargeLabel, null);
		mainPanel.add(chargeTextField, null);
		mainPanel.add(constantLabel, null);
		mainPanel.add(constantRadio, null);
		mainPanel.add(constantFalseRadio, null);

		addDefaultButtonsToPanel();

		return mainPanel;
	}
	
	//---------------------------------------------------------
	/**<pre>
	 * SBaseDialogの実装で、
	 * 引数であたえられたオブジェクトの情報をダイアログ内にセットする。
	 * 引数はダイアログにあわせてダウンキャストして使用する。
	 * </pre>
	 * @param sbase 対象のsbase
	 */
	//---------------------------------------------------------
	protected void setDialogFromObject(PluginSBase sbase){
		if(sbase==null){
			return;
		}

		PluginSpecies species = (PluginSpecies)sbase;

		//id
		String id = species.getId();
		idTextField.setText(id);
		idTextField.setCaretPosition(id.length());

		//name
		String name = species.getName();
		nameTextField.setText(name);
		nameTextField.setCaretPosition(name.length());

		//compartment
		String compartment = species.getCompartment();
		compartmentTextField.setText(compartment);
		compartmentTextField.setCaretPosition(compartment.length());

        //quantityType
//System.out.println("SpeciesDialog@404:int quantityType = species.getQuantityType();");        
//        int quantityType = species.getQuantityType();
//        if ( species.quantityType == Species.QUANTITY_IS_AMOUNT ){
//            amountRadioButton.setSelected(true);
//        } else if ( quantityType == Species.QUANTITY_IS_CONCENTRATION ){
//            concentrationRadioButton.setSelected(true);
//        }

//System.out.println("SpeciesDialog@414:species isSetInitialAmount = " + species.isSetInitialAmount());        
//System.out.println("SpeciesDialog@415:species isSetInitialConcentration = " + species.isSetInitialConcentration());
        if ( species.isSetInitialAmount()){
            amountRadioButton.setSelected(true);
            
            String s1 = "";
            double initialQuantity = species.getInitialAmount();
            s1 = Double.toString(initialQuantity);
            initialQuantityTextField.setText(s1);
            initialQuantityTextField.setCaretPosition(s1.length());
            
        } 
        else if (species.isSetInitialConcentration()){
            concentrationRadioButton.setSelected(true);
            
            String s1 = "";
            double initialQuantity = species.getInitialConcentration();
            s1 = Double.toString(initialQuantity);
            initialQuantityTextField.setText(s1);
            initialQuantityTextField.setCaretPosition(s1.length());
        }
        else{
            amountRadioButton.setSelected(true);
            String s1 = "";
            initialQuantityTextField.setText(s1);
            initialQuantityTextField.setCaretPosition(s1.length());
        }
        
		//initialQuantity
//		double initialQuantity = species.getInitialQuantity();
//        String s1 = "";
//        if ( initialQuantity != Species.quantityUnsetValue ){
//            s1 = Double.toString(initialQuantity);
//        }
//		initialQuantityTextField.setText(s1);
//		initialQuantityTextField.setCaretPosition(s1.length());

		//substanceUnits
		String substanceUnits = species.getSubstanceUnits();
		substanceUnitsTextField.setText(substanceUnits);
		substanceUnitsTextField.setCaretPosition(substanceUnits.length());

        //spatialSizeUnits
        String spatialSizeUnits = species.getSpatialSizeUnits();
        spatialSizeUnitsTextField.setText(spatialSizeUnits);
        spatialSizeUnitsTextField.setCaretPosition(spatialSizeUnits.length());

        //hasOnlySubstanceUnits
        boolean hasOnly = species.getHasOnlySubstanceUnits();
        hasOnlySubstanceUnitsRadio.setSelected(hasOnly);
        hasOnlySubstanceUnitsFalseRadio.setSelected(!hasOnly);

		//boundaryCondition
		boolean b1 = species.getBoundaryCondition();
		boundaryConditionRadio.setSelected(b1);
		boundaryConditionFalseRadio.setSelected(!b1);

		//charge
		int charge = species.getCharge();
		String s2 = Integer.toString(charge);
		chargeTextField.setText(s2);
		chargeTextField.setCaretPosition(s2.length());

		//constant
		boolean b2 = species.getConstant();
		constantRadio.setSelected(b2);
		constantFalseRadio.setSelected(!b2);
	}
	
	/**
	 * 
	 *
	 */
	protected void updateObject(){
//		PluginModifierSpeciesReference ref = (PluginModifierSpeciesReference)editingSBase;
//		
//		ref.setSpecies(speciesTextField.getText());	
	}
	
}
