package plugin.sample2.dialog.editdialog;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;

import plugin.sample2.dialog.PluginSampleDialog;


import jp.sbi.celldesigner.plugin.PluginSBase;

abstract public class PluginSBaseDialog extends JDialog{

	protected boolean addmode = false;
	
	/**@serial*/	protected PluginSBase editingSBase = null;			//現在ダイアログ上で編集中のSBase

	/**@serial*/	private boolean isNewObject = false;		//いま編集中のeditingSBaseは新規か？

	/**@serial*/	protected JButton okButton = new JButton("OK");
	/**@serial*/	protected JButton cancelButton = new JButton("Cancel");

	/**@serial*/	protected JPanel mainPanel = null;

	/**@serial*/	protected JRootPane rootPane = getRootPane();
	
	/* コンポーネントのデフォルトサイズ */
	protected int LINE_HEIGHT = 20;      // 行の高さ
	protected int BUTTON_WIDTH = 75;     // ボタンの幅
	protected int BUTTON_HEIGHT = 26;    // ボタンの高さ
    protected int SHOW_LIST_BUTTON_WIDTH = 100;// Width of "show list.." button 
	/* 相対位置を表す定数 */
	protected int HORIZONTAL_MARGIN = 10;// 左端と右端のマージン
	protected int VERTICAL_MARGIN = 10;  // 上端からのマージン
	protected int LABEL_TEXT_MARGIN = 10;// ラベルとテキスト入力行の間隔
	protected int BUTTON_MARGIN = 6;    // ボタン間隔(横方向)
	protected int BASELINE_SKIP = 24;    // ベースラインスキップ
	/* サブクラスで必ず入力が必要なもの */
	protected int LABEL_WIDTH = 0;       // ラベルの幅
	protected int TEXT_WIDTH = 0;        // テキストエリアの幅
	/* setLayoutConstants()で計算される従属定数 */
	protected int TEXT_POSITION_X = 10;  // テキスト入力エリア開始位置(横方向)
	protected int DIALOG_WIDTH = 190;    // ダイアログ(ContentPane)の幅
	protected int DIALOG_HEIGHT = 94;    // ダイアログ(ContentPane)の高さ
	/* レイアウトを行うことで決定される定数 */
	protected int BUTTON_POSITION_Y = 10;// ボタン描画位置(縦方向)

	public static final int OK_BUTTON = 0;
	public static final int ADD_BUTTON = 0;     //OK_BUTTONと同じ
	public static final int UPDATE_BUTTON = 0;  //OK_BUTTONと同じ
	public static final int CANCEL_BUTTON = 1;
	public static final int SIZE_OF_BUTTONS = 2;

	private static final int CREATE_DONE = 0;	//リスナーへの通知の種類をあらわすフラグ
	private static final int UPDATE_DONE = 1;
	private static final int DIALOG_CANCELED = 2;
	
	/**<pre>
	 * レイアウトに必要な定数を計算する.
	 * LABEL_WIDTH,TEXT_WIDTHを入力の上、必ずサブクラスから呼ぶこと.
	 *</pre>
	 */
	protected void setLayoutConstants() {
	    TEXT_POSITION_X = HORIZONTAL_MARGIN + LABEL_WIDTH + LABEL_TEXT_MARGIN;
	    DIALOG_WIDTH = TEXT_POSITION_X + TEXT_WIDTH + HORIZONTAL_MARGIN;
	}
	
	/**<pre>
	 * OKボタン、CANCELボタンの位置を設定する.
	 * setLayoutConstants()を行い、BUTTON_POSITION_Yを計算の上、必ずサブクラスから呼ぶこと.
	 *</pre>
	 */
	protected void setDefaultButtonsLayout() {
	    int okButton_x = (DIALOG_WIDTH - BUTTON_MARGIN)/2 - BUTTON_WIDTH;
	    int cancelButton_x = (DIALOG_WIDTH + BUTTON_MARGIN)/2;
	    okButton.setBounds(new Rectangle(okButton_x, BUTTON_POSITION_Y, BUTTON_WIDTH, BUTTON_HEIGHT));
	    cancelButton.setBounds(new Rectangle(cancelButton_x, BUTTON_POSITION_Y, BUTTON_WIDTH, BUTTON_HEIGHT));
	}
	
	////////////////////////////////////////////////////////////////////////////////////////////
	// ダイアログGUIの構築
	//サブクラス専用
	protected PluginSBaseDialog() {
		initDialog();
//		initButtonFlag();
	}
	
	private void initDialog(){

		this.getContentPane().setLayout(new BorderLayout());

		//メインパネル(mainPanel)設定
		createDialogPanel();					//サブクラスで個別のパネルを作成

		if(mainPanel != null){
			mainPanel.setPreferredSize(getDialogPanelSize());	//サブクラスからパネルサイズを得る
			getContentPane().add(mainPanel, BorderLayout.CENTER);
		}

		//OKボタンへのリスナー設定
		okButton.setMnemonic(KeyEvent.VK_O);
		okButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				okButton_actionPerformed();
			}
		});
		okButton.addFocusListener(new FocusAdapter() {
			public void focusGained(FocusEvent e) {
				rootPane.setDefaultButton(okButton);
			}
		});

		//キャンセルボタンへのリスナー設定
		cancelButton.setMnemonic(KeyEvent.VK_C);
		cancelButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				cancelButton_actionPerformed();
			}
		});
		cancelButton.addFocusListener(new FocusAdapter() {
			public void focusGained(FocusEvent e) {
				rootPane.setDefaultButton(cancelButton);
			}
		});

		pack();
		setResizable(false);
	}
	
	//---------------------------------------------------------
	/**<pre>
	 * OKボタンが押されたらオブジェクトを更新する。
	 * </pre>
	 */
	//---------------------------------------------------------
	protected void okButton_actionPerformed() {
		try {
			updateObject();	
			if(addmode){
				System.out.println(PluginSampleDialog.plug.notifySBaseAdded(editingSBase));	
				cancelButton_actionPerformed();
			}
			else{
				System.out.println(PluginSampleDialog.plug.notifySBaseChanged(editingSBase));
			}			
		} catch (Exception e){
            e.printStackTrace();
			//入力エラーがあれば警告を出して入力を続けさせる
			JOptionPane.showMessageDialog(this, e.getMessage(), "Confirmation", JOptionPane.WARNING_MESSAGE);
		}
	}
	
	//---------------------------------------------------------
	/**<pre>
	 *  Cancelボタンが押されたらダイアログをキャンセルする。
	 * </pre>
	 */
	//---------------------------------------------------------
	protected void cancelButton_actionPerformed() {
	    //isEdited = false;
		this.setVisible(false);
		this.dispose();
	}
	
	/**<pre>
	 * 必要であればサブクラスで、パネルサイズ定義にかかわる定数を設定する。
	 * createDialogPanel()で作成するパネルのサイズを定義する。
	 * </pre>
	 * @return パネルのサイズ
	 */
	//---------------------------------------------------------
	private Dimension getDialogPanelSize() {
	    DIALOG_HEIGHT = BUTTON_POSITION_Y + BUTTON_HEIGHT + VERTICAL_MARGIN;
	    return new Dimension(DIALOG_WIDTH, DIALOG_HEIGHT);
	}

	//---------------------------------------------------------
	/**<pre>
	 * サブクラスで実装すべきメソッドで、
	 * 各サブクラスで任意のパネルを実装する。
	 * 作成したパネルはgetContentPane().add()しないこと。
	 * </pre>
	 * @return GUIの構築が終わったパネル
	 */
	//---------------------------------------------------------
	protected abstract JPanel createDialogPanel();
	
	/**<pre>
	 * OKボタン、CANCELボタンをパネルに追加する.
	 * 必ずサブクラスから呼ぶこと.
	 *</pre>
	 */
	protected void addDefaultButtonsToPanel() {
	    mainPanel.add(okButton, null);
	    mainPanel.add(cancelButton, null);
	}
	
	abstract protected void updateObject();
}
