package plugin.sample2.dialog.editdialog;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;

import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;

import plugin.sample2.dialog.PluginSampleDialog;
import plugin.sample2.table.ReferenceViewingTable;

import jp.sbi.celldesigner.plugin.PluginKineticLaw;
import jp.sbi.celldesigner.plugin.PluginListOf;
import jp.sbi.celldesigner.plugin.PluginModifierSpeciesReference;
import jp.sbi.celldesigner.plugin.PluginReaction;
import jp.sbi.celldesigner.plugin.PluginSBase;
import jp.sbi.celldesigner.plugin.PluginSpeciesReference;
import jp.sbi.celldesigner.plugin.util.PluginReactionSymbolType;

public class PluginReactionDialog extends PluginSBaseDialog{

	//ユーザ入力用のGUIコンポーネント
	/**@serial*/ private JTextField idTextField;
	/**@serial*/ private JTextField nameTextField;
	/**@serial*/ private JRadioButton reversibleRadio;
	/**@serial*/ private JRadioButton reversibleFalseRadio;
	/**@serial*/ private JRadioButton fastRadio;
	/**@serial*/ private JRadioButton fastFalseRadio;
	/**@serial*/ private JButton reactantListDlgButton;
	/**@serial*/ private JButton productListDlgButton;
	/**@serial*/ private JButton modifierListDlgButton;
	/**@serial*/ private JTextArea kineticLawElementsTextArea;
	/**@serial*/ private JButton kineticLawCreateButton;
	/**@serial*/ private JButton kineticLawDeleteButton;
	/**@serial*/ private JFrame frame;															//TODO (A-1) Add By K.Seki
	/**@serial*/ public static JTabbedPane jTabbedPane;								//TODO (A-1) Add By K.Seki
	
	//要素ダイアログを初めて表示するか？のフラグ
	/**@serial*/ private boolean isFirstShowing[];
	/**@serial*/ private boolean isKineticLawFirstShowing = true;

	
	//モデルの各リストを編集するためのダイアログクラス名。
	//この配列の数と順序はReactionにおけるリストの配列に一致。
	private static String dialogClassName[] = new String[] {
		"PluginSpeciesReferenceDialog",
		"PluginSpeciesReferenceDialog",
		"PluginModifierSpeciesReferenceDialog"
	};

	//リスト名称（タブ用）
	private static String ListName[] = new String[] {			//TODO (A-1) Add By K.Seki
			"listOfReactants",									//TODO (A-1) Add By K.Seki
			"listOfProducts",									//TODO (A-1) Add By K.Seki
			"listOfModifiers"									//TODO (A-1) Add By K.Seki
	};		
	
    /** listOfReactantsをあらわす定数で、0*/
    public static final int LIST_OF_REACTANTS = 0;

    /** listOfProductsをあらわす定数で、1*/
    public static final int LIST_OF_PRODUCTS = 1;

    /** listOfModifiersをあらわす定数で、2*/
    public static final int LIST_OF_MODIFIERS = 2;

    /** &lt;listOf〜&gt;タグの個数をあらわす定数で、3*/
    public static final int SIZE_OF_LISTS = 3;
    
//add MKI
    public static final String REACTANTS = "Reactants";
    public static final String PRODUCTS  = "Products";
    public static final String MODIFIERS = "Modifiers";
	
	////////////////////////////////////////////////////////////////////////////////////
	//コンストラクタ

	//---------------------------------------------------------
	/**<pre>
	 * オーナーなしのダイアログを生成する。
	 * </pre>
	 */
	//---------------------------------------------------------
	public PluginReactionDialog(PluginReaction re , boolean mode) {
		super();
		super.editingSBase = re;
		addmode = mode;
		initListDialogs();
//		if ( useKeyListenerToTextFields ) {
//		    addListenerToTextFields();
//		}
//		initIsFirstShowing();
		
		setDialogFromObject(editingSBase);
		this.setVisible(true);
	}
	
	/**
	 * 各リスト用とKineticLawのSBaseListDialogとSBaseDialogを生成する。
	 */
	private void initListDialogs(){
		//タブへのリストパネルの設定
		PluginReaction re = (PluginReaction)editingSBase;
		JScrollPane panel1 = new JScrollPane();
		JScrollPane panel2 = new JScrollPane();
		JScrollPane panel3 = new JScrollPane();
		
		jTabbedPane = new JTabbedPane();
		
		panel1.getViewport().add(
				new ReferenceViewingTable(formatForTableData(re.getListOfReactants(),ListName[0]), ListName[0],re));
		panel2.getViewport().add(
				new ReferenceViewingTable(formatForTableData(re.getListOfProducts(),ListName[1]), ListName[1],re));
		panel3.getViewport().add(
				new ReferenceViewingTable(formatForTableData(re.getListOfModifiers(),ListName[2]), ListName[2],re));

		
		jTabbedPane.add(ListName[0],panel1);		
		jTabbedPane.add(ListName[1],panel2);
		jTabbedPane.add(ListName[2],panel3);
		
		
		jTabbedPane.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.LOWERED));
		jTabbedPane.setBounds(new Rectangle(10, 118, 440, 170));
		jTabbedPane.setSelectedIndex(0);
		mainPanel.add(jTabbedPane, null);
	}
	
    private void updatePanel(){
    	mainPanel.remove(jTabbedPane);
    	
    	jTabbedPane = new JTabbedPane();
    	initListDialogs();
    }
	
	/**
	 * listOfJars��e�[�u���Z�b�g�p�Ƀt�H�[�}�b�g����
	 * @return Object[][]
	 */
	protected Object[][] formatForTableData(PluginListOf listOfSBase , String tabName) {
		ArrayList newData = new ArrayList();
        
		// It changes in the storage form for the display. 
		if(listOfSBase == null){
			return new Object[0][0];
		}
			
		for( int i = 0;  i < listOfSBase.size(); i++) {
			ArrayList rowData = new ArrayList();
			
			if(tabName.equals(ListName[0]) ||
					tabName.equals(ListName[1])){
				PluginSpeciesReference species = (PluginSpeciesReference) listOfSBase.get(i);
				
				rowData.add(species.getSpecies());
				rowData.add(species.getAlias().getAliasID());
				rowData.add(String.valueOf( species.getStoichiometry()));
				rowData.add(species.getStoichiometryMath());
				
				newData.add(rowData);
			}		
			else if(tabName.equals(ListName[2])){
				PluginModifierSpeciesReference species = (PluginModifierSpeciesReference) listOfSBase.get(i);
								
				rowData.add(species.getSpecies());
				rowData.add(species.getAlias().getAliasID());
				
				newData.add(rowData);
			}		
		}

		// It changes from Vector. 
		Object[][] arrayData = new Object[newData.size()][1];
		for(int i = 0; i < newData.size() ; i++) {
			ArrayList data = (ArrayList)newData.get(i);
			arrayData[i] = data.toArray();
		}

		return arrayData;
	}
	
	private JButton buttonAdd;
	private JButton buttonRemove;
	
	//---------------------------------------------------------
	/**<pre>
	 * SBaseDialogの実装で、
	 * 各サブクラスで任意のパネルを実装する。
	 * 作成したパネルはgetContentPane().add()しないこと。
	 * </pre>
	 * @return GUIの構築が終わったパネル
	 */
	//---------------------------------------------------------
	protected JPanel createDialogPanel(){

	    //final JRootPane rootPane = getRootPane();

		mainPanel = new JPanel();
		mainPanel.setLayout(null);

		//idフィールド
		JLabel idLabel = new JLabel("id");
		idLabel.setBounds(new Rectangle(10, 10, 60, 20));
		mainPanel.add(idLabel, null);

		idTextField = new JTextField();
		idTextField.setBounds(new Rectangle(80, 10, 200, 20));
		idTextField.setEditable(true);
		mainPanel.add(idTextField, null);

		//nameフィールド
		JLabel nameLabel = new JLabel("name");
		nameLabel.setBounds(new Rectangle(10, 34, 60, 20));
		mainPanel.add(nameLabel, null);

		nameTextField = new JTextField();
		nameTextField.setBounds(new Rectangle(80, 34, 200, 20));
		nameTextField.setEditable(true);
		mainPanel.add(nameTextField, null);

		//reversibleフィールド
		JLabel reversibleLabel = new JLabel("reversible");
		reversibleLabel.setBounds(new Rectangle(10, 58, 120, 20));
		mainPanel.add(reversibleLabel, null);

		//trueラジオ
		reversibleRadio = new JRadioButton("true");
		reversibleRadio.setBounds(new Rectangle(80, 58, 60, 20));
		mainPanel.add(reversibleRadio, null);

		//falseラジオ
		reversibleFalseRadio = new JRadioButton("false");
		reversibleFalseRadio.setBounds(new Rectangle(150, 58, 90, 20));
		mainPanel.add(reversibleFalseRadio, null);

		//trueとfalseをグループ化
		ButtonGroup bg1 = new ButtonGroup();
		bg1.add(reversibleRadio);
		bg1.add(reversibleFalseRadio);
		addKeyListener(new KeyAdapter() {
			public void keyPressed(KeyEvent e){
				if(reversibleRadio.hasFocus() || reversibleFalseRadio.hasFocus()) {
					switch(e.getKeyCode()){
					case KeyEvent.VK_RIGHT:
						reversibleFalseRadio.setSelected(true);
						reversibleFalseRadio.grabFocus();
						break;
					case KeyEvent.VK_LEFT:
						reversibleRadio.setSelected(true);
						reversibleRadio.grabFocus();
						break;
					}
				}
			}
		});

		//fastフィールド
		JLabel fastLabel = new JLabel("fast");
		fastLabel.setBounds(new Rectangle(10, 82, 120, 20));
		mainPanel.add(fastLabel, null);

		//trueラジオ
		fastRadio = new JRadioButton("true");
		fastRadio.setBounds(new Rectangle(80, 82, 60, 20));
		mainPanel.add(fastRadio, null);

		//falseラジオ
		fastFalseRadio = new JRadioButton("false");
		fastFalseRadio.setBounds(new Rectangle(150, 82, 90, 20));
		mainPanel.add(fastFalseRadio, null);
		
		buttonAdd = new JButton("ADD");
		buttonAdd.setBounds(new Rectangle(280, 82, 80, 20));
		buttonAdd.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				PluginReaction re = (PluginReaction)editingSBase;
				if(jTabbedPane.getSelectedIndex()==0){
					PluginSpeciesReference ref = new PluginSpeciesReference(re, PluginSampleDialog.model.getSpecies(0).getSpeciesAlias(0));
//					PluginSpeciesReferenceDialog d = new PluginSpeciesReferenceDialog(ref);
//					PluginSpeciesReference ref = new PluginSpeciesReference(re);
					re.addReactant(ref);
					
					PluginSampleDialog.plug.notifySBaseAdded(ref);	
				}
				else if(jTabbedPane.getSelectedIndex()==1){
					PluginSpeciesReference ref = new PluginSpeciesReference(re, PluginSampleDialog.model.getSpecies(0).getSpeciesAlias(0));
//					PluginSpeciesReferenceDialog d = new PluginSpeciesReferenceDialog(ref);
//					PluginSpeciesReference ref = new PluginSpeciesReference(re);
					re.addProduct(ref);
					
					PluginSampleDialog.plug.notifySBaseAdded(ref);
				}
				else if(jTabbedPane.getSelectedIndex()==2){
					PluginModifierSpeciesReference ref = new PluginModifierSpeciesReference(re, PluginSampleDialog.model.getSpecies(0).getSpeciesAlias(0));
					ref.setModificationType(PluginReactionSymbolType.TRANSPORT);
//					PluginSpeciesReferenceDialog d = new PluginSpeciesReferenceDialog(ref);
//					PluginModifierSpeciesReference ref = new PluginModifierSpeciesReference(re);
//					//kari
					re.addModifier(ref);
					
					PluginSampleDialog.plug.notifySBaseAdded(ref);
				}				
				
				updatePanel();
				jTabbedPane.updateUI();
			}			
		});
		mainPanel.add(buttonAdd, null);
		
		buttonRemove = new JButton("REMOVE");
		buttonRemove.setBounds(new Rectangle(360, 82, 80, 20));		
		buttonRemove.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				PluginReaction re = (PluginReaction)editingSBase;
				if(jTabbedPane.getSelectedIndex()==0){
					JScrollPane pane = (JScrollPane) jTabbedPane.getSelectedComponent();
					JTable table = (JTable) pane.getViewport().getComponent(0);
										
					PluginSpeciesReference ref =  re.getReactant(table.getSelectedRow());
					re.removeReactant(table.getSelectedRow());
									
					PluginSampleDialog.plug.notifySBaseDeleted(ref);
				}
				else if(jTabbedPane.getSelectedIndex()==1){
					JScrollPane pane = (JScrollPane) jTabbedPane.getSelectedComponent();
					JTable table = (JTable) pane.getViewport().getComponent(0);
										
					PluginSpeciesReference ref =  re.getProduct(table.getSelectedRow());
					re.removeProduct(table.getSelectedRow());
					
					PluginSampleDialog.plug.notifySBaseDeleted(ref);
				}
				else if(jTabbedPane.getSelectedIndex()==2){
					JScrollPane pane = (JScrollPane) jTabbedPane.getSelectedComponent();
					JTable table = (JTable) pane.getViewport().getComponent(0);
										
					PluginModifierSpeciesReference ref =  re.getModifier(table.getSelectedRow());
					re.removeModifier(table.getSelectedRow());
					
					PluginSampleDialog.plug.notifySBaseDeleted(ref);
				}				
				
				updatePanel();
				jTabbedPane.updateUI();
			}			
		});
		mainPanel.add(buttonRemove, null);

		//trueとfalseをグループ化
		ButtonGroup bg2 = new ButtonGroup();
		bg2.add(fastRadio);
		bg2.add(fastFalseRadio);
		addKeyListener(new KeyAdapter() {
			public void keyPressed(KeyEvent e){
				if(fastRadio.hasFocus() || fastFalseRadio.hasFocus()) {
					switch(e.getKeyCode()){
					case KeyEvent.VK_RIGHT:
						fastFalseRadio.setSelected(true);
						fastFalseRadio.grabFocus();
						break;
					case KeyEvent.VK_LEFT:
						fastRadio.setSelected(true);
						fastRadio.grabFocus();
						break;
					}
				}
			}
		});

		JLabel kineticLawLabel = new JLabel("KineticLaw");
		kineticLawLabel.setBounds(new Rectangle(10, 300, 160, 20));				//TODO (A-1) Add By K.Seki
		mainPanel.add(kineticLawLabel, null);

  		kineticLawCreateButton = new JButton("Create");
		kineticLawCreateButton.setMnemonic(KeyEvent.VK_C);
		kineticLawCreateButton.setBounds(new Rectangle(180, 300, 100, 20));		//TODO (A-1) Add By K.Seki
		kineticLawCreateButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				CreateButton_actionPerformed();
			}
		});
		kineticLawCreateButton.addFocusListener(new FocusAdapter() {
			public void focusGained(FocusEvent e) {
				rootPane.setDefaultButton(kineticLawCreateButton);
			}
		});
		mainPanel.add(kineticLawCreateButton, null);

		/* 互換性のため作るだけ */
		kineticLawDeleteButton = new JButton("Delete") {//消してしまうと危険であるのでフォーカスをさせない
			public boolean isFocusTraversable(){
			    return false;
			}
		    };
		kineticLawElementsTextArea = new JTextArea(""){
			public boolean isManagingFocus(){ //テーブルにあるフォーカスを他のコンポーネントへ
				return false;                 //移動するために必要
			}
			public boolean isFocusTraversable(){
			    return false;
			}
		};

		//OKボタン、Cancelボタン
		LABEL_WIDTH = 60;
		TEXT_WIDTH = 371;								//TODO (A-1) Add By K.Seki
		setLayoutConstants();
		BUTTON_POSITION_Y = 100 + 10 * BASELINE_SKIP;	//TODO (A-1) Add By K.Seki
		setDefaultButtonsLayout();
		addDefaultButtonsToPanel();

		return mainPanel;
	}
	
	/**
	 * 「Create」ボタンが押された
	 */
	private void CreateButton_actionPerformed(){
		PluginReaction reaction = (PluginReaction)super.editingSBase;
		if(reaction.getKineticLaw() == null){
			PluginKineticLaw law = new PluginKineticLaw(reaction);
			reaction.setKineticLaw(law);
		}
		PluginKineticLawDialog kineticLawDialog = new PluginKineticLawDialog(reaction.getKineticLaw());
	}
	
	//---------------------------------------------------------
	/**<pre>
	 * SBaseDialogの実装で、
	 * 引数であたえられたオブジェクトの情報をダイアログ内にセットする。
	 * 引数はダイアログにあわせてダウンキャストして使用する。
	 * </pre>
	 * @param sbase 対象のsbase
	 */
	//---------------------------------------------------------
	protected void setDialogFromObject(PluginSBase sbase){
		if(sbase==null){
			return;
		}
		PluginReaction reaction = (PluginReaction)sbase;

		//idフィールド
		String id = reaction.getId();
		idTextField.setText(id);
		idTextField.setCaretPosition(id.length());
		idTextField.setEditable(false);

		//nameフィールド
		String name = reaction.getName();
		nameTextField.setText(name);
		nameTextField.setCaretPosition(name.length());

		//reversibleフィールド
		boolean b1 = reaction.getReversible();
		reversibleRadio.setSelected(b1);
		reversibleFalseRadio.setSelected(!b1);

		//fastフィールド
		boolean b2 = reaction.getFast();
		fastRadio.setSelected(b2);
		fastFalseRadio.setSelected(!b2);
        
		//このReactionダイアログではid、name、reversible、fastしか編集対象としない。
		//残りの<listOf*>については個別のリストダイアログにまかせる。
		//KineticLawについてはKineticLawダイアログにまかせる。
	}

	/**
	 * 
	 *
	 */
	protected void updateObject(){
		PluginReaction reaction = (PluginReaction)editingSBase;
		
		reaction.setName(nameTextField.getText());
		reaction.setFast(fastRadio.isSelected());
		reaction.setReversible(reversibleRadio.isSelected());		
	}
}
