package plugin.sample2.dialog.editdialog;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import plugin.sample2.dialog.PluginSampleDialog;
import plugin.sample2.table.ProteinViewingTable;


import jp.sbi.celldesigner.plugin.PluginListOf;
import jp.sbi.celldesigner.plugin.PluginModificationResidue;
import jp.sbi.celldesigner.plugin.PluginProtein;
import jp.sbi.celldesigner.plugin.PluginSBase;

public class PluginProteinDialog extends JDialog{

	public PluginProtein protein;
	
	ProteinViewingTable table;
	
	JScrollPane sc;
	
	public PluginProteinDialog(PluginSBase alias){
		this.protein = (PluginProtein) alias;
		init();
//		setDataDialog();
	}
	
	private void init(){
		this.setSize(400,400);
		this.setTitle("ListOfPluginResidue");
		
		getContentPane().setLayout(new BorderLayout());
				
		sc = new JScrollPane();
		table = new ProteinViewingTable(formatForTableData(protein.getListOfPluginResidue()) , this);
		sc.getViewport().add(table);
		getContentPane().add(sc,BorderLayout.CENTER);
		
		
		JPanel innerPanel = new JPanel();
		
		JButton buttonAdd = new JButton("Add");
		buttonAdd.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {	
				add();
			}			
		});
		innerPanel.add(buttonAdd);
				
		JButton buttonDel = new JButton("Del");
		buttonDel.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {	
				del();
			}			
		});
		innerPanel.add(buttonDel);		
		
		getContentPane().add(innerPanel,BorderLayout.SOUTH);
		
		this.setVisible(true);
	}
	
	/**
	 * listOfJars��e�[�u���Z�b�g�p�Ƀt�H�[�}�b�g����
	 * @return Object[][]
	 */
	protected Object[][] formatForTableData(PluginListOf listOfSBase) {
		ArrayList newData = new ArrayList();
        
		// It changes in the storage form for the display. 
		if(listOfSBase == null){
			return new Object[0][0];
		}
			
		for( int i = 0;  i < listOfSBase.size(); i++) {
			ArrayList rowData = new ArrayList();
			
			PluginModificationResidue species = (PluginModificationResidue) listOfSBase.get(i);
			
			rowData.add(species.getId());
			rowData.add(species.getName());
			rowData.add(species.getSide());
			rowData.add(Double.toString(species.getAngle()));			
			
			newData.add(rowData);

		}

		// It changes from Vector. 
		Object[][] arrayData = new Object[newData.size()][1];
		for(int i = 0; i < newData.size() ; i++) {
			ArrayList data = (ArrayList)newData.get(i);
			arrayData[i] = data.toArray();
		}

		return arrayData;
	}
	
	
	void add(){
		PluginModificationResidue s = new PluginModificationResidue(protein);
		
		protein.addPluginModificationResidue(s);
		
		PluginSampleDialog.plug.notifySBaseChanged(s);	
		
		sc.getViewport().removeAll();
		table = new ProteinViewingTable(formatForTableData(protein.getListOfPluginResidue()) , this);
		sc.getViewport().add(table);
		
		
	}
	
	void del(){
		PluginModificationResidue s = protein.getPluginModificationResidue(table.getSelectedRow());
		
		protein.removePluginModificationResidue(table.getSelectedRow());
		
		PluginSampleDialog.plug.notifySBaseDeleted(s);	
		
		sc.getViewport().removeAll();
		table = new ProteinViewingTable(formatForTableData(protein.getListOfPluginResidue()) , this);
		sc.getViewport().add(table);
	}
}

