package plugin.sample2.dialog.editdialog;

import java.awt.Rectangle;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;


import jp.sbi.celldesigner.plugin.PluginModifierSpeciesReference;
import jp.sbi.celldesigner.plugin.PluginSBase;
import jp.sbi.celldesigner.plugin.util.PluginReactionSymbolType;


public class PluginModifierSpeciesReferenceDialog  extends PluginSBaseDialog{

	//ユーザ入力用のGUIコンポーネント
	/**@serial*/	private JTextField speciesTextField;
	
	//---------------------------------------------------------
	/**<pre>
	 * オーナーなしのダイアログを生成する。
	 * </pre>
	 */	
	//---------------------------------------------------------
	public PluginModifierSpeciesReferenceDialog(PluginModifierSpeciesReference ref) {
		super();
		super.editingSBase = ref;
	}
	

	////////////////////////////////////////////////////////////////////////////////////
	//SBaseDialogダイアログの実装

	//---------------------------------------------------------
	/**<pre>
	 * SBaseDialogの実装。
	 * 各サブクラスで任意のパネルを実装する。
	 * 作成したパネルはgetContentPane().add()しないこと。
	 * </pre>
	 * @return GUIの構築が終わったパネル
	 */	
	//---------------------------------------------------------
	protected JPanel createDialogPanel(){

	    //rootPane = getRootPane();

		mainPanel = new JPanel();
		mainPanel.setLayout(null);
		//getContentPane().add(mainPanel);

		//speciesフィールド
		JLabel speciesLabel = new JLabel("species");
		speciesLabel.setBounds(new Rectangle(10, 10, 120, 20));
		mainPanel.add(speciesLabel, null);
		
		speciesTextField = new JTextField();
		speciesTextField.setBounds(new Rectangle(70, 10, 300, 20));
		speciesTextField.setEditable(true);
		mainPanel.add(speciesTextField, null);

		//OKボタン、Cancelボタン
		LABEL_WIDTH = 50;
		TEXT_WIDTH = 300;
		setLayoutConstants();
		BUTTON_POSITION_Y = 10 + 2 * BASELINE_SKIP;
		setDefaultButtonsLayout();
		addDefaultButtonsToPanel();

		return mainPanel;
	}

	//---------------------------------------------------------
	/**<pre>
	 * SBaseDialogの実装で、
	 * 引数であたえられたオブジェクトの情報をダイアログ内にセットする。
	 * 引数はダイアログにあわせてダウンキャストして使用する。
	 * </pre>
	 * @param sbase 対象のsbase
	 */	
	//---------------------------------------------------------
	protected void setDialogFromObject(PluginSBase sbase){
		if(sbase==null){
			return;
		}

		PluginModifierSpeciesReference modifierSpeciesReference = (PluginModifierSpeciesReference)sbase;

		//speciesフィールド
//		String species = modifierSpeciesReference.getId();
        String species = modifierSpeciesReference.getSpecies();
		speciesTextField.setText(species);
		speciesTextField.setCaretPosition(species.length());
	}
	
	/**
	 * 
	 *
	 */
	protected void updateObject(){
		PluginModifierSpeciesReference ref = (PluginModifierSpeciesReference)editingSBase;
		
		ref.setModificationType(PluginReactionSymbolType.TRUNCATION);
//		ref.setSpecies(speciesTextField.getText());	
	}
}
