package plugin.sample2.dialog.editdialog;

import java.awt.BorderLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;

import plugin.sample2.dialog.PluginSampleDialog;
import plugin.sample2.table.ParameterViewingTable;

import jp.sbi.celldesigner.plugin.PluginKineticLaw;
import jp.sbi.celldesigner.plugin.PluginListOf;
import jp.sbi.celldesigner.plugin.PluginParameter;
import jp.sbi.celldesigner.plugin.PluginSBase;
import jp.sbi.sbml.util.MathEditPanel;

public class PluginKineticLawDialog extends PluginSBaseDialog{

	//ユーザ入力用のGUIコンポーネント
	/**@serial*/ private JTextField mathTextField;
	/**@serial*/ private JTextField timeUnitsTextField;
	/**@serial*/ private JTextField substanceUnitsTextField;
	
    private MathEditPanel mathPanel;

	//リスト名称（タブ用）
	private static String ListName[] = new String[] {			//TODO (A-1) Add By K.Seki
			"listOfParameters"			
	};
	
	/**<pre>
	 * オーナーなしのダイアログを生成する。
	 * </pre>
	 */
	//---------------------------------------------------------
	public PluginKineticLawDialog(PluginKineticLaw law) {
		super();
		editingSBase = law;
		initListPanelAndDialog();
		setDialogFromObject(editingSBase);
		this.setVisible(true);
//		initIsFirstShowing();
	}
	
	//---------------------------------------------------------
	/**<pre>
	 * SBaseDialogの実装で、
	 * 各サブクラスで任意のパネルを実装する。
	 * 作成したパネルはgetContentPane().add()しないこと。
	 * </pre>
	 * @return GUIの構築が終わったパネル
	 */
	//---------------------------------------------------------
	protected JPanel createDialogPanel(){
		int y=0; // 各item配置用y座標。added by y.

	    //		final JRootPane rootPane = getRootPane();

		mainPanel = new JPanel();
		mainPanel.setLayout(null);
		
		y += 10;
		int hmargin=4;
		int h=BASELINE_SKIP-hmargin;
		
		//formulaフィールド
		JLabel formulaLabel = new JLabel("math");
		formulaLabel.setBounds(new Rectangle(10, y, 60, h));
		mainPanel.add(formulaLabel, null);
        
        mathPanel = new MathEditPanel();
        mainPanel.add(mathPanel);
        int mpheight = mathPanel.createUI(300, LINE_HEIGHT, BASELINE_SKIP);
        mathPanel.setBounds(new Rectangle(110, y, 300, mpheight));
        mathTextField = mathPanel.getTextField();

        y += mpheight + BASELINE_SKIP - LINE_HEIGHT;

        y += mpheight + BASELINE_SKIP - LINE_HEIGHT;

		//timeUnitsフィールド
		JLabel timeUnitsLabel = new JLabel("timeUnits");
		
		timeUnitsLabel.setBounds(new Rectangle(10, y, 60, h));
		mainPanel.add(timeUnitsLabel, null);

		timeUnitsTextField = new JTextField();
		timeUnitsTextField.setBounds(new Rectangle(110, y, 300, h));
		timeUnitsTextField.setEditable(true);
		mainPanel.add(timeUnitsTextField, null);
		y += h + hmargin;

		//substanceUnitsフィールド
		JLabel substanceUnitsLabel = new JLabel("substanceUnits");
		substanceUnitsLabel.setBounds(new Rectangle(10, y, 100, h));
		mainPanel.add(substanceUnitsLabel, null);

		substanceUnitsTextField = new JTextField();
		substanceUnitsTextField.setBounds(new Rectangle(110, y, 300, h));
		substanceUnitsTextField.setEditable(true);
		mainPanel.add(substanceUnitsTextField, null);
		y += h + hmargin;

		//listOfParametersフィールド
		JLabel listOfParametersLabel = new JLabel("listOfParameters");
		listOfParametersLabel.setBounds(new Rectangle(10, y, 160, h));
		mainPanel.add(listOfParametersLabel, null);
		
        newButton = new JButton("NEW");
        newButton.setBounds(new Rectangle(120, y, 80, h));
        newButton.addActionListener(new ActionListener(){

			public void actionPerformed(ActionEvent e) {
				PluginKineticLaw law = (PluginKineticLaw)editingSBase;
				PluginParameter sbase = new PluginParameter(law);			
				sbase.setId("test1");
				
				law.addParameter((PluginParameter) sbase);	
				
				updatePanel();
				
				//reactionがEditだったら実行
				PluginSampleDialog.plug.notifySBaseAdded(sbase);	
			}
        	
        });
        removeButton = new JButton("REMOVE");
        removeButton.setBounds(new Rectangle(220, y, 80, h));
        removeButton.addActionListener(new ActionListener(){

			public void actionPerformed(ActionEvent e) {
				JTable table = (JTable) panel.getViewport().getComponent(0);
				
				PluginKineticLaw law = (PluginKineticLaw)editingSBase;
				PluginParameter sbase = law.getParameter(table.getSelectedRow());
								
				law.removeParameter(table.getSelectedRow());	
				
				updatePanel();
				
				PluginSampleDialog.plug.notifySBaseDeleted(sbase);	
			}
        	
        });
        mainPanel.add(newButton, null);
        mainPanel.add(removeButton, null);
        
        y += BASELINE_SKIP;

        //initListPanels();
//        initListPanelAndDialog();
//        mainPanel.add(listPanel[0]);
//        listPanel[0].setBounds(new Rectangle(10, y, 400, 200));
        
		y += 200 + BASELINE_SKIP - LINE_HEIGHT;;

		//OKボタン、Cancelボタン
		LABEL_WIDTH = 90;
		TEXT_WIDTH = 300;
		setLayoutConstants();
		BUTTON_POSITION_Y = y; //10 + 5 * BASELINE_SKIP;
		setDefaultButtonsLayout();
		addDefaultButtonsToPanel();

//  		okButton.setText("Apply");
//  		okButton.setMnemonic(KeyEvent.VK_A);

		return mainPanel;
	}

	/**@serial*/
	private JButton newButton;
	/**@serial*/
	private JButton removeButton;
	
	JScrollPane panel;   
	
    /**
     * 各リスト用のSBaseListPanelとSBaseDialogを生成する。
     * Invoked by constructor.
     */
    private void initListPanelAndDialog(){
        // Indeed, KineticLaw.SIZE_OF_LISTS=1. 
//        if ( listPanel == null){
//            listPanel = new SBaseListPanel[1];
//            listPanel[0] = new ListPanel();
//        }
    	
    	panel = new JScrollPane();    	
    	int y = 0;
    	y += 10;
		int hmargin=4;
		int h=BASELINE_SKIP-hmargin;
    	int mpheight = mathPanel.createUI(300, LINE_HEIGHT, BASELINE_SKIP);
        y += mpheight + BASELINE_SKIP - LINE_HEIGHT;
        y += mpheight + BASELINE_SKIP - LINE_HEIGHT;
        y += h + hmargin;
        y += h + hmargin;      
        y += BASELINE_SKIP;
    	panel.setBounds(new Rectangle(10, y, 400, 200));
    	
    	PluginKineticLaw law = (PluginKineticLaw)editingSBase;
    	panel.getViewport().add(
    			new ParameterViewingTable(formatForTableData(law.getListOfParameters(),ListName[0]), ListName[0] , law) ,BorderLayout.CENTER);
    	mainPanel.add(panel);
    }
    
    private void updatePanel(){
    	mainPanel.remove(panel);
    	
    	initListPanelAndDialog();
    }
    
	/**
	 * listOfJars��e�[�u���Z�b�g�p�Ƀt�H�[�}�b�g����
	 * @return Object[][]
	 */
	protected Object[][] formatForTableData(PluginListOf listOfSBase , String tabName) {
		ArrayList newData = new ArrayList();
        
		// It changes in the storage form for the display. 
		if(listOfSBase == null){
			return new Object[0][0];
		}
			
		for( int i = 0;  i < listOfSBase.size(); i++) {
			ArrayList rowData = new ArrayList();
			
			PluginParameter species = (PluginParameter) listOfSBase.get(i);
			
			rowData.add(species.getId());
			rowData.add(species.getName());
			rowData.add(String.valueOf(species.getValue()));
			rowData.add(species.getUnits());			
			rowData.add(new Boolean(species.getConstant()));
			
			newData.add(rowData);

		}

		// It changes from Vector. 
		Object[][] arrayData = new Object[newData.size()][1];
		for(int i = 0; i < newData.size() ; i++) {
			ArrayList data = (ArrayList)newData.get(i);
			arrayData[i] = data.toArray();
		}

		return arrayData;
	}
	
	//---------------------------------------------------------
	/**<pre>
	 * SBaseDialogの実装で、
	 * 引数であたえられたオブジェクトの情報をダイアログ内にセットする。
	 * 引数はダイアログにあわせてダウンキャストして使用する。
	 * </pre>
	 * @param sbase 対象のsbase
	 */
	//---------------------------------------------------------
	protected void setDialogFromObject(PluginSBase sbase){
		if(sbase==null){
			return;
		}
		PluginKineticLaw kineticLaw = (PluginKineticLaw)sbase;

		//formulaフィールド
		String formula = kineticLaw.getFormula();
		mathTextField.setText(formula);
		mathTextField.setCaretPosition(formula.length());

		//timeUnitsフィールド
		String timeUnits = kineticLaw.getTimeUnits();
		timeUnitsTextField.setText(timeUnits);
		timeUnitsTextField.setCaretPosition(timeUnits.length());

		//substanceUnitsフィールド
		String substanceUnits = kineticLaw.getSubstanceUnits();
		substanceUnitsTextField.setText(substanceUnits);
		substanceUnitsTextField.setCaretPosition(substanceUnits.length());
 
		//このKineticLawダイアログではformula、timeUnits、substanceUnitsしか編集対象としない。
		//残りの<listOf*>については個別のリストダイアログにまかせる。
	}
	
	/**
	 * 
	 *
	 */
	protected void updateObject(){
		PluginKineticLaw kineticLaw = (PluginKineticLaw)editingSBase;
		
		kineticLaw.setFormula(mathTextField.getText());
		kineticLaw.setSubstanceUnits(substanceUnitsTextField.getText());
		kineticLaw.setTimeUnits(timeUnitsTextField.getText());		
	}

}
