package plugin.sample2.dialog.editdialog;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import plugin.sample2.dialog.PluginSampleDialog;
import plugin.sample2.table.GeneRNAViewingTable;


import jp.sbi.celldesigner.plugin.PluginAntiSenseRNA;
import jp.sbi.celldesigner.plugin.PluginGene;
import jp.sbi.celldesigner.plugin.PluginListOf;
import jp.sbi.celldesigner.plugin.PluginModificationRegion;
import jp.sbi.celldesigner.plugin.PluginRNA;
import jp.sbi.celldesigner.plugin.PluginSBase;

public class PluginGeneRNADialog extends JDialog{

	public PluginSBase sbase;
	
	GeneRNAViewingTable table;
	
	JScrollPane sc;
	
	public PluginGeneRNADialog(PluginSBase alias){
		this.sbase = alias;
		init();
//		setDataDialog();
	}
	
	private void init(){
		this.setSize(400,400);
		this.setTitle("ListOfPluginResidue");
		
		getContentPane().setLayout(new BorderLayout());
				
		sc = new JScrollPane();
		
		PluginListOf list = null;
		if(sbase instanceof PluginGene){
			PluginGene g = (PluginGene)sbase;
			list = g.getListOfPluginRegion();
		}
		else if(sbase instanceof PluginRNA){
			PluginRNA g = (PluginRNA)sbase;
			list = g.getListOfPluginRegion();
		}
		else if(sbase instanceof PluginAntiSenseRNA){
			PluginAntiSenseRNA g = (PluginAntiSenseRNA)sbase;
			list = g.getListOfPluginRegion();
		}
		
		table = new GeneRNAViewingTable(formatForTableData(list) , this);
		sc.getViewport().add(table);
		getContentPane().add(sc,BorderLayout.CENTER);
		
		
		JPanel innerPanel = new JPanel();
		
		JButton buttonAdd = new JButton("Add");
		buttonAdd.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {	
				add();
			}			
		});
		innerPanel.add(buttonAdd);
				
		JButton buttonDel = new JButton("Del");
		buttonDel.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {	
				del();
			}			
		});
		innerPanel.add(buttonDel);		
		
		getContentPane().add(innerPanel,BorderLayout.SOUTH);
		
		this.setVisible(true);
	}
	
	/**
	 * listOfJars��e�[�u���Z�b�g�p�Ƀt�H�[�}�b�g����
	 * @return Object[][]
	 */
	protected Object[][] formatForTableData(PluginListOf listOfSBase) {
		ArrayList newData = new ArrayList();
        
		// It changes in the storage form for the display. 
		if(listOfSBase == null){
			return new Object[0][0];
		}
			
		for( int i = 0;  i < listOfSBase.size(); i++) {
			ArrayList rowData = new ArrayList();
			
			PluginModificationRegion species = (PluginModificationRegion) listOfSBase.get(i);
			
			rowData.add(species.getId());
			rowData.add(species.getName());
			rowData.add(species.getType());
			rowData.add(Double.toString(species.getSize()));			
			rowData.add(Double.toString(species.getPos()));
			
			newData.add(rowData);

		}

		// It changes from Vector. 
		Object[][] arrayData = new Object[newData.size()][1];
		for(int i = 0; i < newData.size() ; i++) {
			ArrayList data = (ArrayList)newData.get(i);
			arrayData[i] = data.toArray();
		}

		return arrayData;
	}
	
	
	void add(){
		PluginModificationRegion s = null;
		if(sbase instanceof PluginGene){
			PluginGene g = (PluginGene)sbase;
			s = new PluginModificationRegion(g);
			
			g.addPluginModificationRegion(s);
		}
		else if(sbase instanceof PluginRNA){
			PluginRNA g = (PluginRNA)sbase;
			s = new PluginModificationRegion(g);
			
			g.addPluginModificationRegion(s);
		}
		else if(sbase instanceof PluginAntiSenseRNA){
			PluginAntiSenseRNA g = (PluginAntiSenseRNA)sbase;
			s = new PluginModificationRegion(g);
			
			g.addPluginModificationRegion(s);
		}
					
		PluginSampleDialog.plug.notifySBaseChanged(s);	
		
		
		PluginListOf list = null;
		if(sbase instanceof PluginGene){
			PluginGene g = (PluginGene)sbase;
			list = g.getListOfPluginRegion();
		}
		else if(sbase instanceof PluginRNA){
			PluginRNA g = (PluginRNA)sbase;
			list = g.getListOfPluginRegion();
		}
		else if(sbase instanceof PluginAntiSenseRNA){
			PluginAntiSenseRNA g = (PluginAntiSenseRNA)sbase;
			list = g.getListOfPluginRegion();
		}
		sc.getViewport().removeAll();
		table = new GeneRNAViewingTable(formatForTableData(list) , this);
		sc.getViewport().add(table);
		
		
	}
	
	void del(){
		PluginModificationRegion s = null;
		if(sbase instanceof PluginGene){
			PluginGene g = (PluginGene)sbase;
			s = g.getPluginModificationRegion(table.getSelectedRow());			
			g.removePluginModificationRegion(table.getSelectedRow());
		}
		else if(sbase instanceof PluginRNA){
			PluginRNA g = (PluginRNA)sbase;
			s = g.getPluginModificationRegion(table.getSelectedRow());			
			g.removePluginModificationRegion(table.getSelectedRow());
		}
		else if(sbase instanceof PluginAntiSenseRNA){
			PluginAntiSenseRNA g = (PluginAntiSenseRNA)sbase;
			s = g.getPluginModificationRegion(table.getSelectedRow());			
			g.removePluginModificationRegion(table.getSelectedRow());
		}
		
		PluginSampleDialog.plug.notifySBaseDeleted(s);	
		
		PluginListOf list = null;
		if(sbase instanceof PluginGene){
			PluginGene g = (PluginGene)sbase;
			list = g.getListOfPluginRegion();
		}
		else if(sbase instanceof PluginRNA){
			PluginRNA g = (PluginRNA)sbase;
			list = g.getListOfPluginRegion();
		}
		else if(sbase instanceof PluginAntiSenseRNA){
			PluginAntiSenseRNA g = (PluginAntiSenseRNA)sbase;
			list = g.getListOfPluginRegion();
		}
		sc.getViewport().removeAll();
		table = new GeneRNAViewingTable(formatForTableData(list) , this);
		sc.getViewport().add(table);
	}
}

