package plugin.sample2.dialog.editdialog;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import jp.sbi.celldesigner.plugin.PluginEvent;
import jp.sbi.sbml.util.MathEditPanel2;

import org.sbml.libsbml.libsbml;

public class PluginEventDialog extends PluginSBaseDialog{
    private JTextField idTextField;
    private JTextField nameTextField;
    private JTextField triggerTextField; //on math edit panel
    private JTextField delayTextField;   //on math edit panel
    private JTextField timeUnitsField;
    private JButton eventAssignmentButton;
    
    private MathEditPanel2 mathPanel;
    
    /**
     * Constructs dialog without owner.
     */
	public PluginEventDialog(PluginEvent eve , boolean mode) {
		super();
		super.editingSBase = eve;
		addmode = mode;
		setDialogFromObject(eve);
		this.setVisible(true);
	}

	
	protected JPanel createDialogPanel() {
        //main panel
        mainPanel = new JPanel();
        mainPanel.setLayout(null);
        
        LABEL_WIDTH = 60;
        TEXT_WIDTH = 300;
        setLayoutConstants();

        //id
        int yline = VERTICAL_MARGIN;
        JLabel idLabel = new JLabel("id");
        idLabel.setBounds(new Rectangle(HORIZONTAL_MARGIN, yline, LABEL_WIDTH, LINE_HEIGHT));
        mainPanel.add(idLabel, null);
        
        idTextField = new JTextField();
        idTextField.setBounds(new Rectangle(TEXT_POSITION_X, yline, TEXT_WIDTH, LINE_HEIGHT));
        idTextField.setEditable(true);
        mainPanel.add(idTextField, null);
        
        //name
        yline += BASELINE_SKIP;
        JLabel nameLabel = new JLabel("name");
        nameLabel.setBounds(new Rectangle(HORIZONTAL_MARGIN, yline, LABEL_WIDTH, LINE_HEIGHT));
        mainPanel.add(nameLabel, null);
        
        nameTextField = new JTextField();
        nameTextField.setBounds(new Rectangle(TEXT_POSITION_X, yline, TEXT_WIDTH, LINE_HEIGHT));
        nameTextField.setEditable(true);
        mainPanel.add(nameTextField, null);
        
        //trigger and delay
        yline += BASELINE_SKIP;
        JLabel triggerLabel = new JLabel("trigger");
        triggerLabel.setBounds(new Rectangle(HORIZONTAL_MARGIN, yline, LABEL_WIDTH, LINE_HEIGHT));
        mainPanel.add(triggerLabel, null);

        mathPanel = new MathEditPanel2();
        int mpheight = mathPanel.createUI(TEXT_WIDTH, LINE_HEIGHT, BASELINE_SKIP);
        mathPanel.setBounds(new Rectangle(TEXT_POSITION_X, yline, TEXT_WIDTH, mpheight));
        triggerTextField = mathPanel.getTextField(MathEditPanel2.MATH_TEXT_1);
        triggerTextField.setEditable(true);
        delayTextField = mathPanel.getTextField(MathEditPanel2.MATH_TEXT_2);
        delayTextField.setEditable(true);
        mainPanel.add(mathPanel, null);
        
        JLabel delayLabel = new JLabel("delay");
        delayLabel.setBounds(new Rectangle(HORIZONTAL_MARGIN, yline+mpheight-BASELINE_SKIP, LABEL_WIDTH, LINE_HEIGHT));
        mainPanel.add(delayLabel, null);

        //timeUnits
        yline += mpheight + BASELINE_SKIP - LINE_HEIGHT;
        JLabel timeUnitsLabel = new JLabel("timeUnits");
        timeUnitsLabel.setBounds(new Rectangle(HORIZONTAL_MARGIN, yline, LABEL_WIDTH, LINE_HEIGHT));
        mainPanel.add(timeUnitsLabel);
        
        timeUnitsField = new JTextField();
        timeUnitsField.setBounds(new Rectangle(TEXT_POSITION_X, yline, TEXT_WIDTH, LINE_HEIGHT));
        timeUnitsField.setEditable(true);
        mainPanel.add(timeUnitsField);
        
        //listOfEventAssignments
        yline += BASELINE_SKIP;
        JLabel eventAssignmentLabel = new JLabel("listOfEventAssignments");
        eventAssignmentLabel.setBounds(new Rectangle(HORIZONTAL_MARGIN, yline, LABEL_WIDTH+60, LINE_HEIGHT));
        mainPanel.add(eventAssignmentLabel);
        
        eventAssignmentButton = new JButton("Show list..");
        eventAssignmentButton.setBounds(new Rectangle(TEXT_POSITION_X+TEXT_WIDTH-SHOW_LIST_BUTTON_WIDTH, yline, SHOW_LIST_BUTTON_WIDTH, LINE_HEIGHT));
        eventAssignmentButton.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent e){
                listDlgButton_actionPerformed();
            }
        });
        eventAssignmentButton.addFocusListener(new FocusAdapter(){
            public void focusGained(FocusEvent e) {
                rootPane.setDefaultButton(eventAssignmentButton);
            }
        });
        mainPanel.add(eventAssignmentButton, null);
        
        //ok and cancel buttons
        yline += BASELINE_SKIP;
        BUTTON_POSITION_Y = yline;
        setDefaultButtonsLayout();
        addDefaultButtonsToPanel();
        
		return mainPanel;
	}

	private void listDlgButton_actionPerformed(){
		PluginEventAssDialog unitDialog = new PluginEventAssDialog((PluginEvent) editingSBase);
	}
	
    /**
     * Sets the contents of the argument objects to this dialog.
     * The argument should be used with downcast appropriately.
     * 
     * @param sbase 
     * @see jp.sbi.sbml.util.SBaseDialog#setDialogFromObject(jp.sbi.sbml.SBase)
     */
	protected void setDialogFromObject(PluginEvent ev) {
        
        //id
        String id = ev.getId();
        idTextField.setText(id);
        idTextField.setCaretPosition(id.length());
        
        //name
        String name = ev.getName();
        nameTextField.setText(name);
        nameTextField.setCaretPosition(name.length());
        
        //trigger
//System.out.println("EventDialog@236:String trigger = ev.getTriggerString();");        
//        String trigger = ev.getTriggerString();
        String trigger = "";
        if(ev.getTrigger() != null){
            trigger = libsbml.formulaToString(ev.getTrigger().getMath());    
        }        
        triggerTextField.setText(trigger);
        triggerTextField.setCaretPosition(trigger.length());
        
        //delay
//        String delay = ev.getDelayString();
        String delay = "";
        if(ev.getDelay() != null){
            delay = libsbml.formulaToString(ev.getDelay().getMath());    
        }        
        delayTextField.setText(delay);
        delayTextField.setCaretPosition(delay.length());
        
        //timeUnits
        String timeUnits = ev.getTimeUnits();
        timeUnitsField.setText(timeUnits);
        timeUnitsField.setCaretPosition(timeUnits.length());
        
        //remaining lists are left for ListDialog
	}
	
	protected void updateObject() {
		// TODO 自動生成されたメソッド・スタブ
		PluginEvent ev = (PluginEvent)editingSBase;
		ev.setName(nameTextField.getText());
		ev.setTimeUnits(timeUnitsField.getText());
		ev.setName(nameTextField.getText());
		ev.setName(nameTextField.getText());
		
        //trigger
        try {
			String trigger = triggerTextField.getText();
//System.out.println("trigger = " + trigger);            
            //new MathStrParser(trigger);//string check
//            MathMLUtil.toValidMathString(trigger);//check only
            //replace check
            if(libsbml.parseFormula(trigger) == null){
                throw new Exception();
            }
            
//            ev.setTriggerString(trigger);
            ev.setTrigger(libsbml.parseFormula(trigger));
//System.out.println("ev getTrigger = " + ev.getTrigger());            
		} catch (Exception e) {
//			throw new Exception("malformed trigger string");
		}

        //delay
        try {
			String delay = delayTextField.getText();
//System.out.println("delay = " + delay);            
            //new MathStrParser(delay);//string check
//            MathMLUtil.toValidMathString(delay);//check only
            //replace check
            if(libsbml.parseFormula(delay) == null){
                throw new Exception();
            }
//            ev.setDelayString(delay);
            ev.setDelay(libsbml.parseFormula(delay));
//System.out.println("ev getDelay = " + ev.getDelay());
		} catch (Exception e) {
//			throw new Exception("malformed delay string");
		}
	}

}
