package plugin.sample2.dialog.editdialog;

import java.awt.BorderLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

import plugin.sample2.dialog.PluginSampleDialog;
import plugin.sample2.table.EventViewingTable;


import jp.sbi.celldesigner.plugin.PluginEvent;
import jp.sbi.celldesigner.plugin.PluginEventAssignment;

public class PluginEventAssDialog extends PluginSBaseDialog {

	public PluginEventAssDialog(PluginEvent editingSBase){
		super();
		super.editingSBase = editingSBase;
		init();
		this.setResizable(true);
		this.setSize(500,500);
		this.setVisible(true);
	}
	
	private JButton buttonAdd;
	private JButton buttonRemove;
	JScrollPane jTabbedPane;
	
	protected JPanel createDialogPanel() {
		
		
		mainPanel = new JPanel();
		
		buttonAdd = new JButton("ADD");
		buttonAdd.setBounds(new Rectangle(280, 82, 80, 20));
		buttonAdd.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				PluginEvent re = (PluginEvent)editingSBase;
				PluginEventAssignment ref = new PluginEventAssignment(re);
				re.addEventAssignment(ref);
System.out.println("add UNIT");
				updatePanel();
				jTabbedPane.updateUI();
				
				PluginSampleDialog.plug.notifySBaseAdded(ref);	
			}			
		});
		mainPanel.add(buttonAdd, null);
		
		buttonRemove = new JButton("REMOVE");
		buttonRemove.setBounds(new Rectangle(360, 82, 80, 20));		
		buttonRemove.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				PluginEvent re = (PluginEvent)editingSBase;
				JTable table = (JTable) jTabbedPane.getViewport().getComponent(0);
							
				PluginEventAssignment ref = re.getEventAssignment(table.getSelectedRow());
				re.removeEventAssignment(table.getSelectedRow());
					
				updatePanel();
				jTabbedPane.updateUI();
				
				PluginSampleDialog.plug.notifySBaseDeleted(ref);	
			}			
		});
		mainPanel.add(buttonRemove, null);
		
		//中央にテーブルを置くだけ
		return mainPanel;
	}
	
	private void init(){
		jTabbedPane = new JScrollPane();
		
		jTabbedPane.getViewport().add(new EventViewingTable(formatForTableData(),"",(PluginEvent) editingSBase));
		
		mainPanel.add(jTabbedPane,BorderLayout.CENTER);
		
	}
	
    private void updatePanel(){
    	mainPanel.remove(jTabbedPane);
    	
    	init();    	
    	mainPanel.updateUI();
    }

	protected Object[][] formatForTableData() {
		ArrayList newData = new ArrayList();
        
		PluginEvent def = (PluginEvent)editingSBase;
		
		for( int i = 0;  i < def.getNumEventAssignments(); i++) {
			ArrayList rowData = new ArrayList();
			
			PluginEventAssignment species = def.getEventAssignment(i);
				
			rowData.add(String.valueOf(species.getVariable()));
			rowData.add(String.valueOf(species.getMath()));
				
			newData.add(rowData);
		}

		// It changes from Vector. 
		Object[][] arrayData = new Object[newData.size()][1];
		for(int i = 0; i < newData.size() ; i++) {
			ArrayList data = (ArrayList)newData.get(i);
			arrayData[i] = data.toArray();
		}

		return arrayData;
	}
	
	protected void updateObject() {
		// TODO 自動生成されたメソッド・スタブ
		
	}

}
