package plugin.sample2.dialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

import plugin.sample2.SamplePlugin2;

import jp.sbi.celldesigner.plugin.*;

/**
 * NewJNLPDialog
 * @author MKI
 *
 */
public class PluginSampleDialog extends JDialog{

	public static PluginSampleDialog thisInstance;
	
	public static SamplePlugin2 plug;
	
	public static PluginModel model;
	
	/** JSplitPane*/
//	private static JPanel jPanel;

	/** buttonSynchronized */
	private JButton buttonSynchronized;
	
	/** buttonDebug */
	private JButton buttonDebug;
		
	/** buttonClose */
	private JButton buttonClose;
		
	/** textCodebase*/
	private JTextField textCodebase;
	
	/** textAppName*/
	private JTextField textAppName;

	/** textVenderName*/
	private JTextField textVenderName;

	/** textHPName*/
	private JTextField textHPName;
	
	/** textDescreption*/
	private JTextField textDescreption;
	
	/** checkOfflineAllowed*/
	private JCheckBox checkOfflineAllowed;
	
	/** textArg1*/
	private JTextField textArg1;
	
	/** textArg2*/
	private JTextField textArg2;
	
	public final static String SPECIES   = "Species";
	public final static String SPECIES_ALIAS   = "SpeciesAlias";
	public final static String PROTEINS   = "Proteins";
	public final static String GENES   = "Genes";
	public final static String RNAS   = "RNAs";
	public final static String AS_RNAS   = "AsRNAs";
	public final static String REACTIONS  = "Reactions";
	public final static String KINETICLAWS  = "KineticLaws";
	public final static String LOCAL_PARAM  = "Lacal_Parameter";
	public final static String COMPARTMENTS  = "Compartments";
	public final static String PARAMETERS    = "Global_Parameters";
	public final static String FUNCTIONS    = "Functions";
	public final static String UNIT_DEFINITIONS    = "UnitDefinitions";
	public final static String UNITS    = "Units";
	public final static String RULES    = "Rules";
	public final static String EVENTS    = "Events";

	public static int idCount = 0;
		
	/**
	 * 
	 * @param plug2
	 */
	public PluginSampleDialog(SamplePlugin2 plug2){
		PluginSampleDialog.plug =plug2;
		
		setModal(false);
		
		thisInstance = this;
		
		init();
	}
		
	/**
	 * Dialog init
	 */
	private void init(){
		this.setTitle("Sample Plugin2");
		this.setSize(750,600);
		this.setResizable(true);
		
		getContentPane().add(createRightPanel() , BorderLayout.CENTER);
		getContentPane().add(createSouthPanel() ,  BorderLayout.SOUTH);
				
	}
	
	
	public static JTabbedPane tabPane;
	
	public static void updateTable(){
System.out.println("PluginSampleDialog updateTable");	
		int index = tabPane.getSelectedIndex();        
		tabPane.removeAll();
                     
		if(model == null){
			model = plug.getSelectedModel();
		}
        
		tabPane.add(new CommonSBaseViewingTab(thisInstance,SPECIES , model.getListOfSpecies()),SPECIES);
		tabPane.add(new CommonSBaseViewingTab(thisInstance,SPECIES_ALIAS , model.getListOfAllSpeciesAlias()),SPECIES_ALIAS);
		tabPane.add(new CommonSBaseViewingTab(thisInstance,PROTEINS , model.getListOfProteins()),PROTEINS);
		tabPane.add(new CommonSBaseViewingTab(thisInstance,GENES , model.getListOfGenes()),GENES);
		tabPane.add(new CommonSBaseViewingTab(thisInstance,RNAS , model.getListOfRNAs()),RNAS);
		tabPane.add(new CommonSBaseViewingTab(thisInstance,AS_RNAS , model.getListOfAntiSenseRNAs()),AS_RNAS);		
		
		tabPane.add(new CommonSBaseViewingTab(thisInstance,REACTIONS , model.getListOfReactions()),REACTIONS);
		
		PluginListOf listOfKineticLaw = new PluginListOf();
		for(int i= 0 ; i< model.getListOfReactions().size() ; i++){
			listOfKineticLaw.append(model.getReaction(i).getKineticLaw());
		}
		tabPane.add(new CommonSBaseViewingTab(thisInstance,KINETICLAWS , listOfKineticLaw),KINETICLAWS);
		
		tabPane.add(new CommonSBaseViewingTab(thisInstance,COMPARTMENTS , model.getListOfCompartments()),COMPARTMENTS);
		
		tabPane.add(new CommonSBaseViewingTab(thisInstance,PARAMETERS , model.getListOfParameters()),PARAMETERS);
		tabPane.add(new CommonSBaseViewingTab(thisInstance,FUNCTIONS , model.getListOfFunctionDefinitions()),FUNCTIONS);
		tabPane.add(new CommonSBaseViewingTab(thisInstance,UNIT_DEFINITIONS , model.getListOfUnitDefinitions()),UNIT_DEFINITIONS);
		
		tabPane.add(new CommonSBaseViewingTab(thisInstance,RULES , model.getListOfRules()),RULES);
		tabPane.add(new CommonSBaseViewingTab(thisInstance,EVENTS , model.getListOfEvents()),EVENTS);
		
		tabPane.setSelectedIndex(index);
		
	}
	
	/**
	 * createRightPanel
	 * @return JPanel
	 */
	private JTabbedPane createRightPanel(){
		tabPane = new JTabbedPane();
		tabPane.addMouseListener(new MouseListener(){

			public void mouseClicked(MouseEvent arg0) {
				if(tabPane.getSelectedIndex() == CommonSBaseViewingTab.SPECIES_ALIAS ||
						tabPane.getSelectedIndex() == CommonSBaseViewingTab.REACTIONS ||
						tabPane.getSelectedIndex() == CommonSBaseViewingTab.UNITDEFINITIONS ||
						tabPane.getSelectedIndex() == CommonSBaseViewingTab.EVENTS ||
						tabPane.getSelectedIndex() == CommonSBaseViewingTab.PROTEINS ||
						tabPane.getSelectedIndex() == CommonSBaseViewingTab.GENES ||
						tabPane.getSelectedIndex() == CommonSBaseViewingTab.RNAS ||
						tabPane.getSelectedIndex() == CommonSBaseViewingTab.ASRNAS){
					for(int i = 0 ; i < tabPane.getComponentCount() ; i++){
						Component comp = tabPane.getComponent(i);
						if(comp instanceof BaseTabPanel){
							((BaseTabPanel)comp).setEditButtonEnable(true);
						}
					}
				}
				else{
					for(int i = 0 ; i < tabPane.getComponentCount() ; i++){
						Component comp = tabPane.getComponent(i);
						if(comp instanceof BaseTabPanel){
							((BaseTabPanel)comp).setEditButtonEnable(false);
						}
					}
				}
			}

			public void mousePressed(MouseEvent arg0) {
			}

			public void mouseReleased(MouseEvent arg0) {
			}

			public void mouseEntered(MouseEvent arg0) {
			}

			public void mouseExited(MouseEvent arg0) {
			}});
				
		model = plug.getSelectedModel();
		
		if(model == null){
			return tabPane;
		}
		
		tabPane.add(new CommonSBaseViewingTab(this,SPECIES , model.getListOfSpecies()),SPECIES);
		tabPane.add(new CommonSBaseViewingTab(this,SPECIES_ALIAS , model.getListOfAllSpeciesAlias()),SPECIES_ALIAS);
		tabPane.add(new CommonSBaseViewingTab(this,PROTEINS , model.getListOfProteins()),PROTEINS);
		tabPane.add(new CommonSBaseViewingTab(this,GENES , model.getListOfGenes()),GENES);
		tabPane.add(new CommonSBaseViewingTab(this,RNAS , model.getListOfRNAs()),RNAS);
		tabPane.add(new CommonSBaseViewingTab(this,AS_RNAS , model.getListOfAntiSenseRNAs()),AS_RNAS);		
		
		tabPane.add(new CommonSBaseViewingTab(this,REACTIONS , model.getListOfReactions()),REACTIONS);
		
		PluginListOf listOfKineticLaw = new PluginListOf();
		for(int i= 0 ; i< model.getListOfReactions().size() ; i++){
			listOfKineticLaw.append(model.getReaction(i).getKineticLaw());
		}
		tabPane.add(new CommonSBaseViewingTab(this,KINETICLAWS , listOfKineticLaw),KINETICLAWS);
		
		
		tabPane.add(new CommonSBaseViewingTab(this,COMPARTMENTS , model.getListOfCompartments()),COMPARTMENTS);
		
		tabPane.add(new CommonSBaseViewingTab(this,PARAMETERS , model.getListOfParameters()),PARAMETERS);
		tabPane.add(new CommonSBaseViewingTab(this,FUNCTIONS , model.getListOfFunctionDefinitions()),FUNCTIONS);
		tabPane.add(new CommonSBaseViewingTab(this,UNIT_DEFINITIONS , model.getListOfUnitDefinitions()),UNIT_DEFINITIONS);
		
		tabPane.add(new CommonSBaseViewingTab(this,RULES , model.getListOfRules()),RULES);
		tabPane.add(new CommonSBaseViewingTab(this,EVENTS , model.getListOfEvents()),EVENTS);
		
		return tabPane;
	}
				
	/**
	 * createSouthPanel
	 * @return createSouthPanel
	 */
	private JPanel createSouthPanel(){
		JPanel southPanel = new JPanel();
		
		JPanel innerSouthPanel = new JPanel();
				
		buttonSynchronized = new JButton("Synchronized");
		buttonSynchronized.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent arg0) {
				buttonSynchronized_actionPerformed(arg0);
			}
		});
		
		buttonDebug = new JButton("debug print");
		buttonDebug.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent arg0) {
				buttonDebug_actionPerformed(arg0);
			}
		});
		
		buttonClose = new JButton("Close");
		buttonClose.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent arg0) {
				buttonClose_actionPerformed(arg0);	
			}
		});
		
		innerSouthPanel.add(buttonSynchronized);
		innerSouthPanel.add(buttonDebug);
		innerSouthPanel.add(buttonClose);

        southPanel.add(innerSouthPanel,BorderLayout.CENTER);
		
		return southPanel;
	}
		
	/**
	 * buttonSynchronized_actionPerformed
	 * @param arg0
	 */
	private void buttonSynchronized_actionPerformed(ActionEvent arg0){	
		model = null;
		updateTable();
	}
	
	/**
	 * buttonCreate_actionPerformed
	 * @param arg0
	 */
	private void buttonDebug_actionPerformed(ActionEvent arg0){		
		System.out.println("---------debug print start");
		
		PluginListOf listOf = PluginSampleDialog.plug.getSelectedSpeciesNode();
		if(listOf != null){
			for(int i = 0 ; i < listOf.size() ; i++){
				PluginSpeciesAlias alias = (PluginSpeciesAlias)listOf.get(i);
				
				System.out.println("selected SpeciesNode = " + alias.getAliasID());
				System.out.println("selected name = " + alias.getName());
			}			
		}
		
		//debug
		PluginListOf listOfR = PluginSampleDialog.plug.getSelectedReactionNode(model);
		if(listOfR != null){
			for(int i = 0 ; i < listOfR.size() ; i++){
				((PluginReaction)listOfR.get(i)).setLineColor(Color.BLUE);
System.out.println("selected ReactionNode = " + ((PluginReaction)listOfR.get(i)).getId());
System.out.println("selected setLineColor = " + ((PluginReaction)listOfR.get(i)).getLineColor());
				PluginSampleDialog.plug.notifySBaseChanged(listOfR.get(i));			
			}			
		}
		
		//debug
		PluginListOf listOfC = PluginSampleDialog.plug.getSelectedCompartmentNode(model);
		if(listOfR != null){
			for(int i = 0 ; i < listOfC.size() ; i++){
				System.out.println("selected CompartmentNode = " + ((PluginCompartment)listOfC.get(i)).getId());			
				PluginSampleDialog.plug.notifySBaseChanged(listOfC.get(i));			
			}			
		}
		
		//debug
		PluginModel pmodel = PluginSampleDialog.plug.getSelectedModel();
		if(pmodel != null){
			System.out.println("selected model id = " + pmodel.getId());			
			System.out.println("selected model name = " + pmodel.getName());
			System.out.println("selected model notes = " + pmodel.getNotesString());
		}
		
		System.out.println("---------debug print end");		
	}
	
	/**
	 * error check
	 * @return
	 */
	private boolean isValidData(){
		
		if(textCodebase.getText().equals("")){
			JOptionPane.showMessageDialog(null, "Please input Codabase.", "Warning",
					JOptionPane.INFORMATION_MESSAGE);
			
			return false;
		}
		else if(textArg1.getText().equals("")){
			JOptionPane.showMessageDialog(null, "Please input Argument1.", "Warning",
					JOptionPane.INFORMATION_MESSAGE);
			
			return false;
		}
		else if(textArg2.getText().equals("")){
			JOptionPane.showMessageDialog(null, "Please input Argument2.", "Warning",
					JOptionPane.INFORMATION_MESSAGE);
			
			return false;
		}
		
		return true;
	}
	
	/**
	 * buttonClose_actionPerformed
	 * @param arg0
	 */
	private void buttonClose_actionPerformed(ActionEvent arg0){
		setVisible(false);
		dispose();		
	}
	
	/**
	 * Override as ended when the window is shut.<br>
	 * @param  e    WindowEvent
	 */
	protected void processWindowEvent( WindowEvent e ){
		if( e.getID() == WindowEvent.WINDOW_CLOSING ){
			setVisible(false);
			dispose();
		}
	}
}
