package plugin.sample2.dialog;

import java.util.ArrayList;

import jp.sbi.celldesigner.plugin.PluginAlgebraicRule;
import jp.sbi.celldesigner.plugin.PluginAntiSenseRNA;
import jp.sbi.celldesigner.plugin.PluginAssignmentRule;
import jp.sbi.celldesigner.plugin.PluginCompartment;
import jp.sbi.celldesigner.plugin.PluginEvent;
import jp.sbi.celldesigner.plugin.PluginFunctionDefinition;
import jp.sbi.celldesigner.plugin.PluginGene;
import jp.sbi.celldesigner.plugin.PluginKineticLaw;
import jp.sbi.celldesigner.plugin.PluginListOf;
import jp.sbi.celldesigner.plugin.PluginModel;
import jp.sbi.celldesigner.plugin.PluginModificationRegion;
import jp.sbi.celldesigner.plugin.PluginModificationResidue;
import jp.sbi.celldesigner.plugin.PluginModifierSpeciesReference;
import jp.sbi.celldesigner.plugin.PluginParameter;
import jp.sbi.celldesigner.plugin.PluginProtein;
import jp.sbi.celldesigner.plugin.PluginRNA;
import jp.sbi.celldesigner.plugin.PluginRateRule;
import jp.sbi.celldesigner.plugin.PluginReaction;
import jp.sbi.celldesigner.plugin.PluginRule;
import jp.sbi.celldesigner.plugin.PluginSBase;
import jp.sbi.celldesigner.plugin.PluginSpecies;
import jp.sbi.celldesigner.plugin.PluginSpeciesAlias;
import jp.sbi.celldesigner.plugin.PluginSpeciesReference;
import jp.sbi.celldesigner.plugin.PluginUnitDefinition;
import jp.sbi.celldesigner.plugin.util.PluginCompartmentSymbolType;
import jp.sbi.celldesigner.plugin.util.PluginReactionSymbolType;
import jp.sbi.celldesigner.plugin.util.PluginSpeciesSymbolType;

import org.sbml.libsbml.libsbml;

import plugin.sample2.dialog.editdialog.PluginEventDialog;
import plugin.sample2.dialog.editdialog.PluginGeneRNADialog;
import plugin.sample2.dialog.editdialog.PluginProteinDialog;
import plugin.sample2.dialog.editdialog.PluginReactionDialog;
import plugin.sample2.dialog.editdialog.PluginSpeciesNodeDialog;
import plugin.sample2.dialog.editdialog.PluginUnitDefinitionDialog;

public class CommonSBaseViewingTab extends BaseTabPanel{

	PluginSampleDialog parent;
	
	public static final int SPECIES = 0;
	public static final int SPECIES_ALIAS = 1;
	public static final int PROTEINS = 2;
	public static final int GENES = 3;
	public static final int RNAS = 4;
	public static final int ASRNAS = 5;
	public static final int REACTIONS = 6;
	public static final int KINETICLAWS = 7;
	public static final int COMPARTMENTS = 8;
	public static final int G_PARAMETERS = 9;
	public static final int FUNCTIONS = 10;
	public static final int UNITDEFINITIONS = 11;
	public static final int RULES = 12;
	public static final int EVENTS = 13;
	
	
	/**
	 * constructor
	 * @param parent
	 * @param tabName
	 * @param listOfSBase
	 */
	public CommonSBaseViewingTab(PluginSampleDialog parent ,String tabName , PluginListOf listOfSBase){
		this.parent = parent;
		this.tabName = tabName;
		this.listOfSBase = listOfSBase;
		initTabPanel();
		
		if(tabName.equals(PluginSampleDialog.KINETICLAWS)){
			this.setAllButtonEnable(false);
		}
		else if(tabName.equals(PluginSampleDialog.PROTEINS) ||
				tabName.equals(PluginSampleDialog.GENES) ||
				tabName.equals(PluginSampleDialog.RNAS) ||
				tabName.equals(PluginSampleDialog.AS_RNAS)){
			this.setDeleteButtonEnable(false);
		}
	}
	
	protected void addData() {
		PluginSBase sbase = null;
		
		PluginModel model= PluginSampleDialog.model;
			
		//Species
		if(SPECIES == PluginSampleDialog.tabPane.getSelectedIndex()){
			sbase = new PluginSpecies(PluginSpeciesSymbolType.PROTEIN , "TEST" + (++PluginSampleDialog.idCount));			

			PluginSpecies species = (PluginSpecies)sbase;
			species.getSpeciesAlias(0).setFramePosition(40,40);
			
			model.addSpecies(species);
			
			PluginModificationResidue r = new PluginModificationResidue(species.getSpeciesAlias(0).getProtein());
			r.setName("bb");			
			species.getSpeciesAlias(0).getProtein().addPluginModificationResidue(r);
			System.out.println(PluginSampleDialog.plug.notifySBaseAdded(sbase));
			PluginSampleDialog.updateTable();

			
			return;
		}
		else if(SPECIES_ALIAS == PluginSampleDialog.tabPane.getSelectedIndex()){
			
			if(((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow() == -1){
				return;
			}
			
			PluginSpeciesAlias selectedAlias = (PluginSpeciesAlias) model.getListOfAllSpeciesAlias().get(getViewTabel().getSelectedRow());				
            
			PluginSpeciesAlias alias = new PluginSpeciesAlias(selectedAlias.getSpecies(),selectedAlias.getExtensionType());
			PluginSpeciesAlias palias= selectedAlias.getSpecies().getSpeciesAlias(0);
			alias.setFramePosition(palias.getX()+1,palias.getY()+1);			
			if(palias.getProtein() != null){
				alias.setProtein(palias.getProtein());
			}
			else if(palias.getGene() != null){
				alias.setGene(palias.getGene());
			}
			else if(palias.getRNA() != null){
				alias.setRNA(palias.getRNA());
			}
			else if(palias.getAntiSenseRNA() != null){
				alias.setAntiSenseRNA(palias.getAntiSenseRNA());
			}
			
			selectedAlias.getSpecies().addSpeciesAlias(alias);		
			
			System.out.println(PluginSampleDialog.plug.notifySBaseAdded(alias));
			PluginSampleDialog.updateTable();
			return;
		}
		else if(PROTEINS == PluginSampleDialog.tabPane.getSelectedIndex()){
			sbase = new PluginSpecies(PluginSpeciesSymbolType.PROTEIN_GENERIC , "TEST" + (++PluginSampleDialog.idCount));			

			PluginSpecies species = (PluginSpecies)sbase;
			species.getSpeciesAlias(0).setFramePosition(40,40);
									
			model.addSpecies(species);
			
			System.out.println(PluginSampleDialog.plug.notifySBaseAdded(sbase));
			PluginSampleDialog.updateTable();
			return;
		}
		else if(GENES == PluginSampleDialog.tabPane.getSelectedIndex()){
			sbase = new PluginSpecies(PluginSpeciesSymbolType.GENE , "TEST" + (++PluginSampleDialog.idCount));			

			PluginSpecies species = (PluginSpecies)sbase;
			species.getSpeciesAlias(0).setFramePosition(40,40);
									
			model.addSpecies(species);
			
			System.out.println(PluginSampleDialog.plug.notifySBaseAdded(sbase));
			PluginSampleDialog.updateTable();
			return;
		}
		else if(RNAS == PluginSampleDialog.tabPane.getSelectedIndex()){
			sbase = new PluginSpecies(PluginSpeciesSymbolType.RNA , "TEST" + (++PluginSampleDialog.idCount));			

			PluginSpecies species = (PluginSpecies)sbase;
			species.getSpeciesAlias(0).setFramePosition(40,40);
									
			model.addSpecies(species);
			
			System.out.println(PluginSampleDialog.plug.notifySBaseAdded(sbase));
			PluginSampleDialog.updateTable();
			return;
		}
		else if(ASRNAS == PluginSampleDialog.tabPane.getSelectedIndex()){
			sbase = new PluginSpecies(PluginSpeciesSymbolType.ANTISENSE_RNA , "TEST" + (++PluginSampleDialog.idCount));			

			PluginSpecies species = (PluginSpecies)sbase;
			species.getSpeciesAlias(0).setFramePosition(40,40);
									
			model.addSpecies(species);
			
			System.out.println(PluginSampleDialog.plug.notifySBaseAdded(sbase));
			PluginSampleDialog.updateTable();
			return;
		}
		//reaction
		else if(REACTIONS == PluginSampleDialog.tabPane.getSelectedIndex()){	
			sbase = new PluginReaction();
			
			boolean reactionAddTest = true;
			if(reactionAddTest){
				PluginReaction re = (PluginReaction)sbase;
				re.setReactionType(PluginReactionSymbolType.TRANSPORT);
				
				PluginSpecies newSp1 = new PluginSpecies(PluginSpeciesSymbolType.PROTEIN_GENERIC,"test1");
				PluginSpeciesReference nref1 = new PluginSpeciesReference(re,newSp1.getSpeciesAlias(0));
				re.addReactant(nref1);
				
				model.addSpecies(newSp1);

				PluginSpecies newSp2 = new PluginSpecies(PluginSpeciesSymbolType.PROTEIN_GENERIC,"test2");
				PluginSpeciesReference nref2 = new PluginSpeciesReference(re,newSp2.getSpeciesAlias(0));
				newSp2.getSpeciesAlias(0).setFramePosition(10,10);
				re.addProduct(nref2);
				
				model.addSpecies(newSp2);
				
				PluginSpecies newSp3 = new PluginSpecies(PluginSpeciesSymbolType.PROTEIN_GENERIC,"test3");
				PluginModifierSpeciesReference nref3 = new PluginModifierSpeciesReference(re,newSp3.getSpeciesAlias(0));
				newSp3.getSpeciesAlias(0).setFramePosition(20,20);
				nref3.setModificationType(PluginReactionSymbolType.TRANSPORT);
				re.addModifier(nref3);
				
				model.addSpecies(newSp3);
				
				model.addReaction(re);
			}
		}
		//KineticLaw
		else if(KINETICLAWS == PluginSampleDialog.tabPane.getSelectedIndex()){
//			PluginReaction re = model.getReaction(0);
//			sbase = new PluginKineticLaw(re);
//			
//			re.setKineticLaw((PluginKineticLaw) sbase);
		}
		//Comaprtment
		else if(COMPARTMENTS == PluginSampleDialog.tabPane.getSelectedIndex()){
			sbase = new PluginCompartment(PluginCompartmentSymbolType.SQUARE);
			((PluginCompartment)sbase).setName("test");
			((PluginCompartment)sbase).setX(100);
			((PluginCompartment)sbase).setY(100);
			((PluginCompartment)sbase).setWidth(100);
			((PluginCompartment)sbase).setHeight(100);
			model.addCompartment((PluginCompartment) sbase);
		}
		//local parameter
//		else if(8 == PluginSampleDialog.tabPane.getSelectedIndex()){		
//			PluginKineticLaw ki = model.getReaction(0).getKineticLaw(); 
//			sbase = new PluginParameter(ki);			
//			((PluginParameter) sbase).setId("test1");
//			
//			ki.addParameter((PluginParameter) sbase);
//		}
		//global parameter
		else if(G_PARAMETERS == PluginSampleDialog.tabPane.getSelectedIndex()){	
			sbase = new PluginParameter(model);
			((PluginParameter) sbase).setId("test1");
			model.addParameter((PluginParameter) sbase);
		}
		//FunctionDefinition
		else if(FUNCTIONS == PluginSampleDialog.tabPane.getSelectedIndex()){
			sbase = new PluginFunctionDefinition("test1");
			model.addFunctionDefinition((PluginFunctionDefinition) sbase);
		}
		//UnitDefinition
		else if(UNITDEFINITIONS == PluginSampleDialog.tabPane.getSelectedIndex()){		
			sbase = new PluginUnitDefinition("test1");
//			PluginUnitDefinitionDialog d = new PluginUnitDefinitionDialog((PluginUnitDefinition) sbase,true);
			
			model.addUnitDefinition((PluginUnitDefinition) sbase);
		}
//		//Unit
//		else if(11 == PluginSampleDialog.tabPane.getSelectedIndex()){
//			PluginUnitDefinition def = model.getUnitDefinition(0);
//			sbase = new PluginUnit(def);
//			def.addUnit((PluginUnit) sbase);			
//		}
		//Rule
		else if(RULES == PluginSampleDialog.tabPane.getSelectedIndex()){	
			sbase = new PluginAlgebraicRule(model);
			model.addRule((PluginRule) sbase);
			
			System.out.println("sbase PARENT MODEL " + ((PluginAlgebraicRule)sbase).getParentModel().getNumRules());			
			System.out.println("MODEL " + model.getNumRules());
		}
		//Event
		else if(EVENTS == PluginSampleDialog.tabPane.getSelectedIndex()){										
			sbase = new PluginEvent("test1");
			model.addEvent((PluginEvent) sbase);
		}
		
		System.out.println(PluginSampleDialog.plug.notifySBaseAdded(sbase));
		
		PluginSampleDialog.updateTable();

	}

	protected void deleteData() {
		PluginSBase sbase = null;
		
		if(((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow() == -1){
			return;
		}
		
		PluginModel model= PluginSampleDialog.model;
		
		//Species
		if(SPECIES == PluginSampleDialog.tabPane.getSelectedIndex()){
			sbase = model.getSpecies(
					((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow());			
		    model.removeSpecies(((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow());
		
		    // Plugin must delete the Reaction whose Species (Reactant, Product, Modifier) is deleted by the Plugin.
		    PluginListOf list = new PluginListOf();
		    PluginSpecies target = (PluginSpecies)sbase;
		    for(int i = 0 ; i < target.getListOfSpeciesAlias().size() ; i++){
		    	PluginSpeciesAlias alias = target.getSpeciesAlias(i);
		    	for(int k = 0 ; k < model.getNumReactions() ; k++){
		    		PluginReaction re = model.getReaction(k);
		    		
		    		for(int j = 0 ; j < re.getNumReactants() ; j++){
		    			PluginSpeciesReference ref = re.getReactant(j);
		    			if(ref.getAlias().getAliasID().equals(alias.getAliasID())){
		    				re.removeReactant(j);
		    				break;
		    			}
		    		}
		    		for(int j = 0 ; j < re.getNumProducts() ; j++){
		    			PluginSpeciesReference ref = re.getProduct(j);
		    			if(ref.getAlias().getAliasID().equals(alias.getAliasID())){
		    				re.removeProduct(j);
		    				break;
		    			}
		    		}
		    		for(int j = 0 ; j < re.getNumModifiers() ; j++){
		    			PluginModifierSpeciesReference ref = re.getModifier(j);
		    			if(ref.getAlias().getAliasID().equals(alias.getAliasID())){
		    				re.removeModifier(j);
		    				break;
		    			}
		    		}
		    		
		    		if(!PluginReactionSymbolType.isValidReaction(re)){
		    			list.append(re);
		    		}
		    	}
		    }
		    
		    for(int i = 0 ; i < list.size() ; i++){
		    	model.removeReaction(((PluginReaction)list.get(i)).getId());
		    }
		
		}
		//alias
		else if(SPECIES_ALIAS == PluginSampleDialog.tabPane.getSelectedIndex()){	
			PluginSpeciesAlias alias = (PluginSpeciesAlias) model.getListOfAllSpeciesAlias().get(getViewTabel().getSelectedRow());
			alias.getSpecies().removeSpeciesAlias(alias.getAliasID());
			if(alias.getSpecies().getNumSpeciesAlias() == 0){
				model.removeSpecies(alias.getSpecies().getId());	
				if(alias.getProtein() != null){
					if(model.getListOfSpecies(alias.getProtein()).size() == 0){
						model.removeProtein(alias.getProtein());
					}
				}
				else if(alias.getRNA() != null){
					if(model.getListOfSpecies(alias.getRNA()).size() == 0){
						model.removeRNA(alias.getRNA());
					}
				}
				else if(alias.getGene() != null){
					if(model.getListOfSpecies(alias.getGene()).size() == 0){
						model.removeGene(alias.getGene());
					}
				}
				else if(alias.getAntiSenseRNA() != null){
					if(model.getListOfSpecies(alias.getAntiSenseRNA()).size() == 0){
						model.removeAntiSenseRNA(alias.getAntiSenseRNA());
					}
				}

			}
			
			sbase = alias;
			
		    // Plugin must delete the Reaction whose SpeciesAlias (Reactant, Product, Modifier) is deleted by the Plugin.			
		    PluginListOf list = new PluginListOf();		    
	    	for(int k = 0 ; k < model.getNumReactions() ; k++){
	    		PluginReaction re = model.getReaction(k);
	    		
	    		for(int j = 0 ; j < re.getNumReactants() ; j++){
	    			PluginSpeciesReference ref = re.getReactant(j);
	    			if(ref.getAlias().getAliasID().equals(alias.getAliasID())){
	    				re.removeReactant(j);
	    				break;
	    			}
	    		}
	    		for(int j = 0 ; j < re.getNumProducts() ; j++){
	    			PluginSpeciesReference ref = re.getProduct(j);
	    			if(ref.getAlias().getAliasID().equals(alias.getAliasID())){
	    				re.removeProduct(j);
	    				break;
	    			}
	    		}
	    		for(int j = 0 ; j < re.getNumModifiers() ; j++){
	    			PluginModifierSpeciesReference ref = re.getModifier(j);
	    			if(ref.getAlias().getAliasID().equals(alias.getAliasID())){
	    				re.removeModifier(j);
	    				break;
	    			}
	    		}
	    		
	    		if(!PluginReactionSymbolType.isValidReaction(re)){
	    			list.append(re);
	    		}
	    	}
		    
		    for(int i = 0 ; i < list.size() ; i++){
		    	model.removeReaction(((PluginReaction)list.get(i)).getId());
		    }
		}
		//reaction
		else if(REACTIONS == PluginSampleDialog.tabPane.getSelectedIndex()){	
			sbase = model.getReaction(
					((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow());			
			model.removeReaction(((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow());
		}
		//KineticLaw
		else if(KINETICLAWS == PluginSampleDialog.tabPane.getSelectedIndex()){
		}
		//Comaprtment
		else if(COMPARTMENTS == PluginSampleDialog.tabPane.getSelectedIndex()){
			sbase = model.getCompartment(
					((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow());
			model.removeCompartment(((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow());
		}
		//local parameter
//		else if(4 == PluginSampleDialog.tabPane.getSelectedIndex()){		
//			PluginReaction re = model.getReaction(0);
//			sbase = re.getKineticLaw().getParameter(((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow());
//			re.getKineticLaw().removeParameter(((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow());
//		}
		//global parameter
		else if(G_PARAMETERS == PluginSampleDialog.tabPane.getSelectedIndex()){	
			sbase = model.getParameter(
					((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow());
			model.removeParameter(((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow());
		}
		//FunctionDefinition
		else if(FUNCTIONS == PluginSampleDialog.tabPane.getSelectedIndex()){
			sbase = model.getFunctionDefinition(
					((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow());
		    model.removeFunctionDefinition(((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow());
		}
		//UnitDefinition
		else if(UNITDEFINITIONS == PluginSampleDialog.tabPane.getSelectedIndex()){		
			sbase = model.getUnitDefinition(
					((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow());
		    model.removeUnitDefinition(((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow());
		}
//		//Unit
//		else if(11 == PluginSampleDialog.tabPane.getSelectedIndex()){			
//			PluginUnitDefinition def = model.getUnitDefinition(0);
//
//			sbase = def.getUnit(((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow());
//            def.removeUnit(((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow());
//		}
		//Rule
		else if(RULES == PluginSampleDialog.tabPane.getSelectedIndex()){	
			sbase = model.getRule(
					((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow());
		    model.removeRule(((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow());
		
		}
		//Event
		else if(EVENTS == PluginSampleDialog.tabPane.getSelectedIndex()){										
			sbase = model.getEvent(
					((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow());
		    model.removeEvent(((CommonSBaseViewingTab)PluginSampleDialog.tabPane.getSelectedComponent()).getViewTabel().getSelectedRow());
		}
		
		System.out.println(PluginSampleDialog.plug.notifySBaseDeleted(sbase));
		sbase = null;
		PluginSampleDialog.updateTable();
	}

	protected Object[][] formatForTableData() {
		ArrayList newData = new ArrayList();
        
		// It changes in the storage form for the display. 
		if(listOfSBase == null){
			return new Object[0][0];
		}
			
		for( int i = 0;  i < listOfSBase.size(); i++) {
			ArrayList rowData = new ArrayList();
			
			if(tabName.equals(PluginSampleDialog.SPECIES)){
				PluginSpecies species = (PluginSpecies) listOfSBase.get(i);
				
				if(species.getSpeciesAlias(0) != null){
					rowData.add(/*species.getSpeciesTypeForView()*/species.getSpeciesAlias(0).getExtensionType());						

					if(species.getSpeciesAlias(0).getExtensionId() != null){
						rowData.add(species.getSpeciesAlias(0).getExtensionId());	
					}
					else{
						rowData.add("null");
					}

				}
				else{		
					rowData.add("NULL");
					rowData.add("null");
				}
								
				rowData.add(species.getPositionToCompartment());
				rowData.add(species.getId());
				rowData.add(species.getName());
				rowData.add(species.getCompartment());
				if (species.isSetInitialAmount())
				{
					rowData.add("Amount");
					rowData.add(String.valueOf(species.getInitialAmount()));
				}
				else if (species.isSetInitialConcentration())
				{
					rowData.add("Concentration");
					rowData.add(String.valueOf(species.getInitialConcentration()));
				}
				else
				{
					rowData.add("");
					rowData.add("");
				}
				rowData.add(species.getSubstanceUnits());
				rowData.add(species.getSpatialSizeUnits());
				rowData.add(new Boolean(species.getHasOnlySubstanceUnits()));				
				rowData.add(new Boolean(species.getBoundaryCondition()));
				rowData.add(String.valueOf(species.getCharge()));
				rowData.add(new Boolean(species.getConstant()));
				
				//annotation info
//				rowData.add(String.valueOf(species.getX()));
//				rowData.add(String.valueOf(species.getY()));
//				rowData.add(String.valueOf(species.getWidth()));
//				rowData.add(String.valueOf(species.getHeight()));
				
				rowData.add(String.valueOf(species.getNotesString()));
				
				newData.add(rowData);
			}	
			else if(tabName.equals(PluginSampleDialog.SPECIES_ALIAS)){
				PluginSpeciesAlias species = (PluginSpeciesAlias) listOfSBase.get(i);
				
				rowData.add(species.getSpecies().getId() + "//" + species.getModifications().size());
				rowData.add(species.getAliasID());
				rowData.add(species.getExtensionType());
				rowData.add(species.getName());
				rowData.add(Double.toString(species.getX()));
				rowData.add(Double.toString(species.getY()));
				
				newData.add(rowData);
			}
			else if(tabName.equals(PluginSampleDialog.PROTEINS)){
				PluginProtein species = (PluginProtein) listOfSBase.get(i);
				
				rowData.add(species.getType());
				rowData.add(species.getExtensionId());
				rowData.add(species.getName());
				rowData.add(species.getNotesString());
				
				newData.add(rowData);
			}
			else if(tabName.equals(PluginSampleDialog.GENES)){
				PluginGene species = (PluginGene) listOfSBase.get(i);
				
				rowData.add(species.getType());
				rowData.add(species.getExtensionId());
				rowData.add(species.getName());
				rowData.add(species.getNotesString());
				
				newData.add(rowData);
			}
			else if(tabName.equals(PluginSampleDialog.RNAS)){
				PluginRNA species = (PluginRNA) listOfSBase.get(i);
				
				rowData.add(species.getType());
				rowData.add(species.getExtensionId());
				rowData.add(species.getName());
				rowData.add(species.getNotesString());
				
				newData.add(rowData);
			}
			else if(tabName.equals(PluginSampleDialog.AS_RNAS)){
				PluginAntiSenseRNA species = (PluginAntiSenseRNA) listOfSBase.get(i);
				
				rowData.add(species.getType());
				rowData.add(species.getExtensionId());
				rowData.add(species.getName());
				rowData.add(species.getNotesString());
				
				newData.add(rowData);
			}			
			else if(tabName.equals(PluginSampleDialog.REACTIONS)){
				PluginReaction reaction = (PluginReaction) listOfSBase.get(i);
				
				rowData.add(reaction.getReactionType());
				rowData.add(reaction.getId());
				rowData.add(reaction.getName());
				rowData.add(new Boolean(reaction.getReversible()));				
				rowData.add(new Boolean(reaction.getFast()));
				
				String reactants = "";
				for(int k = 0 ; k < reaction.getNumReactants() ; k++){
					reactants += reaction.getReactant(k).getSpecies();
					if(k+1 < reaction.getNumReactants()){
						reactants += ",";
					}
				}
				rowData.add(reactants);
				
				String products = "";
				for(int k = 0 ; k < reaction.getNumProducts() ; k++){
					products += reaction.getProduct(k).getSpecies();
					if(k+1 < reaction.getNumProducts()){
						products += ",";
					}
				}
				rowData.add(products);
				
				String modifiers = "";
				for(int k = 0 ; k < reaction.getNumModifiers() ; k++){
					modifiers += reaction.getModifier(k).getSpecies();
					if(k+1 < reaction.getNumModifiers()){
						modifiers += ",";
					}
				}
				rowData.add(modifiers);
				
				if(reaction.getKineticLaw() != null){
					rowData.add(reaction.getKineticLaw().getFormula());	
				}
				else{
					rowData.add("");
				}
				
				//annotation info
				rowData.add(String.valueOf(reaction.getLineWidth()));
				rowData.add(String.valueOf(reaction.getNotesString()));
				
				newData.add(rowData);
			}	
			else if(tabName.equals(PluginSampleDialog.KINETICLAWS)){
				PluginKineticLaw compartment = (PluginKineticLaw) listOfSBase.get(i);
			
				if(compartment == null){
					rowData.add("");
					rowData.add("");
					rowData.add("");
				}
				else{
					if(compartment.getFormula() == null){
						rowData.add("");	
					}
					else{
						rowData.add(compartment.getFormula());
					}
					
					rowData.add(compartment.getSubstanceUnits());
					rowData.add(compartment.getTimeUnits());
				}
				
				newData.add(rowData);
			}
			else if(tabName.equals(PluginSampleDialog.COMPARTMENTS)){
				PluginCompartment compartment = (PluginCompartment) listOfSBase.get(i);
			
				rowData.add(compartment.getId());
				rowData.add(compartment.getName());
				rowData.add(String.valueOf(compartment.getSpatialDimensions()));
				rowData.add(String.valueOf(compartment.getSize()));
				rowData.add(compartment.getUnits());
				rowData.add(compartment.getOutside());
				rowData.add(new Boolean(compartment.getConstant()));
				
				//annotation info
				rowData.add(String.valueOf(compartment.getX()));
				rowData.add(String.valueOf(compartment.getY()));
				rowData.add(String.valueOf(compartment.getWidth()));
				rowData.add(String.valueOf(compartment.getHeight()));
				rowData.add(String.valueOf(compartment.getNotesString()));
				
				newData.add(rowData);
			}
			else if(tabName.equals(PluginSampleDialog.LOCAL_PARAM)){
				PluginParameter parameter = (PluginParameter) listOfSBase.get(i);
				
				rowData.add(parameter.getParentSBaseID() + ":" + parameter.getId());
				rowData.add(parameter.getName());
				rowData.add(String.valueOf(parameter.getValue()));
				rowData.add(parameter.getUnits());
				rowData.add(new Boolean(parameter.getConstant()));
				
				newData.add(rowData);
			}
			else if(tabName.equals(PluginSampleDialog.PARAMETERS)){
				PluginParameter parameter = (PluginParameter) listOfSBase.get(i);
				
				rowData.add(parameter.getId());
				rowData.add(parameter.getName());
				rowData.add(String.valueOf(parameter.getValue()));
				rowData.add(parameter.getUnits());
				rowData.add(new Boolean(parameter.getConstant()));
				
				newData.add(rowData);
			}
			else if(tabName.equals(PluginSampleDialog.FUNCTIONS)){
				PluginFunctionDefinition function = (PluginFunctionDefinition) listOfSBase.get(i);
				
				rowData.add(function.getId());
				rowData.add(function.getName());
				rowData.add("argument");
				rowData.add("math");
				
				if(function.getMath() != null){
					rowData.add(libsbml.formulaToString(function.getMath()));	
				}				
				
				newData.add(rowData);
			}
			else if(tabName.equals(PluginSampleDialog.UNIT_DEFINITIONS)){
				PluginUnitDefinition unitsDefinition = (PluginUnitDefinition) listOfSBase.get(i);
				
				rowData.add(unitsDefinition.getId());
				rowData.add(unitsDefinition.getName());
				String units = "";
				for(int k = 0 ; k < unitsDefinition.getNumUnits() ; k++){
					units += unitsDefinition.getUnit(k);
					if(k+1 < unitsDefinition.getNumUnits()){
						units += ",";
					}
				}
				rowData.add(units);			
				
				newData.add(rowData);
			}
			else if(tabName.equals(PluginSampleDialog.RULES)){
				PluginRule rule = (PluginRule) listOfSBase.get(i);
				
				if(rule instanceof PluginAssignmentRule){
					PluginAssignmentRule r = (PluginAssignmentRule)rule;
					rowData.add("AssignmentRule");
					rowData.add(r.getFormula());
					rowData.add(r.getVariable());
				}
				else if(rule instanceof PluginRateRule){
					PluginRateRule r = (PluginRateRule)rule;
					rowData.add("RateRule");
					rowData.add(r.getFormula());
					rowData.add(r.getVariable());
				}
				else{
					rowData.add("AlgebraicRule");
					rowData.add(rule.getFormula());				
					rowData.add("");
				}
				
				newData.add(rowData);
			}
			else if(tabName.equals(PluginSampleDialog.EVENTS)){
				PluginEvent unitsDefinition = (PluginEvent) listOfSBase.get(i);
				
				rowData.add(unitsDefinition.getId());
				rowData.add(unitsDefinition.getName());
				if(unitsDefinition.getTrigger() != null)
				{
					rowData.add(libsbml.formulaToString(unitsDefinition.getTrigger().getMath()));
				}
				else
				{
					rowData.add("");
				}
				if(unitsDefinition.getDelay() != null)
				{
					rowData.add(libsbml.formulaToString(unitsDefinition.getDelay().getMath()));
				}
				else
				{
					rowData.add("");
				}
				rowData.add(unitsDefinition.getTimeUnits());
				
				newData.add(rowData);
			}
		}

		// It changes from Vector. 
		Object[][] arrayData = new Object[newData.size()][1];
		for(int i = 0; i < newData.size() ; i++) {
			ArrayList data = (ArrayList)newData.get(i);
			arrayData[i] = data.toArray();
		}

		return arrayData;
	}
	
	protected PluginListOf formatForArrayList() {
		return listOfSBase;
	}

	/**
	 * buttonAdd_actionPerformed
	 */
	protected void buttonAdd_actionPerformed() {
		this.addData();
	}

	/**
	 * buttonDelete_actionPerformed
	 */
	protected void buttonDelete_actionPerformed() { 
		deleteData();
	}

	protected void buttonEdit_actionPerformed() {
		PluginModel model= PluginSampleDialog.model;
		
		if(SPECIES_ALIAS == PluginSampleDialog.tabPane.getSelectedIndex()){
			PluginSpeciesNodeDialog d = new PluginSpeciesNodeDialog((PluginSpeciesAlias) model.getListOfAllSpeciesAlias().get(getViewTabel().getSelectedRow()));
		}
		else if(REACTIONS == PluginSampleDialog.tabPane.getSelectedIndex()){
			PluginReactionDialog d = new PluginReactionDialog(model.getReaction(getViewTabel().getSelectedRow()),false);
		}
		else if(UNITDEFINITIONS == PluginSampleDialog.tabPane.getSelectedIndex()){
			PluginUnitDefinitionDialog d = new PluginUnitDefinitionDialog(model.getUnitDefinition(getViewTabel().getSelectedRow()),false);
		}
		else if(EVENTS == PluginSampleDialog.tabPane.getSelectedIndex()){
			PluginEventDialog d = new PluginEventDialog(model.getEvent(getViewTabel().getSelectedRow()),false);
		}	
		else if(PROTEINS == PluginSampleDialog.tabPane.getSelectedIndex()){
			PluginProteinDialog d = new PluginProteinDialog(model.getListOfProteins().get(getViewTabel().getSelectedRow()));
		}	
		else if(GENES == PluginSampleDialog.tabPane.getSelectedIndex()){
			PluginGeneRNADialog d = new PluginGeneRNADialog(model.getListOfGenes().get(getViewTabel().getSelectedRow()));
		}	
		else if(RNAS == PluginSampleDialog.tabPane.getSelectedIndex()){
			PluginGeneRNADialog d = new PluginGeneRNADialog(model.getListOfRNAs().get(getViewTabel().getSelectedRow()));
		}	
		else if(ASRNAS == PluginSampleDialog.tabPane.getSelectedIndex()){
			PluginGeneRNADialog d = new PluginGeneRNADialog(model.getListOfAntiSenseRNAs().get(getViewTabel().getSelectedRow()));
		}	
	}


}
