package plugin.sample2.dialog;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;

import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import plugin.sample2.table.SBaseViewingTable;

import jp.sbi.celldesigner.plugin.PluginListOf;

public abstract class BaseTabPanel extends JPanel{

	/** tabName*/
	protected String tabName;
	
	/** buttonAdd */
	private JButton buttonAdd;
	
	/** buttonEdit */
	private JButton buttonEdit;
		
	/** buttonDelete */
	private JButton buttonDelete;
		
	/** resultTabel */
	protected SBaseViewingTable viewTabel;
		
	/** listOfJars*/
	protected PluginListOf listOfSBase;
		
	/**
	 * initTabPanel
	 */
	protected void initTabPanel(){
		//createNorthPanel
		add(createNorthPanel() , BorderLayout.NORTH);
		
		add(createCenterPanel() , BorderLayout.CENTER);
				
	}
	
	/**
	 * createNorthPanel
	 */
	private JPanel createNorthPanel(){
		JPanel innerNorthPanel = new JPanel(new BorderLayout());
		
		buttonAdd = new JButton("Add");
		buttonAdd.addActionListener(new java.awt.event.ActionListener(){
			public void actionPerformed(ActionEvent e){
				buttonAdd_actionPerformed();
			}
		});		
		buttonAdd.setEnabled(true);
		
		buttonEdit = new JButton("Edit");
		buttonEdit.addActionListener(new java.awt.event.ActionListener(){
			public void actionPerformed(ActionEvent e){
				buttonEdit_actionPerformed();
			}
		});		
		buttonEdit.setEnabled(true);
		
		buttonDelete = new JButton("Delete");
		buttonDelete.addActionListener(new java.awt.event.ActionListener(){
			public void actionPerformed(ActionEvent e){
				buttonDelete_actionPerformed();
			}
		});				
		buttonDelete.setEnabled(true);
		
		JPanel innerPanel = new JPanel();
		innerPanel.add(buttonAdd);
		innerPanel.add(buttonEdit);
		innerPanel.add(buttonDelete);
		
		innerNorthPanel.add(innerPanel , BorderLayout.WEST);		
		
		return innerNorthPanel;
	}
	
	/**
	 * createCenterPanel
	 */
	private JScrollPane createCenterPanel(){
		JScrollPane tabelScrool = new JScrollPane();
		tabelScrool.setPreferredSize(new Dimension(550,350));
		
		viewTabel = new SBaseViewingTable(formatForTableData(),tabName);
		
		tabelScrool.getViewport().add(viewTabel, null);
		
		return tabelScrool;
	}
	
	/**
	 * addData
	 */
	protected abstract void addData();
	
	/**
	 * deleteData
	 */
	protected abstract void deleteData();
	
	/**
	 * formatForTableData
	 */
	protected abstract Object[][] formatForTableData();
	
	/**
	 * formatForTableData
	 */
	protected abstract PluginListOf formatForArrayList();
	
	/**
	 * formatTableData
	 */
	protected abstract void buttonAdd_actionPerformed();
	
	/**
	 * formatTableData
	 */
	protected abstract void buttonEdit_actionPerformed();
	
	/**
	 * formatTableData
	 */
	protected abstract void buttonDelete_actionPerformed();

	/**
	 * 
	 * @return
	 */
	public SBaseViewingTable getViewTabel() {
		return viewTabel;
	}
	
	/**
	 * 
	 * @param b
	 */
	public void setAllButtonEnable(boolean b){
		buttonAdd.setEnabled(b);
		buttonDelete.setEnabled(b);
		buttonEdit.setEnabled(b);
	} 
	
	/**
	 * 
	 * @param b
	 */
	public void setDeleteButtonEnable(boolean b){
		buttonDelete.setEnabled(b);
	}
	
	/**
	 * 
	 * @param b
	 */
	public void setEditButtonEnable(boolean b){
		buttonEdit.setEnabled(b);
    }
}
