package plugin.sample2;

import plugin.sample2.dialog.PluginSampleDialog;
import jp.sbi.celldesigner.plugin.*;

/**
 * SamplePlugin2
 * 
 *  This plugin opens a tabbed table of elements in the selected model.
 *  In the table, you can see the list of selected element.
 *  You can also edit, add, and delete the selcted element.
 *  This plugin can open not only from "Plugin" menu bar but also from "Species"
 *  context menu (opened by selecting species and right click) or "Reaction" context menu.
 * 
 * @author The Systems Biology Institute and Mitsui Knowledge Industry Co. Ltd.
  */
public class SamplePlugin2 extends CellDesignerPlugin{

	private SampleAction2 test;
	
	private SampleAction2 test2;
	
	private SampleAction2 test3;
	
	/**
	 * Constructor
	 */
	public SamplePlugin2(){
		addPluginMenu();
	}	
		
	/**
	 * addPluginMenu
	 * @return PluginMenu
	 */
	public void addPluginMenu() {
		PluginMenu menu = new PluginMenu("Sample Plugin2");
		//main menu
		test = new SampleAction2(this,menu);
		PluginMenuItem item1 = new PluginMenuItem("Open Sample Plugin2 table"  , test);		
		
		menu.add(item1);
				
		addCellDesignerPluginMenu(menu);
		
		//	species menu		
		PluginMenu menu2 = new PluginMenu("Sample Plugin2");

		test2 = new SampleAction2(this,menu2);
		PluginMenuItem item2 = new PluginMenuItem("Open Sample Plugin2 table from Species menu" , test2);		
		
		menu2.add(item2);
				
		addSpeciesPopupMenuSeparator();
		addSpeciesPopupMenu(menu2);
		
		//reaction menu		
		PluginMenu menu3 = new PluginMenu("Plugin Sample2");

		test3 = new SampleAction2(this,menu3);
		PluginMenuItem item3 = new PluginMenuItem("Open Sample Plugin2  table from Reaction" , test3);		
		
		menu3.add(item3);
		
		addReactionPopupMenuSeparator();
		addReactionPopupMenu(menu3);
	}
	
	public void SBaseAdded(PluginSBase sbase) {
		System.out.println("SamplePlugin2 SBaseAdded = " + sbase);		
        if(sbase == null ||
        		PluginSampleDialog.model == null){
        	return;
        }
		if(sbase instanceof PluginSpecies){
			PluginSampleDialog.model.addSpecies((PluginSpecies) sbase);
			System.out.println("add ((PluginSpecies) sbase).getId() = " + ((PluginSpecies) sbase).getId());
		}
		else if(sbase instanceof PluginSpeciesAlias){
			PluginSpeciesAlias alias = (PluginSpeciesAlias)sbase;
			PluginSpecies parent = PluginSampleDialog.model.getSpecies(alias.getSpecies().getId());
			if(parent != null){
				parent.addSpeciesAlias(alias);
			}
		}
		else if(sbase instanceof PluginCompartment){
			PluginSampleDialog.model.addCompartment((PluginCompartment) sbase);
		}
		else if(sbase instanceof PluginReaction){
			PluginSampleDialog.model.addReaction((PluginReaction) sbase);
		}
		else if(sbase instanceof PluginParameter){
			PluginSampleDialog.model.addParameter((PluginParameter) sbase);
		}
		else if(sbase instanceof PluginFunctionDefinition){
			PluginSampleDialog.model.addFunctionDefinition((PluginFunctionDefinition) sbase);
		}
		else if(sbase instanceof PluginUnitDefinition){
			PluginSampleDialog.model.addUnitDefinition((PluginUnitDefinition) sbase);
		}
		else if(sbase instanceof PluginRule){
			PluginSampleDialog.model.addRule((PluginRule) sbase);
		}
		else if(sbase instanceof PluginEvent){
			PluginSampleDialog.model.addEvent((PluginEvent) sbase);
		}
		test.updateTable();
	}

	public void SBaseChanged(PluginSBase sbase) {
		System.out.println("SamplePlugin2 SBaseChanged = " + sbase);
		if(sbase == null ||
				PluginSampleDialog.model == null){
			return;
		}
		if(sbase instanceof PluginSpecies){
			PluginSpecies sp = PluginSampleDialog.model.getSpecies(((PluginSpecies) sbase).getId());
			System.out.println("((PluginSpecies) sbase).getId() = " + ((PluginSpecies) sbase).getId());			
			System.out.println("sp = " + sp);			
            if(sp != null){
                sp.update((PluginSpecies) sbase);
//              System.out.println("add ((PluginSpecies) sbase).Notes = " + ((PluginSpecies) sbase).getNotes());            	
            }
		}
		else if(sbase instanceof PluginSpeciesAlias){
			PluginSpeciesAlias alias = (PluginSpeciesAlias)sbase;
			PluginSpecies parent = PluginSampleDialog.model.getSpecies(alias.getSpecies().getId());
			if(parent == null){
				return;
			}
			PluginSpeciesAlias target = parent.getSpeciesAlias(alias.getAliasID());
			System.out.println("parent = " + parent.getId());				
			System.out.println("target = " + target);		
			System.out.println("alias.getAliasID() = " + alias.getAliasID());
			target.update(alias);
		}
		else if(sbase instanceof PluginProtein){
			PluginProtein target = PluginSampleDialog.model.getProtein(((PluginProtein) sbase).getExtensionId());
			if(target == null){
				return;
			}
			target.update((PluginProtein) sbase);
		}
		else if(sbase instanceof PluginGene){
			PluginGene target = PluginSampleDialog.model.getGene(((PluginGene) sbase).getExtensionId());
			if(target == null){
				return;
			}
			target.update((PluginGene) sbase);
		}
		else if(sbase instanceof PluginRNA){
			PluginRNA target = PluginSampleDialog.model.getRNA(((PluginRNA) sbase).getExtensionId());
			if(target == null){
				return;
			}
			target.update((PluginRNA) sbase);
		}
		else if(sbase instanceof PluginAntiSenseRNA){
			PluginAntiSenseRNA target = PluginSampleDialog.model.getAntiSenseRNA(((PluginAntiSenseRNA) sbase).getExtensionId());
			if(target == null){
				return;
			}
			target.update((PluginAntiSenseRNA) sbase);
		}
		else if(sbase instanceof PluginCompartment){
			PluginCompartment sp = PluginSampleDialog.model.getCompartment(((PluginCompartment) sbase).getId());
			if(sp == null){
				return;
			}
			sp.update((PluginCompartment) sbase);
		}
		else if(sbase instanceof PluginReaction){
			PluginReaction sp = PluginSampleDialog.model.getReaction(((PluginReaction) sbase).getId());
			if(sp != null){
				sp.update((PluginReaction) sbase);	
			}			
		}
		else if(sbase instanceof PluginParameter){
			PluginParameter param = PluginSampleDialog.model.getParameter(((PluginParameter) sbase).getId());
			System.out.println("param = " + ((PluginParameter) sbase).getId());			
			if(param != null){
				System.out.println("param id = " + param.getId());				
				param.update((PluginParameter) sbase);	
			}	
		}
		else if(sbase instanceof PluginModel){
			PluginSampleDialog.model = (PluginModel) sbase;
			System.out.println("update PluginModel id" + ((PluginModel)sbase).getId());			
			System.out.println("update PluginModel name" + ((PluginModel)sbase).getName());
		}
		else if(sbase instanceof PluginFunctionDefinition){
			PluginFunctionDefinition fc = PluginSampleDialog.model.getFunctionDefinition(((PluginFunctionDefinition) sbase).getId());
			if(fc != null){
				fc.update((PluginFunctionDefinition) sbase);	
			}
		}
		else if(sbase instanceof PluginUnitDefinition){
			PluginUnitDefinition fc = PluginSampleDialog.model.getUnitDefinition(((PluginUnitDefinition) sbase).getId());
			if(fc != null){
				fc.update((PluginUnitDefinition) sbase);	
			}
		}
		else if(sbase instanceof PluginRule){
			PluginRule rule = (PluginRule) sbase;
			PluginModel upModel = rule.getParentModel();
			if(upModel == null){
				return;
			}
			PluginSampleDialog.model.setListOfRules(upModel.getListOfRules());
		}
		else if(sbase instanceof PluginEvent){
			PluginEvent fc = PluginSampleDialog.model.getEvent(((PluginEvent) sbase).getId());
			if(fc != null){
				fc.update((PluginEvent) sbase);	
			}
		}
		test.updateTable();

	}

	public void SBaseDeleted(PluginSBase sbase) {
		System.out.println("SamplePlugin2 SBaseDeleted = " + sbase);
		if(sbase == null ||
				PluginSampleDialog.model == null){
			return;
		}	
		if(sbase instanceof PluginSpecies){
			PluginSampleDialog.model.removeSpecies(((PluginSpecies) sbase).getId());
		}
		else if(sbase instanceof PluginSpeciesAlias){
			PluginSpeciesAlias alias = (PluginSpeciesAlias)sbase;
			PluginSpecies parent = PluginSampleDialog.model.getSpecies(alias.getSpecies().getId());
			if(parent == null){
				return;
			}
			parent.removeSpeciesAlias(alias.getAliasID());
		}
		else if(sbase instanceof PluginProtein){
			PluginSampleDialog.model.removeProtein((PluginProtein) sbase);
		}
		else if(sbase instanceof PluginGene){
			PluginSampleDialog.model.removeGene((PluginGene) sbase);
		}
		else if(sbase instanceof PluginRNA){
			PluginSampleDialog.model.removeRNA((PluginRNA) sbase);
		}
		else if(sbase instanceof PluginAntiSenseRNA){
			PluginSampleDialog.model.removeAntiSenseRNA((PluginAntiSenseRNA) sbase);
		}
		else if(sbase instanceof PluginCompartment){
			PluginSampleDialog.model.removeCompartment(((PluginCompartment) sbase).getId());
		}
		else if(sbase instanceof PluginReaction){
			PluginSampleDialog.model.removeReaction(((PluginReaction) sbase).getId());
		}
		else if(sbase instanceof PluginParameter){
			PluginSampleDialog.model.removeParameter(((PluginParameter) sbase).getId());
		}
		else if(sbase instanceof PluginFunctionDefinition){
			PluginSampleDialog.model.removeFunctionDefinition(((PluginFunctionDefinition) sbase).getId());
		}
		else if(sbase instanceof PluginUnitDefinition){
			PluginSampleDialog.model.removeUnitDefinition(((PluginUnitDefinition) sbase).getId());
		}
		else if(sbase instanceof PluginRule){
			PluginRule rule = (PluginRule) sbase;
			PluginModel upModel = rule.getParentModel();
			if(upModel == null){
				return;
			}
			PluginSampleDialog.model.setListOfRules(upModel.getListOfRules());
		}
		else if(sbase instanceof PluginEvent){
			PluginSampleDialog.model.removeEvent(((PluginEvent) sbase).getId());
		}
		test.updateTable();
	}

	public void modelOpened(PluginSBase sbase) {
		test.updateTable();
	}

	public void modelSelectChanged(PluginSBase sbase) {
		PluginSampleDialog.model = getSelectedModel();
        test.updateTable();		
	}

	public void modelClosed(PluginSBase sbase) {
		test.updateTable();		
	}
}
