/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.util;

import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.jeuclid.DOMMathBuilder;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.util.ResourceEntityResolver;
import org.apache.avalon.framework.logger.Logger;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ODFSupport {
    private ODFSupport() {
    }

    public static MathBase createMathBaseFromFile(File inFile, Logger log) throws SAXException, IOException {
        MathBase base = new MathBase(new Font("Arial Unicode MS", 0, 12));
        Document document = ODFSupport.parseFile(inFile, log);
        if (document != null) {
            new DOMMathBuilder(document, log, base);
        }
        return base;
    }

    public static Document parseFile(File inFile, Logger log) throws SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Document document = null;
        DocumentBuilder parser = null;
        try {
            parser = documentBuilderFactory.newDocumentBuilder();
            parser.setEntityResolver(new ResourceEntityResolver());
            parser.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException exception) throws SAXException {
                    throw exception;
                }

                public void fatalError(SAXParseException exception) throws SAXException {
                    throw exception;
                }

                public void warning(SAXParseException exception) throws SAXException {
                    throw exception;
                }
            });
            document = parser.parse(inFile.toString());
        }
        catch (SAXParseException se) {
            try {
                ZipFile zipFile = new ZipFile(inFile);
                ZipEntry contentEntry = zipFile.getEntry("content.xml");
                InputStream contentStream = zipFile.getInputStream(contentEntry);
                document = parser.parse(new InputSource(contentStream));
            }
            catch (SAXParseException e2) {
                log.warn("Parsing failed: " + se.getMessage());
                throw se;
            }
            catch (IOException io) {
                log.warn("Parsing failed: " + se.getMessage());
                throw se;
            }
        }
        catch (ParserConfigurationException pce) {
            log.error("Parsing failed: " + pce.getMessage());
        }
        return document;
    }
}

