/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.util.ODFSupport;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.shetline.io.GIFOutputStream;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class Converter {
    public static final String TYPE_SVG = "image/svg+xml";
    public static final String TYPE_GIF = "image/gif";

    private Converter() {
    }

    public static boolean convert(File inFile, File outFile, String outFileType, Logger log) throws IOException {
        block6: {
            try {
                log.info("Converting " + inFile + " to " + outFile + " ...");
                MathBase base = ODFSupport.createMathBaseFromFile(inFile, log);
                if (TYPE_GIF.equalsIgnoreCase(outFileType)) {
                    int width = base.getWidth();
                    int height = base.getHeight();
                    BufferedImage image = new BufferedImage(width, height, 1);
                    Graphics2D g = image.createGraphics();
                    Color transparency = new Color(78, 91, 234);
                    g.setColor(transparency);
                    g.fillRect(0, 0, width, height);
                    g.setColor(Color.black);
                    base.paint(g);
                    BufferedOutputStream buffer = new BufferedOutputStream(new FileOutputStream(outFile));
                    GIFOutputStream.writeGIF((OutputStream)buffer, (Image)image, (int)0, (Color)transparency);
                    buffer.flush();
                    buffer.close();
                    break block6;
                }
                if (TYPE_SVG.equalsIgnoreCase(outFileType)) {
                    DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
                    Document document = domImpl.createDocument(null, "svg", null);
                    SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
                    svgGenerator.setSVGCanvasSize(new Dimension(base.getWidth(), base.getHeight()));
                    base.paint((Graphics)svgGenerator);
                    boolean useCSS = true;
                    BufferedOutputStream buffer = new BufferedOutputStream(new FileOutputStream(outFile));
                    OutputStreamWriter out = new OutputStreamWriter((OutputStream)buffer, "UTF-8");
                    svgGenerator.stream((Writer)out, useCSS);
                    break block6;
                }
                Iterator<ImageWriter> it = ImageIO.getImageWritersByMIMEType(outFileType);
                if (it.hasNext()) {
                    ImageWriter writer = it.next();
                    int width = base.getWidth();
                    int height = base.getHeight();
                    BufferedImage image = new BufferedImage(width, height, 2);
                    Graphics2D g = image.createGraphics();
                    Color transparency = new Color(255, 255, 255, 0);
                    g.setColor(transparency);
                    g.fillRect(0, 0, width, height);
                    g.setColor(Color.black);
                    base.paint(g);
                    FileImageOutputStream ios = new FileImageOutputStream(outFile);
                    writer.setOutput(ios);
                    writer.write(image);
                    ios.close();
                    break block6;
                }
                log.error("Unsupported output type: " + outFileType);
                return false;
            }
            catch (SAXException ex) {
                log.error("Failed to process " + inFile + ": " + ex.getMessage());
                if (outFile != null) {
                    outFile.delete();
                }
                return false;
            }
        }
        return true;
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            Converter.showUsage();
        } else {
            try {
                Converter.convert(new File(args[0]), new File(args[1]), args[2], (Logger)new ConsoleLogger());
            }
            catch (IOException e) {
                System.out.println(String.valueOf(e.getClass().toString()) + ": " + e.getMessage());
                System.out.println();
                Converter.showUsage();
            }
        }
    }

    private static void showUsage() {
        System.out.println("JEuclid Converter");
        System.out.println("");
        System.out.println("Usage:");
        System.out.println("");
        System.out.println("Converter source target targettype");
        System.out.println("");
        System.out.println("where:");
        System.out.println(" source is the path to the source file (MathML or ODF format)");
        System.out.println(" target is the path to the target file");
        System.out.println(" targettype is one of the supported types:");
        System.out.print("    image/gif image/svg+xml");
        String[] iiotypes = ImageIO.getWriterMIMETypes();
        int i = 0;
        while (i < iiotypes.length) {
            System.out.print(" " + iiotypes[i]);
            ++i;
        }
        System.out.println();
        System.out.println();
    }
}

