/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.test;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.jeuclid.awt.MathComponent;
import net.sourceforge.jeuclid.util.ODFSupport;
import net.sourceforge.jeuclid.util.ResourceEntityResolver;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MathComponentTest {
    private static String test = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><math mode=\"display\"><mrow><munderover><mo>&#x0222B;</mo><mn>1</mn><mi>x</mi></munderover><mfrac><mi>dt</mi><mi>t</mi></mfrac></mrow></math>";

    public static void main(String[] args) {
        ConsoleLogger logger = new ConsoleLogger();
        try {
            Document document;
            if (args.length > 0) {
                document = ODFSupport.parseFile(new File(args[0]), (Logger)logger);
            } else {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder parser = documentBuilderFactory.newDocumentBuilder();
                parser.setEntityResolver(new ResourceEntityResolver());
                document = parser.parse(new InputSource(new StringReader(test)));
            }
            Frame frame = new Frame("Test MathComponent");
            frame.setLayout(new BorderLayout());
            MathComponent component = new MathComponent();
            component.setDocument(document);
            component.setLogger((Logger)logger);
            component.setDebug(false);
            frame.add((Component)component, "Center");
            frame.setVisible(true);
            frame.pack();
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    System.exit(0);
                }
            });
        }
        catch (SAXException e) {
            logger.error("SAXException:" + e.getMessage());
        }
        catch (IOException e) {
            logger.error("IOException:" + e.getMessage());
        }
        catch (ParserConfigurationException e) {
            logger.error("ParserConfigurationException:" + e.getMessage());
        }
    }
}

