/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.test;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sourceforge.jeuclid.swing.JMathComponent;
import net.sourceforge.jeuclid.util.ODFSupport;
import net.sourceforge.jeuclid.util.ResourceEntityResolver;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class JMathComponentTest {
    public static void main(String[] args) {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(new StreamSource("mmlctop2_0.xsl"));
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(new StreamSource("mathTest20070123.xml"), new StreamResult("test.xml"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        File inFile = new File("test.xml");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        ConsoleLogger logger = new ConsoleLogger();
        try {
            Document document;
            if (args.length > 0) {
                document = ODFSupport.parseFile(new File(args[0]), (Logger)logger);
            } else {
                DocumentBuilder parser = documentBuilderFactory.newDocumentBuilder();
                parser.setEntityResolver(new ResourceEntityResolver());
                document = parser.parse(inFile);
            }
            JFrame frame = new JFrame("Test MathComponent");
            frame.setDefaultCloseOperation(3);
            frame.getContentPane().setLayout(new BorderLayout());
            JMathComponent component = new JMathComponent();
            component.setLogger((Logger)logger);
            component.setDocument(document);
            component.setDebug(false);
            frame.getContentPane().add((Component)component, "Center");
            frame.setVisible(true);
            frame.pack();
            int width = frame.getWidth();
            int height = frame.getHeight();
            BufferedImage image = new BufferedImage(width, height, 4);
            Graphics2D graphics = image.createGraphics();
            frame.paintAll(graphics);
            graphics.dispose();
            ImageIO.write((RenderedImage)image, "jpeg", new File("test.jpeg"));
        }
        catch (SAXException e) {
            logger.error("SAXException:" + e.getMessage());
        }
        catch (IOException e) {
            logger.error("IOException:" + e.getMessage());
        }
        catch (ParserConfigurationException e) {
            logger.error("ParserConfigurationException:" + e.getMessage());
        }
    }
}

