/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.element.helpers;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import net.sourceforge.jeuclid.element.helpers.DictionaryException;
import net.sourceforge.jeuclid.element.helpers.UnknownAttributeException;
import org.apache.avalon.framework.logger.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class OperatorDictionary {
    public static final String DICTIONARY_FILE = "/net/sourceforge/jeuclid/element/helpers/moDictionary.xml";
    public static final String NAME_VERYVERYTHINMATHSPACE = "veryverythinmathspace";
    public static final String NAME_VERYTHINMATHSPACE = "verythinmathspace";
    public static final String NAME_THINMATHSPACE = "thinmathspace";
    public static final String NAME_MEDIUMMATHSPACE = "mediummathspace";
    public static final String NAME_THICKMATHSPACE = "thickmathspace";
    public static final String NAME_VERYTHICKMATHSPACE = "verythickmathspace";
    public static final String NAME_VERYVERYTHICKMATHSPACE = "veryverythickmathspace";
    public static final String NAME_INFINITY = "infinity";
    public static final int VALUE_PREFIX = 100;
    public static final int VALUE_INFIX = 101;
    public static final int VALUE_POSTFIX = 102;
    public static final String VALUE_UNKNOWN = "NULL";
    private static Hashtable dictionary;
    private static boolean isDictionaryRead;
    private static OperatorDictionary instance;
    private static Logger log;
    private static String[][] attributeDefValues;

    static {
        isDictionaryRead = false;
        instance = null;
        log = null;
        attributeDefValues = new String[][]{{"form", "infix"}, {"fence", "false"}, {"separator", "false"}, {"lspace", NAME_THICKMATHSPACE}, {"rspace", NAME_THICKMATHSPACE}, {"stretchy", "false"}, {"symmetric", "true"}, {"maxsize", NAME_INFINITY}, {"minsize", "1"}, {"largeop", "false"}, {"movablelimits", "false"}, {"accent", "false"}};
    }

    OperatorDictionary() throws DictionaryException {
        try {
            this.initialize();
        }
        catch (ParserConfigurationException e) {
            throw new DictionaryException("Cannot get SAXParser:" + e.getMessage());
        }
        catch (SAXException e) {
            throw new DictionaryException("SAXException during parsing dictionary:" + e.getMessage());
        }
        catch (IOException e) {
            throw new DictionaryException("The problems with dictionary XML reading");
        }
    }

    private void initialize() throws ParserConfigurationException, SAXException, IOException {
        InputStream dictInput = this.getClass().getResourceAsStream(DICTIONARY_FILE);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        XMLReader reader = factory.newSAXParser().getXMLReader();
        reader.setContentHandler(new DictionaryReader());
        reader.parse(new InputSource(dictInput));
    }

    public static String getDefaultAttributeValue(String operator, int form, String attributeName) throws UnknownAttributeException {
        String result;
        if (!isDictionaryRead) {
            try {
                isDictionaryRead = true;
                instance = new OperatorDictionary();
            }
            catch (DictionaryException e) {
                if (log != null) {
                    log.error(e.getMessage());
                }
                System.out.println(e.getMessage());
            }
        }
        if (instance != null) {
            Object attr = dictionary.get(String.valueOf(operator) + form);
            if (attr == null && form != 101) {
                attr = dictionary.get(String.valueOf(operator) + 101);
            }
            if (attr == null && form != 102) {
                attr = dictionary.get(String.valueOf(operator) + 102);
            }
            if (attr == null && form != 100) {
                attr = dictionary.get(String.valueOf(operator) + 100);
            }
            if (attr == null) {
                return VALUE_UNKNOWN;
            }
            String[][] attribute = (String[][])attr;
            int i = 0;
            while (i < attribute.length) {
                if (attribute[i][0].equals(attributeName)) {
                    return attribute[i][1];
                }
                ++i;
            }
        }
        if ((result = OperatorDictionary.getDefaultValue(attributeName)) != null) {
            return result;
        }
        throw new UnknownAttributeException(attributeName);
    }

    private static String getDefaultValue(String attributeName) {
        int i = 0;
        while (i < attributeDefValues.length) {
            if (attributeName.equalsIgnoreCase(attributeDefValues[i][0])) {
                return attributeDefValues[i][1];
            }
            ++i;
        }
        return null;
    }

    public static void setLogger(Logger loger) {
        log = loger;
    }

    private class DictionaryReader
    extends DefaultHandler {
        private String currentOperator;
        private int currentFormIndex;
        private int currentLength;
        private String[][] currentEntry;

        private DictionaryReader() {
        }

        public void startDocument() throws SAXException {
            dictionary = new Hashtable();
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String uri, String localName, String rawName, Attributes attlist) throws SAXException {
            if (rawName.equals("element")) {
                this.currentLength = attlist.getLength() - 1;
                this.currentEntry = new String[this.currentLength][2];
                String form = attlist.getValue("form");
                if (form == null) {
                    if (log != null) {
                        log.error("Error in dictionary, attribute 'form' is required attribute for the dictionary");
                    } else {
                        System.out.println("Error in dictionary, attribute 'form' is required attribute for the dictionary");
                    }
                }
                if (form.equals("prefix")) {
                    this.currentFormIndex = 100;
                } else if (form.equals("infix")) {
                    this.currentFormIndex = 101;
                } else if (form.equals("postfix")) {
                    this.currentFormIndex = 102;
                }
                int index = 0;
                int i = 0;
                while (i < this.currentLength + 1) {
                    String attName = attlist.getQName(i);
                    String attValue = attlist.getValue(i);
                    if (!attName.equals("form")) {
                        this.currentEntry[index][0] = attName;
                        this.currentEntry[index][1] = attValue;
                        ++index;
                    }
                    ++i;
                }
            }
        }

        public void endElement(String uri, String localName, String rawName) throws SAXException {
            if (rawName.equals("element")) {
                String key = String.valueOf(this.currentOperator) + this.currentFormIndex;
                Object existedEntry = dictionary.get(key);
                if (existedEntry == null) {
                    dictionary.put(key, this.currentEntry);
                }
            }
            this.currentEntry = null;
            this.currentOperator = null;
        }

        public void characters(char[] data, int start, int length) throws SAXException {
            if (this.currentEntry != null) {
                char[] temp = new char[length];
                System.arraycopy(data, start, temp, 0, length);
                this.currentOperator = this.currentOperator == null ? new String(temp) : String.valueOf(this.currentOperator) + new String(temp);
                this.currentOperator = this.currentOperator.trim();
            }
        }
    }
}

