/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.element.helpers;

import java.awt.Font;
import java.awt.FontMetrics;

public final class AttributesHelper {
    public static final double EM = 0.8;
    public static final double EX = 0.6;
    public static final String VERYVERYTHINMATHSPACE = "0.0555556em";
    public static final String VERYTHINMATHSPACE = "0.111111em";
    public static final String THINMATHSPACE = "0.166667em";
    public static final String MEDIUMMATHSPACE = "0.222222em";
    public static final String THICKMATHSPACE = "0.277778em";
    public static final String VERYTHICKMATHSPACE = "0.333333em";
    public static final String VERYVERYTHICKMATHSPACE = "0.388889em";

    private AttributesHelper() {
    }

    public static int getPixels(String value, FontMetrics fontmetrix) {
        double dpi;
        double fontheight;
        block25: {
            block24: {
                block23: {
                    block22: {
                        fontheight = fontmetrix.getHeight();
                        try {
                            dpi = fontheight / (double)fontmetrix.getFont().getSize() * 72.0;
                            if (!value.equals("infinity")) break block22;
                            return 999999;
                        }
                        catch (NumberFormatException nfe) {
                            return 0;
                        }
                    }
                    if (!value.equals("thin")) break block23;
                    return 1;
                }
                if (!value.equals("medium")) break block24;
                return 2;
            }
            if (!value.equals("thick")) break block25;
            return 3;
        }
        if (value.endsWith("em")) {
            return (int)Math.round(AttributesHelper.getNumber(value, 2) * fontheight * 0.8);
        }
        if (value.endsWith("ex")) {
            return (int)Math.round(AttributesHelper.getNumber(value, 2) * fontheight * 0.6);
        }
        if (value.endsWith("px")) {
            return new Integer(value.substring(0, value.length() - 2));
        }
        if (value.endsWith("in")) {
            return (int)Math.round(AttributesHelper.getNumber(value, 2) * dpi);
        }
        if (value.endsWith("cm")) {
            return (int)Math.round(AttributesHelper.getNumber(value, 2) * dpi / 2.54);
        }
        if (value.endsWith("mm")) {
            return (int)Math.round(AttributesHelper.getNumber(value, 2) * dpi / 25.4);
        }
        if (value.endsWith("pt")) {
            return (int)Math.round(AttributesHelper.getNumber(value, 2) * dpi / 72.0);
        }
        if (value.endsWith("pc")) {
            return (int)Math.round(AttributesHelper.getNumber(value, 2) * dpi / 6.0);
        }
        if (value.endsWith("%")) {
            return (int)Math.round(AttributesHelper.getNumber(value, 1) / 100.0 * fontheight);
        }
        if (value.equals("mediummathspace")) {
            return AttributesHelper.getPixels(MEDIUMMATHSPACE, fontmetrix);
        }
        if (value.equals("thinmathspace")) {
            return AttributesHelper.getPixels(THINMATHSPACE, fontmetrix);
        }
        if (value.equals("verythinmathspace")) {
            return AttributesHelper.getPixels(VERYTHINMATHSPACE, fontmetrix);
        }
        if (value.equals("veryverythinmathspace")) {
            return AttributesHelper.getPixels(VERYVERYTHINMATHSPACE, fontmetrix);
        }
        if (value.equals("thickmathspace")) {
            return AttributesHelper.getPixels(THICKMATHSPACE, fontmetrix);
        }
        if (value.equals("verythickmathspace")) {
            return AttributesHelper.getPixels(VERYTHICKMATHSPACE, fontmetrix);
        }
        if (value.equals("veryverythickmathspace")) {
            return AttributesHelper.getPixels(VERYVERYTHICKMATHSPACE, fontmetrix);
        }
        return (int)Math.round(new Double(value) * fontheight);
    }

    public static int getFontSize(String mathSize, Font font) {
        int fontsize = font.getSize();
        try {
            if (mathSize.endsWith("em")) {
                return (int)(AttributesHelper.getNumber(mathSize, 2) * (double)fontsize);
            }
            if (mathSize.endsWith("ex")) {
                return (int)(AttributesHelper.getNumber(mathSize, 2) * (double)fontsize);
            }
            if (mathSize.endsWith("px")) {
                return new Integer(mathSize.substring(0, mathSize.length() - 2));
            }
            if (mathSize.endsWith("in")) {
                return (int)(AttributesHelper.getNumber(mathSize, 2) * 72.0);
            }
            if (mathSize.endsWith("cm")) {
                return (int)(AttributesHelper.getNumber(mathSize, 2) * 72.0 / 2.54);
            }
            if (mathSize.endsWith("mm")) {
                return (int)(AttributesHelper.getNumber(mathSize, 2) * 72.0 / 25.4);
            }
            if (mathSize.endsWith("pt")) {
                return (int)AttributesHelper.getNumber(mathSize, 2);
            }
            if (mathSize.endsWith("pc")) {
                return (int)(AttributesHelper.getNumber(mathSize, 2) * 12.0);
            }
            if (mathSize.endsWith("%")) {
                return (int)(AttributesHelper.getNumber(mathSize, 1) / 100.0 * (double)fontsize);
            }
            if (mathSize.equals("mediummathspace")) {
                return AttributesHelper.getFontSize(MEDIUMMATHSPACE, font);
            }
            if (mathSize.equals("thinmathspace")) {
                return AttributesHelper.getFontSize(THINMATHSPACE, font);
            }
            if (mathSize.equals("verythinmathspace")) {
                return AttributesHelper.getFontSize(VERYTHINMATHSPACE, font);
            }
            if (mathSize.equals("veryverythinmathspace")) {
                return AttributesHelper.getFontSize(VERYVERYTHINMATHSPACE, font);
            }
            if (mathSize.equals("thickmathspace")) {
                return AttributesHelper.getFontSize(THICKMATHSPACE, font);
            }
            if (mathSize.equals("verythickmathspace")) {
                return AttributesHelper.getFontSize(VERYTHICKMATHSPACE, font);
            }
            if (mathSize.equals("veryverythickmathspace")) {
                return AttributesHelper.getFontSize(VERYVERYTHICKMATHSPACE, font);
            }
            return (int)(new Double(mathSize) * (double)fontsize);
        }
        catch (NumberFormatException nfe) {
            return fontsize;
        }
    }

    private static double getNumber(String value, int countABC) {
        return new Double(value.substring(0, value.length() - countABC));
    }

    public static String multipleSize(String value, double mult) {
        try {
            if (value.endsWith("em")) {
                return String.valueOf(String.valueOf(AttributesHelper.getNumber(value, 2) * mult)) + "em";
            }
            if (value.endsWith("ex")) {
                return String.valueOf(String.valueOf(AttributesHelper.getNumber(value, 2) * mult)) + "ex";
            }
            if (value.endsWith("px")) {
                return String.valueOf(String.valueOf(AttributesHelper.getNumber(value, 2) * mult)) + "px";
            }
            if (value.endsWith("in")) {
                return String.valueOf(String.valueOf(AttributesHelper.getNumber(value, 2) * mult)) + "in";
            }
            if (value.endsWith("cm")) {
                return String.valueOf(String.valueOf(AttributesHelper.getNumber(value, 2) * mult)) + "cm";
            }
            if (value.endsWith("mm")) {
                return String.valueOf(String.valueOf(AttributesHelper.getNumber(value, 2) * mult)) + "mm";
            }
            if (value.endsWith("pt")) {
                return String.valueOf(String.valueOf(AttributesHelper.getNumber(value, 2) * mult)) + "pt";
            }
            if (value.endsWith("pc")) {
                return String.valueOf(String.valueOf(AttributesHelper.getNumber(value, 2) * mult)) + "pc";
            }
            if (value.endsWith("%")) {
                return String.valueOf(String.valueOf(AttributesHelper.getNumber(value, 1) * mult)) + "%";
            }
            if (value.equals("mediummathspace")) {
                return AttributesHelper.multipleSize(MEDIUMMATHSPACE, mult);
            }
            if (value.equals("thinmathspace")) {
                return AttributesHelper.multipleSize(THINMATHSPACE, mult);
            }
            if (value.equals("verythinmathspace")) {
                return AttributesHelper.multipleSize(VERYTHINMATHSPACE, mult);
            }
            if (value.equals("veryverythinmathspace")) {
                return AttributesHelper.multipleSize(VERYVERYTHINMATHSPACE, mult);
            }
            if (value.equals("thickmathspace")) {
                return AttributesHelper.multipleSize(THICKMATHSPACE, mult);
            }
            if (value.equals("verythickmathspace")) {
                return AttributesHelper.multipleSize(VERYTHICKMATHSPACE, mult);
            }
            if (value.equals("veryverythickmathspace")) {
                return AttributesHelper.multipleSize(VERYVERYTHICKMATHSPACE, mult);
            }
            return String.valueOf((double)new Integer(value).intValue() * mult);
        }
        catch (NumberFormatException nfe) {
            return value;
        }
    }
}

