/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.element.generic;

import java.awt.Graphics;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.element.generic.AbstractMathElement;
import net.sourceforge.jeuclid.element.generic.TransitionElement;

public abstract class AbstractMathElementWithChildren
extends AbstractMathElement {
    public AbstractMathElementWithChildren(MathBase base) {
        super(base);
    }

    public void paint(Graphics g, int posX, int posY) {
        if (this.getBackgroundColor() != null) {
            g.setColor(this.getBackgroundColor());
            g.fillRect(posX, posY - this.getAscentHeight(g), this.getWidth(g), this.getHeight(g));
        }
        g.setColor(this.getForegroundColor());
        g.setFont(this.getFont());
        if (this.getMathBase().isDebug()) {
            this.debug(g, posX, posY);
        }
        int pos = posX;
        AbstractMathElement child = null;
        int i = 0;
        while (i < this.getMathElementCount()) {
            child = this.getMathElement(i);
            child.paint(g, pos, posY);
            pos += child.getWidth(g);
            ++i;
        }
    }

    public int calculateWidth(Graphics g) {
        int width = 0;
        TransitionElement.NodeList childList = this.getChildNodes();
        int i = 0;
        while (i < childList.getLength()) {
            AbstractMathElement element = (AbstractMathElement)childList.item(i);
            width += element.getWidth(g);
            ++i;
        }
        return width;
    }

    public int calculateAscentHeight(Graphics g) {
        int height = 0;
        TransitionElement.NodeList childList = this.getChildNodes();
        int i = 0;
        while (i < childList.getLength()) {
            AbstractMathElement element = (AbstractMathElement)childList.item(i);
            height = Math.max(height, element.getAscentHeight(g));
            ++i;
        }
        return height;
    }

    public int calculateDescentHeight(Graphics g) {
        int height = 0;
        TransitionElement.NodeList childList = this.getChildNodes();
        int i = 0;
        while (i < childList.getLength()) {
            AbstractMathElement element = (AbstractMathElement)childList.item(i);
            height = Math.max(height, element.getDescentHeight(g));
            ++i;
        }
        return height;
    }
}

