/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.element.generic;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.element.MathMultiScripts;
import net.sourceforge.jeuclid.element.MathOperator;
import net.sourceforge.jeuclid.element.MathOver;
import net.sourceforge.jeuclid.element.MathRoot;
import net.sourceforge.jeuclid.element.MathRootElement;
import net.sourceforge.jeuclid.element.MathRow;
import net.sourceforge.jeuclid.element.MathStyle;
import net.sourceforge.jeuclid.element.MathSub;
import net.sourceforge.jeuclid.element.MathSubSup;
import net.sourceforge.jeuclid.element.MathSup;
import net.sourceforge.jeuclid.element.MathTable;
import net.sourceforge.jeuclid.element.MathTableRow;
import net.sourceforge.jeuclid.element.MathText;
import net.sourceforge.jeuclid.element.MathUnder;
import net.sourceforge.jeuclid.element.MathUnderOver;
import net.sourceforge.jeuclid.element.generic.ChangeTrackingElement;
import net.sourceforge.jeuclid.element.generic.TransitionElement;
import net.sourceforge.jeuclid.element.helpers.AttributeMap;
import net.sourceforge.jeuclid.element.helpers.CharConverter;
import org.apache.avalon.framework.logger.Logger;

public abstract class AbstractMathElement
extends ChangeTrackingElement {
    private boolean calculatingSize = false;
    public static final String ELEMENT = "none";
    public static final String URI = "http://www.w3.org/1998/Math/MathML";
    private static final Set DEPRECATED_ATTRIBUTES = new HashSet();
    private int calculatedHeight = -1;
    private int calculatedWidth = -1;
    private int calculatedAscentHeight = -1;
    private int calculatedDescentHeight = -1;
    private int calculatedStretchHeight = -1;
    private int calculatedStretchAscentHeight = -1;
    private int calculatedStretchDescentHeight = -1;
    protected MathBase m_base;
    private AbstractMathElement fakeParent;
    protected Font m_font;
    private float m_scriptsizemultiplier = 0.71f;
    private int m_mathvariant = 0;
    protected boolean m_inheritdisplaystyle = true;
    private boolean m_inheritmathvariant = true;
    private boolean m_inheritmathsize = true;
    protected boolean m_displaystyle = true;
    private int globalLineCorrecter = 0;
    protected Logger m_log = null;

    public AbstractMathElement(MathBase base) {
        DEPRECATED_ATTRIBUTES.add("color");
        DEPRECATED_ATTRIBUTES.add("background");
        DEPRECATED_ATTRIBUTES.add("fontsize");
        DEPRECATED_ATTRIBUTES.add("fontweight");
        DEPRECATED_ATTRIBUTES.add("fontstyle");
        DEPRECATED_ATTRIBUTES.add("fontfamily");
        this.m_font = base.getFont();
        this.setMathBase(base);
    }

    protected void recalculateSize() {
        this.calculatedHeight = -1;
        this.calculatedAscentHeight = -1;
        this.calculatedDescentHeight = -1;
        this.calculatedStretchHeight = -1;
        this.calculatedStretchAscentHeight = -1;
        this.calculatedStretchDescentHeight = -1;
        this.calculatedWidth = -1;
    }

    protected void setChanged(boolean hasChanged) {
        super.setChanged(hasChanged);
        if (hasChanged) {
            this.recalculateSize();
        }
    }

    public Font getFont() {
        return this.m_font;
    }

    public final void multipleFont(Font font, float multiplier) {
        this.setFont(this.getMathBase().getFont(multiplier * (float)font.getSize(), this.getMathVariant()));
    }

    private void setChildSize(AbstractMathElement child, int childpos) {
        child.setScriptSizeMultiplier(this.getScriptSizeMultiplier());
        if (this instanceof MathMultiScripts) {
            if (childpos > 0) {
                child.multipleFont(this.m_font, this.getScriptSizeMultiplier());
                child.setDisplayStyle(false);
                child.setInheritSisplayStyle(false);
            }
        } else if (this instanceof MathOver) {
            if (childpos == 1 && (this.getMathElement(0) instanceof MathOperator && ((MathOperator)this.getMathElement(0)).getMoveableLimits() || !((MathOver)this).getAccent())) {
                child.multipleFont(this.m_font, this.getScriptSizeMultiplier());
                child.setDisplayStyle(false);
                child.setInheritSisplayStyle(false);
            }
        } else if (this instanceof MathUnder) {
            if (childpos == 1 && (this.getMathElement(0) instanceof MathOperator && ((MathOperator)this.getMathElement(0)).getMoveableLimits() || !((MathUnder)this).getAccentUnder())) {
                child.multipleFont(this.m_font, this.getScriptSizeMultiplier());
                child.setDisplayStyle(false);
                child.setInheritSisplayStyle(false);
            }
        } else if (this instanceof MathUnderOver) {
            if (childpos > 0 && (this.getMathElement(0) instanceof MathOperator && ((MathOperator)this.getMathElement(0)).getMoveableLimits() || childpos == 1 && !((MathUnderOver)this).getAccentUnder() || childpos == 2 && !((MathUnderOver)this).getAccent())) {
                child.multipleFont(this.m_font, this.getScriptSizeMultiplier());
                child.setDisplayStyle(false);
                child.setInheritSisplayStyle(false);
            }
        } else if (this instanceof MathRoot) {
            if (childpos == 1) {
                child.multipleFont(this.m_font, (float)Math.pow(this.getScriptSizeMultiplier(), 2.0));
                child.setDisplayStyle(false);
                child.setInheritSisplayStyle(false);
            }
        } else if (this instanceof MathSub) {
            if (childpos == 1) {
                child.multipleFont(this.m_font, this.getScriptSizeMultiplier());
                child.setDisplayStyle(false);
                child.setInheritSisplayStyle(false);
            }
        } else if (this instanceof MathSup) {
            if (childpos == 1) {
                child.multipleFont(this.m_font, this.getScriptSizeMultiplier());
                child.setDisplayStyle(false);
                child.setInheritSisplayStyle(false);
            }
        } else if (this instanceof MathSubSup) {
            if (childpos > 0) {
                child.multipleFont(this.m_font, this.getScriptSizeMultiplier());
                child.setDisplayStyle(false);
                child.setInheritSisplayStyle(false);
            }
        } else if (this instanceof MathStyle) {
            child.multipleFont(this.m_font, (float)Math.pow(this.getScriptSizeMultiplier(), ((MathStyle)this).getScriptlevel()));
        } else {
            child.setFont(this.m_font);
        }
    }

    public final void setFont(Font font) {
        if (this instanceof MathText) {
            this.m_font = this.getMathBase().getFont(((MathText)this).getMathSize(), this.getMathVariant(), this.m_font);
        } else {
            this.m_font = font;
            TransitionElement.NodeList childList = this.getChildNodes();
            int i = 0;
            while (i < childList.getLength()) {
                AbstractMathElement child = (AbstractMathElement)childList.item(i);
                if (child.isInheritMathSize()) {
                    this.setChildSize(child, i);
                }
                ++i;
            }
        }
    }

    public final void addMathElement(AbstractMathElement child) {
        if (child != null) {
            this.appendChild(child);
            child.setMathBase(this.getMathBase());
            if (child.isInheritMathSize()) {
                this.setChildSize(child, this.getMathElementCount() - 1);
            }
            if (child.isInheritMathVariant()) {
                child.setMathVariant(this.m_mathvariant);
            }
            if (child.isInheritDisplayStyle()) {
                child.setDisplayStyle(this.m_displaystyle);
            }
        }
    }

    public AbstractMathElement getMathElement(int index) {
        TransitionElement.NodeList childList = this.getChildNodes();
        if (index >= 0 && index < childList.getLength()) {
            return (AbstractMathElement)childList.item(index);
        }
        return null;
    }

    public int getIndexOfMathElement(AbstractMathElement element) {
        TransitionElement.NodeList childList = this.getChildNodes();
        int i = 0;
        while (i < childList.getLength()) {
            if (childList.item(i).equals(element)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getMathElementCount() {
        return this.getChildNodes().getLength();
    }

    public void addText(String text) {
        StringBuffer newText = new StringBuffer();
        if (this.getTextContent() != null) {
            newText.append(this.getTextContent());
        }
        if (text != null) {
            newText.append(text);
        }
        int i = 0;
        while (i < newText.length() - 1) {
            if (Character.isWhitespace(newText.charAt(i)) && Character.isWhitespace(newText.charAt(i + 1))) {
                newText.deleteCharAt(i + 1);
            }
            ++i;
        }
        String toSet = CharConverter.convert(newText.toString().trim());
        if (toSet.length() > 0) {
            this.setTextContent(toSet);
        }
    }

    public String getText() {
        String theText = this.getTextContent();
        if (theText == null) {
            return "";
        }
        return theText;
    }

    public void setMathBase(MathBase base) {
        this.m_base = base;
        TransitionElement.NodeList childList = this.getChildNodes();
        int i = 0;
        while (i < childList.getLength()) {
            ((AbstractMathElement)childList.item(i)).setMathBase(base);
            ++i;
        }
    }

    public MathBase getMathBase() {
        return this.m_base;
    }

    public void setFakeParent(AbstractMathElement parent) {
        this.fakeParent = parent;
    }

    public AbstractMathElement getParent() {
        AbstractMathElement theParent = (AbstractMathElement)this.getParentNode();
        if (theParent == null) {
            return this.fakeParent;
        }
        return theParent;
    }

    public void setMathVariant(int mathvariant) {
        if (mathvariant >= 0 && mathvariant <= 13) {
            this.m_mathvariant = mathvariant;
            this.multipleFont(this.m_font, 1.0f);
        }
    }

    public int getMathVariant() {
        return this.m_mathvariant;
    }

    public void setInheritMathVariant(boolean inheritmathvariant) {
        this.m_inheritmathvariant = inheritmathvariant;
    }

    public boolean isInheritMathVariant() {
        return this.m_inheritmathvariant;
    }

    public void setInheritMathSize(boolean inheritmathsize) {
        this.m_inheritmathsize = inheritmathsize;
    }

    public boolean isInheritMathSize() {
        return this.m_inheritmathsize;
    }

    public float getScriptSizeMultiplier() {
        return this.m_scriptsizemultiplier;
    }

    public void setScriptSizeMultiplier(float scriptsizemultiplier) {
        this.m_scriptsizemultiplier = scriptsizemultiplier;
    }

    public void setDisplayStyle(boolean displaystyle) {
        this.m_displaystyle = displaystyle;
    }

    public boolean getDisplayStyle() {
        return this.m_displaystyle;
    }

    public FontMetrics getFontMetrics(Graphics g) {
        return g.getFontMetrics(this.getFont());
    }

    public void setMathcolor(String mathcolor) {
        this.setAttribute("mathcolor", mathcolor);
    }

    public String getMathcolor() {
        String color = this.getMathAttribute("mathcolor");
        if (color == null) {
            color = this.getMathAttribute("color");
        }
        return color;
    }

    protected String getMathAttribute(String attrName) {
        String attrValue = this.getAttributeNS(URI, attrName);
        if (attrValue == null) {
            attrValue = this.getAttribute(attrName);
        }
        return attrValue;
    }

    public String getMathbackground() {
        String color = this.getMathAttribute("mathbackground");
        if (color == null) {
            color = this.getMathAttribute("background");
        }
        return color;
    }

    protected Color getForegroundColor() {
        String colorString = this.getMathcolor();
        Color theColor = colorString == null ? (this.getParent() != null ? this.getParent().getForegroundColor() : Color.BLACK) : this.stringToColor(colorString, Color.BLACK);
        return theColor;
    }

    private Color stringToColor(String value, Color defaultValue) {
        if (value != null && value.length() > 0) {
            if (value.equalsIgnoreCase("Black")) {
                value = "#000000";
            } else if (value.equalsIgnoreCase("Green")) {
                value = "#008000";
            } else if (value.equalsIgnoreCase("Silver")) {
                value = "#C0C0C0";
            } else if (value.equalsIgnoreCase("Lime")) {
                value = "#00FF00";
            } else if (value.equalsIgnoreCase("Gray")) {
                value = "#808080";
            } else if (value.equalsIgnoreCase("Olive")) {
                value = "#808000";
            } else if (value.equalsIgnoreCase("White")) {
                value = "#FFFFFF";
            } else if (value.equalsIgnoreCase("Yellow")) {
                value = "#FFFF00";
            } else if (value.equalsIgnoreCase("Maroon")) {
                value = "#800000";
            } else if (value.equalsIgnoreCase("Navy")) {
                value = "#000080";
            } else if (value.equalsIgnoreCase("Red")) {
                value = "#FF0000";
            } else if (value.equalsIgnoreCase("Blue")) {
                value = "#0000FF";
            } else if (value.equalsIgnoreCase("Purple")) {
                value = "#800080";
            } else if (value.equalsIgnoreCase("Teal")) {
                value = "#008080";
            } else if (value.equalsIgnoreCase("Fuchsia")) {
                value = "#FF00FF";
            } else if (value.equalsIgnoreCase("Aqua")) {
                value = "#00FFFF";
            }
            if (value.startsWith("#") && value.length() == 4) {
                value = "#" + value.charAt(1) + "0" + value.charAt(2) + "0" + value.charAt(3) + "0";
            }
            try {
                return new Color(Integer.decode(value));
            }
            catch (NumberFormatException nfe) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public void setInheritSisplayStyle(boolean inheritdisplaystyle) {
        this.m_inheritdisplaystyle = inheritdisplaystyle;
    }

    public boolean isInheritDisplayStyle() {
        return this.m_inheritdisplaystyle;
    }

    public Color getBackgroundColor() {
        String colorString = this.getMathbackground();
        Color theColor = colorString == null ? (this.getParent() != null ? this.getParent().getBackgroundColor() : null) : this.stringToColor(colorString, null);
        return theColor;
    }

    public void debug(Graphics g, int posX, int posY) {
        g.setColor(Color.blue);
        g.drawLine(posX, posY - this.getAscentHeight(g), posX + this.getWidth(g), posY - this.getAscentHeight(g));
        g.drawLine(posX + this.getWidth(g), posY - this.getAscentHeight(g), posX + this.getWidth(g), posY + this.getDescentHeight(g));
        g.drawLine(posX, posY + this.getDescentHeight(g), posX + this.getWidth(g), posY + this.getDescentHeight(g));
        g.drawLine(posX, posY - this.getAscentHeight(g), posX, posY + this.getDescentHeight(g));
        g.setColor(Color.red);
        g.drawLine(posX, posY, posX + this.getWidth(g), posY);
        g.setColor(Color.black);
    }

    public abstract void paint(Graphics var1, int var2, int var3);

    public void setGlobalLineCorrector(int corrector) {
        if (this.getParent() == null) {
            return;
        }
        if (this instanceof MathTableRow || this instanceof MathRow && this.getParent() instanceof MathTable || this.getParent() instanceof MathRootElement) {
            if (this.globalLineCorrecter < corrector) {
                this.globalLineCorrecter = corrector;
            }
        } else {
            this.getParent().setGlobalLineCorrector(corrector);
        }
    }

    public int getGlobalLineCorrector() {
        if (this.getParent() == null) {
            return 0;
        }
        if (this instanceof MathTableRow || this instanceof MathRow && this.getParent() instanceof MathTable || this.getParent() instanceof MathRootElement) {
            return this.globalLineCorrecter;
        }
        return this.getParent().getGlobalLineCorrector();
    }

    public int getWidth(Graphics g) {
        if (this.calculatedWidth == -1) {
            this.calculatedWidth = this.calculateWidth(g);
        }
        return this.calculatedWidth;
    }

    public abstract int calculateWidth(Graphics var1);

    public int getHeight(Graphics g) {
        if (this.calculatingSize || this.getParent() != null && this.getParent().calculatingSize) {
            if (this.calculatedStretchHeight == -1) {
                this.calculatedStretchHeight = this.calculateHeight(g);
            }
            return this.calculatedStretchHeight;
        }
        if (this.calculatedHeight == -1) {
            this.calculatedHeight = this.calculateHeight(g);
        }
        return this.calculatedHeight;
    }

    public int calculateHeight(Graphics g) {
        return this.getAscentHeight(g) + this.getDescentHeight(g);
    }

    public int getAscentHeight(Graphics g) {
        if (this.calculatingSize || this.getParent() != null && this.getParent().calculatingSize) {
            if (this.calculatedStretchAscentHeight == -1) {
                this.calculatedStretchAscentHeight = this.calculateAscentHeight(g);
            }
            return this.calculatedStretchAscentHeight;
        }
        if (this.calculatedAscentHeight == -1) {
            this.calculatedAscentHeight = this.calculateAscentHeight(g);
        }
        return this.calculatedAscentHeight;
    }

    public abstract int calculateAscentHeight(Graphics var1);

    public int getDescentHeight(Graphics g) {
        if (this.calculatingSize || this.getParent() != null && this.getParent().calculatingSize) {
            if (this.calculatedStretchDescentHeight == -1) {
                this.calculatedStretchDescentHeight = this.calculateDescentHeight(g);
            }
            return this.calculatedStretchDescentHeight;
        }
        if (this.calculatedDescentHeight == -1) {
            this.calculatedDescentHeight = this.calculateDescentHeight(g);
        }
        return this.calculatedDescentHeight;
    }

    public abstract int calculateDescentHeight(Graphics var1);

    public int getMiddleShift(Graphics g) {
        return (int)((double)this.getFontMetrics(g).getAscent() * 0.38);
    }

    public Logger getLogger() {
        return this.m_log;
    }

    public void setLogger(Logger log) {
        this.m_log = log;
    }

    public void eventElementComplete() {
    }

    public void eventAllElementsComplete() {
        TransitionElement.NodeList childList = this.getChildNodes();
        int i = 0;
        while (i < childList.getLength()) {
            ((AbstractMathElement)childList.item(i)).eventAllElementsComplete();
            ++i;
        }
    }

    public void eventInitSpecificAttributes(AttributeMap attributes) {
        Map attrsAsMap = attributes.getAsMap();
        Iterator i = attrsAsMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            String attrName = (String)e.getKey();
            if (DEPRECATED_ATTRIBUTES.contains(attrName)) {
                this.m_log.warn("Deprecated attribute " + attrName);
            }
            this.setAttribute(attrName, (String)e.getValue());
        }
    }

    public boolean isCalculatingSize() {
        return this.calculatingSize;
    }

    public void setCalculatingSize(boolean calculatingSize) {
        this.calculatingSize = calculatingSize;
    }
}

