/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.element.generic;

import java.awt.Graphics;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.element.generic.AbstractMathElement;
import net.sourceforge.jeuclid.element.helpers.AttributeMap;

public abstract class AbstractElementWithDelegate
extends AbstractMathElement {
    private AbstractMathElement delegate;

    public AbstractElementWithDelegate(MathBase base) {
        super(base);
    }

    protected abstract AbstractMathElement createDelegate();

    private void prepareDelegate() {
        this.delegate = this.createDelegate();
        this.delegate.setFakeParent(this);
        this.setChanged(false);
    }

    public void eventInitSpecificAttributes(AttributeMap attributes) {
        super.eventInitSpecificAttributes(attributes);
        this.prepareDelegate();
        this.delegate.eventInitSpecificAttributes(attributes);
    }

    public int calculateAscentHeight(Graphics g) {
        if (this.isChanged()) {
            this.prepareDelegate();
        }
        return this.delegate.calculateAscentHeight(g);
    }

    public int calculateDescentHeight(Graphics g) {
        if (this.isChanged()) {
            this.prepareDelegate();
        }
        return this.delegate.calculateDescentHeight(g);
    }

    public int calculateWidth(Graphics g) {
        if (this.isChanged()) {
            this.prepareDelegate();
        }
        return this.delegate.calculateWidth(g);
    }

    public void paint(Graphics g, int posX, int posY) {
        if (this.isChanged()) {
            this.prepareDelegate();
        }
        this.delegate.paint(g, posX, posY);
    }
}

