/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.element;

import java.awt.Graphics;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.element.MathOperator;
import net.sourceforge.jeuclid.element.generic.AbstractMathElement;
import net.sourceforge.jeuclid.element.helpers.AttributesHelper;

public class MathUnderOver
extends AbstractMathElement {
    public static final String ELEMENT = "munderover";
    public static final String UNDER_OVER_SPACE = "0.2em";
    private boolean m_accentunder = false;
    private boolean m_accent = false;

    public MathUnderOver(MathBase base) {
        super(base);
    }

    public void setAccentUnder(boolean accentunder) {
        this.m_accentunder = accentunder;
    }

    public boolean getAccentUnder() {
        return this.m_accentunder;
    }

    public void setAccent(boolean accent) {
        this.m_accent = accent;
    }

    public boolean getAccent() {
        return this.m_accent;
    }

    private int getUnderOverSpace(Graphics g) {
        return AttributesHelper.getPixels(UNDER_OVER_SPACE, this.getFontMetrics(g));
    }

    public void paint(Graphics g, int posX, int posY) {
        int posX2;
        int posX1;
        int posX0;
        int posY2;
        int posY1;
        if (this.getBackgroundColor() != null) {
            g.setColor(this.getBackgroundColor());
            g.fillRect(posX, posY - this.getAscentHeight(g), this.getWidth(g), this.getHeight(g));
        }
        g.setColor(this.getForegroundColor());
        g.setFont(this.getFont());
        AbstractMathElement e1 = this.getMathElement(0);
        AbstractMathElement e2 = this.getMathElement(1);
        AbstractMathElement e3 = this.getMathElement(2);
        if (this.getMathElement(0) instanceof MathOperator && ((MathOperator)this.getMathElement(0)).getMoveableLimits()) {
            int e1AscentHeight;
            int middleshift = (int)((double)e1.getHeight(g) * 0.215);
            int e1DescentHeight = e1.getDescentHeight(g);
            if (e1DescentHeight == 0) {
                e1DescentHeight = this.getFontMetrics(g).getDescent();
            }
            if ((e1AscentHeight = e1.getAscentHeight(g)) == 0) {
                e1AscentHeight = this.getFontMetrics(g).getAscent();
            }
            posY1 = posY + e1DescentHeight + e2.getAscentHeight(g) - middleshift - 1;
            posY2 = posY - e1AscentHeight + middleshift - e2.getDescentHeight(g) + 1;
            posX0 = posX;
            posX1 = posX + e1.getWidth(g);
            posX2 = posX + e1.getWidth(g);
        } else {
            int width = this.getWidth(g);
            posX0 = posX + (width - e1.getWidth(g)) / 2;
            posX1 = posX + (width - e2.getWidth(g)) / 2;
            posY1 = posY + e1.getDescentHeight(g) + e2.getAscentHeight(g) + this.getUnderOverSpace(g) - 1;
            posX2 = posX + (width - e3.getWidth(g)) / 2;
            posY2 = posY - e1.getAscentHeight(g) - e3.getDescentHeight(g) - this.getUnderOverSpace(g) - 1;
            if (this.getAccent()) {
                posY1 += this.getUnderOverSpace(g);
            }
            if (this.getAccentUnder()) {
                posY2 -= this.getUnderOverSpace(g);
            }
        }
        e1.paint(g, posX0, posY);
        e2.paint(g, posX1, posY1);
        e3.paint(g, posX2, posY2);
    }

    public int calculateWidth(Graphics g) {
        if (this.getMathElement(0) instanceof MathOperator && ((MathOperator)this.getMathElement(0)).getMoveableLimits()) {
            return this.getMathElement(0).getWidth(g) + Math.max(this.getMathElement(1).getWidth(g), this.getMathElement(2).getWidth(g)) + 1;
        }
        return Math.max(this.getMathElement(0).getWidth(g), Math.max(this.getMathElement(1).getWidth(g), this.getMathElement(2).getWidth(g)));
    }

    public int calculateAscentHeight(Graphics g) {
        int res;
        if (this.getMathElement(0) instanceof MathOperator && ((MathOperator)this.getMathElement(0)).getMoveableLimits()) {
            int e2h = (int)Math.max((double)this.getMathElement(2).getHeight(g) - (double)this.getMathElement(0).getHeight(g) * 0.215, 0.0);
            res = this.getMathElement(0).getAscentHeight(g) + e2h;
        } else {
            res = this.getMathElement(0).getAscentHeight(g) + this.getMathElement(2).getHeight(g) + this.getUnderOverSpace(g);
            if (this.getAccentUnder()) {
                res += this.getUnderOverSpace(g);
            }
        }
        return res;
    }

    public int calculateDescentHeight(Graphics g) {
        int res;
        if (this.getMathElement(0) instanceof MathOperator && ((MathOperator)this.getMathElement(0)).getMoveableLimits()) {
            int e2h = (int)Math.max((double)this.getMathElement(1).getHeight(g) - (double)this.getMathElement(0).getHeight(g) * 0.215, 0.0);
            res = this.getMathElement(0).getDescentHeight(g) + e2h;
        } else {
            res = this.getMathElement(0).getDescentHeight(g) + this.getMathElement(1).getHeight(g) + this.getUnderOverSpace(g);
            if (this.getAccentUnder()) {
                res += this.getUnderOverSpace(g);
            }
        }
        return res;
    }
}

