/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.element;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.element.generic.AbstractMathElement;
import net.sourceforge.jeuclid.element.helpers.AttributeMap;

public class MathText
extends AbstractMathElement {
    public static final String ELEMENT = "mtext";
    private String m_mathSize = "100%";

    public MathText(MathBase base) {
        super(base);
    }

    public void setMathSize(String mathSize) {
        this.m_mathSize = mathSize;
        this.recalculateSize();
        this.setFont(this.getMathBase().getFont(mathSize, this.getMathVariant(), this.getFont()));
    }

    public String getMathSize() {
        return this.m_mathSize;
    }

    public void paint(Graphics g, int posX, int posY) {
        if (this.getBackgroundColor() != null) {
            g.setColor(this.getBackgroundColor());
            g.fillRect(posX, posY - this.getAscentHeight(g), this.getWidth(g), this.getHeight(g));
        }
        g.setColor(this.getForegroundColor());
        g.setFont(this.getFont());
        g.drawString(this.getText(), posX, posY);
    }

    public GlyphVector getGlyphVector(char theChar) {
        return this.getFont().createGlyphVector(new FontRenderContext(new AffineTransform(), true, false), new char[]{theChar});
    }

    public int calculateWidth(Graphics g) {
        return this.getFontMetrics(g).stringWidth(this.getText().replace(' ', 'A'));
    }

    public int calculateAscentHeight(Graphics g) {
        if (this.getText().equals("")) {
            return g.getFontMetrics().getAscent();
        }
        return MathText.getCharsMaxAscentHeight(g, this.getFont(), MathText.getChars(this.getText()));
    }

    public int calculateDescentHeight(Graphics g) {
        if (this.getText().equals("")) {
            return g.getFontMetrics().getDescent();
        }
        return MathText.getCharsMaxDescentHeight(g, this.getFont(), MathText.getChars(this.getText()));
    }

    public static int getCharsMaxDescentHeight(Graphics g, Font font, char[] chars) {
        int result = 0;
        GlyphVector gv = font.createGlyphVector(new FontRenderContext(new AffineTransform(), true, false), chars);
        int descHeight = 0;
        Rectangle2D gr = null;
        int i = 0;
        while (i < chars.length) {
            gr = gv.getGlyphMetrics(i).getBounds2D();
            descHeight = (int)Math.round(gr.getHeight() + gr.getY() + 0.5);
            if (descHeight < 0) {
                descHeight = 0;
            }
            result = Math.max(result, descHeight);
            ++i;
        }
        return result;
    }

    public static int getCharsMaxAscentHeight(Graphics g, Font font, char[] chars) {
        int result = 0;
        GlyphVector gv = font.createGlyphVector(new FontRenderContext(new AffineTransform(), true, false), chars);
        int ascHeight = 0;
        Rectangle2D gr = null;
        int i = 0;
        while (i < chars.length) {
            gr = gv.getGlyphMetrics(i).getBounds2D();
            ascHeight = gr.getY() < 0.0 ? (int)Math.round(-gr.getY() + 0.5) : 0;
            result = Math.max(result, ascHeight);
            ++i;
        }
        return result;
    }

    public static char[] getChars(String text) {
        char[] result = new char[text.length()];
        text.getChars(0, text.length(), result, 0);
        return result;
    }

    public void eventInitSpecificAttributes(AttributeMap attributes) {
        super.eventInitSpecificAttributes(attributes);
        if (attributes.hasAttribute("mathsize")) {
            this.setMathSize(attributes.getString("mathsize", "100%"));
            this.setInheritMathSize(false);
        }
    }
}

