/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.element;

import java.awt.Graphics;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.element.MathTable;
import net.sourceforge.jeuclid.element.generic.AbstractMathElement;

public class MathTableRow
extends AbstractMathElement {
    public static final String ELEMENT = "mtr";
    public static final int ALIGN_TOP = 0;
    public static final int ALIGN_BOTTOM = 1;
    public static final int ALIGN_CENTER = 2;
    public static final int ALIGN_BASELINE = 3;
    public static final int ALIGN_AXIS = 4;
    public static final int ALIGN_LEFT = 5;
    public static final int ALIGN_RIGHT = 6;
    public static final int ALIGN_DECIMALPOINT = 7;
    private int m_rowalign = 2;
    private int m_columnalign = 2;
    private int m_groupalign = 2;
    private int[] groupsalignvalues = null;

    public MathTableRow(MathBase base) {
        super(base);
    }

    public int getRowalign() {
        return this.m_rowalign;
    }

    public void setRowalign(int rowalign) {
        this.m_rowalign = rowalign;
    }

    public int getColumnalign() {
        return this.m_columnalign;
    }

    public void setColumnalign(int columnalign) {
        this.m_columnalign = columnalign;
    }

    public int getGroupalign() {
        return this.m_groupalign;
    }

    public void setGroupalign(int groupalign) {
        this.m_groupalign = groupalign;
    }

    public void paint(Graphics g, int posX, int posY) {
        if (this.getBackgroundColor() != null) {
            g.setColor(this.getBackgroundColor());
            g.fillRect(posX, posY - this.getAscentHeight(g), this.getWidth(g), this.getHeight(g));
        }
        g.setColor(this.getForegroundColor());
        g.setFont(this.getFont());
        if (this.getMathBase().isDebug()) {
            this.debug(g, posX, posY);
        }
        int columnwidth = this.getMaxColumnWidth(g);
        int pos = posX;
        int i = 0;
        while (i < this.getMathElementCount()) {
            this.getMathElement(i).paint(g, pos, posY);
            pos += columnwidth;
            ++i;
        }
    }

    protected int getMaxColumnWidth(Graphics g) {
        int width = 0;
        int i = 0;
        while (i < this.getMathElementCount()) {
            width = Math.max(width, this.getMathElement(i).getWidth(g));
            ++i;
        }
        return width;
    }

    public int calculateWidth(Graphics g) {
        return this.getMaxColumnWidth(g) * this.getMathElementCount();
    }

    public int calculateAscentHeight(Graphics g) {
        int height = 0;
        int i = 0;
        while (i < this.getMathElementCount()) {
            height = Math.max(height, this.getMathElement(i).getAscentHeight(g));
            ++i;
        }
        return height;
    }

    public int calculateDescentHeight(Graphics g) {
        int height = 0;
        int i = 0;
        while (i < this.getMathElementCount()) {
            height = Math.max(height, this.getMathElement(i).getDescentHeight(g));
            ++i;
        }
        return height;
    }

    public int[] getGroupAlign() {
        return this.groupsalignvalues;
    }

    public void setGroupAlign(String groupalign) {
        this.groupsalignvalues = MathTable.createGroupAlignValues(groupalign);
    }
}

