/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.element;

import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Iterator;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.element.MathAlignGroup;
import net.sourceforge.jeuclid.element.MathAlignMark;
import net.sourceforge.jeuclid.element.MathNumber;
import net.sourceforge.jeuclid.element.MathTableData;
import net.sourceforge.jeuclid.element.MathTableRow;
import net.sourceforge.jeuclid.element.generic.AbstractMathElement;
import net.sourceforge.jeuclid.element.generic.TransitionElement;
import net.sourceforge.jeuclid.element.helpers.AttributesHelper;

public class MathTable
extends AbstractMathElement {
    public static final String ELEMENT = "mtable";
    public static final int ALIGN_TOP = 0;
    public static final int ALIGN_BOTTOM = 1;
    public static final String DEFAULT_COLUMNSPACING = "0.8em";
    public static final String DEFAULT_ROWSPACING = "1.0ex";
    public static final String DEFAULT_FRAMESPACING = "0.4em 0.5ex";
    public static final int ALIGN_CENTER = 2;
    public static final int ALIGN_BASELINE = 3;
    public static final int ALIGN_AXIS = 4;
    public static final int ALIGN_LEFT = 5;
    public static final int ALIGN_RIGHT = 6;
    public static final int ALIGN_MARK = 11;
    public static final int ALIGN_DECIMALPOINT = 7;
    private int m_align = 2;
    private int m_rowalign = 2;
    private int m_columnalign = 2;
    private int m_groupalign = 2;
    private boolean m_alignmentscope = false;
    public static final int WIDTH_AUTO = -1;
    public static final int WIDTH_FIT = -2;
    private int m_columnwidth = -1;
    private int m_width = -1;
    private ArrayList m_rowspacing = new ArrayList();
    private ArrayList m_columnspacing = new ArrayList();
    public static final int LINE_NONE = 0;
    public static final int LINE_SOLID = 1;
    public static final int LINE_DASHED = 2;
    private int[] m_rowlines = new int[1];
    private int[] m_columnlines = new int[1];
    private int m_frame = 0;
    private String m_framespacing = "";
    private int framespacingh = -1;
    private int framespacingv = -1;
    private boolean m_equalrows = false;
    private boolean m_equalcolumns = false;
    public static final int SIDE_LEFT = 0;
    public static final int SIDE_RIGHT = 1;
    public static final int SIDE_LEFTOVERLAP = 2;
    public static final int SIDE_RIGHTOVERLAP = 3;
    private int m_side = 0;
    private int m_minlabelspacing = 0;
    private int[] groupsalignvalues = null;
    private static int WHOLE_WIDTH = 0;
    private static int LEFT_WIDTH = 1;
    private static int RIGHT_WIDTH = 2;

    public MathTable(MathBase base) {
        super(base);
        this.setInheritMathSize(false);
        this.setDisplayStyle(false);
    }

    public int getAlign() {
        return this.m_align;
    }

    public void setAlign(String align) {
        if (align.equals("axis")) {
            this.m_align = 4;
        } else if (align.equals("bottom")) {
            this.m_align = 1;
        } else if (align.equals("center")) {
            this.m_align = 2;
        } else if (align.equals("baseline")) {
            this.m_align = 3;
        } else if (align.equals("top")) {
            this.m_align = 0;
        }
    }

    public int getRowAlign() {
        return this.m_rowalign;
    }

    public void setRowAlign(int rowalign) {
        if (rowalign == 0 || rowalign == 1 || rowalign == 2 || rowalign == 3 || rowalign == 4) {
            this.m_rowalign = rowalign;
        }
    }

    public int getColumnalign() {
        return this.m_columnalign;
    }

    public void setColumnalign(int columnalign) {
        if (columnalign == 5 || columnalign == 6 || columnalign == 2) {
            this.m_columnalign = columnalign;
        }
    }

    public void setGroupalign(int groupalign) {
        if (groupalign == 5 || groupalign == 6 || groupalign == 2 || groupalign == 7) {
            this.m_groupalign = groupalign;
        }
    }

    public int getGroupalign() {
        return this.m_groupalign;
    }

    public boolean getAlignmentscope() {
        return this.m_alignmentscope;
    }

    public void setAlignmentscope(boolean alignmentscope) {
        this.m_alignmentscope = alignmentscope;
    }

    public int getColumnwidth() {
        return this.m_columnwidth;
    }

    public void setColumnwidth(int columnwidth) {
        if (columnwidth >= 0 || columnwidth == -1 || columnwidth == -2) {
            this.m_columnwidth = columnwidth;
        }
    }

    public void setWidth(int width) {
        if (width >= 0 || width == -1) {
            this.m_width = width;
        }
    }

    public int getRowspacing(Graphics g, int row) {
        if (row < this.m_rowspacing.size()) {
            return AttributesHelper.getPixels((String)this.m_rowspacing.get(row), this.getFontMetrics(g));
        }
        return AttributesHelper.getPixels(DEFAULT_ROWSPACING, this.getFontMetrics(g));
    }

    public void setRowspacing(String rowspacing) {
        while (!rowspacing.equals("")) {
            int pos = rowspacing.indexOf(32);
            if (pos < 0) {
                pos = rowspacing.length();
            }
            this.m_rowspacing.add(rowspacing.substring(0, pos));
            rowspacing = pos == rowspacing.length() ? "" : rowspacing.substring(pos + 1);
        }
    }

    public int getColumnspacing(Graphics g, int col) {
        if (col < this.m_columnspacing.size()) {
            return AttributesHelper.getPixels((String)this.m_columnspacing.get(col), this.getFontMetrics(g));
        }
        return AttributesHelper.getPixels(DEFAULT_COLUMNSPACING, this.getFontMetrics(g));
    }

    public void setColumnspacing(String columnspacing) {
        while (!columnspacing.equals("")) {
            int pos = columnspacing.indexOf(32);
            if (pos < 0) {
                pos = columnspacing.length() - 1;
            }
            this.m_columnspacing.add(columnspacing.substring(0, pos));
            columnspacing = columnspacing.substring(pos + 1);
        }
    }

    public int[] getRowlines() {
        return this.m_rowlines;
    }

    public void setRowlines(int[] rowlines) {
        if (rowlines.length > 0) {
            this.m_rowlines = rowlines;
        }
    }

    public int[] getColumnlines() {
        return this.m_columnlines;
    }

    public void setColumnlines(int[] columnlines) {
        if (columnlines.length > 0) {
            this.m_columnlines = columnlines;
        }
    }

    public int getFrame() {
        return this.m_frame;
    }

    public void setFrame(int frame) {
        this.m_frame = frame;
    }

    protected int getFramespacingh(Graphics g) {
        if (this.m_frame == 0) {
            return 0;
        }
        if (this.m_framespacing == "") {
            this.setFramespacing(DEFAULT_FRAMESPACING);
        }
        if (this.framespacingh == -1) {
            this.framespacingh = AttributesHelper.getPixels(this.m_framespacing.substring(0, this.m_framespacing.indexOf(32)), this.getFontMetrics(g));
            this.framespacingv = AttributesHelper.getPixels(this.m_framespacing.substring(this.m_framespacing.indexOf(32) + 1), this.getFontMetrics(g));
        }
        return this.framespacingh;
    }

    protected int getFramespacingv(Graphics g) {
        if (this.m_frame == 0) {
            return 0;
        }
        if (this.m_framespacing == "") {
            this.setFramespacing(DEFAULT_FRAMESPACING);
        }
        if (this.framespacingh == -1) {
            this.framespacingh = AttributesHelper.getPixels(this.m_framespacing.substring(0, this.m_framespacing.indexOf(32)), this.getFontMetrics(g));
            this.framespacingv = AttributesHelper.getPixels(this.m_framespacing.substring(this.m_framespacing.indexOf(32) + 1), this.getFontMetrics(g));
        }
        return this.framespacingv;
    }

    public void setFramespacing(String framespacing) {
        this.m_framespacing = framespacing;
    }

    public boolean getEqualrows() {
        return this.m_equalrows;
    }

    public void setEqualrows(boolean equalrows) {
        this.m_equalrows = equalrows;
    }

    public boolean getEqualcolumns() {
        return this.m_equalcolumns;
    }

    public void setEqualcolumns(boolean equalcolumns) {
        this.m_equalcolumns = equalcolumns;
    }

    public int getSide() {
        return this.m_side;
    }

    public void setSide(int side) {
        if (side == 0 || side == 1 || side == 2 || side == 3) {
            this.m_side = side;
        }
    }

    public int getMinlabelspacing() {
        return this.m_minlabelspacing;
    }

    public void setMinlabelspacing(int minlabelspacing) {
        this.m_minlabelspacing = minlabelspacing;
    }

    public void paint(Graphics g, int posX, int posY) {
        int x1;
        if (this.getBackgroundColor() != null) {
            g.setColor(this.getBackgroundColor());
            g.fillRect(posX, posY - this.getAscentHeight(g), this.getWidth(g), this.getHeight(g));
        }
        g.setColor(this.getForegroundColor());
        g.setFont(this.getFont());
        posX += this.getFramespacingh(g);
        posY += this.getFramespacingv(g);
        int[] maxrowascentheight = new int[this.getMathElementCount()];
        int[] maxrowdescentheight = new int[this.getMathElementCount()];
        int i = 0;
        while (i < this.getMathElementCount()) {
            maxrowascentheight[i] = this.getMaxRowAscentHeight(g, i);
            maxrowdescentheight[i] = this.getMaxRowDescentHeight(g, i);
            ++i;
        }
        int maxcolumns = this.getMaxColumnCount();
        boolean isAlignGroupsExist = this.getMaxGroupAlignCount() != 0;
        int[] maxcolumnwidth = new int[maxcolumns];
        i = 0;
        while (i < maxcolumns) {
            maxcolumnwidth[i] = this.getMaxColumnWidth(g, i);
            ++i;
        }
        int x = x1 = posX;
        posY -= this.getAscentHeight(g);
        i = 0;
        while (i < this.getMathElementCount()) {
            AbstractMathElement row = this.getMathElement(i);
            posY += maxrowascentheight[i];
            x = x1;
            int j = 0;
            while (j < maxcolumns && j < row.getMathElementCount()) {
                if (isAlignGroupsExist && this.getAlignGroups((MathTableData)row.getMathElement(j)).length > 0) {
                    row.getMathElement(j).paint(g, x, posY);
                } else {
                    int xx = x + maxcolumnwidth[j] / 2 - row.getMathElement(j).getWidth(g) / 2;
                    row.getMathElement(j).paint(g, xx, posY);
                }
                x += maxcolumnwidth[j] + this.getColumnspacing(g, j);
                ++j;
            }
            posY += maxrowdescentheight[i];
            posY += this.getRowspacing(g, i);
            ++i;
        }
    }

    private int getMaxRowAscentHeight(Graphics g, int row) {
        if (row >= this.getMathElementCount()) {
            return 0;
        }
        AbstractMathElement child = this.getMathElement(row);
        int height = 0;
        int i = 0;
        while (i < child.getMathElementCount()) {
            height = Math.max(height, child.getMathElement(i).getAscentHeight(g));
            ++i;
        }
        return height;
    }

    private int getMaxRowDescentHeight(Graphics g, int row) {
        if (row >= this.getMathElementCount()) {
            return 0;
        }
        AbstractMathElement child = this.getMathElement(row);
        int height = 0;
        int i = 0;
        while (i < child.getMathElementCount()) {
            height = Math.max(height, child.getMathElement(i).getDescentHeight(g));
            ++i;
        }
        return height;
    }

    private int getMaxColumnWidth(Graphics g, int column) {
        int width = 0;
        int i = 0;
        while (i < this.getMathElementCount()) {
            AbstractMathElement child = this.getMathElement(i);
            if (column < child.getMathElementCount()) {
                width = Math.max(width, child.getMathElement(column).getWidth(g));
            }
            ++i;
        }
        return width;
    }

    private int getMaxColumnCount() {
        int count = 0;
        int i = 0;
        while (i < this.getMathElementCount()) {
            AbstractMathElement child = this.getMathElement(i);
            count = Math.max(count, child.getMathElementCount());
            ++i;
        }
        return count;
    }

    public int calculateWidth(Graphics g) {
        this.calculateAlignmentGroups(g);
        int width = 0;
        int maxcolumns = this.getMaxColumnCount();
        int i = 0;
        while (i < maxcolumns) {
            width += this.getMaxColumnWidth(g, i);
            if (i + 1 < maxcolumns) {
                width += this.getColumnspacing(g, i);
            }
            ++i;
        }
        return width += this.getFramespacingh(g) * 2;
    }

    public int calculateHeight(Graphics g) {
        int height = 0;
        int mec = this.getMathElementCount();
        int i = 0;
        while (i < mec) {
            height = height + this.getMaxRowAscentHeight(g, i) + this.getMaxRowDescentHeight(g, i);
            if (i + 1 < mec) {
                height += this.getRowspacing(g, i);
            }
            ++i;
        }
        return height += this.getFramespacingv(g) * 2;
    }

    public int calculateAscentHeight(Graphics g) {
        if (this.getAlign() == 1) {
            return this.getHeight(g);
        }
        if (this.getAlign() == 0) {
            return this.getRowCount() > 0 ? this.getMaxRowAscentHeight(g, 0) : 0;
        }
        if (this.getAlign() == 4) {
            return this.getHeight(g) / 2;
        }
        return this.getHeight(g) / 2 + this.getMiddleShift(g);
    }

    public int calculateDescentHeight(Graphics g) {
        if (this.getAlign() == 1) {
            return 0;
        }
        if (this.getAlign() == 0) {
            return this.getHeight(g) - (this.getRowCount() > 0 ? this.getMaxRowAscentHeight(g, 0) : 0);
        }
        if (this.getAlign() == 4) {
            return this.getHeight(g) / 2;
        }
        int b = this.getMiddleShift(g);
        int c = this.getHeight(g) / 2;
        return c - b;
    }

    public void setGroupAlign(String groupalign) {
        this.groupsalignvalues = MathTable.createGroupAlignValues(groupalign);
    }

    public static int[] createGroupAlignValues(String groupalign) {
        int[] result = null;
        ArrayList<Integer> alignArray = new ArrayList<Integer>();
        String alignString = groupalign.trim();
        alignString = String.valueOf(alignString.substring(1, alignString.length() - 1)) + " ";
        int spaceIndex = alignString.indexOf(" ");
        while (spaceIndex > 0) {
            String valueString = alignString.substring(0, spaceIndex).toLowerCase();
            int valueInt = 5;
            if (valueString.equals("center")) {
                valueInt = 2;
            } else if (valueString.equals("left")) {
                valueInt = 5;
            } else if (valueString.equals("right")) {
                valueInt = 6;
            } else if (valueString.equals("decimalpoint")) {
                valueInt = 7;
            }
            alignArray.add(new Integer(valueInt));
            alignString = alignString.substring(spaceIndex + 1);
            spaceIndex = alignString.indexOf(" ");
        }
        result = new int[alignArray.size()];
        int i = 0;
        while (i < alignArray.size()) {
            result[i] = (Integer)alignArray.get(i);
            ++i;
        }
        return result;
    }

    public int[] getGroupAlign() {
        return this.groupsalignvalues;
    }

    public int[] getGroupAlign(MathTableData cell) {
        int[] result = null;
        if (cell == null) {
            return new int[0];
        }
        result = cell.getGroupAlign() == null || cell.getGroupAlign().length == 0 ? ((MathTableRow)cell.getParent()).getGroupAlign() : cell.getGroupAlign();
        if (result == null) {
            result = this.getGroupAlign();
        }
        if (result == null) {
            result = new int[]{};
        }
        return result;
    }

    private int getMaxGroupAlignCount() {
        int result = 0;
        int rowsCount = this.getRowCount();
        int columnsCount = this.getMaxColumnCount();
        int tmpLength = 0;
        int column = 0;
        while (column < columnsCount) {
            int row = 0;
            while (row < rowsCount) {
                MathTableData cell = null;
                try {
                    cell = this.getCell(row, column);
                }
                catch (Exception e) {
                    return 0;
                }
                if (cell != null && result < (tmpLength = cell.getAlignGroups().size())) {
                    result = tmpLength;
                }
                ++row;
            }
            ++column;
        }
        return result;
    }

    private int getRowCount() {
        return this.getMathElementCount();
    }

    private MathTableData getCell(int row, int column) throws Exception {
        int rowsCount = this.getRowCount();
        int columnsCount = this.getMaxColumnCount();
        MathTableData cell = null;
        if (row > rowsCount - 1 || column > columnsCount - 1) {
            return cell;
        }
        AbstractMathElement theRow = this.getMathElement(row);
        if (column < theRow.getMathElementCount()) {
            if (theRow.getMathElement(column) instanceof MathTableData) {
                cell = (MathTableData)theRow.getMathElement(column);
            } else {
                throw new Exception("This table doesn't contain <mtr> and <mtd> tags.");
            }
        }
        return cell;
    }

    private MathAlignGroup[] getAlignGroups(MathTableData cell) {
        MathAlignGroup[] result;
        ArrayList list = cell.getAlignGroups();
        if (list.size() == 0) {
            result = new MathAlignGroup[]{};
        } else {
            result = new MathAlignGroup[list.size()];
            int i = 0;
            while (i < list.size()) {
                result[i] = (MathAlignGroup)list.get(i);
                ++i;
            }
        }
        return result;
    }

    protected void calculateAlignmentGroups(Graphics g) {
        int[] groupalignvalues;
        MathAlignGroup[] aligngroups;
        int rowsCount = this.getRowCount();
        int columnsCount = this.getMaxColumnCount();
        int MAX_WIDTH_IN_COLUMN = rowsCount;
        int maxGroupAlignCount = this.getMaxGroupAlignCount();
        if (maxGroupAlignCount == 0) {
            return;
        }
        int[][][][] alignwidths = new int[columnsCount][3][rowsCount + 1][maxGroupAlignCount];
        boolean[][] usesMarks = new boolean[columnsCount][this.getMaxGroupAlignCount()];
        int col = 0;
        while (col < columnsCount) {
            int row = 0;
            while (row < rowsCount) {
                MathTableData cell = null;
                try {
                    cell = this.getCell(row, col);
                }
                catch (Exception e) {
                    cell = null;
                }
                if (cell != null) {
                    aligngroups = this.getAlignGroups(cell);
                    groupalignvalues = this.getGroupAlign(cell);
                    if (groupalignvalues.length == 0) {
                        groupalignvalues = new int[aligngroups.length];
                        int i = 0;
                        while (i < aligngroups.length) {
                            groupalignvalues[i] = 5;
                            ++i;
                        }
                    }
                    if (aligngroups.length != 0 && aligngroups.length >= groupalignvalues.length) {
                        int alignIndex = 0;
                        while (alignIndex < groupalignvalues.length) {
                            ArrayList elements = MathAlignGroup.getElementsOfAlignGroup(aligngroups[alignIndex]);
                            alignwidths[col][MathTable.WHOLE_WIDTH][row][alignIndex] = MathAlignGroup.getElementsWholeWidth(g, elements);
                            if (alignwidths[col][WHOLE_WIDTH][MAX_WIDTH_IN_COLUMN][alignIndex] < alignwidths[col][WHOLE_WIDTH][row][alignIndex]) {
                                alignwidths[col][MathTable.WHOLE_WIDTH][MAX_WIDTH_IN_COLUMN][alignIndex] = alignwidths[col][WHOLE_WIDTH][row][alignIndex];
                            }
                            if (aligngroups[alignIndex].getMark() != null) {
                                int leftPart;
                                usesMarks[col][alignIndex] = true;
                                alignwidths[col][MathTable.LEFT_WIDTH][row][alignIndex] = leftPart = this.getWidthTillMark(g, elements.iterator());
                                alignwidths[col][MathTable.RIGHT_WIDTH][row][alignIndex] = alignwidths[col][WHOLE_WIDTH][row][alignIndex] - leftPart;
                                if (alignwidths[col][LEFT_WIDTH][MAX_WIDTH_IN_COLUMN][alignIndex] < leftPart) {
                                    alignwidths[col][MathTable.LEFT_WIDTH][MAX_WIDTH_IN_COLUMN][alignIndex] = leftPart;
                                }
                                if (alignwidths[col][RIGHT_WIDTH][MAX_WIDTH_IN_COLUMN][alignIndex] < alignwidths[col][RIGHT_WIDTH][row][alignIndex]) {
                                    alignwidths[col][MathTable.RIGHT_WIDTH][MAX_WIDTH_IN_COLUMN][alignIndex] = alignwidths[col][RIGHT_WIDTH][row][alignIndex];
                                }
                            } else {
                                alignwidths[col][MathTable.LEFT_WIDTH][row][alignIndex] = 0;
                                alignwidths[col][MathTable.RIGHT_WIDTH][row][alignIndex] = alignwidths[col][WHOLE_WIDTH][row][alignIndex];
                                if (groupalignvalues[alignIndex] == 7) {
                                    int tillPoint = this.getWidthTillPoint(g, elements.iterator());
                                    int pointWidth = this.getPointWidth(g, elements.iterator());
                                    alignwidths[col][MathTable.LEFT_WIDTH][row][alignIndex] = tillPoint;
                                    if (alignwidths[col][LEFT_WIDTH][MAX_WIDTH_IN_COLUMN][alignIndex] < tillPoint) {
                                        alignwidths[col][MathTable.LEFT_WIDTH][MAX_WIDTH_IN_COLUMN][alignIndex] = tillPoint;
                                    }
                                    alignwidths[col][MathTable.RIGHT_WIDTH][row][alignIndex] = alignwidths[col][WHOLE_WIDTH][row][alignIndex] - tillPoint - pointWidth;
                                    if (alignwidths[col][RIGHT_WIDTH][MAX_WIDTH_IN_COLUMN][alignIndex] < alignwidths[col][RIGHT_WIDTH][row][alignIndex]) {
                                        alignwidths[col][MathTable.RIGHT_WIDTH][MAX_WIDTH_IN_COLUMN][alignIndex] = alignwidths[col][RIGHT_WIDTH][row][alignIndex];
                                    }
                                }
                            }
                            ++alignIndex;
                        }
                    }
                }
                ++row;
            }
            ++col;
        }
        int alignOfTheGroup = 5;
        int currentWidth = 0;
        int maxWidth = 0;
        int leftWidth = 0;
        int leftMaxWidth = 0;
        int rightWidth = 0;
        int rightMaxWidth = 0;
        MathAlignGroup group = null;
        MathAlignGroup nextGroup = null;
        int col2 = 0;
        while (col2 < columnsCount) {
            int row = 0;
            while (row < rowsCount) {
                MathTableData cell = null;
                try {
                    cell = this.getCell(row, col2);
                }
                catch (Exception e) {
                    cell = null;
                }
                if (cell != null) {
                    aligngroups = this.getAlignGroups(cell);
                    groupalignvalues = this.getGroupAlign(cell);
                    if (groupalignvalues.length == 0) {
                        groupalignvalues = new int[aligngroups.length];
                        int i = 0;
                        while (i < aligngroups.length) {
                            groupalignvalues[i] = 5;
                            ++i;
                        }
                    }
                    if (aligngroups.length != 0 && aligngroups.length >= groupalignvalues.length) {
                        int alignIndex = 0;
                        while (alignIndex < groupalignvalues.length) {
                            alignOfTheGroup = groupalignvalues[alignIndex];
                            currentWidth = alignwidths[col2][WHOLE_WIDTH][row][alignIndex];
                            maxWidth = alignwidths[col2][WHOLE_WIDTH][MAX_WIDTH_IN_COLUMN][alignIndex];
                            leftWidth = alignwidths[col2][LEFT_WIDTH][row][alignIndex];
                            leftMaxWidth = alignwidths[col2][LEFT_WIDTH][MAX_WIDTH_IN_COLUMN][alignIndex];
                            rightWidth = alignwidths[col2][RIGHT_WIDTH][row][alignIndex];
                            rightMaxWidth = alignwidths[col2][RIGHT_WIDTH][MAX_WIDTH_IN_COLUMN][alignIndex];
                            group = aligngroups[alignIndex];
                            if (usesMarks[col2][alignIndex]) {
                                alignOfTheGroup = 11;
                            }
                            if (alignIndex < groupalignvalues.length - 1) {
                                nextGroup = aligngroups[alignIndex + 1];
                            }
                            switch (alignOfTheGroup) {
                                case 6: {
                                    group.width += maxWidth - currentWidth;
                                    break;
                                }
                                case 5: {
                                    if (alignIndex >= groupalignvalues.length - 1) break;
                                    nextGroup.width += maxWidth - currentWidth;
                                    break;
                                }
                                case 2: {
                                    group.width += (maxWidth - currentWidth) / 2;
                                    if (alignIndex >= groupalignvalues.length - 1) break;
                                    nextGroup.width += (maxWidth - currentWidth) / 2;
                                    break;
                                }
                                case 7: 
                                case 11: {
                                    group.width += leftMaxWidth - leftWidth;
                                    if (alignIndex >= groupalignvalues.length - 1) break;
                                    nextGroup.width += rightMaxWidth - rightWidth;
                                    break;
                                }
                                default: {
                                    group.width += maxWidth - currentWidth;
                                }
                            }
                            ++alignIndex;
                        }
                    }
                }
                ++row;
            }
            ++col2;
        }
    }

    private int getWidthTillPoint(Graphics g, Iterator elements) {
        int result = 0;
        AbstractMathElement element = null;
        while (elements.hasNext()) {
            element = (AbstractMathElement)elements.next();
            if (element instanceof MathNumber) {
                return result + ((MathNumber)element).getWidthTillPoint(g);
            }
            if (!this.containsNumber(element)) {
                result += element.getWidth(g);
                continue;
            }
            result += this.getWidthTillPoint(g, new ChildIterator(this.getChildNodes()));
        }
        return result;
    }

    private boolean containsNumber(AbstractMathElement element) {
        return this.containsElement(element, "mn");
    }

    private int getPointWidth(Graphics g, Iterator iterator) {
        int result = 0;
        while (iterator.hasNext()) {
            AbstractMathElement element = (AbstractMathElement)iterator.next();
            if (!(element instanceof MathNumber)) continue;
            result = ((MathNumber)element).getPointWidth(g);
            break;
        }
        return result;
    }

    private int getWidthTillMark(Graphics g, Iterator elements) {
        int result = 0;
        AbstractMathElement element = null;
        while (elements.hasNext()) {
            element = (AbstractMathElement)elements.next();
            if (element instanceof MathAlignMark) {
                return result;
            }
            if (!this.containsMark(element)) {
                result += element.getWidth(g);
                continue;
            }
            result += this.getWidthTillMark(g, new ChildIterator(this.getChildNodes()));
        }
        return result;
    }

    private boolean containsMark(AbstractMathElement element) {
        return this.containsElement(element, "malignmark");
    }

    private boolean containsElement(AbstractMathElement container, String searchName) {
        if ("none".equals(searchName)) {
            return true;
        }
        int i = 0;
        while (i < container.getMathElementCount()) {
            if (this.containsElement(container.getMathElement(i), searchName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private class ChildIterator
    implements Iterator {
        private final TransitionElement.NodeList nodeList;
        private int pos;

        protected ChildIterator(TransitionElement.NodeList nl) {
            this.nodeList = nl;
        }

        public boolean hasNext() {
            return this.pos < this.nodeList.getLength();
        }

        public Object next() {
            ++this.pos;
            return this.nodeList.item(this.pos - 1);
        }

        public void remove() {
        }
    }
}

