/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.element;

import java.awt.Graphics;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.element.generic.AbstractMathElement;

public class MathSubSup
extends AbstractMathElement {
    protected static final double DY = 0.215;
    public static final String ELEMENT = "msubsup";
    private int m_subscriptshift = 0;
    private int m_superscriptshift = 0;

    public MathSubSup(MathBase base) {
        super(base);
    }

    public void setSubScriptShift(int subscriptshift) {
        this.m_subscriptshift = subscriptshift;
    }

    public int getSubScriptShift() {
        return this.m_subscriptshift;
    }

    public void setSuperScriptShift(int superscriptshift) {
        this.m_superscriptshift = superscriptshift;
    }

    public int getSuperScriptShift() {
        return this.m_superscriptshift;
    }

    public void paint(Graphics g, int posX, int posY) {
        int e1AscentHeight;
        if (this.getBackgroundColor() != null) {
            g.setColor(this.getBackgroundColor());
            g.fillRect(posX, posY - this.getAscentHeight(g), this.getWidth(g), this.getHeight(g));
        }
        g.setColor(this.getForegroundColor());
        g.setFont(this.getFont());
        AbstractMathElement e1 = this.getMathElement(0);
        AbstractMathElement e2 = this.getMathElement(1);
        AbstractMathElement e3 = this.getMathElement(2);
        int middleshift = (int)((double)e1.getHeight(g) * 0.215);
        int e1DescentHeight = e1.getDescentHeight(g);
        if (e1DescentHeight == 0) {
            e1DescentHeight = this.getFontMetrics(g).getDescent();
        }
        if ((e1AscentHeight = e1.getAscentHeight(g)) == 0) {
            e1AscentHeight = this.getFontMetrics(g).getAscent();
        }
        int posY1 = posY + e1DescentHeight + e2.getAscentHeight(g) - middleshift - 1;
        int posY2 = posY - e1AscentHeight + middleshift - e3.getDescentHeight(g) + 1;
        e1.paint(g, posX, posY);
        e2.paint(g, posX + e1.getWidth(g), posY1);
        e3.paint(g, posX + e1.getWidth(g), posY2);
    }

    public int calculateWidth(Graphics g) {
        return this.getMathElement(0).getWidth(g) + Math.max(this.getMathElement(1).getWidth(g), this.getMathElement(2).getWidth(g)) + 1;
    }

    public int calculateAscentHeight(Graphics g) {
        int e2h = Math.max(this.getMathElement(2).getHeight(g) - (int)((double)this.getMathElement(0).getHeight(g) * 0.215), 0);
        return this.getMathElement(0).getAscentHeight(g) + e2h;
    }

    public int calculateDescentHeight(Graphics g) {
        int e2h = Math.max(this.getMathElement(1).getHeight(g) - (int)((double)this.getMathElement(0).getHeight(g) * 0.215), 0);
        return this.getMathElement(0).getDescentHeight(g) + e2h;
    }
}

