/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.element;

import java.awt.Graphics;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.element.generic.AbstractMathElement;

public class MathSub
extends AbstractMathElement {
    private static final double DY = 0.215;
    public static final String ELEMENT = "msub";
    private int m_subscriptshift = 0;

    public MathSub(MathBase base) {
        super(base);
    }

    public void setSubScriptShift(int subscriptshift) {
        this.m_subscriptshift = subscriptshift;
    }

    public int getSubScriptShift() {
        return this.m_subscriptshift;
    }

    public void paint(Graphics g, int posX, int posY) {
        int e1AscentHeight;
        if (this.getBackgroundColor() != null) {
            g.setColor(this.getBackgroundColor());
            g.fillRect(posX, posY - this.getAscentHeight(g), this.getWidth(g), this.getHeight(g));
        }
        g.setColor(this.getForegroundColor());
        g.setFont(this.getFont());
        AbstractMathElement e1 = this.getMathElement(0);
        AbstractMathElement e2 = this.getMathElement(1);
        int middleshift = (int)((double)e1.getHeight(g) * 0.215);
        int e1DescentHeight = e1.getDescentHeight(g);
        if (e1DescentHeight == 0) {
            e1DescentHeight = this.getFontMetrics(g).getDescent();
        }
        if ((e1AscentHeight = e1.getAscentHeight(g)) == 0) {
            e1AscentHeight = this.getFontMetrics(g).getAscent();
        }
        int posY1 = posY + e1DescentHeight + e2.getAscentHeight(g) - middleshift - 1;
        e1.paint(g, posX, posY);
        e2.paint(g, posX + e1.getWidth(g), posY1);
    }

    public int calculateWidth(Graphics g) {
        return this.getMathElement(0).getWidth(g) + this.getMathElement(1).getWidth(g);
    }

    public int calculateAscentHeight(Graphics g) {
        return this.getMathElement(0).getAscentHeight(g);
    }

    public int calculateDescentHeight(Graphics g) {
        int e2h = Math.max(this.getMathElement(1).getHeight(g) - (int)((double)this.getMathElement(0).getHeight(g) * 0.215), 0);
        return this.getMathElement(0).getDescentHeight(g) + e2h;
    }
}

