/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.element;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.element.generic.AbstractMathElement;
import net.sourceforge.jeuclid.element.generic.AbstractMathElementWithChildren;

public class MathSqrt
extends AbstractMathElementWithChildren {
    public static final String ELEMENT = "msqrt";
    public static final char ROOT_CHAR = '\u221a';

    public MathSqrt(MathBase base) {
        super(base);
    }

    public void paint(Graphics g, int posX, int posY) {
        if (this.getBackgroundColor() != null) {
            g.setColor(this.getBackgroundColor());
            g.fillRect(posX, posY - this.getAscentHeight(g), this.getWidth(g), this.getHeight(g));
        }
        g.setColor(this.getForegroundColor());
        g.setFont(this.getFont());
        Graphics2D g2d = (Graphics2D)g;
        Font font = this.getMathBase().getFont(this.getFont().getSize() * 100, 0);
        GlyphVector gv = font.createGlyphVector(g2d.getFontRenderContext(), new char[]{'\u221a'});
        Rectangle2D gbounds = gv.getGlyphMetrics(0).getBounds2D();
        double glyphWidth = gbounds.getWidth() / 100.0;
        double glyphHeight = gbounds.getHeight() / 100.0;
        double ascent = gbounds.getY() / 100.0;
        double yScale = (double)this.getHeight(g) / glyphHeight;
        double xScale = 1.0;
        AffineTransform transform = new AffineTransform();
        AffineTransform prevTransform = g2d.getTransform();
        transform.scale(xScale, yScale);
        double y = posY + this.getDescentHeight(g);
        y -= (ascent + glyphHeight) * yScale;
        double x = posX;
        g2d.clipRect(posX - 1, posY + this.getDescentHeight(g) - this.getHeight(g), (int)((double)posX + glyphWidth * xScale) + this.getMathElementsWidth(g) + 2, this.getHeight(g) + 2);
        g2d.setTransform(transform);
        g2d.drawString(String.valueOf('\u221a'), (float)(x /= xScale), (float)(y /= yScale));
        g2d.setTransform(prevTransform);
        int rightTopPoint = posY + this.getDescentHeight(g) - this.getHeight(g);
        g2d.drawLine(posX + this.getRootWidth() + 1, rightTopPoint, posX + this.getWidth(g), rightTopPoint);
        int pos = posX + this.getRootWidth() + 1;
        g2d.setClip(null);
        int i = 0;
        while (i < this.getMathElementCount()) {
            AbstractMathElement child = this.getMathElement(i);
            child.paint(g, pos, posY);
            pos += child.getWidth(g);
            ++i;
        }
    }

    private int getMathElementsWidth(Graphics g) {
        int width = 0;
        int i = 0;
        while (i < this.getMathElementCount()) {
            width += this.getMathElement(i).getWidth(g);
            ++i;
        }
        if (width == 0) {
            return this.getFontMetrics(g).stringWidth(" ");
        }
        return width;
    }

    public int calculateWidth(Graphics g) {
        return this.getMathElementsWidth(g) + this.getRootWidth() + 2;
    }

    private int getRootWidth() {
        FontRenderContext context = new FontRenderContext(new AffineTransform(), false, false);
        GlyphVector gv = this.getFont().createGlyphVector(context, new char[]{'\u221a'});
        int result = (int)gv.getGlyphMetrics(0).getBounds2D().getWidth();
        return result;
    }

    public int calculateAscentHeight(Graphics g) {
        return super.calculateAscentHeight(g) + 2;
    }

    public int calculateDescentHeight(Graphics g) {
        return super.calculateDescentHeight(g) + 2;
    }
}

