/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.element;

import java.awt.Color;
import java.awt.Graphics;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.element.generic.AbstractMathElement;

public class MathRootElement
extends AbstractMathElement {
    public static final String ELEMENT = "math";
    public static final String ATTRIBUTE_DISPLAY = "display";
    public static final int INLINE = 0;
    public static final int BLOCK = 1;
    private int m_display = 0;
    private boolean m_debug = false;

    public MathRootElement(MathBase base) {
        super(base);
    }

    public void setDisplay(int display) {
        if (display == 0 || display == 1) {
            this.m_display = display;
        }
        if (display == 0) {
            this.m_displaystyle = false;
        }
        if (display == 1) {
            this.m_displaystyle = true;
        }
    }

    public int getDisplay() {
        return this.m_display;
    }

    public void setDebug(boolean debug) {
        this.m_debug = debug;
    }

    public boolean isDebug() {
        return this.m_debug;
    }

    public void paint(Graphics g) {
        if (this.isDebug()) {
            g.setColor(Color.blue);
            g.drawLine(0, 0, this.getWidth(g) - 1, 0);
            g.drawLine(this.getWidth(g) - 1, 0, this.getWidth(g) - 1, this.getHeight(g) - 1);
            g.drawLine(0, 0, 0, this.getHeight(g) - 1);
            g.drawLine(0, this.getHeight(g) - 1, this.getWidth(g) - 1, this.getHeight(g) - 1);
            g.setColor(Color.cyan);
            g.drawLine(0, this.getHeight(g) / 2, this.getWidth(g) - 1, this.getHeight(g) / 2);
            g.setColor(Color.black);
        }
        this.paint(g, 0, this.getAscentHeight(g));
    }

    public void paint(Graphics g, int posX, int posY) {
        if (this.getBackgroundColor() != null) {
            g.setColor(this.getBackgroundColor());
            g.fillRect(posX, posY - this.getAscentHeight(g), this.getWidth(g), this.getHeight(g));
        }
        g.setColor(this.getForegroundColor());
        g.setFont(this.getFont());
        int pos = posX;
        int i = 0;
        while (i < this.getMathElementCount()) {
            AbstractMathElement child = this.getMathElement(i);
            child.paint(g, pos, posY);
            pos += child.getWidth(g);
            ++i;
        }
    }

    public int calculateWidth(Graphics g) {
        return this.getMathElement(0) == null ? 0 : this.getMathElement(0).getWidth(g) + 1;
    }

    public int calculateAscentHeight(Graphics g) {
        return this.getMathElement(0) == null ? 0 : this.getMathElement(0).getAscentHeight(g);
    }

    public int calculateDescentHeight(Graphics g) {
        return this.getMathElement(0) == null ? 0 : this.getMathElement(0).getDescentHeight(g);
    }
}

