/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.element;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.element.generic.AbstractMathElement;

public class MathRoot
extends AbstractMathElement {
    public static final String ELEMENT = "mroot";
    public static final char ROOT_CHAR = '\u221a';

    public MathRoot(MathBase base) {
        super(base);
    }

    public void paint(Graphics g, int posX, int posY) {
        if (this.getMathElementCount() < 2) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        if (this.getBackgroundColor() != null) {
            g2d.setColor(this.getBackgroundColor());
            g2d.fillRect(posX, posY - this.getAscentHeight(g), this.getWidth(g), this.getHeight(g));
        }
        g2d.setColor(this.getForegroundColor());
        g2d.setFont(this.getFont());
        AbstractMathElement e1 = this.getMathElement(0);
        AbstractMathElement e2 = this.getMathElement(1);
        int width1 = e1.getWidth(g);
        int height1 = e1.getHeight(g);
        Font font = this.getMathBase().getFont(this.getFont().getSize() * 100, 0);
        GlyphVector gv = font.createGlyphVector(g2d.getFontRenderContext(), new char[]{'\u221a'});
        Rectangle2D gbounds = gv.getGlyphMetrics(0).getBounds2D();
        double glyphWidth = gbounds.getWidth() / 100.0;
        double glyphHeight = gbounds.getHeight() / 100.0;
        double ascent = gbounds.getY() / 100.0;
        int width2 = (int)Math.round((double)e2.getWidth(g) - glyphWidth * 0.5);
        double yScale = (double)(e1.getHeight(g) + 4) / glyphHeight;
        double xScale = 1.0;
        AffineTransform transform = new AffineTransform();
        AffineTransform prevTransform = g2d.getTransform();
        transform.scale(xScale, yScale);
        double y = posY + this.getDescentHeight(g);
        y -= (ascent + glyphHeight) * yScale;
        double x = posX + width2;
        g2d.setTransform(transform);
        g2d.drawString(String.valueOf('\u221a'), (float)(x /= xScale), (float)(y /= yScale));
        g2d.setTransform(prevTransform);
        g2d.clipRect(posX + width2, posY + e1.getDescentHeight(g) - height1 - 2, (int)((glyphWidth + (double)width2) * xScale) + 1 + width1 - width2, height1 + 4);
        int rightTopRootPoint = posY + e1.getDescentHeight(g) - height1 - 2;
        g2d.drawLine((int)((double)posX + (glyphWidth + (double)width2) * xScale) + 1, rightTopRootPoint, posX + this.getWidth(g), rightTopRootPoint);
        g2d.setClip(null);
        e1.paint(g, posX + this.getRootWidth(g) + 1, posY);
        e2.paint(g, posX, posY + e1.getDescentHeight(g) - e2.getDescentHeight(g) - e1.getHeight(g) / 2);
    }

    private int getRootWidth(Graphics g) {
        int result = 0;
        FontRenderContext context = new FontRenderContext(new AffineTransform(), false, false);
        GlyphVector gv = this.getFont().createGlyphVector(context, new char[]{'\u221a'});
        result = (int)gv.getGlyphMetrics(0).getBounds2D().getWidth();
        result = (int)((double)result + Math.max((double)this.getMathElement(1).getWidth(g) - 0.5 * (double)result, 0.0));
        return result;
    }

    public int calculateWidth(Graphics g) {
        if (this.getMathElementCount() < 2) {
            return 0;
        }
        return this.getMathElement(0).getWidth(g) + this.getRootWidth(g) + 1;
    }

    public int calculateAscentHeight(Graphics g) {
        if (this.getMathElementCount() < 2) {
            return 0;
        }
        AbstractMathElement elem = this.getMathElement(0);
        return Math.max(elem.getAscentHeight(g) + 2, elem.getHeight(g) / 2 + 2 - elem.getDescentHeight(g) + elem.getHeight(g));
    }

    public int calculateDescentHeight(Graphics g) {
        if (this.getMathElementCount() < 2) {
            return 0;
        }
        return this.getMathElement(0).getDescentHeight(g) + 2;
    }
}

