/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.element;

import java.awt.Graphics;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.element.MathOperator;
import net.sourceforge.jeuclid.element.generic.AbstractMathElement;
import net.sourceforge.jeuclid.element.helpers.AttributesHelper;

public class MathOver
extends AbstractMathElement {
    public static final String ELEMENT = "mover";
    private boolean m_accent = false;

    public MathOver(MathBase base) {
        super(base);
    }

    public void setAccent(boolean accent) {
        this.m_accent = accent;
    }

    public boolean getAccent() {
        return this.m_accent;
    }

    private int getOverSpace(Graphics g) {
        return AttributesHelper.getPixels("0.2em", this.getFontMetrics(g));
    }

    public void paint(Graphics g, int posX, int posY) {
        if (this.getBackgroundColor() != null) {
            g.setColor(this.getBackgroundColor());
            g.fillRect(posX, posY - this.getAscentHeight(g), this.getWidth(g), this.getHeight(g));
        }
        g.setColor(this.getForegroundColor());
        g.setFont(this.getFont());
        AbstractMathElement e1 = this.getMathElement(0);
        AbstractMathElement e2 = this.getMathElement(1);
        if (this.getMathElement(0) instanceof MathOperator && ((MathOperator)this.getMathElement(0)).getMoveableLimits()) {
            int e1AscentHeight;
            int middleshift = (int)((double)e1.getHeight(g) * 0.215);
            int e1DescentHeight = e1.getDescentHeight(g);
            if (e1DescentHeight == 0) {
                e1DescentHeight = this.getFontMetrics(g).getDescent();
            }
            if ((e1AscentHeight = e1.getAscentHeight(g)) == 0) {
                e1AscentHeight = this.getFontMetrics(g).getAscent();
            }
            int posY2 = posY - e1AscentHeight + middleshift - e2.getDescentHeight(g) + 1;
            e1.paint(g, posX, posY);
            e2.paint(g, posX + e1.getWidth(g), posY2);
        } else {
            int width = this.getWidth(g);
            e1.paint(g, posX + (width - e1.getWidth(g)) / 2, posY);
            posY = posY - e1.getAscentHeight(g) - e2.getDescentHeight(g) - this.getOverSpace(g) - 1;
            if (this.getAccent()) {
                posY -= this.getOverSpace(g);
            }
            e2.paint(g, posX + (width - e2.getWidth(g)) / 2, posY);
        }
    }

    public int calculateWidth(Graphics g) {
        if (this.getMathElement(0) instanceof MathOperator && ((MathOperator)this.getMathElement(0)).getMoveableLimits()) {
            return this.getMathElement(0).getWidth(g) + this.getMathElement(1).getWidth(g);
        }
        return Math.max(this.getMathElement(0).getWidth(g), this.getMathElement(1).getWidth(g));
    }

    public int calculateAscentHeight(Graphics g) {
        int res;
        if (this.getMathElement(0) instanceof MathOperator && ((MathOperator)this.getMathElement(0)).getMoveableLimits()) {
            res = Math.max(this.getMathElement(0).getAscentHeight(g), this.getMathElement(1).getHeight(g) + this.getMiddleShift(g));
        } else {
            res = this.getMathElement(0).getAscentHeight(g) + this.getMathElement(1).getHeight(g) + this.getOverSpace(g);
            if (this.getAccent()) {
                res += this.getOverSpace(g);
            }
        }
        return res;
    }

    public int calculateDescentHeight(Graphics g) {
        return this.getMathElement(0).getDescentHeight(g);
    }
}

