/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.element;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.element.MathOver;
import net.sourceforge.jeuclid.element.MathRow;
import net.sourceforge.jeuclid.element.MathTableData;
import net.sourceforge.jeuclid.element.MathText;
import net.sourceforge.jeuclid.element.MathUnder;
import net.sourceforge.jeuclid.element.MathUnderOver;
import net.sourceforge.jeuclid.element.generic.AbstractMathElement;
import net.sourceforge.jeuclid.element.helpers.AttributeMap;
import net.sourceforge.jeuclid.element.helpers.AttributesHelper;
import net.sourceforge.jeuclid.element.helpers.OperatorDictionary;
import net.sourceforge.jeuclid.element.helpers.UnknownAttributeException;

public class MathOperator
extends MathText {
    public static final String ELEMENT = "mo";
    public static final float LARGEOP_CORRECTOR_INLINE = 1.2f;
    public static final float LARGEOP_CORRECTOR_BLOCK = 1.5f;
    public static final String ATTRIBUTE_STRETCHY = "stretchy";
    public static final String ATTRIBUTE_LARGEOP = "largeop";
    public static final String ATTRIBUTE_SYMMETRIC = "symmetric";
    public static final String HOR_DELIMITERS = "\ufe37\ufe38_\u00af\u2190\u2192\u2194\u0333\u033f";
    public static final String VER_DELIMITERS = "[{()}]|\u2223\u2225\u2329\u232a";
    public static final char LEFT_CURLY_BRACKET_CHAR = '{';
    public static final char RIGHT_CURLY_BRACKET_CHAR = '}';
    public static final char LEFT_SQUARE_BRACKET_CHAR = '[';
    public static final char RIGHT_SQUARE_BRACKET_CHAR = ']';
    public static final char LEFT_PARENTHESIS_CHAR = '(';
    public static final char RIGHT_PARENTHESIS_CHAR = ')';
    public static final char TOP_CURLY_BRACKET_CHAR = '\ufe37';
    public static final char BOTTOM_CURLY_BRACKET_CHAR = '\ufe38';
    public static final char SUM_CHAR = '\u2211';
    public static final char PRODUCT_CHAR = '\u220f';
    public static final String ARROWS = "\u2192\u21d2\u21d0\u2190\u21d4\u2194\u2191\u21d1\u2193\u21d3\u21a6";
    private boolean m_stretchy = true;
    public static final int FORM_UKNOWN = -1;
    private int m_form = -1;
    private boolean m_fence = false;
    private boolean m_separator = false;
    private boolean isLSpaceFromDict = true;
    private String m_lspace = "";
    private boolean isRSpaceFromDict = true;
    private String m_rspace = "";
    private boolean m_symmetric = true;
    private boolean m_largeop = false;
    private boolean m_moveablelimits = false;
    private boolean m_accent = false;

    public MathOperator(MathBase base) {
        super(base);
        this.setMaxsize("infinity");
        this.setMinsize("1");
    }

    public void setForm(int form) {
        this.m_form = form;
    }

    public int getForm() {
        return this.m_form;
    }

    public void setFence(boolean fence) {
        this.m_fence = fence;
    }

    public boolean getFence() {
        return this.m_fence;
    }

    public void setSeparator(boolean separator) {
        this.m_separator = separator;
    }

    public boolean getSeparator() {
        return this.m_separator;
    }

    public void setLSpace(String lspace) {
        this.isLSpaceFromDict = false;
        this.m_lspace = lspace;
    }

    public double getLSpace(Graphics g) {
        if (this.isLSpaceFromDict) {
            try {
                String s = OperatorDictionary.getDefaultAttributeValue(this.getText(), this.m_form, "lspace");
                return AttributesHelper.getPixels(s, g.getFontMetrics());
            }
            catch (UnknownAttributeException e) {
                if (this.getLogger() == null) {
                    System.out.println("Unknown attribute name: lspace");
                } else {
                    this.getLogger().error("Unknown attribute name: lspace");
                }
                return 0.0;
            }
        }
        return AttributesHelper.getPixels(this.m_lspace, g.getFontMetrics());
    }

    public float getLargeOpCorrector() {
        if (this.getMathBase().isInline()) {
            return 1.2f;
        }
        return 1.5f;
    }

    public void setRSpace(String rspace) {
        this.isRSpaceFromDict = false;
        this.m_rspace = rspace;
    }

    public double getRSpace(Graphics g) {
        if (this.isRSpaceFromDict) {
            try {
                String s = OperatorDictionary.getDefaultAttributeValue(this.getText(), this.m_form, "rspace");
                return AttributesHelper.getPixels(s, g.getFontMetrics());
            }
            catch (UnknownAttributeException e) {
                if (this.getLogger() == null) {
                    System.out.println("Unknown attribute name: rspace");
                } else {
                    this.getLogger().error("Unknown attribute name: rspace");
                }
                return 0.0;
            }
        }
        return AttributesHelper.getPixels(this.m_rspace, g.getFontMetrics());
    }

    public void setStretchy(boolean stretchy) {
        this.m_stretchy = stretchy;
    }

    public boolean getStretchy() {
        return this.m_stretchy || this.getFence();
    }

    public void setSymmetric(boolean symmetric) {
        this.m_symmetric = symmetric;
        this.recalculateSize();
    }

    public boolean getSymmetric() {
        return this.m_symmetric;
    }

    private void setRealMathSize(Graphics g) {
        String currentSize;
        String mathSize = currentSize = super.getMathSize();
        if (AttributesHelper.getPixels(currentSize, this.getFontMetrics(g)) > AttributesHelper.getPixels(this.getMaxsize(), this.getFontMetrics(g))) {
            mathSize = this.getMaxsize();
        }
        if (AttributesHelper.getPixels(currentSize, this.getFontMetrics(g)) < AttributesHelper.getPixels(this.getMinsize(), this.getFontMetrics(g))) {
            mathSize = this.getMinsize();
        }
        if (!mathSize.equals(currentSize)) {
            super.setMathSize(mathSize);
        }
    }

    public void setMaxsize(String maxsize) {
        this.setAttribute("maxsize", maxsize);
    }

    public String getMaxsize() {
        return this.getMathAttribute("maxsize");
    }

    public void setMinsize(String minsize) {
        this.setAttribute("minsize", minsize);
    }

    public String getMinsize() {
        return this.getMathAttribute("minsize");
    }

    public void setLargeOp(boolean largeop) {
        this.m_largeop = largeop;
        this.recalculateSize();
    }

    public boolean getLargeOp() {
        return this.m_largeop;
    }

    public void setMoveableLimits(boolean moveablelimits) {
        this.m_moveablelimits = moveablelimits;
    }

    public boolean getMoveableLimits() {
        return this.m_moveablelimits && !this.getDisplayStyle();
    }

    public void setAccent(boolean accent) {
        this.m_accent = accent;
    }

    public boolean getAccent() {
        return this.m_accent;
    }

    private void paintDelimiter(Graphics g, int posX, int posY, char delimiter, boolean vertical) {
        double xScale;
        double yScale;
        int height = this.getHeight(g);
        if (!vertical) {
            height -= 2;
            --posY;
        }
        int width = (int)((double)this.getWidth(g) - this.getRSpace(g) - this.getLSpace(g));
        Graphics2D g2d = (Graphics2D)g;
        Font font = this.getMathBase().getFont(this.getFont().getSize() * 100, 0);
        GlyphVector gv = font.createGlyphVector(g2d.getFontRenderContext(), new char[]{delimiter});
        Rectangle2D gbounds = gv.getGlyphMetrics(0).getBounds2D();
        double glyphWidth = gbounds.getWidth() / 100.0;
        double glyphHeight = gbounds.getHeight() / 100.0;
        double ascent = gbounds.getY() / 100.0;
        double left = gbounds.getX() / 100.0;
        if (vertical) {
            yScale = (double)height / glyphHeight;
            xScale = 1.0;
        } else {
            xScale = Math.max(1.0, (double)width / glyphWidth);
            yScale = 1.0;
        }
        AffineTransform transform = new AffineTransform();
        AffineTransform prevTransform = g2d.getTransform();
        double y = posY + this.getDescentHeight(g);
        y -= (ascent + glyphHeight) * yScale;
        double x = (double)posX - left * xScale;
        if (vertical) {
            x += ((double)width - glyphWidth) / 2.0;
        }
        transform.translate(x, y);
        transform.scale(xScale, yScale);
        g2d.setTransform(transform);
        g2d.drawString(String.valueOf(delimiter), 0, 0);
        g2d.setTransform(prevTransform);
    }

    public Font getFont() {
        Font font = super.getFont();
        if (this.getLargeOp()) {
            return this.getMathBase().getFont((float)font.getSize() * this.getLargeOpCorrector(), this.getMathVariant());
        }
        if (this.getStretchy() && this.isVerticalDelimeter() && font.getSize() > 12) {
            return this.getMathBase().getFont(12.0f, this.getMathVariant());
        }
        return font;
    }

    private boolean isVerticalDelimeter() {
        return this.getText().length() == 1 && (VER_DELIMITERS.indexOf(this.getText().charAt(0)) >= 0 || this.getFence());
    }

    private boolean isHorizontalDelimeter() {
        return this.getText().length() == 1 && HOR_DELIMITERS.indexOf(this.getText().charAt(0)) >= 0;
    }

    public void paint(Graphics g, int posX, int posY) {
        if (this.getBackgroundColor() != null) {
            g.setColor(this.getBackgroundColor());
            g.fillRect(posX, posY - this.getAscentHeight(g), this.getWidth(g), this.getHeight(g));
        }
        g.setColor(this.getForegroundColor());
        this.setRealMathSize(g);
        g.setFont(this.getFont());
        posX = (int)((double)posX + this.getLSpace(g));
        if (this.getText().length() == 0) {
            return;
        }
        char firstChar = this.getText().charAt(0);
        if (this.getText().length() == 1 && this.getStretchy()) {
            if (this.isVerticalDelimeter()) {
                this.getParent().setCalculatingSize(true);
                int ascent = this.getParent().calculateAscentHeight(g);
                int descent = this.getParent().calculateDescentHeight(g);
                this.getParent().setCalculatingSize(false);
                int height = ascent + descent;
                if (height <= this.getFontMetrics(g).getHeight()) {
                    g.drawString(this.getText(), posX, posY);
                } else {
                    this.paintDelimiter(g, posX, posY, firstChar, true);
                }
            } else if (HOR_DELIMITERS.indexOf(firstChar) >= 0 && (this.getParent() instanceof MathOver || this.getParent() instanceof MathUnderOver || this.getParent() instanceof MathUnder)) {
                int width = (int)((double)this.getWidth(g) - this.getLSpace(g) - this.getRSpace(g));
                Polygon rp = new Polygon();
                rp.addPoint(posX + width, posY - this.getHeight(g) / 2);
                rp.addPoint(posX + width - Math.round(this.getFont().getSize() / 3), posY);
                rp.addPoint(posX + width - Math.round(this.getFont().getSize() / 3), posY - this.getHeight(g));
                Polygon lp = new Polygon();
                lp.addPoint(posX, posY - this.getHeight(g) / 2);
                lp.addPoint(posX + Math.round(this.getFont().getSize() / 3), posY);
                lp.addPoint(posX + Math.round(this.getFont().getSize() / 3), posY - this.getHeight(g));
                switch (HOR_DELIMITERS.indexOf(firstChar)) {
                    case 0: {
                        this.paintDelimiter(g, posX, posY, firstChar, false);
                        break;
                    }
                    case 1: {
                        this.paintDelimiter(g, posX, posY, firstChar, false);
                        break;
                    }
                    case 2: {
                        g.fillRect(posX, posY - this.getFont().getSize() / 12, width, this.getFont().getSize() / 12 + 1);
                        break;
                    }
                    case 3: {
                        g.fillRect(posX, posY - this.getHeight(g), width, this.getFont().getSize() / 12 + 1);
                        break;
                    }
                    case 4: {
                        g.fillPolygon(lp);
                        g.fillRect(posX + Math.round(this.getFont().getSize() / 3), Math.round(posY - this.getHeight(g) * 2 / 3), width - Math.round(this.getFont().getSize() / 3), this.getFont().getSize() / 12 + 1);
                        break;
                    }
                    case 5: {
                        g.fillPolygon(rp);
                        g.fillRect(posX, Math.round(posY - this.getHeight(g) * 2 / 3), width - Math.round(this.getFont().getSize() / 3), this.getFont().getSize() / 12 + 1);
                        break;
                    }
                    case 6: {
                        g.fillPolygon(rp);
                        g.fillPolygon(lp);
                        g.fillRect(posX + Math.round(this.getFont().getSize() / 3), Math.round(posY - this.getHeight(g) * 2 / 3), width - Math.round(this.getFont().getSize() / 3 * 2), this.getFont().getSize() / 12 + 1);
                        break;
                    }
                    case 7: {
                        g.fillRect(posX, posY - this.getHeight(g), width, this.getFont().getSize() / 12 + 1);
                        g.fillRect(posX, posY - this.getFont().getSize() / 12, width, this.getFont().getSize() / 12 + 1);
                        break;
                    }
                    case 8: {
                        g.fillRect(posX, posY - this.getHeight(g), width, this.getFont().getSize() / 12 + 1);
                        g.fillRect(posX, posY - this.getFont().getSize() / 12, width, this.getFont().getSize() / 12 + 1);
                        break;
                    }
                    default: {
                        this.paintDelimiter(g, posX, posY, firstChar, false);
                        break;
                    }
                }
            } else if (this.getLargeOp()) {
                int y = posY + this.getDescentHeight(g) - MathText.getCharsMaxDescentHeight(g, this.getFont(), MathText.getChars(this.getText()));
                g.drawString(this.getText(), posX, y);
            } else {
                g.drawString(this.getText(), posX, posY);
            }
        } else if (this.getLargeOp()) {
            int y = posY + this.getDescentHeight(g) - MathText.getCharsMaxDescentHeight(g, this.getFont(), MathText.getChars(this.getText()));
            g.drawString(this.getText(), posX, y);
        } else {
            g.drawString(this.getText(), posX, posY);
        }
    }

    public int calculateWidth(Graphics g) {
        int result = 0;
        this.setRealMathSize(g);
        if (this.getText().length() != 1) {
            result = this.getFontMetrics(g).stringWidth(this.getText());
        } else if (this.isHorizontalDelimeter() && (this.getParent() instanceof MathOver || this.getParent() instanceof MathUnderOver || this.getParent() instanceof MathUnder)) {
            if (this.getParent().isCalculatingSize()) {
                result = -1;
            } else {
                this.getParent().setCalculatingSize(true);
                int res = Math.max(this.getParent().getWidth(g), this.getFontMetrics(g).stringWidth(this.getText()));
                this.getParent().setCalculatingSize(false);
                result = res;
            }
        } else {
            result = this.getFontMetrics(g).stringWidth(this.getText());
        }
        if (result >= 0) {
            result += (int)(this.getLSpace(g) + this.getRSpace(g));
        }
        return result;
    }

    public int calculateAscentHeight(Graphics g) {
        this.setRealMathSize(g);
        int result = 0;
        if (this.getText().length() != 1) {
            result = MathText.getCharsMaxAscentHeight(g, this.getFont(), MathText.getChars(this.getText()));
        } else {
            char firstChar = this.getText().charAt(0);
            if (this.isVerticalDelimeter()) {
                if (!this.getStretchy()) {
                    result = MathText.getCharsMaxAscentHeight(g, this.getFont(), new char[]{firstChar});
                } else if (this.getParent().isCalculatingSize()) {
                    result = 0;
                } else {
                    int size;
                    this.getParent().setCalculatingSize(true);
                    int dh = this.getParent().getDescentHeight(g);
                    int ah = this.getParent().getAscentHeight(g);
                    this.getParent().setCalculatingSize(false);
                    if (this.getSymmetric()) {
                        dh += this.getMiddleShift(g);
                        dh = Math.max(dh, ah -= this.getMiddleShift(g));
                        ah = dh + this.getMiddleShift(g);
                        dh -= this.getMiddleShift(g);
                    }
                    if (ah + dh > (size = AttributesHelper.getPixels(this.getMaxsize(), this.getFontMetrics(g)))) {
                        ah = (ah - this.getMiddleShift(g)) * size / (ah + dh) + this.getMiddleShift(g);
                    } else {
                        size = AttributesHelper.getPixels(this.getMinsize(), this.getFontMetrics(g));
                        if (ah + dh < size) {
                            ah = (ah - this.getMiddleShift(g)) * size / (ah + dh) + this.getMiddleShift(g);
                        }
                    }
                    result = ah;
                }
            } else if (HOR_DELIMITERS.indexOf(firstChar) >= 0) {
                double lh = Math.max(this.getFont().getSize() / 12, 1);
                Rectangle2D rect = this.getGlyphVector(firstChar).getGlyphMetrics(0).getBounds2D();
                switch (HOR_DELIMITERS.indexOf(firstChar)) {
                    case 0: {
                        result = (int)rect.getHeight();
                        break;
                    }
                    case 1: {
                        result = (int)rect.getHeight();
                        break;
                    }
                    case 2: {
                        result = (int)lh;
                        break;
                    }
                    case 3: {
                        result = (int)lh;
                        break;
                    }
                    case 4: {
                        result = (int)rect.getHeight() + 2;
                        break;
                    }
                    case 5: {
                        result = (int)rect.getHeight() + 2;
                        break;
                    }
                    case 6: {
                        result = (int)rect.getHeight() + 2;
                        break;
                    }
                    case 7: {
                        result = (int)(lh * 3.0);
                        break;
                    }
                    case 8: {
                        result = (int)(lh * 3.0);
                        break;
                    }
                    default: {
                        result = (int)rect.getHeight();
                        break;
                    }
                }
            } else {
                result = MathText.getCharsMaxAscentHeight(g, this.getFont(), MathText.getChars(this.getText()));
            }
        }
        return result;
    }

    public int calculateDescentHeight(Graphics g) {
        this.setRealMathSize(g);
        int result = 0;
        if (this.getText().length() != 1) {
            result = MathText.getCharsMaxDescentHeight(g, this.getFont(), MathText.getChars(this.getText()));
        } else {
            char firstChar = this.getText().charAt(0);
            if (VER_DELIMITERS.indexOf(this.getText().charAt(0)) >= 0) {
                if (!this.getStretchy()) {
                    result = MathText.getCharsMaxDescentHeight(g, this.getFont(), new char[]{firstChar});
                } else if (this.getParent().isCalculatingSize()) {
                    result = 0;
                } else {
                    int size;
                    this.getParent().setCalculatingSize(true);
                    int dh = this.getParent().getDescentHeight(g);
                    int ah = this.getParent().getAscentHeight(g);
                    this.getParent().setCalculatingSize(false);
                    if (this.getSymmetric()) {
                        dh += this.getMiddleShift(g);
                        dh = Math.max(dh, ah -= this.getMiddleShift(g));
                        ah = dh + this.getMiddleShift(g);
                        dh -= this.getMiddleShift(g);
                    }
                    if (ah + dh > (size = AttributesHelper.getPixels(this.getMaxsize(), this.getFontMetrics(g)))) {
                        dh = (dh + this.getMiddleShift(g)) * size / (ah + dh) - this.getMiddleShift(g);
                    } else {
                        size = AttributesHelper.getPixels(this.getMinsize(), this.getFontMetrics(g));
                        if (ah + dh < size) {
                            dh = (dh + this.getMiddleShift(g)) * size / (ah + dh) - this.getMiddleShift(g);
                        }
                    }
                    result = dh;
                }
            } else {
                result = HOR_DELIMITERS.indexOf(firstChar) >= 0 ? 0 : MathText.getCharsMaxDescentHeight(g, this.getFont(), MathText.getChars(this.getText()));
            }
        }
        return result;
    }

    public static boolean isStretchyByContext(AbstractMathElement parent) {
        boolean result = false;
        if (parent instanceof MathTableData || parent instanceof MathRow) {
            result = true;
        }
        return result;
    }

    private boolean getBooleanFromDictionary(String attrname, boolean defvalue) {
        boolean def = false;
        try {
            String attr = OperatorDictionary.getDefaultAttributeValue(this.getText(), this.getForm(), attrname);
            def = attr.equals("NULL") ? defvalue : attr.equals("true");
        }
        catch (Exception e) {
            if (this.getLogger() == null) {
                System.out.println("Unknown attribute name:" + attrname);
            }
            this.getLogger().error("Unknown attribute name:" + attrname);
        }
        return def;
    }

    public void eventInitSpecificAttributes(AttributeMap attributes) {
        super.eventInitSpecificAttributes(attributes);
        boolean def = this.getBooleanFromDictionary(ATTRIBUTE_LARGEOP, false);
        this.setLargeOp(attributes.getBoolean(ATTRIBUTE_LARGEOP, def));
        def = this.getBooleanFromDictionary(ATTRIBUTE_SYMMETRIC, true);
        this.setSymmetric(attributes.getBoolean(ATTRIBUTE_SYMMETRIC, def));
        def = this.getBooleanFromDictionary(ATTRIBUTE_STRETCHY, true);
        this.setStretchy(attributes.getBoolean(ATTRIBUTE_STRETCHY, def));
    }

    public void eventAllElementsComplete() {
        if (this.getForm() == -1) {
            int index;
            AbstractMathElement parent = this.getParent();
            this.m_form = parent != null && parent instanceof MathRow ? ((index = parent.getIndexOfMathElement(this)) == 0 && parent.getMathElementCount() > 0 ? 100 : (index == parent.getMathElementCount() - 1 && parent.getMathElementCount() > 0 ? 102 : 101)) : 101;
        }
    }
}

