/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.element;

import java.awt.Graphics;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.element.MathPreScripts;
import net.sourceforge.jeuclid.element.generic.AbstractMathElement;

public class MathMultiScripts
extends AbstractMathElement {
    private static final double DY = 0.215;
    public static final String ELEMENT = "mmultiscripts";
    private int msubscriptshift = 0;
    private int msuperscriptshift = 0;

    public MathMultiScripts(MathBase base) {
        super(base);
    }

    public final void setSubScriptShift(int subscriptshift) {
        this.msubscriptshift = subscriptshift;
    }

    public final int getSubScriptShift() {
        return this.msubscriptshift;
    }

    public final void setSuperScriptShift(int superscriptshift) {
        this.msuperscriptshift = superscriptshift;
    }

    public final int getSuperScriptShift() {
        return this.msuperscriptshift;
    }

    public final void paint(Graphics g, int posX, int posY) {
        int i;
        int p;
        if (this.getBackgroundColor() != null) {
            g.setColor(this.getBackgroundColor());
            g.fillRect(posX, posY - this.getAscentHeight(g), this.getWidth(g), this.getHeight(g));
        }
        g.setColor(this.getForegroundColor());
        g.setFont(this.getFont());
        int prPos = -1;
        int i2 = 1;
        while (i2 < this.getMathElementCount()) {
            if (this.getMathElement(i2) instanceof MathPreScripts) {
                prPos = i2;
                break;
            }
            ++i2;
        }
        AbstractMathElement baseElement = null;
        baseElement = this.getMathElement(0);
        AbstractMathElement childElement = null;
        if (this.getMathElementCount() > 2) {
            int i3 = 1;
            while (i3 < this.getMathElementCount()) {
                if (!(this.getMathElement(i3) instanceof MathPreScripts)) {
                    childElement = this.getMathElement(i3);
                    break;
                }
                ++i3;
            }
        }
        int middleshift = 0;
        if (childElement != null) {
            middleshift = (int)((double)baseElement.getHeight(g) * 0.215);
        }
        int e1DescentHeight = 0;
        if (baseElement != null) {
            e1DescentHeight = baseElement.getDescentHeight(g);
        }
        if (e1DescentHeight == 0) {
            e1DescentHeight = this.getFontMetrics(g).getDescent();
        }
        int e1AscentHeight = 0;
        if (baseElement != null) {
            e1AscentHeight = baseElement.getAscentHeight(g);
        }
        if (e1AscentHeight == 0) {
            e1AscentHeight = this.getFontMetrics(g).getAscent();
        }
        int posY1 = posY + e1DescentHeight + this.calculateMaxElementAscentHeight(g) - middleshift;
        int posY2 = posY - e1AscentHeight + middleshift - this.calculateMaxElementDescentHeight(g);
        int width = 0;
        if (prPos != -1) {
            p = 0;
            if ((this.getMathElementCount() - prPos - 1) % 2 != 0) {
                p = 1;
            }
            i = prPos + 1;
            while (i < this.getMathElementCount() - p) {
                if (i - (prPos + 1) > 1 && (i - (prPos + 1)) % 2 == 0) {
                    width += Math.max(this.getMathElement(i - 2).getWidth(g), this.getMathElement(i - 1).getWidth(g));
                }
                if ((i - (prPos + 1)) % 2 == 0) {
                    this.getMathElement(i).paint(g, posX + width, posY1);
                } else {
                    this.getMathElement(i).paint(g, posX + width, posY2);
                }
                ++i;
            }
            width += Math.max(this.getMathElement(this.getMathElementCount() - 2 - p).getWidth(g), this.getMathElement(this.getMathElementCount() - 1 - p).getWidth(g));
        }
        if (baseElement != null) {
            baseElement.paint(g, posX + width, posY);
            posX += baseElement.getWidth(g);
        }
        if (prPos == -1) {
            prPos = this.getMathElementCount();
        }
        p = 0;
        if (prPos % 2 == 0) {
            p = 1;
        }
        i = 1;
        while (i < prPos - p) {
            if (i - 1 > 1 && (i - 1) % 2 == 0) {
                width += Math.max(this.getMathElement(i - 2).getWidth(g), this.getMathElement(i - 1).getWidth(g));
            }
            if ((i - 1) % 2 == 0) {
                this.getMathElement(i).paint(g, posX + width, posY1);
            } else {
                this.getMathElement(i).paint(g, posX + width, posY2);
            }
            ++i;
        }
    }

    public final int calculateWidth(Graphics g) {
        int width = 0;
        if (this.getMathElementCount() > 0) {
            width += this.getMathElement(0).getWidth(g);
            int prPos = -1;
            int i = 0;
            while (i < this.getMathElementCount()) {
                if (this.getMathElement(i) instanceof MathPreScripts) {
                    prPos = i;
                    break;
                }
                ++i;
            }
            if (prPos == -1) {
                prPos = this.getMathElementCount();
            }
            int p = 0;
            if (prPos % 2 == 0) {
                p = 1;
            }
            int i2 = 1;
            while (i2 < prPos - p) {
                width += Math.max(this.getMathElement(i2).getWidth(g), this.getMathElement(i2 + 1).getWidth(g));
                i2 += 2;
            }
            if (prPos != this.getMathElementCount()) {
                p = (this.getMathElementCount() - prPos - 1) % 2 != 0 ? 1 : 0;
                i2 = prPos + 1;
                while (i2 < this.getMathElementCount() - p) {
                    width += Math.max(this.getMathElement(i2).getWidth(g), this.getMathElement(i2 + 1).getWidth(g));
                    i2 += 2;
                }
            }
        }
        return width + 1;
    }

    public final int calculateMaxElementAscentHeight(Graphics g) {
        int prPos = -1;
        int descenHeight = 0;
        int i = 0;
        while (i < this.getMathElementCount()) {
            if (this.getMathElement(i) instanceof MathPreScripts) {
                prPos = i;
                break;
            }
            ++i;
        }
        if (prPos != -1) {
            int p = 0;
            if (prPos % 2 == 0) {
                p = 1;
            }
            int i2 = 1;
            while (i2 < prPos - p) {
                descenHeight = Math.max(descenHeight, this.getMathElement(i2).getAscentHeight(g));
                i2 += 2;
            }
            if ((this.getMathElementCount() - prPos - 1) % 2 != 0) {
                p = 1;
            }
            i2 = prPos + 1;
            while (i2 < this.getMathElementCount() - p) {
                descenHeight = Math.max(descenHeight, this.getMathElement(i2).getAscentHeight(g));
                i2 += 2;
            }
        } else {
            i = 1;
            while (i < this.getMathElementCount()) {
                descenHeight = Math.max(descenHeight, this.getMathElement(i).getAscentHeight(g));
                i += 2;
            }
        }
        return descenHeight;
    }

    public final int calculateAscentHeight(Graphics g) {
        int prPos = -1;
        int e2h = 0;
        int i = 0;
        while (i < this.getMathElementCount()) {
            if (this.getMathElement(i) instanceof MathPreScripts) {
                prPos = i;
                break;
            }
            ++i;
        }
        if (prPos != -1) {
            int p = 0;
            if (prPos % 2 == 0) {
                p = 1;
            }
            int i2 = 2;
            while (i2 < prPos - p) {
                e2h = Math.max(e2h, Math.max(this.getMathElement(i2).getHeight(g) - (int)((double)this.getMathElement(0).getHeight(g) * 0.215), 0));
                i2 += 2;
            }
            if ((this.getMathElementCount() - prPos - 1) % 2 != 0) {
                p = 1;
            }
            i2 = prPos + 2;
            while (i2 < this.getMathElementCount() - p) {
                e2h = Math.max(e2h, Math.max(this.getMathElement(i2).getHeight(g) - (int)((double)this.getMathElement(0).getHeight(g) * 0.215), 0));
                i2 += 2;
            }
        } else {
            i = 2;
            while (i < this.getMathElementCount()) {
                e2h = Math.max(e2h, Math.max(this.getMathElement(i).getHeight(g) - (int)((double)this.getMathElement(0).getHeight(g) * 0.215), 0));
                i += 2;
            }
        }
        return this.getMathElement(0).getAscentHeight(g) + e2h;
    }

    public final int getMaxElementHeight(Graphics g) {
        int childHeight = 0;
        int prPos = -1;
        int i = 0;
        while (i < this.getMathElementCount()) {
            if (this.getMathElement(i) instanceof MathPreScripts) {
                prPos = i;
                break;
            }
            ++i;
        }
        if (prPos != -1) {
            int p = 0;
            if (prPos % 2 == 0) {
                p = 1;
            }
            int i2 = 2;
            while (i2 < prPos - p) {
                childHeight = Math.max(childHeight, this.getMathElement(i2).getHeight(g));
                i2 += 2;
            }
            if ((this.getMathElementCount() - prPos - 1) % 2 != 0) {
                p = 1;
            }
            i2 = prPos + 2;
            while (i2 < this.getMathElementCount() - p) {
                childHeight = Math.max(childHeight, this.getMathElement(i2).getHeight(g));
                i2 += 2;
            }
        } else {
            i = 2;
            while (i < this.getMathElementCount()) {
                childHeight = Math.max(childHeight, this.getMathElement(i).getHeight(g));
                i += 2;
            }
        }
        return childHeight;
    }

    public final int calculateMaxElementDescentHeight(Graphics g) {
        int prPos = -1;
        int ascentHeight = 0;
        int i = 0;
        while (i < this.getMathElementCount()) {
            if (this.getMathElement(i) instanceof MathPreScripts) {
                prPos = i;
                break;
            }
            ++i;
        }
        if (prPos != -1) {
            int p = 0;
            if (prPos % 2 == 0) {
                p = 1;
            }
            int i2 = 2;
            while (i2 < prPos - p) {
                ascentHeight = Math.max(ascentHeight, this.getMathElement(i2).getDescentHeight(g));
                i2 += 2;
            }
            if ((this.getMathElementCount() - prPos - 1) % 2 != 0) {
                p = 1;
            }
            i2 = prPos + 2;
            while (i2 < this.getMathElementCount() - p) {
                ascentHeight = Math.max(ascentHeight, this.getMathElement(i2).getDescentHeight(g));
                i2 += 2;
            }
        } else {
            i = 2;
            while (i < this.getMathElementCount()) {
                ascentHeight = Math.max(ascentHeight, this.getMathElement(i).getDescentHeight(g));
                i += 2;
            }
        }
        return ascentHeight;
    }

    public final int calculateDescentHeight(Graphics g) {
        int prPos = -1;
        int e2h = 0;
        int i = 0;
        while (i < this.getMathElementCount()) {
            if (this.getMathElement(i) instanceof MathPreScripts) {
                prPos = i;
                break;
            }
            ++i;
        }
        if (prPos != -1) {
            int p = 0;
            if (prPos % 2 == 0) {
                p = 1;
            }
            int i2 = 1;
            while (i2 < prPos - p) {
                e2h = Math.max(e2h, Math.max(this.getMathElement(i2).getHeight(g) - (int)((double)this.getMathElement(0).getHeight(g) * 0.215), 0));
                i2 += 2;
            }
            if ((this.getMathElementCount() - prPos - 1) % 2 != 0) {
                p = 1;
            }
            i2 = prPos + 1;
            while (i2 < this.getMathElementCount() - p) {
                e2h = Math.max(e2h, Math.max(this.getMathElement(i2).getHeight(g) - (int)((double)this.getMathElement(0).getHeight(g) * 0.215), 0));
                i2 += 2;
            }
        } else {
            i = 1;
            while (i < this.getMathElementCount()) {
                e2h = Math.max(e2h, Math.max(this.getMathElement(i).getHeight(g) - (int)((double)this.getMathElement(0).getHeight(g) * 0.215), 0));
                i += 2;
            }
        }
        return this.getMathElement(0).getDescentHeight(g) + e2h;
    }

    final void messageForLog(String msg) {
        if (this.getLogger() != null) {
            this.getLogger().error(msg);
        } else {
            System.out.println(msg);
        }
    }

    public final void eventAllElementsComplete() {
        super.eventAllElementsComplete();
        if (this.getMathElementCount() == 0) {
            this.messageForLog("Wrong number of parametrs, must be 1 or more");
        } else if (this.getMathElement(0) instanceof MathPreScripts) {
            this.messageForLog("The first argument must be base.");
        }
        boolean isMultMPrescripts = false;
        if (this.getMathElementCount() > 0) {
            int prPos = -1;
            int i = 0;
            while (i < this.getMathElementCount()) {
                if (this.getMathElement(i) instanceof MathPreScripts) {
                    if (prPos != -1) {
                        this.messageForLog("The empty element mprescripts must be declared once.");
                        isMultMPrescripts = true;
                        break;
                    }
                    prPos = i;
                }
                ++i;
            }
            if (!isMultMPrescripts) {
                if (prPos == -1 && this.getMathElementCount() % 2 == 0) {
                    this.messageForLog("The total number of the arguments must be odd.\nSome elements may not be drown. ");
                } else if (prPos != -1) {
                    if (prPos % 2 == 0) {
                        this.messageForLog("The total number of the postcripts elements must be even.\nSome elements may not be drown.");
                    }
                    if ((this.getMathElementCount() - prPos - 1) % 2 != 0) {
                        this.messageForLog("The total number of the prestcripts elements must be even.\nSome elements may not be drown.");
                    }
                }
            }
        }
    }
}

